/*
 * Decompiled with CFR 0.152.
 */
package android.media.metrics;

import android.media.metrics.IMediaMetricsManager;
import android.media.metrics.NetworkEvent;
import android.media.metrics.PlaybackErrorEvent;
import android.media.metrics.PlaybackMetrics;
import android.media.metrics.PlaybackSession;
import android.media.metrics.PlaybackStateEvent;
import android.media.metrics.RecordingSession;
import android.media.metrics.TrackChangeEvent;
import android.os.RemoteException;

public class MediaMetricsManager {
    public static final long INVALID_TIMESTAMP = -1L;
    private static final String TAG = "MediaMetricsManager";
    private IMediaMetricsManager mService;
    private int mUserId;

    public MediaMetricsManager(IMediaMetricsManager service, int userId) {
        this.mService = service;
        this.mUserId = userId;
    }

    public void reportPlaybackMetrics(String sessionId, PlaybackMetrics metrics) {
        try {
            this.mService.reportPlaybackMetrics(sessionId, metrics, this.mUserId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void reportNetworkEvent(String sessionId, NetworkEvent event) {
        try {
            this.mService.reportNetworkEvent(sessionId, event, this.mUserId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void reportPlaybackStateEvent(String sessionId, PlaybackStateEvent event) {
        try {
            this.mService.reportPlaybackStateEvent(sessionId, event, this.mUserId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void reportTrackChangeEvent(String sessionId, TrackChangeEvent event) {
        try {
            this.mService.reportTrackChangeEvent(sessionId, event, this.mUserId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public PlaybackSession createPlaybackSession() {
        try {
            String id2 = this.mService.getPlaybackSessionId(this.mUserId);
            PlaybackSession session = new PlaybackSession(id2, this);
            return session;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public RecordingSession createRecordingSession() {
        try {
            String id2 = this.mService.getRecordingSessionId(this.mUserId);
            RecordingSession session = new RecordingSession(id2, this);
            return session;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void reportPlaybackErrorEvent(String sessionId, PlaybackErrorEvent event) {
        try {
            this.mService.reportPlaybackErrorEvent(sessionId, event, this.mUserId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }
}

