/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@SystemApi
public class TvInputHardwareInfo
implements Parcelable {
    static final String TAG = "TvInputHardwareInfo";
    public static final int TV_INPUT_TYPE_OTHER_HARDWARE = 1;
    public static final int TV_INPUT_TYPE_TUNER = 2;
    public static final int TV_INPUT_TYPE_COMPOSITE = 3;
    public static final int TV_INPUT_TYPE_SVIDEO = 4;
    public static final int TV_INPUT_TYPE_SCART = 5;
    public static final int TV_INPUT_TYPE_COMPONENT = 6;
    public static final int TV_INPUT_TYPE_VGA = 7;
    public static final int TV_INPUT_TYPE_DVI = 8;
    public static final int TV_INPUT_TYPE_HDMI = 9;
    public static final int TV_INPUT_TYPE_DISPLAY_PORT = 10;
    public static final int CABLE_CONNECTION_STATUS_UNKNOWN = 0;
    public static final int CABLE_CONNECTION_STATUS_CONNECTED = 1;
    public static final int CABLE_CONNECTION_STATUS_DISCONNECTED = 2;
    public static final Parcelable.Creator<TvInputHardwareInfo> CREATOR = new Parcelable.Creator<TvInputHardwareInfo>(){

        @Override
        public TvInputHardwareInfo createFromParcel(Parcel source) {
            try {
                TvInputHardwareInfo info = new TvInputHardwareInfo();
                info.readFromParcel(source);
                return info;
            }
            catch (Exception e) {
                Log.e(TvInputHardwareInfo.TAG, "Exception creating TvInputHardwareInfo from parcel", e);
                return null;
            }
        }

        public TvInputHardwareInfo[] newArray(int size) {
            return new TvInputHardwareInfo[size];
        }
    };
    private int mDeviceId;
    private int mType;
    private int mAudioType;
    private String mAudioAddress;
    private int mHdmiPortId;
    private int mCableConnectionStatus;

    private TvInputHardwareInfo() {
    }

    public int getDeviceId() {
        return this.mDeviceId;
    }

    public int getType() {
        return this.mType;
    }

    public int getAudioType() {
        return this.mAudioType;
    }

    public String getAudioAddress() {
        return this.mAudioAddress;
    }

    public int getHdmiPortId() {
        if (this.mType != 9) {
            throw new IllegalStateException();
        }
        return this.mHdmiPortId;
    }

    public int getCableConnectionStatus() {
        return this.mCableConnectionStatus;
    }

    public String toString() {
        StringBuilder b = new StringBuilder(128);
        b.append("TvInputHardwareInfo {id=").append(this.mDeviceId);
        b.append(", type=").append(this.mType);
        b.append(", audio_type=").append(this.mAudioType);
        b.append(", audio_addr=").append(this.mAudioAddress);
        if (this.mType == 9) {
            b.append(", hdmi_port=").append(this.mHdmiPortId);
        }
        b.append(", cable_connection_status=").append(this.mCableConnectionStatus);
        b.append("}");
        return b.toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mDeviceId);
        dest.writeInt(this.mType);
        dest.writeInt(this.mAudioType);
        dest.writeString(this.mAudioAddress);
        if (this.mType == 9) {
            dest.writeInt(this.mHdmiPortId);
        }
        dest.writeInt(this.mCableConnectionStatus);
    }

    public void readFromParcel(Parcel source) {
        this.mDeviceId = source.readInt();
        this.mType = source.readInt();
        this.mAudioType = source.readInt();
        this.mAudioAddress = source.readString();
        if (this.mType == 9) {
            this.mHdmiPortId = source.readInt();
        }
        this.mCableConnectionStatus = source.readInt();
    }

    public Builder toBuilder() {
        Builder newBuilder = new Builder().deviceId(this.mDeviceId).type(this.mType).audioType(this.mAudioType).audioAddress(this.mAudioAddress).cableConnectionStatus(this.mCableConnectionStatus);
        if (this.mType == 9) {
            newBuilder.hdmiPortId(this.mHdmiPortId);
        }
        return newBuilder;
    }

    public static class Builder {
        private Integer mDeviceId = null;
        private Integer mType = null;
        private int mAudioType = 0;
        private String mAudioAddress = "";
        private Integer mHdmiPortId = null;
        private Integer mCableConnectionStatus = 0;

        public Builder deviceId(int deviceId) {
            this.mDeviceId = deviceId;
            return this;
        }

        public Builder type(int type) {
            this.mType = type;
            return this;
        }

        public Builder audioType(int audioType) {
            this.mAudioType = audioType;
            return this;
        }

        public Builder audioAddress(String audioAddress) {
            this.mAudioAddress = audioAddress;
            return this;
        }

        public Builder hdmiPortId(int hdmiPortId) {
            this.mHdmiPortId = hdmiPortId;
            return this;
        }

        public Builder cableConnectionStatus(int cableConnectionStatus) {
            this.mCableConnectionStatus = cableConnectionStatus;
            return this;
        }

        public TvInputHardwareInfo build() {
            if (this.mDeviceId == null || this.mType == null) {
                throw new UnsupportedOperationException();
            }
            if (this.mType == 9 && this.mHdmiPortId == null || this.mType != 9 && this.mHdmiPortId != null) {
                throw new UnsupportedOperationException();
            }
            TvInputHardwareInfo info = new TvInputHardwareInfo();
            info.mDeviceId = this.mDeviceId;
            info.mType = this.mType;
            info.mAudioType = this.mAudioType;
            if (info.mAudioType != 0) {
                info.mAudioAddress = this.mAudioAddress;
            }
            if (this.mHdmiPortId != null) {
                info.mHdmiPortId = this.mHdmiPortId;
            }
            info.mCableConnectionStatus = this.mCableConnectionStatus;
            return info;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CableConnectionStatus {
    }
}

