/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.app.PendingIntent;
import android.compat.annotation.UnsupportedAppUsage;
import android.net.ConnectionInfo;
import android.net.IConnectivityDiagnosticsCallback;
import android.net.INetworkActivityListener;
import android.net.INetworkAgent;
import android.net.INetworkOfferCallback;
import android.net.IOnCompleteListener;
import android.net.IQosCallback;
import android.net.ISocketKeepaliveCallback;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkAgentConfig;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import android.net.NetworkScore;
import android.net.NetworkState;
import android.net.NetworkStateSnapshot;
import android.net.OemNetworkPreferences;
import android.net.ProxyInfo;
import android.net.QosSocketInfo;
import android.net.UidRange;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Messenger;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.os.RemoteException;
import android.os.UserHandle;
import java.util.ArrayList;
import java.util.List;

public interface IConnectivityManager
extends IInterface {
    public Network getActiveNetwork() throws RemoteException;

    public Network getActiveNetworkForUid(int var1, boolean var2) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="packages/modules/Connectivity/framework/src/android/net/IConnectivityManager.aidl:59:1:59:25")
    public NetworkInfo getActiveNetworkInfo() throws RemoteException;

    public NetworkInfo getActiveNetworkInfoForUid(int var1, boolean var2) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=28, overrideSourcePosition="packages/modules/Connectivity/framework/src/android/net/IConnectivityManager.aidl:62:1:62:44")
    public NetworkInfo getNetworkInfo(int var1) throws RemoteException;

    public NetworkInfo getNetworkInfoForUid(Network var1, int var2, boolean var3) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="packages/modules/Connectivity/framework/src/android/net/IConnectivityManager.aidl:65:1:65:25")
    public NetworkInfo[] getAllNetworkInfo() throws RemoteException;

    public Network getNetworkForType(int var1) throws RemoteException;

    public Network[] getAllNetworks() throws RemoteException;

    public NetworkCapabilities[] getDefaultNetworkCapabilitiesForUser(int var1, String var2, String var3) throws RemoteException;

    public boolean isNetworkSupported(int var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="packages/modules/Connectivity/framework/src/android/net/IConnectivityManager.aidl:74:1:74:25")
    public LinkProperties getActiveLinkProperties() throws RemoteException;

    public LinkProperties getLinkPropertiesForType(int var1) throws RemoteException;

    public LinkProperties getLinkProperties(Network var1) throws RemoteException;

    public NetworkCapabilities getNetworkCapabilities(Network var1, String var2, String var3) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="packages/modules/Connectivity/framework/src/android/net/IConnectivityManager.aidl:82:1:82:69")
    public NetworkState[] getAllNetworkState() throws RemoteException;

    public List<NetworkStateSnapshot> getAllNetworkStateSnapshots() throws RemoteException;

    public boolean isActiveNetworkMetered() throws RemoteException;

    public boolean requestRouteToHostAddress(int var1, byte[] var2, String var3, String var4) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=29, publicAlternatives="Use {@code TetheringManager#getLastTetherError} as alternative", overrideSourcePosition="packages/modules/Connectivity/framework/src/android/net/IConnectivityManager.aidl:92:1:93:99")
    public int getLastTetherError(String var1) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=29, publicAlternatives="Use {@code TetheringManager#getTetherableIfaces} as alternative", overrideSourcePosition="packages/modules/Connectivity/framework/src/android/net/IConnectivityManager.aidl:96:1:97:100")
    public String[] getTetherableIfaces() throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=29, publicAlternatives="Use {@code TetheringManager#getTetheredIfaces} as alternative", overrideSourcePosition="packages/modules/Connectivity/framework/src/android/net/IConnectivityManager.aidl:100:1:101:98")
    public String[] getTetheredIfaces() throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=29, publicAlternatives="Use {@code TetheringManager#getTetheringErroredIfaces} as Alternative", overrideSourcePosition="packages/modules/Connectivity/framework/src/android/net/IConnectivityManager.aidl:104:1:106:32")
    public String[] getTetheringErroredIfaces() throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=29, publicAlternatives="Use {@code TetheringManager#getTetherableUsbRegexs} as alternative", overrideSourcePosition="packages/modules/Connectivity/framework/src/android/net/IConnectivityManager.aidl:109:1:110:103")
    public String[] getTetherableUsbRegexs() throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=29, publicAlternatives="Use {@code TetheringManager#getTetherableWifiRegexs} as alternative", overrideSourcePosition="packages/modules/Connectivity/framework/src/android/net/IConnectivityManager.aidl:113:1:114:104")
    public String[] getTetherableWifiRegexs() throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=28, overrideSourcePosition="packages/modules/Connectivity/framework/src/android/net/IConnectivityManager.aidl:117:1:117:44")
    public void reportInetCondition(int var1, int var2) throws RemoteException;

    public void reportNetworkConnectivity(Network var1, boolean var2) throws RemoteException;

    public ProxyInfo getGlobalProxy() throws RemoteException;

    public void setGlobalProxy(ProxyInfo var1) throws RemoteException;

    public ProxyInfo getProxyForNetwork(Network var1) throws RemoteException;

    public void setRequireVpnForUids(boolean var1, UidRange[] var2) throws RemoteException;

    public void setLegacyLockdownVpnEnabled(boolean var1) throws RemoteException;

    public void setProvisioningNotificationVisible(boolean var1, int var2, String var3) throws RemoteException;

    public void setAirplaneMode(boolean var1) throws RemoteException;

    public boolean requestBandwidthUpdate(Network var1) throws RemoteException;

    public int registerNetworkProvider(Messenger var1, String var2) throws RemoteException;

    public void unregisterNetworkProvider(Messenger var1) throws RemoteException;

    public void declareNetworkRequestUnfulfillable(NetworkRequest var1) throws RemoteException;

    public Network registerNetworkAgent(INetworkAgent var1, NetworkInfo var2, LinkProperties var3, NetworkCapabilities var4, NetworkScore var5, NetworkAgentConfig var6, int var7) throws RemoteException;

    public NetworkRequest requestNetwork(int var1, NetworkCapabilities var2, int var3, Messenger var4, int var5, IBinder var6, int var7, int var8, String var9, String var10) throws RemoteException;

    public NetworkRequest pendingRequestForNetwork(NetworkCapabilities var1, PendingIntent var2, String var3, String var4) throws RemoteException;

    public void releasePendingNetworkRequest(PendingIntent var1) throws RemoteException;

    public NetworkRequest listenForNetwork(NetworkCapabilities var1, Messenger var2, IBinder var3, int var4, String var5, String var6) throws RemoteException;

    public void pendingListenForNetwork(NetworkCapabilities var1, PendingIntent var2, String var3, String var4) throws RemoteException;

    public void releaseNetworkRequest(NetworkRequest var1) throws RemoteException;

    public void setAcceptUnvalidated(Network var1, boolean var2, boolean var3) throws RemoteException;

    public void setAcceptPartialConnectivity(Network var1, boolean var2, boolean var3) throws RemoteException;

    public void setAvoidUnvalidated(Network var1) throws RemoteException;

    public void startCaptivePortalApp(Network var1) throws RemoteException;

    public void startCaptivePortalAppInternal(Network var1, Bundle var2) throws RemoteException;

    public boolean shouldAvoidBadWifi() throws RemoteException;

    public int getMultipathPreference(Network var1) throws RemoteException;

    public NetworkRequest getDefaultRequest() throws RemoteException;

    public int getRestoreDefaultNetworkDelay(int var1) throws RemoteException;

    public void factoryReset() throws RemoteException;

    public void startNattKeepalive(Network var1, int var2, ISocketKeepaliveCallback var3, String var4, int var5, String var6) throws RemoteException;

    public void startNattKeepaliveWithFd(Network var1, ParcelFileDescriptor var2, int var3, int var4, ISocketKeepaliveCallback var5, String var6, String var7) throws RemoteException;

    public void startTcpKeepalive(Network var1, ParcelFileDescriptor var2, int var3, ISocketKeepaliveCallback var4) throws RemoteException;

    public void stopKeepalive(Network var1, int var2) throws RemoteException;

    public String getCaptivePortalServerUrl() throws RemoteException;

    public byte[] getNetworkWatchlistConfigHash() throws RemoteException;

    public int getConnectionOwnerUid(ConnectionInfo var1) throws RemoteException;

    public void registerConnectivityDiagnosticsCallback(IConnectivityDiagnosticsCallback var1, NetworkRequest var2, String var3) throws RemoteException;

    public void unregisterConnectivityDiagnosticsCallback(IConnectivityDiagnosticsCallback var1) throws RemoteException;

    public IBinder startOrGetTestNetworkService() throws RemoteException;

    public void simulateDataStall(int var1, long var2, Network var4, PersistableBundle var5) throws RemoteException;

    public void systemReady() throws RemoteException;

    public void registerNetworkActivityListener(INetworkActivityListener var1) throws RemoteException;

    public void unregisterNetworkActivityListener(INetworkActivityListener var1) throws RemoteException;

    public boolean isDefaultNetworkActive() throws RemoteException;

    public void registerQosSocketCallback(QosSocketInfo var1, IQosCallback var2) throws RemoteException;

    public void unregisterQosCallback(IQosCallback var1) throws RemoteException;

    public void setOemNetworkPreference(OemNetworkPreferences var1, IOnCompleteListener var2) throws RemoteException;

    public void setProfileNetworkPreference(UserHandle var1, int var2, IOnCompleteListener var3) throws RemoteException;

    public int getRestrictBackgroundStatusByCaller() throws RemoteException;

    public void offerNetwork(int var1, NetworkScore var2, NetworkCapabilities var3, INetworkOfferCallback var4) throws RemoteException;

    public void unofferNetwork(INetworkOfferCallback var1) throws RemoteException;

    public void setTestAllowBadWifiUntil(long var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IConnectivityManager {
        public static final String DESCRIPTOR = "android.net.IConnectivityManager";
        static final int TRANSACTION_getActiveNetwork = 1;
        static final int TRANSACTION_getActiveNetworkForUid = 2;
        static final int TRANSACTION_getActiveNetworkInfo = 3;
        static final int TRANSACTION_getActiveNetworkInfoForUid = 4;
        static final int TRANSACTION_getNetworkInfo = 5;
        static final int TRANSACTION_getNetworkInfoForUid = 6;
        static final int TRANSACTION_getAllNetworkInfo = 7;
        static final int TRANSACTION_getNetworkForType = 8;
        static final int TRANSACTION_getAllNetworks = 9;
        static final int TRANSACTION_getDefaultNetworkCapabilitiesForUser = 10;
        static final int TRANSACTION_isNetworkSupported = 11;
        static final int TRANSACTION_getActiveLinkProperties = 12;
        static final int TRANSACTION_getLinkPropertiesForType = 13;
        static final int TRANSACTION_getLinkProperties = 14;
        static final int TRANSACTION_getNetworkCapabilities = 15;
        static final int TRANSACTION_getAllNetworkState = 16;
        static final int TRANSACTION_getAllNetworkStateSnapshots = 17;
        static final int TRANSACTION_isActiveNetworkMetered = 18;
        static final int TRANSACTION_requestRouteToHostAddress = 19;
        static final int TRANSACTION_getLastTetherError = 20;
        static final int TRANSACTION_getTetherableIfaces = 21;
        static final int TRANSACTION_getTetheredIfaces = 22;
        static final int TRANSACTION_getTetheringErroredIfaces = 23;
        static final int TRANSACTION_getTetherableUsbRegexs = 24;
        static final int TRANSACTION_getTetherableWifiRegexs = 25;
        static final int TRANSACTION_reportInetCondition = 26;
        static final int TRANSACTION_reportNetworkConnectivity = 27;
        static final int TRANSACTION_getGlobalProxy = 28;
        static final int TRANSACTION_setGlobalProxy = 29;
        static final int TRANSACTION_getProxyForNetwork = 30;
        static final int TRANSACTION_setRequireVpnForUids = 31;
        static final int TRANSACTION_setLegacyLockdownVpnEnabled = 32;
        static final int TRANSACTION_setProvisioningNotificationVisible = 33;
        static final int TRANSACTION_setAirplaneMode = 34;
        static final int TRANSACTION_requestBandwidthUpdate = 35;
        static final int TRANSACTION_registerNetworkProvider = 36;
        static final int TRANSACTION_unregisterNetworkProvider = 37;
        static final int TRANSACTION_declareNetworkRequestUnfulfillable = 38;
        static final int TRANSACTION_registerNetworkAgent = 39;
        static final int TRANSACTION_requestNetwork = 40;
        static final int TRANSACTION_pendingRequestForNetwork = 41;
        static final int TRANSACTION_releasePendingNetworkRequest = 42;
        static final int TRANSACTION_listenForNetwork = 43;
        static final int TRANSACTION_pendingListenForNetwork = 44;
        static final int TRANSACTION_releaseNetworkRequest = 45;
        static final int TRANSACTION_setAcceptUnvalidated = 46;
        static final int TRANSACTION_setAcceptPartialConnectivity = 47;
        static final int TRANSACTION_setAvoidUnvalidated = 48;
        static final int TRANSACTION_startCaptivePortalApp = 49;
        static final int TRANSACTION_startCaptivePortalAppInternal = 50;
        static final int TRANSACTION_shouldAvoidBadWifi = 51;
        static final int TRANSACTION_getMultipathPreference = 52;
        static final int TRANSACTION_getDefaultRequest = 53;
        static final int TRANSACTION_getRestoreDefaultNetworkDelay = 54;
        static final int TRANSACTION_factoryReset = 55;
        static final int TRANSACTION_startNattKeepalive = 56;
        static final int TRANSACTION_startNattKeepaliveWithFd = 57;
        static final int TRANSACTION_startTcpKeepalive = 58;
        static final int TRANSACTION_stopKeepalive = 59;
        static final int TRANSACTION_getCaptivePortalServerUrl = 60;
        static final int TRANSACTION_getNetworkWatchlistConfigHash = 61;
        static final int TRANSACTION_getConnectionOwnerUid = 62;
        static final int TRANSACTION_registerConnectivityDiagnosticsCallback = 63;
        static final int TRANSACTION_unregisterConnectivityDiagnosticsCallback = 64;
        static final int TRANSACTION_startOrGetTestNetworkService = 65;
        static final int TRANSACTION_simulateDataStall = 66;
        static final int TRANSACTION_systemReady = 67;
        static final int TRANSACTION_registerNetworkActivityListener = 68;
        static final int TRANSACTION_unregisterNetworkActivityListener = 69;
        static final int TRANSACTION_isDefaultNetworkActive = 70;
        static final int TRANSACTION_registerQosSocketCallback = 71;
        static final int TRANSACTION_unregisterQosCallback = 72;
        static final int TRANSACTION_setOemNetworkPreference = 73;
        static final int TRANSACTION_setProfileNetworkPreference = 74;
        static final int TRANSACTION_getRestrictBackgroundStatusByCaller = 75;
        static final int TRANSACTION_offerNetwork = 76;
        static final int TRANSACTION_unofferNetwork = 77;
        static final int TRANSACTION_setTestAllowBadWifiUntil = 78;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IConnectivityManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IConnectivityManager) {
                return (IConnectivityManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    Network _result = this.getActiveNetwork();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    boolean _arg1 = 0 != data.readInt();
                    Network _result = this.getActiveNetworkForUid(_arg0, _arg1);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    NetworkInfo _result = this.getActiveNetworkInfo();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    boolean _arg1 = 0 != data.readInt();
                    NetworkInfo _result = this.getActiveNetworkInfoForUid(_arg0, _arg1);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    NetworkInfo _result = this.getNetworkInfo(_arg0);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    Network _arg0 = 0 != data.readInt() ? Network.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    boolean _arg2 = 0 != data.readInt();
                    NetworkInfo _result = this.getNetworkInfoForUid(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    Parcelable[] _result = this.getAllNetworkInfo();
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    Network _result = this.getNetworkForType(_arg0);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    Parcelable[] _result = this.getAllNetworks();
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    Parcelable[] _result = this.getDefaultNetworkCapabilitiesForUser(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    return true;
                }
                case 11: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    boolean _result = this.isNetworkSupported(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 12: {
                    data.enforceInterface(descriptor);
                    LinkProperties _result = this.getActiveLinkProperties();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 13: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    LinkProperties _result = this.getLinkPropertiesForType(_arg0);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 14: {
                    data.enforceInterface(descriptor);
                    Network _arg0 = 0 != data.readInt() ? Network.CREATOR.createFromParcel(data) : null;
                    LinkProperties _result = this.getLinkProperties(_arg0);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 15: {
                    data.enforceInterface(descriptor);
                    Network _arg0 = 0 != data.readInt() ? Network.CREATOR.createFromParcel(data) : null;
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    NetworkCapabilities _result = this.getNetworkCapabilities(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 16: {
                    data.enforceInterface(descriptor);
                    Parcelable[] _result = this.getAllNetworkState();
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    return true;
                }
                case 17: {
                    data.enforceInterface(descriptor);
                    List<NetworkStateSnapshot> _result = this.getAllNetworkStateSnapshots();
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
                case 18: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.isActiveNetworkMetered();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 19: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    byte[] _arg1 = data.createByteArray();
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    boolean _result = this.requestRouteToHostAddress(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 20: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _result = this.getLastTetherError(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 21: {
                    data.enforceInterface(descriptor);
                    String[] _result = this.getTetherableIfaces();
                    reply.writeNoException();
                    reply.writeStringArray(_result);
                    return true;
                }
                case 22: {
                    data.enforceInterface(descriptor);
                    String[] _result = this.getTetheredIfaces();
                    reply.writeNoException();
                    reply.writeStringArray(_result);
                    return true;
                }
                case 23: {
                    data.enforceInterface(descriptor);
                    String[] _result = this.getTetheringErroredIfaces();
                    reply.writeNoException();
                    reply.writeStringArray(_result);
                    return true;
                }
                case 24: {
                    data.enforceInterface(descriptor);
                    String[] _result = this.getTetherableUsbRegexs();
                    reply.writeNoException();
                    reply.writeStringArray(_result);
                    return true;
                }
                case 25: {
                    data.enforceInterface(descriptor);
                    String[] _result = this.getTetherableWifiRegexs();
                    reply.writeNoException();
                    reply.writeStringArray(_result);
                    return true;
                }
                case 26: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.reportInetCondition(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 27: {
                    data.enforceInterface(descriptor);
                    Network _arg0 = 0 != data.readInt() ? Network.CREATOR.createFromParcel(data) : null;
                    boolean _arg1 = 0 != data.readInt();
                    this.reportNetworkConnectivity(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 28: {
                    data.enforceInterface(descriptor);
                    ProxyInfo _result = this.getGlobalProxy();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 29: {
                    data.enforceInterface(descriptor);
                    ProxyInfo _arg0 = 0 != data.readInt() ? ProxyInfo.CREATOR.createFromParcel(data) : null;
                    this.setGlobalProxy(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 30: {
                    data.enforceInterface(descriptor);
                    Network _arg0 = 0 != data.readInt() ? Network.CREATOR.createFromParcel(data) : null;
                    ProxyInfo _result = this.getProxyForNetwork(_arg0);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 31: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    UidRange[] _arg1 = data.createTypedArray(UidRange.CREATOR);
                    this.setRequireVpnForUids(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 32: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    this.setLegacyLockdownVpnEnabled(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 33: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    this.setProvisioningNotificationVisible(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 34: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    this.setAirplaneMode(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 35: {
                    data.enforceInterface(descriptor);
                    Network _arg0 = 0 != data.readInt() ? Network.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.requestBandwidthUpdate(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 36: {
                    data.enforceInterface(descriptor);
                    Messenger _arg0 = 0 != data.readInt() ? Messenger.CREATOR.createFromParcel(data) : null;
                    String _arg1 = data.readString();
                    int _result = this.registerNetworkProvider(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 37: {
                    data.enforceInterface(descriptor);
                    Messenger _arg0 = 0 != data.readInt() ? Messenger.CREATOR.createFromParcel(data) : null;
                    this.unregisterNetworkProvider(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 38: {
                    data.enforceInterface(descriptor);
                    NetworkRequest _arg0 = 0 != data.readInt() ? NetworkRequest.CREATOR.createFromParcel(data) : null;
                    this.declareNetworkRequestUnfulfillable(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 39: {
                    data.enforceInterface(descriptor);
                    INetworkAgent _arg0 = INetworkAgent.Stub.asInterface(data.readStrongBinder());
                    NetworkInfo _arg1 = 0 != data.readInt() ? NetworkInfo.CREATOR.createFromParcel(data) : null;
                    LinkProperties _arg2 = 0 != data.readInt() ? LinkProperties.CREATOR.createFromParcel(data) : null;
                    NetworkCapabilities _arg3 = 0 != data.readInt() ? NetworkCapabilities.CREATOR.createFromParcel(data) : null;
                    NetworkScore _arg4 = 0 != data.readInt() ? NetworkScore.CREATOR.createFromParcel(data) : null;
                    NetworkAgentConfig _arg5 = 0 != data.readInt() ? NetworkAgentConfig.CREATOR.createFromParcel(data) : null;
                    int _arg6 = data.readInt();
                    Network _result = this.registerNetworkAgent(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 40: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    NetworkCapabilities _arg1 = 0 != data.readInt() ? NetworkCapabilities.CREATOR.createFromParcel(data) : null;
                    int _arg2 = data.readInt();
                    Messenger _arg3 = 0 != data.readInt() ? Messenger.CREATOR.createFromParcel(data) : null;
                    int _arg4 = data.readInt();
                    IBinder _arg5 = data.readStrongBinder();
                    int _arg6 = data.readInt();
                    int _arg7 = data.readInt();
                    String _arg8 = data.readString();
                    String _arg9 = data.readString();
                    NetworkRequest _result = this.requestNetwork(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7, _arg8, _arg9);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 41: {
                    data.enforceInterface(descriptor);
                    NetworkCapabilities _arg0 = 0 != data.readInt() ? NetworkCapabilities.CREATOR.createFromParcel(data) : null;
                    PendingIntent _arg1 = 0 != data.readInt() ? PendingIntent.CREATOR.createFromParcel(data) : null;
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    NetworkRequest _result = this.pendingRequestForNetwork(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 42: {
                    data.enforceInterface(descriptor);
                    PendingIntent _arg0 = 0 != data.readInt() ? PendingIntent.CREATOR.createFromParcel(data) : null;
                    this.releasePendingNetworkRequest(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 43: {
                    data.enforceInterface(descriptor);
                    NetworkCapabilities _arg0 = 0 != data.readInt() ? NetworkCapabilities.CREATOR.createFromParcel(data) : null;
                    Messenger _arg1 = 0 != data.readInt() ? Messenger.CREATOR.createFromParcel(data) : null;
                    IBinder _arg2 = data.readStrongBinder();
                    int _arg3 = data.readInt();
                    String _arg4 = data.readString();
                    String _arg5 = data.readString();
                    NetworkRequest _result = this.listenForNetwork(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 44: {
                    data.enforceInterface(descriptor);
                    NetworkCapabilities _arg0 = 0 != data.readInt() ? NetworkCapabilities.CREATOR.createFromParcel(data) : null;
                    PendingIntent _arg1 = 0 != data.readInt() ? PendingIntent.CREATOR.createFromParcel(data) : null;
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    this.pendingListenForNetwork(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 45: {
                    data.enforceInterface(descriptor);
                    NetworkRequest _arg0 = 0 != data.readInt() ? NetworkRequest.CREATOR.createFromParcel(data) : null;
                    this.releaseNetworkRequest(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 46: {
                    data.enforceInterface(descriptor);
                    Network _arg0 = 0 != data.readInt() ? Network.CREATOR.createFromParcel(data) : null;
                    boolean _arg1 = 0 != data.readInt();
                    boolean _arg2 = 0 != data.readInt();
                    this.setAcceptUnvalidated(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 47: {
                    data.enforceInterface(descriptor);
                    Network _arg0 = 0 != data.readInt() ? Network.CREATOR.createFromParcel(data) : null;
                    boolean _arg1 = 0 != data.readInt();
                    boolean _arg2 = 0 != data.readInt();
                    this.setAcceptPartialConnectivity(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 48: {
                    data.enforceInterface(descriptor);
                    Network _arg0 = 0 != data.readInt() ? Network.CREATOR.createFromParcel(data) : null;
                    this.setAvoidUnvalidated(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 49: {
                    data.enforceInterface(descriptor);
                    Network _arg0 = 0 != data.readInt() ? Network.CREATOR.createFromParcel(data) : null;
                    this.startCaptivePortalApp(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 50: {
                    data.enforceInterface(descriptor);
                    Network _arg0 = 0 != data.readInt() ? Network.CREATOR.createFromParcel(data) : null;
                    Bundle _arg1 = 0 != data.readInt() ? Bundle.CREATOR.createFromParcel(data) : null;
                    this.startCaptivePortalAppInternal(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 51: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.shouldAvoidBadWifi();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 52: {
                    data.enforceInterface(descriptor);
                    Network _arg0 = 0 != data.readInt() ? Network.CREATOR.createFromParcel(data) : null;
                    int _result = this.getMultipathPreference(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 53: {
                    data.enforceInterface(descriptor);
                    NetworkRequest _result = this.getDefaultRequest();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 54: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _result = this.getRestoreDefaultNetworkDelay(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 55: {
                    data.enforceInterface(descriptor);
                    this.factoryReset();
                    reply.writeNoException();
                    return true;
                }
                case 56: {
                    data.enforceInterface(descriptor);
                    Network _arg0 = 0 != data.readInt() ? Network.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    ISocketKeepaliveCallback _arg2 = ISocketKeepaliveCallback.Stub.asInterface(data.readStrongBinder());
                    String _arg3 = data.readString();
                    int _arg4 = data.readInt();
                    String _arg5 = data.readString();
                    this.startNattKeepalive(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    return true;
                }
                case 57: {
                    data.enforceInterface(descriptor);
                    Network _arg0 = 0 != data.readInt() ? Network.CREATOR.createFromParcel(data) : null;
                    ParcelFileDescriptor _arg1 = 0 != data.readInt() ? ParcelFileDescriptor.CREATOR.createFromParcel(data) : null;
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    ISocketKeepaliveCallback _arg4 = ISocketKeepaliveCallback.Stub.asInterface(data.readStrongBinder());
                    String _arg5 = data.readString();
                    String _arg6 = data.readString();
                    this.startNattKeepaliveWithFd(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6);
                    reply.writeNoException();
                    return true;
                }
                case 58: {
                    data.enforceInterface(descriptor);
                    Network _arg0 = 0 != data.readInt() ? Network.CREATOR.createFromParcel(data) : null;
                    ParcelFileDescriptor _arg1 = 0 != data.readInt() ? ParcelFileDescriptor.CREATOR.createFromParcel(data) : null;
                    int _arg2 = data.readInt();
                    ISocketKeepaliveCallback _arg3 = ISocketKeepaliveCallback.Stub.asInterface(data.readStrongBinder());
                    this.startTcpKeepalive(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 59: {
                    data.enforceInterface(descriptor);
                    Network _arg0 = 0 != data.readInt() ? Network.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    this.stopKeepalive(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 60: {
                    data.enforceInterface(descriptor);
                    String _result = this.getCaptivePortalServerUrl();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 61: {
                    data.enforceInterface(descriptor);
                    byte[] _result = this.getNetworkWatchlistConfigHash();
                    reply.writeNoException();
                    reply.writeByteArray(_result);
                    return true;
                }
                case 62: {
                    data.enforceInterface(descriptor);
                    ConnectionInfo _arg0 = 0 != data.readInt() ? ConnectionInfo.CREATOR.createFromParcel(data) : null;
                    int _result = this.getConnectionOwnerUid(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 63: {
                    data.enforceInterface(descriptor);
                    IConnectivityDiagnosticsCallback _arg0 = IConnectivityDiagnosticsCallback.Stub.asInterface(data.readStrongBinder());
                    NetworkRequest _arg1 = 0 != data.readInt() ? NetworkRequest.CREATOR.createFromParcel(data) : null;
                    String _arg2 = data.readString();
                    this.registerConnectivityDiagnosticsCallback(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 64: {
                    data.enforceInterface(descriptor);
                    IConnectivityDiagnosticsCallback _arg0 = IConnectivityDiagnosticsCallback.Stub.asInterface(data.readStrongBinder());
                    this.unregisterConnectivityDiagnosticsCallback(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 65: {
                    data.enforceInterface(descriptor);
                    IBinder _result = this.startOrGetTestNetworkService();
                    reply.writeNoException();
                    reply.writeStrongBinder(_result);
                    return true;
                }
                case 66: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    long _arg1 = data.readLong();
                    Network _arg2 = 0 != data.readInt() ? Network.CREATOR.createFromParcel(data) : null;
                    PersistableBundle _arg3 = 0 != data.readInt() ? PersistableBundle.CREATOR.createFromParcel(data) : null;
                    this.simulateDataStall(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 67: {
                    data.enforceInterface(descriptor);
                    this.systemReady();
                    reply.writeNoException();
                    return true;
                }
                case 68: {
                    data.enforceInterface(descriptor);
                    INetworkActivityListener _arg0 = INetworkActivityListener.Stub.asInterface(data.readStrongBinder());
                    this.registerNetworkActivityListener(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 69: {
                    data.enforceInterface(descriptor);
                    INetworkActivityListener _arg0 = INetworkActivityListener.Stub.asInterface(data.readStrongBinder());
                    this.unregisterNetworkActivityListener(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 70: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.isDefaultNetworkActive();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 71: {
                    data.enforceInterface(descriptor);
                    QosSocketInfo _arg0 = 0 != data.readInt() ? QosSocketInfo.CREATOR.createFromParcel(data) : null;
                    IQosCallback _arg1 = IQosCallback.Stub.asInterface(data.readStrongBinder());
                    this.registerQosSocketCallback(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 72: {
                    data.enforceInterface(descriptor);
                    IQosCallback _arg0 = IQosCallback.Stub.asInterface(data.readStrongBinder());
                    this.unregisterQosCallback(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 73: {
                    data.enforceInterface(descriptor);
                    OemNetworkPreferences _arg0 = 0 != data.readInt() ? OemNetworkPreferences.CREATOR.createFromParcel(data) : null;
                    IOnCompleteListener _arg1 = IOnCompleteListener.Stub.asInterface(data.readStrongBinder());
                    this.setOemNetworkPreference(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 74: {
                    data.enforceInterface(descriptor);
                    UserHandle _arg0 = 0 != data.readInt() ? UserHandle.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    IOnCompleteListener _arg2 = IOnCompleteListener.Stub.asInterface(data.readStrongBinder());
                    this.setProfileNetworkPreference(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 75: {
                    data.enforceInterface(descriptor);
                    int _result = this.getRestrictBackgroundStatusByCaller();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 76: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    NetworkScore _arg1 = 0 != data.readInt() ? NetworkScore.CREATOR.createFromParcel(data) : null;
                    NetworkCapabilities _arg2 = 0 != data.readInt() ? NetworkCapabilities.CREATOR.createFromParcel(data) : null;
                    INetworkOfferCallback _arg3 = INetworkOfferCallback.Stub.asInterface(data.readStrongBinder());
                    this.offerNetwork(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 77: {
                    data.enforceInterface(descriptor);
                    INetworkOfferCallback _arg0 = INetworkOfferCallback.Stub.asInterface(data.readStrongBinder());
                    this.unofferNetwork(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 78: {
                    data.enforceInterface(descriptor);
                    long _arg0 = data.readLong();
                    this.setTestAllowBadWifiUntil(_arg0);
                    reply.writeNoException();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IConnectivityManager impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IConnectivityManager getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IConnectivityManager {
            private IBinder mRemote;
            public static IConnectivityManager sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Network getActiveNetwork() throws RemoteException {
                Network _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Network network = Stub.getDefaultImpl().getActiveNetwork();
                        return network;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? Network.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Network getActiveNetworkForUid(int uid, boolean ignoreBlocked) throws RemoteException {
                Network _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    _data.writeInt(ignoreBlocked ? 1 : 0);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Network network = Stub.getDefaultImpl().getActiveNetworkForUid(uid, ignoreBlocked);
                        return network;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? Network.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public NetworkInfo getActiveNetworkInfo() throws RemoteException {
                NetworkInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        NetworkInfo networkInfo = Stub.getDefaultImpl().getActiveNetworkInfo();
                        return networkInfo;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? NetworkInfo.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public NetworkInfo getActiveNetworkInfoForUid(int uid, boolean ignoreBlocked) throws RemoteException {
                NetworkInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    _data.writeInt(ignoreBlocked ? 1 : 0);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        NetworkInfo networkInfo = Stub.getDefaultImpl().getActiveNetworkInfoForUid(uid, ignoreBlocked);
                        return networkInfo;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? NetworkInfo.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public NetworkInfo getNetworkInfo(int networkType) throws RemoteException {
                NetworkInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(networkType);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        NetworkInfo networkInfo = Stub.getDefaultImpl().getNetworkInfo(networkType);
                        return networkInfo;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? NetworkInfo.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public NetworkInfo getNetworkInfoForUid(Network network, int uid, boolean ignoreBlocked) throws RemoteException {
                NetworkInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (network != null) {
                        _data.writeInt(1);
                        network.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(uid);
                    _data.writeInt(ignoreBlocked ? 1 : 0);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        NetworkInfo networkInfo = Stub.getDefaultImpl().getNetworkInfoForUid(network, uid, ignoreBlocked);
                        return networkInfo;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? NetworkInfo.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public NetworkInfo[] getAllNetworkInfo() throws RemoteException {
                NetworkInfo[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        NetworkInfo[] networkInfoArray = Stub.getDefaultImpl().getAllNetworkInfo();
                        return networkInfoArray;
                    }
                    _reply.readException();
                    _result = _reply.createTypedArray(NetworkInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Network getNetworkForType(int networkType) throws RemoteException {
                Network _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(networkType);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Network network = Stub.getDefaultImpl().getNetworkForType(networkType);
                        return network;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? Network.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Network[] getAllNetworks() throws RemoteException {
                Network[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Network[] networkArray = Stub.getDefaultImpl().getAllNetworks();
                        return networkArray;
                    }
                    _reply.readException();
                    _result = _reply.createTypedArray(Network.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public NetworkCapabilities[] getDefaultNetworkCapabilitiesForUser(int userId, String callingPackageName, String callingAttributionTag) throws RemoteException {
                NetworkCapabilities[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeString(callingPackageName);
                    _data.writeString(callingAttributionTag);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        NetworkCapabilities[] networkCapabilitiesArray = Stub.getDefaultImpl().getDefaultNetworkCapabilitiesForUser(userId, callingPackageName, callingAttributionTag);
                        return networkCapabilitiesArray;
                    }
                    _reply.readException();
                    _result = _reply.createTypedArray(NetworkCapabilities.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isNetworkSupported(int networkType) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(networkType);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isNetworkSupported(networkType);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public LinkProperties getActiveLinkProperties() throws RemoteException {
                LinkProperties _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        LinkProperties linkProperties = Stub.getDefaultImpl().getActiveLinkProperties();
                        return linkProperties;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? LinkProperties.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public LinkProperties getLinkPropertiesForType(int networkType) throws RemoteException {
                LinkProperties _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(networkType);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        LinkProperties linkProperties = Stub.getDefaultImpl().getLinkPropertiesForType(networkType);
                        return linkProperties;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? LinkProperties.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public LinkProperties getLinkProperties(Network network) throws RemoteException {
                LinkProperties _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (network != null) {
                        _data.writeInt(1);
                        network.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        LinkProperties linkProperties = Stub.getDefaultImpl().getLinkProperties(network);
                        return linkProperties;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? LinkProperties.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public NetworkCapabilities getNetworkCapabilities(Network network, String callingPackageName, String callingAttributionTag) throws RemoteException {
                NetworkCapabilities _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (network != null) {
                        _data.writeInt(1);
                        network.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(callingPackageName);
                    _data.writeString(callingAttributionTag);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        NetworkCapabilities networkCapabilities = Stub.getDefaultImpl().getNetworkCapabilities(network, callingPackageName, callingAttributionTag);
                        return networkCapabilities;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? NetworkCapabilities.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public NetworkState[] getAllNetworkState() throws RemoteException {
                NetworkState[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        NetworkState[] networkStateArray = Stub.getDefaultImpl().getAllNetworkState();
                        return networkStateArray;
                    }
                    _reply.readException();
                    _result = _reply.createTypedArray(NetworkState.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<NetworkStateSnapshot> getAllNetworkStateSnapshots() throws RemoteException {
                ArrayList<NetworkStateSnapshot> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        List<NetworkStateSnapshot> list = Stub.getDefaultImpl().getAllNetworkStateSnapshots();
                        return list;
                    }
                    _reply.readException();
                    _result = _reply.createTypedArrayList(NetworkStateSnapshot.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isActiveNetworkMetered() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isActiveNetworkMetered();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean requestRouteToHostAddress(int networkType, byte[] hostAddress, String callingPackageName, String callingAttributionTag) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(networkType);
                    _data.writeByteArray(hostAddress);
                    _data.writeString(callingPackageName);
                    _data.writeString(callingAttributionTag);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().requestRouteToHostAddress(networkType, hostAddress, callingPackageName, callingAttributionTag);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getLastTetherError(String iface) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(iface);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getLastTetherError(iface);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] getTetherableIfaces() throws RemoteException {
                String[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String[] stringArray = Stub.getDefaultImpl().getTetherableIfaces();
                        return stringArray;
                    }
                    _reply.readException();
                    _result = _reply.createStringArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] getTetheredIfaces() throws RemoteException {
                String[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String[] stringArray = Stub.getDefaultImpl().getTetheredIfaces();
                        return stringArray;
                    }
                    _reply.readException();
                    _result = _reply.createStringArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] getTetheringErroredIfaces() throws RemoteException {
                String[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String[] stringArray = Stub.getDefaultImpl().getTetheringErroredIfaces();
                        return stringArray;
                    }
                    _reply.readException();
                    _result = _reply.createStringArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] getTetherableUsbRegexs() throws RemoteException {
                String[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String[] stringArray = Stub.getDefaultImpl().getTetherableUsbRegexs();
                        return stringArray;
                    }
                    _reply.readException();
                    _result = _reply.createStringArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] getTetherableWifiRegexs() throws RemoteException {
                String[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String[] stringArray = Stub.getDefaultImpl().getTetherableWifiRegexs();
                        return stringArray;
                    }
                    _reply.readException();
                    _result = _reply.createStringArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reportInetCondition(int networkType, int percentage) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(networkType);
                    _data.writeInt(percentage);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().reportInetCondition(networkType, percentage);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reportNetworkConnectivity(Network network, boolean hasConnectivity) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (network != null) {
                        _data.writeInt(1);
                        network.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(hasConnectivity ? 1 : 0);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().reportNetworkConnectivity(network, hasConnectivity);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ProxyInfo getGlobalProxy() throws RemoteException {
                ProxyInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ProxyInfo proxyInfo = Stub.getDefaultImpl().getGlobalProxy();
                        return proxyInfo;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? ProxyInfo.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setGlobalProxy(ProxyInfo p) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (p != null) {
                        _data.writeInt(1);
                        p.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setGlobalProxy(p);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ProxyInfo getProxyForNetwork(Network nework) throws RemoteException {
                ProxyInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (nework != null) {
                        _data.writeInt(1);
                        nework.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ProxyInfo proxyInfo = Stub.getDefaultImpl().getProxyForNetwork(nework);
                        return proxyInfo;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? ProxyInfo.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setRequireVpnForUids(boolean requireVpn, UidRange[] ranges) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(requireVpn ? 1 : 0);
                    _data.writeTypedArray(ranges, 0);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setRequireVpnForUids(requireVpn, ranges);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setLegacyLockdownVpnEnabled(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(enabled ? 1 : 0);
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setLegacyLockdownVpnEnabled(enabled);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setProvisioningNotificationVisible(boolean visible, int networkType, String action) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(visible ? 1 : 0);
                    _data.writeInt(networkType);
                    _data.writeString(action);
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setProvisioningNotificationVisible(visible, networkType, action);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAirplaneMode(boolean enable) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(enable ? 1 : 0);
                    boolean _status = this.mRemote.transact(34, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setAirplaneMode(enable);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean requestBandwidthUpdate(Network network) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (network != null) {
                        _data.writeInt(1);
                        network.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(35, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().requestBandwidthUpdate(network);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int registerNetworkProvider(Messenger messenger, String name) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (messenger != null) {
                        _data.writeInt(1);
                        messenger.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(name);
                    boolean _status = this.mRemote.transact(36, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().registerNetworkProvider(messenger, name);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterNetworkProvider(Messenger messenger) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (messenger != null) {
                        _data.writeInt(1);
                        messenger.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(37, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().unregisterNetworkProvider(messenger);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void declareNetworkRequestUnfulfillable(NetworkRequest request) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (request != null) {
                        _data.writeInt(1);
                        request.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(38, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().declareNetworkRequestUnfulfillable(request);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Network registerNetworkAgent(INetworkAgent na, NetworkInfo ni, LinkProperties lp, NetworkCapabilities nc, NetworkScore score, NetworkAgentConfig config, int factorySerialNumber) throws RemoteException {
                Network _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(na != null ? na.asBinder() : null);
                    if (ni != null) {
                        _data.writeInt(1);
                        ni.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (lp != null) {
                        _data.writeInt(1);
                        lp.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (nc != null) {
                        _data.writeInt(1);
                        nc.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (score != null) {
                        _data.writeInt(1);
                        score.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (config != null) {
                        _data.writeInt(1);
                        config.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(factorySerialNumber);
                    boolean _status = this.mRemote.transact(39, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Network network = Stub.getDefaultImpl().registerNetworkAgent(na, ni, lp, nc, score, config, factorySerialNumber);
                        return network;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? Network.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public NetworkRequest requestNetwork(int uid, NetworkCapabilities networkCapabilities, int reqType, Messenger messenger, int timeoutSec, IBinder binder, int legacy, int callbackFlags, String callingPackageName, String callingAttributionTag) throws RemoteException {
                NetworkRequest _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    if (networkCapabilities != null) {
                        _data.writeInt(1);
                        networkCapabilities.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(reqType);
                    if (messenger != null) {
                        _data.writeInt(1);
                        messenger.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(timeoutSec);
                    _data.writeStrongBinder(binder);
                    _data.writeInt(legacy);
                    _data.writeInt(callbackFlags);
                    _data.writeString(callingPackageName);
                    _data.writeString(callingAttributionTag);
                    boolean _status = this.mRemote.transact(40, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        NetworkRequest networkRequest = Stub.getDefaultImpl().requestNetwork(uid, networkCapabilities, reqType, messenger, timeoutSec, binder, legacy, callbackFlags, callingPackageName, callingAttributionTag);
                        return networkRequest;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? NetworkRequest.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public NetworkRequest pendingRequestForNetwork(NetworkCapabilities networkCapabilities, PendingIntent operation, String callingPackageName, String callingAttributionTag) throws RemoteException {
                NetworkRequest _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (networkCapabilities != null) {
                        _data.writeInt(1);
                        networkCapabilities.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (operation != null) {
                        _data.writeInt(1);
                        operation.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(callingPackageName);
                    _data.writeString(callingAttributionTag);
                    boolean _status = this.mRemote.transact(41, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        NetworkRequest networkRequest = Stub.getDefaultImpl().pendingRequestForNetwork(networkCapabilities, operation, callingPackageName, callingAttributionTag);
                        return networkRequest;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? NetworkRequest.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void releasePendingNetworkRequest(PendingIntent operation) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (operation != null) {
                        _data.writeInt(1);
                        operation.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(42, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().releasePendingNetworkRequest(operation);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public NetworkRequest listenForNetwork(NetworkCapabilities networkCapabilities, Messenger messenger, IBinder binder, int callbackFlags, String callingPackageName, String callingAttributionTag) throws RemoteException {
                NetworkRequest _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (networkCapabilities != null) {
                        _data.writeInt(1);
                        networkCapabilities.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (messenger != null) {
                        _data.writeInt(1);
                        messenger.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(binder);
                    _data.writeInt(callbackFlags);
                    _data.writeString(callingPackageName);
                    _data.writeString(callingAttributionTag);
                    boolean _status = this.mRemote.transact(43, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        NetworkRequest networkRequest = Stub.getDefaultImpl().listenForNetwork(networkCapabilities, messenger, binder, callbackFlags, callingPackageName, callingAttributionTag);
                        return networkRequest;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? NetworkRequest.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void pendingListenForNetwork(NetworkCapabilities networkCapabilities, PendingIntent operation, String callingPackageName, String callingAttributionTag) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (networkCapabilities != null) {
                        _data.writeInt(1);
                        networkCapabilities.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (operation != null) {
                        _data.writeInt(1);
                        operation.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(callingPackageName);
                    _data.writeString(callingAttributionTag);
                    boolean _status = this.mRemote.transact(44, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().pendingListenForNetwork(networkCapabilities, operation, callingPackageName, callingAttributionTag);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void releaseNetworkRequest(NetworkRequest networkRequest) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (networkRequest != null) {
                        _data.writeInt(1);
                        networkRequest.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(45, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().releaseNetworkRequest(networkRequest);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAcceptUnvalidated(Network network, boolean accept, boolean always) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (network != null) {
                        _data.writeInt(1);
                        network.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(accept ? 1 : 0);
                    _data.writeInt(always ? 1 : 0);
                    boolean _status = this.mRemote.transact(46, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setAcceptUnvalidated(network, accept, always);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAcceptPartialConnectivity(Network network, boolean accept, boolean always) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (network != null) {
                        _data.writeInt(1);
                        network.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(accept ? 1 : 0);
                    _data.writeInt(always ? 1 : 0);
                    boolean _status = this.mRemote.transact(47, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setAcceptPartialConnectivity(network, accept, always);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAvoidUnvalidated(Network network) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (network != null) {
                        _data.writeInt(1);
                        network.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(48, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setAvoidUnvalidated(network);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startCaptivePortalApp(Network network) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (network != null) {
                        _data.writeInt(1);
                        network.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(49, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().startCaptivePortalApp(network);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startCaptivePortalAppInternal(Network network, Bundle appExtras) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (network != null) {
                        _data.writeInt(1);
                        network.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (appExtras != null) {
                        _data.writeInt(1);
                        appExtras.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(50, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().startCaptivePortalAppInternal(network, appExtras);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean shouldAvoidBadWifi() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(51, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().shouldAvoidBadWifi();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getMultipathPreference(Network Network2) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (Network2 != null) {
                        _data.writeInt(1);
                        Network2.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(52, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getMultipathPreference(Network2);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public NetworkRequest getDefaultRequest() throws RemoteException {
                NetworkRequest _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(53, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        NetworkRequest networkRequest = Stub.getDefaultImpl().getDefaultRequest();
                        return networkRequest;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? NetworkRequest.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getRestoreDefaultNetworkDelay(int networkType) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(networkType);
                    boolean _status = this.mRemote.transact(54, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getRestoreDefaultNetworkDelay(networkType);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void factoryReset() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(55, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().factoryReset();
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startNattKeepalive(Network network, int intervalSeconds, ISocketKeepaliveCallback cb, String srcAddr, int srcPort, String dstAddr) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (network != null) {
                        _data.writeInt(1);
                        network.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(intervalSeconds);
                    _data.writeStrongBinder(cb != null ? cb.asBinder() : null);
                    _data.writeString(srcAddr);
                    _data.writeInt(srcPort);
                    _data.writeString(dstAddr);
                    boolean _status = this.mRemote.transact(56, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().startNattKeepalive(network, intervalSeconds, cb, srcAddr, srcPort, dstAddr);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startNattKeepaliveWithFd(Network network, ParcelFileDescriptor pfd, int resourceId, int intervalSeconds, ISocketKeepaliveCallback cb, String srcAddr, String dstAddr) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (network != null) {
                        _data.writeInt(1);
                        network.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (pfd != null) {
                        _data.writeInt(1);
                        pfd.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(resourceId);
                    _data.writeInt(intervalSeconds);
                    _data.writeStrongBinder(cb != null ? cb.asBinder() : null);
                    _data.writeString(srcAddr);
                    _data.writeString(dstAddr);
                    boolean _status = this.mRemote.transact(57, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().startNattKeepaliveWithFd(network, pfd, resourceId, intervalSeconds, cb, srcAddr, dstAddr);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startTcpKeepalive(Network network, ParcelFileDescriptor pfd, int intervalSeconds, ISocketKeepaliveCallback cb) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (network != null) {
                        _data.writeInt(1);
                        network.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (pfd != null) {
                        _data.writeInt(1);
                        pfd.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(intervalSeconds);
                    _data.writeStrongBinder(cb != null ? cb.asBinder() : null);
                    boolean _status = this.mRemote.transact(58, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().startTcpKeepalive(network, pfd, intervalSeconds, cb);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopKeepalive(Network network, int slot) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (network != null) {
                        _data.writeInt(1);
                        network.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(slot);
                    boolean _status = this.mRemote.transact(59, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().stopKeepalive(network, slot);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getCaptivePortalServerUrl() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(60, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String string2 = Stub.getDefaultImpl().getCaptivePortalServerUrl();
                        return string2;
                    }
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] getNetworkWatchlistConfigHash() throws RemoteException {
                byte[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(61, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        byte[] byArray = Stub.getDefaultImpl().getNetworkWatchlistConfigHash();
                        return byArray;
                    }
                    _reply.readException();
                    _result = _reply.createByteArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getConnectionOwnerUid(ConnectionInfo connectionInfo) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (connectionInfo != null) {
                        _data.writeInt(1);
                        connectionInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(62, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getConnectionOwnerUid(connectionInfo);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerConnectivityDiagnosticsCallback(IConnectivityDiagnosticsCallback callback, NetworkRequest request, String callingPackageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    if (request != null) {
                        _data.writeInt(1);
                        request.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(callingPackageName);
                    boolean _status = this.mRemote.transact(63, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().registerConnectivityDiagnosticsCallback(callback, request, callingPackageName);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterConnectivityDiagnosticsCallback(IConnectivityDiagnosticsCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean _status = this.mRemote.transact(64, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().unregisterConnectivityDiagnosticsCallback(callback);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IBinder startOrGetTestNetworkService() throws RemoteException {
                IBinder _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(65, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        IBinder iBinder = Stub.getDefaultImpl().startOrGetTestNetworkService();
                        return iBinder;
                    }
                    _reply.readException();
                    _result = _reply.readStrongBinder();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void simulateDataStall(int detectionMethod, long timestampMillis, Network network, PersistableBundle extras) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(detectionMethod);
                    _data.writeLong(timestampMillis);
                    if (network != null) {
                        _data.writeInt(1);
                        network.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (extras != null) {
                        _data.writeInt(1);
                        extras.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(66, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().simulateDataStall(detectionMethod, timestampMillis, network, extras);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void systemReady() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(67, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().systemReady();
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerNetworkActivityListener(INetworkActivityListener l) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(l != null ? l.asBinder() : null);
                    boolean _status = this.mRemote.transact(68, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().registerNetworkActivityListener(l);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterNetworkActivityListener(INetworkActivityListener l) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(l != null ? l.asBinder() : null);
                    boolean _status = this.mRemote.transact(69, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().unregisterNetworkActivityListener(l);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isDefaultNetworkActive() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(70, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isDefaultNetworkActive();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerQosSocketCallback(QosSocketInfo socketInfo, IQosCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (socketInfo != null) {
                        _data.writeInt(1);
                        socketInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean _status = this.mRemote.transact(71, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().registerQosSocketCallback(socketInfo, callback);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterQosCallback(IQosCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean _status = this.mRemote.transact(72, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().unregisterQosCallback(callback);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOemNetworkPreference(OemNetworkPreferences preference, IOnCompleteListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (preference != null) {
                        _data.writeInt(1);
                        preference.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    boolean _status = this.mRemote.transact(73, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setOemNetworkPreference(preference, listener);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setProfileNetworkPreference(UserHandle profile, int preference, IOnCompleteListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (profile != null) {
                        _data.writeInt(1);
                        profile.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(preference);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    boolean _status = this.mRemote.transact(74, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setProfileNetworkPreference(profile, preference, listener);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getRestrictBackgroundStatusByCaller() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(75, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getRestrictBackgroundStatusByCaller();
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void offerNetwork(int providerId, NetworkScore score, NetworkCapabilities caps, INetworkOfferCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(providerId);
                    if (score != null) {
                        _data.writeInt(1);
                        score.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (caps != null) {
                        _data.writeInt(1);
                        caps.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean _status = this.mRemote.transact(76, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().offerNetwork(providerId, score, caps, callback);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unofferNetwork(INetworkOfferCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean _status = this.mRemote.transact(77, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().unofferNetwork(callback);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setTestAllowBadWifiUntil(long timeMs) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(timeMs);
                    boolean _status = this.mRemote.transact(78, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setTestAllowBadWifiUntil(timeMs);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IConnectivityManager {
        @Override
        public Network getActiveNetwork() throws RemoteException {
            return null;
        }

        @Override
        public Network getActiveNetworkForUid(int uid, boolean ignoreBlocked) throws RemoteException {
            return null;
        }

        @Override
        public NetworkInfo getActiveNetworkInfo() throws RemoteException {
            return null;
        }

        @Override
        public NetworkInfo getActiveNetworkInfoForUid(int uid, boolean ignoreBlocked) throws RemoteException {
            return null;
        }

        @Override
        public NetworkInfo getNetworkInfo(int networkType) throws RemoteException {
            return null;
        }

        @Override
        public NetworkInfo getNetworkInfoForUid(Network network, int uid, boolean ignoreBlocked) throws RemoteException {
            return null;
        }

        @Override
        public NetworkInfo[] getAllNetworkInfo() throws RemoteException {
            return null;
        }

        @Override
        public Network getNetworkForType(int networkType) throws RemoteException {
            return null;
        }

        @Override
        public Network[] getAllNetworks() throws RemoteException {
            return null;
        }

        @Override
        public NetworkCapabilities[] getDefaultNetworkCapabilitiesForUser(int userId, String callingPackageName, String callingAttributionTag) throws RemoteException {
            return null;
        }

        @Override
        public boolean isNetworkSupported(int networkType) throws RemoteException {
            return false;
        }

        @Override
        public LinkProperties getActiveLinkProperties() throws RemoteException {
            return null;
        }

        @Override
        public LinkProperties getLinkPropertiesForType(int networkType) throws RemoteException {
            return null;
        }

        @Override
        public LinkProperties getLinkProperties(Network network) throws RemoteException {
            return null;
        }

        @Override
        public NetworkCapabilities getNetworkCapabilities(Network network, String callingPackageName, String callingAttributionTag) throws RemoteException {
            return null;
        }

        @Override
        public NetworkState[] getAllNetworkState() throws RemoteException {
            return null;
        }

        @Override
        public List<NetworkStateSnapshot> getAllNetworkStateSnapshots() throws RemoteException {
            return null;
        }

        @Override
        public boolean isActiveNetworkMetered() throws RemoteException {
            return false;
        }

        @Override
        public boolean requestRouteToHostAddress(int networkType, byte[] hostAddress, String callingPackageName, String callingAttributionTag) throws RemoteException {
            return false;
        }

        @Override
        public int getLastTetherError(String iface) throws RemoteException {
            return 0;
        }

        @Override
        public String[] getTetherableIfaces() throws RemoteException {
            return null;
        }

        @Override
        public String[] getTetheredIfaces() throws RemoteException {
            return null;
        }

        @Override
        public String[] getTetheringErroredIfaces() throws RemoteException {
            return null;
        }

        @Override
        public String[] getTetherableUsbRegexs() throws RemoteException {
            return null;
        }

        @Override
        public String[] getTetherableWifiRegexs() throws RemoteException {
            return null;
        }

        @Override
        public void reportInetCondition(int networkType, int percentage) throws RemoteException {
        }

        @Override
        public void reportNetworkConnectivity(Network network, boolean hasConnectivity) throws RemoteException {
        }

        @Override
        public ProxyInfo getGlobalProxy() throws RemoteException {
            return null;
        }

        @Override
        public void setGlobalProxy(ProxyInfo p) throws RemoteException {
        }

        @Override
        public ProxyInfo getProxyForNetwork(Network nework) throws RemoteException {
            return null;
        }

        @Override
        public void setRequireVpnForUids(boolean requireVpn, UidRange[] ranges) throws RemoteException {
        }

        @Override
        public void setLegacyLockdownVpnEnabled(boolean enabled) throws RemoteException {
        }

        @Override
        public void setProvisioningNotificationVisible(boolean visible, int networkType, String action) throws RemoteException {
        }

        @Override
        public void setAirplaneMode(boolean enable) throws RemoteException {
        }

        @Override
        public boolean requestBandwidthUpdate(Network network) throws RemoteException {
            return false;
        }

        @Override
        public int registerNetworkProvider(Messenger messenger, String name) throws RemoteException {
            return 0;
        }

        @Override
        public void unregisterNetworkProvider(Messenger messenger) throws RemoteException {
        }

        @Override
        public void declareNetworkRequestUnfulfillable(NetworkRequest request) throws RemoteException {
        }

        @Override
        public Network registerNetworkAgent(INetworkAgent na, NetworkInfo ni, LinkProperties lp, NetworkCapabilities nc, NetworkScore score, NetworkAgentConfig config, int factorySerialNumber) throws RemoteException {
            return null;
        }

        @Override
        public NetworkRequest requestNetwork(int uid, NetworkCapabilities networkCapabilities, int reqType, Messenger messenger, int timeoutSec, IBinder binder, int legacy, int callbackFlags, String callingPackageName, String callingAttributionTag) throws RemoteException {
            return null;
        }

        @Override
        public NetworkRequest pendingRequestForNetwork(NetworkCapabilities networkCapabilities, PendingIntent operation, String callingPackageName, String callingAttributionTag) throws RemoteException {
            return null;
        }

        @Override
        public void releasePendingNetworkRequest(PendingIntent operation) throws RemoteException {
        }

        @Override
        public NetworkRequest listenForNetwork(NetworkCapabilities networkCapabilities, Messenger messenger, IBinder binder, int callbackFlags, String callingPackageName, String callingAttributionTag) throws RemoteException {
            return null;
        }

        @Override
        public void pendingListenForNetwork(NetworkCapabilities networkCapabilities, PendingIntent operation, String callingPackageName, String callingAttributionTag) throws RemoteException {
        }

        @Override
        public void releaseNetworkRequest(NetworkRequest networkRequest) throws RemoteException {
        }

        @Override
        public void setAcceptUnvalidated(Network network, boolean accept, boolean always) throws RemoteException {
        }

        @Override
        public void setAcceptPartialConnectivity(Network network, boolean accept, boolean always) throws RemoteException {
        }

        @Override
        public void setAvoidUnvalidated(Network network) throws RemoteException {
        }

        @Override
        public void startCaptivePortalApp(Network network) throws RemoteException {
        }

        @Override
        public void startCaptivePortalAppInternal(Network network, Bundle appExtras) throws RemoteException {
        }

        @Override
        public boolean shouldAvoidBadWifi() throws RemoteException {
            return false;
        }

        @Override
        public int getMultipathPreference(Network Network2) throws RemoteException {
            return 0;
        }

        @Override
        public NetworkRequest getDefaultRequest() throws RemoteException {
            return null;
        }

        @Override
        public int getRestoreDefaultNetworkDelay(int networkType) throws RemoteException {
            return 0;
        }

        @Override
        public void factoryReset() throws RemoteException {
        }

        @Override
        public void startNattKeepalive(Network network, int intervalSeconds, ISocketKeepaliveCallback cb, String srcAddr, int srcPort, String dstAddr) throws RemoteException {
        }

        @Override
        public void startNattKeepaliveWithFd(Network network, ParcelFileDescriptor pfd, int resourceId, int intervalSeconds, ISocketKeepaliveCallback cb, String srcAddr, String dstAddr) throws RemoteException {
        }

        @Override
        public void startTcpKeepalive(Network network, ParcelFileDescriptor pfd, int intervalSeconds, ISocketKeepaliveCallback cb) throws RemoteException {
        }

        @Override
        public void stopKeepalive(Network network, int slot) throws RemoteException {
        }

        @Override
        public String getCaptivePortalServerUrl() throws RemoteException {
            return null;
        }

        @Override
        public byte[] getNetworkWatchlistConfigHash() throws RemoteException {
            return null;
        }

        @Override
        public int getConnectionOwnerUid(ConnectionInfo connectionInfo) throws RemoteException {
            return 0;
        }

        @Override
        public void registerConnectivityDiagnosticsCallback(IConnectivityDiagnosticsCallback callback, NetworkRequest request, String callingPackageName) throws RemoteException {
        }

        @Override
        public void unregisterConnectivityDiagnosticsCallback(IConnectivityDiagnosticsCallback callback) throws RemoteException {
        }

        @Override
        public IBinder startOrGetTestNetworkService() throws RemoteException {
            return null;
        }

        @Override
        public void simulateDataStall(int detectionMethod, long timestampMillis, Network network, PersistableBundle extras) throws RemoteException {
        }

        @Override
        public void systemReady() throws RemoteException {
        }

        @Override
        public void registerNetworkActivityListener(INetworkActivityListener l) throws RemoteException {
        }

        @Override
        public void unregisterNetworkActivityListener(INetworkActivityListener l) throws RemoteException {
        }

        @Override
        public boolean isDefaultNetworkActive() throws RemoteException {
            return false;
        }

        @Override
        public void registerQosSocketCallback(QosSocketInfo socketInfo, IQosCallback callback) throws RemoteException {
        }

        @Override
        public void unregisterQosCallback(IQosCallback callback) throws RemoteException {
        }

        @Override
        public void setOemNetworkPreference(OemNetworkPreferences preference, IOnCompleteListener listener) throws RemoteException {
        }

        @Override
        public void setProfileNetworkPreference(UserHandle profile, int preference, IOnCompleteListener listener) throws RemoteException {
        }

        @Override
        public int getRestrictBackgroundStatusByCaller() throws RemoteException {
            return 0;
        }

        @Override
        public void offerNetwork(int providerId, NetworkScore score, NetworkCapabilities caps, INetworkOfferCallback callback) throws RemoteException {
        }

        @Override
        public void unofferNetwork(INetworkOfferCallback callback) throws RemoteException {
        }

        @Override
        public void setTestAllowBadWifiUntil(long timeMs) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

