/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.NetworkScore;
import android.net.QosSession;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.telephony.data.EpsBearerQosSessionAttributes;
import android.telephony.data.NrQosSessionAttributes;
import java.util.ArrayList;
import java.util.List;

public interface INetworkAgentRegistry
extends IInterface {
    public static final String DESCRIPTOR = "android.net.INetworkAgentRegistry";

    public void sendNetworkCapabilities(NetworkCapabilities var1) throws RemoteException;

    public void sendLinkProperties(LinkProperties var1) throws RemoteException;

    public void sendNetworkInfo(NetworkInfo var1) throws RemoteException;

    public void sendScore(NetworkScore var1) throws RemoteException;

    public void sendExplicitlySelected(boolean var1, boolean var2) throws RemoteException;

    public void sendSocketKeepaliveEvent(int var1, int var2) throws RemoteException;

    public void sendUnderlyingNetworks(List<Network> var1) throws RemoteException;

    public void sendEpsQosSessionAvailable(int var1, QosSession var2, EpsBearerQosSessionAttributes var3) throws RemoteException;

    public void sendNrQosSessionAvailable(int var1, QosSession var2, NrQosSessionAttributes var3) throws RemoteException;

    public void sendQosSessionLost(int var1, QosSession var2) throws RemoteException;

    public void sendQosCallbackError(int var1, int var2) throws RemoteException;

    public void sendTeardownDelayMs(int var1) throws RemoteException;

    public void sendLingerDuration(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements INetworkAgentRegistry {
        static final int TRANSACTION_sendNetworkCapabilities = 1;
        static final int TRANSACTION_sendLinkProperties = 2;
        static final int TRANSACTION_sendNetworkInfo = 3;
        static final int TRANSACTION_sendScore = 4;
        static final int TRANSACTION_sendExplicitlySelected = 5;
        static final int TRANSACTION_sendSocketKeepaliveEvent = 6;
        static final int TRANSACTION_sendUnderlyingNetworks = 7;
        static final int TRANSACTION_sendEpsQosSessionAvailable = 8;
        static final int TRANSACTION_sendNrQosSessionAvailable = 9;
        static final int TRANSACTION_sendQosSessionLost = 10;
        static final int TRANSACTION_sendQosCallbackError = 11;
        static final int TRANSACTION_sendTeardownDelayMs = 12;
        static final int TRANSACTION_sendLingerDuration = 13;

        public Stub() {
            this.attachInterface(this, INetworkAgentRegistry.DESCRIPTOR);
        }

        public static INetworkAgentRegistry asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(INetworkAgentRegistry.DESCRIPTOR);
            if (iin != null && iin instanceof INetworkAgentRegistry) {
                return (INetworkAgentRegistry)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = INetworkAgentRegistry.DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    NetworkCapabilities _arg0 = 0 != data.readInt() ? NetworkCapabilities.CREATOR.createFromParcel(data) : null;
                    this.sendNetworkCapabilities(_arg0);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    LinkProperties _arg0 = 0 != data.readInt() ? LinkProperties.CREATOR.createFromParcel(data) : null;
                    this.sendLinkProperties(_arg0);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    NetworkInfo _arg0 = 0 != data.readInt() ? NetworkInfo.CREATOR.createFromParcel(data) : null;
                    this.sendNetworkInfo(_arg0);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    NetworkScore _arg0 = 0 != data.readInt() ? NetworkScore.CREATOR.createFromParcel(data) : null;
                    this.sendScore(_arg0);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    boolean _arg1 = 0 != data.readInt();
                    this.sendExplicitlySelected(_arg0, _arg1);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.sendSocketKeepaliveEvent(_arg0, _arg1);
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    ArrayList<Network> _arg0 = data.createTypedArrayList(Network.CREATOR);
                    this.sendUnderlyingNetworks(_arg0);
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    QosSession _arg1 = 0 != data.readInt() ? QosSession.CREATOR.createFromParcel(data) : null;
                    EpsBearerQosSessionAttributes _arg2 = 0 != data.readInt() ? EpsBearerQosSessionAttributes.CREATOR.createFromParcel(data) : null;
                    this.sendEpsQosSessionAvailable(_arg0, _arg1, _arg2);
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    QosSession _arg1 = 0 != data.readInt() ? QosSession.CREATOR.createFromParcel(data) : null;
                    NrQosSessionAttributes _arg2 = 0 != data.readInt() ? NrQosSessionAttributes.CREATOR.createFromParcel(data) : null;
                    this.sendNrQosSessionAvailable(_arg0, _arg1, _arg2);
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    QosSession _arg1 = 0 != data.readInt() ? QosSession.CREATOR.createFromParcel(data) : null;
                    this.sendQosSessionLost(_arg0, _arg1);
                    return true;
                }
                case 11: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.sendQosCallbackError(_arg0, _arg1);
                    return true;
                }
                case 12: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.sendTeardownDelayMs(_arg0);
                    return true;
                }
                case 13: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.sendLingerDuration(_arg0);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(INetworkAgentRegistry impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static INetworkAgentRegistry getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements INetworkAgentRegistry {
            private IBinder mRemote;
            public static INetworkAgentRegistry sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return INetworkAgentRegistry.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendNetworkCapabilities(NetworkCapabilities nc) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgentRegistry.DESCRIPTOR);
                    if (nc != null) {
                        _data.writeInt(1);
                        nc.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().sendNetworkCapabilities(nc);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendLinkProperties(LinkProperties lp) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgentRegistry.DESCRIPTOR);
                    if (lp != null) {
                        _data.writeInt(1);
                        lp.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().sendLinkProperties(lp);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendNetworkInfo(NetworkInfo info) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgentRegistry.DESCRIPTOR);
                    if (info != null) {
                        _data.writeInt(1);
                        info.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().sendNetworkInfo(info);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendScore(NetworkScore score) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgentRegistry.DESCRIPTOR);
                    if (score != null) {
                        _data.writeInt(1);
                        score.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(4, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().sendScore(score);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendExplicitlySelected(boolean explicitlySelected, boolean acceptPartial) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgentRegistry.DESCRIPTOR);
                    _data.writeInt(explicitlySelected ? 1 : 0);
                    _data.writeInt(acceptPartial ? 1 : 0);
                    boolean _status = this.mRemote.transact(5, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().sendExplicitlySelected(explicitlySelected, acceptPartial);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendSocketKeepaliveEvent(int slot, int reason) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgentRegistry.DESCRIPTOR);
                    _data.writeInt(slot);
                    _data.writeInt(reason);
                    boolean _status = this.mRemote.transact(6, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().sendSocketKeepaliveEvent(slot, reason);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendUnderlyingNetworks(List<Network> networks) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgentRegistry.DESCRIPTOR);
                    _data.writeTypedList(networks);
                    boolean _status = this.mRemote.transact(7, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().sendUnderlyingNetworks(networks);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendEpsQosSessionAvailable(int callbackId, QosSession session, EpsBearerQosSessionAttributes attributes) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgentRegistry.DESCRIPTOR);
                    _data.writeInt(callbackId);
                    if (session != null) {
                        _data.writeInt(1);
                        session.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (attributes != null) {
                        _data.writeInt(1);
                        attributes.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(8, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().sendEpsQosSessionAvailable(callbackId, session, attributes);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendNrQosSessionAvailable(int callbackId, QosSession session, NrQosSessionAttributes attributes) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgentRegistry.DESCRIPTOR);
                    _data.writeInt(callbackId);
                    if (session != null) {
                        _data.writeInt(1);
                        session.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (attributes != null) {
                        _data.writeInt(1);
                        attributes.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(9, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().sendNrQosSessionAvailable(callbackId, session, attributes);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendQosSessionLost(int qosCallbackId, QosSession session) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgentRegistry.DESCRIPTOR);
                    _data.writeInt(qosCallbackId);
                    if (session != null) {
                        _data.writeInt(1);
                        session.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(10, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().sendQosSessionLost(qosCallbackId, session);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendQosCallbackError(int qosCallbackId, int exceptionType) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgentRegistry.DESCRIPTOR);
                    _data.writeInt(qosCallbackId);
                    _data.writeInt(exceptionType);
                    boolean _status = this.mRemote.transact(11, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().sendQosCallbackError(qosCallbackId, exceptionType);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendTeardownDelayMs(int teardownDelayMs) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgentRegistry.DESCRIPTOR);
                    _data.writeInt(teardownDelayMs);
                    boolean _status = this.mRemote.transact(12, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().sendTeardownDelayMs(teardownDelayMs);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendLingerDuration(int durationMs) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgentRegistry.DESCRIPTOR);
                    _data.writeInt(durationMs);
                    boolean _status = this.mRemote.transact(13, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().sendLingerDuration(durationMs);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements INetworkAgentRegistry {
        @Override
        public void sendNetworkCapabilities(NetworkCapabilities nc) throws RemoteException {
        }

        @Override
        public void sendLinkProperties(LinkProperties lp) throws RemoteException {
        }

        @Override
        public void sendNetworkInfo(NetworkInfo info) throws RemoteException {
        }

        @Override
        public void sendScore(NetworkScore score) throws RemoteException {
        }

        @Override
        public void sendExplicitlySelected(boolean explicitlySelected, boolean acceptPartial) throws RemoteException {
        }

        @Override
        public void sendSocketKeepaliveEvent(int slot, int reason) throws RemoteException {
        }

        @Override
        public void sendUnderlyingNetworks(List<Network> networks) throws RemoteException {
        }

        @Override
        public void sendEpsQosSessionAvailable(int callbackId, QosSession session, EpsBearerQosSessionAttributes attributes) throws RemoteException {
        }

        @Override
        public void sendNrQosSessionAvailable(int callbackId, QosSession session, NrQosSessionAttributes attributes) throws RemoteException {
        }

        @Override
        public void sendQosSessionLost(int qosCallbackId, QosSession session) throws RemoteException {
        }

        @Override
        public void sendQosCallbackError(int qosCallbackId, int exceptionType) throws RemoteException {
        }

        @Override
        public void sendTeardownDelayMs(int teardownDelayMs) throws RemoteException {
        }

        @Override
        public void sendLingerDuration(int durationMs) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

