/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.NetworkRequest;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface INetworkOfferCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.net.INetworkOfferCallback";

    public void onNetworkNeeded(NetworkRequest var1) throws RemoteException;

    public void onNetworkUnneeded(NetworkRequest var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements INetworkOfferCallback {
        static final int TRANSACTION_onNetworkNeeded = 1;
        static final int TRANSACTION_onNetworkUnneeded = 2;

        public Stub() {
            this.attachInterface(this, INetworkOfferCallback.DESCRIPTOR);
        }

        public static INetworkOfferCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(INetworkOfferCallback.DESCRIPTOR);
            if (iin != null && iin instanceof INetworkOfferCallback) {
                return (INetworkOfferCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = INetworkOfferCallback.DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    NetworkRequest _arg0 = 0 != data.readInt() ? NetworkRequest.CREATOR.createFromParcel(data) : null;
                    this.onNetworkNeeded(_arg0);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    NetworkRequest _arg0 = 0 != data.readInt() ? NetworkRequest.CREATOR.createFromParcel(data) : null;
                    this.onNetworkUnneeded(_arg0);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(INetworkOfferCallback impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static INetworkOfferCallback getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements INetworkOfferCallback {
            private IBinder mRemote;
            public static INetworkOfferCallback sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return INetworkOfferCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNetworkNeeded(NetworkRequest networkRequest) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkOfferCallback.DESCRIPTOR);
                    if (networkRequest != null) {
                        _data.writeInt(1);
                        networkRequest.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onNetworkNeeded(networkRequest);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNetworkUnneeded(NetworkRequest networkRequest) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkOfferCallback.DESCRIPTOR);
                    if (networkRequest != null) {
                        _data.writeInt(1);
                        networkRequest.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onNetworkUnneeded(networkRequest);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements INetworkOfferCallback {
        @Override
        public void onNetworkNeeded(NetworkRequest networkRequest) throws RemoteException {
        }

        @Override
        public void onNetworkUnneeded(NetworkRequest networkRequest) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

