/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.LinkAddress;
import android.net.LinkProperties;
import android.net.TestNetworkInterface;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ITestNetworkManager
extends IInterface {
    public static final String DESCRIPTOR = "android.net.ITestNetworkManager";

    public TestNetworkInterface createTunInterface(LinkAddress[] var1) throws RemoteException;

    public TestNetworkInterface createTapInterface() throws RemoteException;

    public void setupTestNetwork(String var1, LinkProperties var2, boolean var3, int[] var4, IBinder var5) throws RemoteException;

    public void teardownTestNetwork(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITestNetworkManager {
        static final int TRANSACTION_createTunInterface = 1;
        static final int TRANSACTION_createTapInterface = 2;
        static final int TRANSACTION_setupTestNetwork = 3;
        static final int TRANSACTION_teardownTestNetwork = 4;

        public Stub() {
            this.attachInterface(this, ITestNetworkManager.DESCRIPTOR);
        }

        public static ITestNetworkManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ITestNetworkManager.DESCRIPTOR);
            if (iin != null && iin instanceof ITestNetworkManager) {
                return (ITestNetworkManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ITestNetworkManager.DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    LinkAddress[] _arg0 = data.createTypedArray(LinkAddress.CREATOR);
                    TestNetworkInterface _result = this.createTunInterface(_arg0);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    TestNetworkInterface _result = this.createTapInterface();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    LinkProperties _arg1 = 0 != data.readInt() ? LinkProperties.CREATOR.createFromParcel(data) : null;
                    boolean _arg2 = 0 != data.readInt();
                    int[] _arg3 = data.createIntArray();
                    IBinder _arg4 = data.readStrongBinder();
                    this.setupTestNetwork(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.teardownTestNetwork(_arg0);
                    reply.writeNoException();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(ITestNetworkManager impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static ITestNetworkManager getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements ITestNetworkManager {
            private IBinder mRemote;
            public static ITestNetworkManager sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ITestNetworkManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public TestNetworkInterface createTunInterface(LinkAddress[] linkAddrs) throws RemoteException {
                TestNetworkInterface _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITestNetworkManager.DESCRIPTOR);
                    _data.writeTypedArray(linkAddrs, 0);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        TestNetworkInterface testNetworkInterface = Stub.getDefaultImpl().createTunInterface(linkAddrs);
                        return testNetworkInterface;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? TestNetworkInterface.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public TestNetworkInterface createTapInterface() throws RemoteException {
                TestNetworkInterface _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITestNetworkManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        TestNetworkInterface testNetworkInterface = Stub.getDefaultImpl().createTapInterface();
                        return testNetworkInterface;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? TestNetworkInterface.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setupTestNetwork(String iface, LinkProperties lp, boolean isMetered, int[] administratorUids, IBinder binder) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITestNetworkManager.DESCRIPTOR);
                    _data.writeString(iface);
                    if (lp != null) {
                        _data.writeInt(1);
                        lp.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(isMetered ? 1 : 0);
                    _data.writeIntArray(administratorUids);
                    _data.writeStrongBinder(binder);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setupTestNetwork(iface, lp, isMetered, administratorUids, binder);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void teardownTestNetwork(int netId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITestNetworkManager.DESCRIPTOR);
                    _data.writeInt(netId);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().teardownTestNetwork(netId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ITestNetworkManager {
        @Override
        public TestNetworkInterface createTunInterface(LinkAddress[] linkAddrs) throws RemoteException {
            return null;
        }

        @Override
        public TestNetworkInterface createTapInterface() throws RemoteException {
            return null;
        }

        @Override
        public void setupTestNetwork(String iface, LinkProperties lp, boolean isMetered, int[] administratorUids, IBinder binder) throws RemoteException {
        }

        @Override
        public void teardownTestNetwork(int netId) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

