/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ITetheredInterfaceCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.net.ITetheredInterfaceCallback";

    public void onAvailable(String var1) throws RemoteException;

    public void onUnavailable() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITetheredInterfaceCallback {
        static final int TRANSACTION_onAvailable = 1;
        static final int TRANSACTION_onUnavailable = 2;

        public Stub() {
            this.attachInterface(this, ITetheredInterfaceCallback.DESCRIPTOR);
        }

        public static ITetheredInterfaceCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ITetheredInterfaceCallback.DESCRIPTOR);
            if (iin != null && iin instanceof ITetheredInterfaceCallback) {
                return (ITetheredInterfaceCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onAvailable";
                }
                case 2: {
                    return "onUnavailable";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ITetheredInterfaceCallback.DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.onAvailable(_arg0);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    this.onUnavailable();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(ITetheredInterfaceCallback impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static ITetheredInterfaceCallback getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements ITetheredInterfaceCallback {
            private IBinder mRemote;
            public static ITetheredInterfaceCallback sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ITetheredInterfaceCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAvailable(String iface) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITetheredInterfaceCallback.DESCRIPTOR);
                    _data.writeString(iface);
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onAvailable(iface);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onUnavailable() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITetheredInterfaceCallback.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onUnavailable();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ITetheredInterfaceCallback {
        @Override
        public void onAvailable(String iface) throws RemoteException {
        }

        @Override
        public void onUnavailable() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

