/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.content.Context;
import android.net.IIpSecService;
import android.net.IpSecAlgorithm;
import android.net.IpSecConfig;
import android.net.IpSecManager;
import android.net.IpSecTransformResponse;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.ServiceSpecificException;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.Preconditions;
import dalvik.system.CloseGuard;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.InetAddress;

public class IpSecTransform
implements AutoCloseable {
    private static final String TAG = "IpSecTransform";
    public static final int MODE_TRANSPORT = 0;
    public static final int MODE_TUNNEL = 1;
    public static final int ENCAP_NONE = 0;
    public static final int ENCAP_ESPINUDP_NON_IKE = 1;
    public static final int ENCAP_ESPINUDP = 2;
    private final IpSecConfig mConfig;
    private int mResourceId;
    private final Context mContext;
    private final CloseGuard mCloseGuard = CloseGuard.get();

    @VisibleForTesting
    public IpSecTransform(Context context, IpSecConfig config) {
        this.mContext = context;
        this.mConfig = new IpSecConfig(config);
        this.mResourceId = -1;
    }

    private IIpSecService getIpSecService() {
        IBinder b = ServiceManager.getService("ipsec");
        if (b == null) {
            throw new RemoteException("Failed to connect to IpSecService").rethrowAsRuntimeException();
        }
        return IIpSecService.Stub.asInterface(b);
    }

    private void checkResultStatus(int status) throws IOException, IpSecManager.ResourceUnavailableException, IpSecManager.SpiUnavailableException {
        switch (status) {
            case 0: {
                return;
            }
            case 1: {
                throw new IpSecManager.ResourceUnavailableException("Failed to allocate a new IpSecTransform");
            }
            case 2: {
                Log.wtf(TAG, "Attempting to use an SPI that was somehow not reserved");
            }
        }
        throw new IllegalStateException("Failed to Create a Transform with status code " + status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IpSecTransform activate() throws IOException, IpSecManager.ResourceUnavailableException, IpSecManager.SpiUnavailableException {
        IpSecTransform ipSecTransform = this;
        synchronized (ipSecTransform) {
            try {
                IIpSecService svc = this.getIpSecService();
                IpSecTransformResponse result = svc.createTransform(this.mConfig, new Binder(), this.mContext.getOpPackageName());
                int status = result.status;
                this.checkResultStatus(status);
                this.mResourceId = result.resourceId;
                Log.d(TAG, "Added Transform with Id " + this.mResourceId);
                this.mCloseGuard.open("build");
            }
            catch (ServiceSpecificException e) {
                throw IpSecManager.rethrowUncheckedExceptionFromServiceSpecificException(e);
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
        }
        return this;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IpSecTransform)) {
            return false;
        }
        IpSecTransform rhs = (IpSecTransform)other;
        return this.getConfig().equals(rhs.getConfig()) && this.mResourceId == rhs.mResourceId;
    }

    @Override
    public void close() {
        Log.d(TAG, "Removing Transform with Id " + this.mResourceId);
        if (this.mResourceId == -1) {
            this.mCloseGuard.close();
            return;
        }
        try {
            IIpSecService svc = this.getIpSecService();
            svc.deleteTransform(this.mResourceId);
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
        catch (Exception e) {
            Log.e(TAG, "Failed to close " + this + ", Exception=" + e);
        }
        finally {
            this.mResourceId = -1;
            this.mCloseGuard.close();
        }
    }

    protected void finalize() throws Throwable {
        if (this.mCloseGuard != null) {
            this.mCloseGuard.warnIfOpen();
        }
        this.close();
    }

    IpSecConfig getConfig() {
        return this.mConfig;
    }

    @VisibleForTesting
    public int getResourceId() {
        return this.mResourceId;
    }

    public String toString() {
        return "IpSecTransform{resourceId=" + this.mResourceId + "}";
    }

    public static class Builder {
        private Context mContext;
        private IpSecConfig mConfig;

        public Builder setEncryption(IpSecAlgorithm algo) {
            Preconditions.checkNotNull(algo);
            this.mConfig.setEncryption(algo);
            return this;
        }

        public Builder setAuthentication(IpSecAlgorithm algo) {
            Preconditions.checkNotNull(algo);
            this.mConfig.setAuthentication(algo);
            return this;
        }

        public Builder setAuthenticatedEncryption(IpSecAlgorithm algo) {
            Preconditions.checkNotNull(algo);
            this.mConfig.setAuthenticatedEncryption(algo);
            return this;
        }

        public Builder setIpv4Encapsulation(IpSecManager.UdpEncapsulationSocket localSocket, int remotePort) {
            Preconditions.checkNotNull(localSocket);
            this.mConfig.setEncapType(2);
            if (localSocket.getResourceId() == -1) {
                throw new IllegalArgumentException("Invalid UdpEncapsulationSocket");
            }
            this.mConfig.setEncapSocketResourceId(localSocket.getResourceId());
            this.mConfig.setEncapRemotePort(remotePort);
            return this;
        }

        public IpSecTransform buildTransportModeTransform(InetAddress sourceAddress, IpSecManager.SecurityParameterIndex spi) throws IpSecManager.ResourceUnavailableException, IpSecManager.SpiUnavailableException, IOException {
            Preconditions.checkNotNull(sourceAddress);
            Preconditions.checkNotNull(spi);
            if (spi.getResourceId() == -1) {
                throw new IllegalArgumentException("Invalid SecurityParameterIndex");
            }
            this.mConfig.setMode(0);
            this.mConfig.setSourceAddress(sourceAddress.getHostAddress());
            this.mConfig.setSpiResourceId(spi.getResourceId());
            return new IpSecTransform(this.mContext, this.mConfig).activate();
        }

        @SystemApi
        @RequiresPermission(value="android.permission.MANAGE_IPSEC_TUNNELS")
        public IpSecTransform buildTunnelModeTransform(InetAddress sourceAddress, IpSecManager.SecurityParameterIndex spi) throws IpSecManager.ResourceUnavailableException, IpSecManager.SpiUnavailableException, IOException {
            Preconditions.checkNotNull(sourceAddress);
            Preconditions.checkNotNull(spi);
            if (spi.getResourceId() == -1) {
                throw new IllegalArgumentException("Invalid SecurityParameterIndex");
            }
            this.mConfig.setMode(1);
            this.mConfig.setSourceAddress(sourceAddress.getHostAddress());
            this.mConfig.setSpiResourceId(spi.getResourceId());
            return new IpSecTransform(this.mContext, this.mConfig).activate();
        }

        public Builder(Context context) {
            Preconditions.checkNotNull(context);
            this.mContext = context;
            this.mConfig = new IpSecConfig();
        }
    }

    public static class NattKeepaliveCallback {
        public static final int ERROR_INVALID_NETWORK = 1;
        public static final int ERROR_HARDWARE_UNSUPPORTED = 2;
        public static final int ERROR_HARDWARE_ERROR = 3;

        public void onStarted() {
        }

        public void onStopped() {
        }

        public void onError(int error) {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EncapType {
    }
}

