/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

@SystemApi
public class NetworkAgentConfig
implements Parcelable {
    public boolean allowBypass;
    public boolean explicitlySelected;
    public boolean acceptUnvalidated;
    public boolean acceptPartialConnectivity;
    public boolean provisioningNotificationDisabled;
    public String subscriberId;
    public boolean skip464xlat;
    public int legacyType = -1;
    public int legacySubType = -1;
    public transient boolean hasShownBroken;
    public String legacyTypeName = "";
    public String legacySubTypeName = "";
    private String mLegacyExtraInfo = "";
    public static final Parcelable.Creator<NetworkAgentConfig> CREATOR = new Parcelable.Creator<NetworkAgentConfig>(){

        @Override
        public NetworkAgentConfig createFromParcel(Parcel in) {
            NetworkAgentConfig networkAgentConfig = new NetworkAgentConfig();
            networkAgentConfig.allowBypass = in.readInt() != 0;
            networkAgentConfig.explicitlySelected = in.readInt() != 0;
            networkAgentConfig.acceptUnvalidated = in.readInt() != 0;
            networkAgentConfig.acceptPartialConnectivity = in.readInt() != 0;
            networkAgentConfig.subscriberId = in.readString();
            networkAgentConfig.provisioningNotificationDisabled = in.readInt() != 0;
            networkAgentConfig.skip464xlat = in.readInt() != 0;
            networkAgentConfig.legacyType = in.readInt();
            networkAgentConfig.legacyTypeName = in.readString();
            networkAgentConfig.legacySubType = in.readInt();
            networkAgentConfig.legacySubTypeName = in.readString();
            networkAgentConfig.mLegacyExtraInfo = in.readString();
            return networkAgentConfig;
        }

        public NetworkAgentConfig[] newArray(int size) {
            return new NetworkAgentConfig[size];
        }
    };

    public boolean isExplicitlySelected() {
        return this.explicitlySelected;
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public boolean isBypassableVpn() {
        return this.allowBypass;
    }

    public boolean isUnvalidatedConnectivityAcceptable() {
        return this.acceptUnvalidated;
    }

    public boolean isPartialConnectivityAcceptable() {
        return this.acceptPartialConnectivity;
    }

    public boolean isProvisioningNotificationEnabled() {
        return !this.provisioningNotificationDisabled;
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public String getSubscriberId() {
        return this.subscriberId;
    }

    public boolean isNat64DetectionEnabled() {
        return !this.skip464xlat;
    }

    public int getLegacyType() {
        return this.legacyType;
    }

    public String getLegacyTypeName() {
        return this.legacyTypeName;
    }

    public String getLegacyExtraInfo() {
        return this.mLegacyExtraInfo;
    }

    public NetworkAgentConfig() {
    }

    public NetworkAgentConfig(NetworkAgentConfig nac) {
        if (nac != null) {
            this.allowBypass = nac.allowBypass;
            this.explicitlySelected = nac.explicitlySelected;
            this.acceptUnvalidated = nac.acceptUnvalidated;
            this.acceptPartialConnectivity = nac.acceptPartialConnectivity;
            this.subscriberId = nac.subscriberId;
            this.provisioningNotificationDisabled = nac.provisioningNotificationDisabled;
            this.skip464xlat = nac.skip464xlat;
            this.legacyType = nac.legacyType;
            this.legacyTypeName = nac.legacyTypeName;
            this.legacySubType = nac.legacySubType;
            this.legacySubTypeName = nac.legacySubTypeName;
            this.mLegacyExtraInfo = nac.mLegacyExtraInfo;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetworkAgentConfig that = (NetworkAgentConfig)o;
        return this.allowBypass == that.allowBypass && this.explicitlySelected == that.explicitlySelected && this.acceptUnvalidated == that.acceptUnvalidated && this.acceptPartialConnectivity == that.acceptPartialConnectivity && this.provisioningNotificationDisabled == that.provisioningNotificationDisabled && this.skip464xlat == that.skip464xlat && this.legacyType == that.legacyType && Objects.equals(this.subscriberId, that.subscriberId) && Objects.equals(this.legacyTypeName, that.legacyTypeName) && Objects.equals(this.mLegacyExtraInfo, that.mLegacyExtraInfo);
    }

    public int hashCode() {
        return Objects.hash(this.allowBypass, this.explicitlySelected, this.acceptUnvalidated, this.acceptPartialConnectivity, this.provisioningNotificationDisabled, this.subscriberId, this.skip464xlat, this.legacyType, this.legacyTypeName, this.mLegacyExtraInfo);
    }

    public String toString() {
        return "NetworkAgentConfig { allowBypass = " + this.allowBypass + ", explicitlySelected = " + this.explicitlySelected + ", acceptUnvalidated = " + this.acceptUnvalidated + ", acceptPartialConnectivity = " + this.acceptPartialConnectivity + ", provisioningNotificationDisabled = " + this.provisioningNotificationDisabled + ", subscriberId = '" + this.subscriberId + '\'' + ", skip464xlat = " + this.skip464xlat + ", legacyType = " + this.legacyType + ", hasShownBroken = " + this.hasShownBroken + ", legacyTypeName = '" + this.legacyTypeName + '\'' + ", legacyExtraInfo = '" + this.mLegacyExtraInfo + '\'' + "}";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.allowBypass ? 1 : 0);
        out.writeInt(this.explicitlySelected ? 1 : 0);
        out.writeInt(this.acceptUnvalidated ? 1 : 0);
        out.writeInt(this.acceptPartialConnectivity ? 1 : 0);
        out.writeString(this.subscriberId);
        out.writeInt(this.provisioningNotificationDisabled ? 1 : 0);
        out.writeInt(this.skip464xlat ? 1 : 0);
        out.writeInt(this.legacyType);
        out.writeString(this.legacyTypeName);
        out.writeInt(this.legacySubType);
        out.writeString(this.legacySubTypeName);
        out.writeString(this.mLegacyExtraInfo);
    }

    public static class Builder {
        private final NetworkAgentConfig mConfig = new NetworkAgentConfig();

        public Builder setExplicitlySelected(boolean explicitlySelected) {
            this.mConfig.explicitlySelected = explicitlySelected;
            return this;
        }

        public Builder setUnvalidatedConnectivityAcceptable(boolean unvalidatedConnectivityAcceptable) {
            this.mConfig.acceptUnvalidated = unvalidatedConnectivityAcceptable;
            return this;
        }

        public Builder setPartialConnectivityAcceptable(boolean partialConnectivityAcceptable) {
            this.mConfig.acceptPartialConnectivity = partialConnectivityAcceptable;
            return this;
        }

        @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
        public Builder setSubscriberId(String subscriberId) {
            this.mConfig.subscriberId = subscriberId;
            return this;
        }

        public Builder setNat64DetectionEnabled(boolean enabled) {
            this.mConfig.skip464xlat = !enabled;
            return this;
        }

        public Builder setProvisioningNotificationEnabled(boolean enabled) {
            this.mConfig.provisioningNotificationDisabled = !enabled;
            return this;
        }

        public Builder setLegacyType(int legacyType) {
            this.mConfig.legacyType = legacyType;
            return this;
        }

        public Builder setLegacySubType(int legacySubType) {
            this.mConfig.legacySubType = legacySubType;
            return this;
        }

        public Builder setLegacyTypeName(String legacyTypeName) {
            this.mConfig.legacyTypeName = legacyTypeName;
            return this;
        }

        public Builder setLegacySubTypeName(String legacySubTypeName) {
            this.mConfig.legacySubTypeName = legacySubTypeName;
            return this;
        }

        public Builder setLegacyExtraInfo(String legacyExtraInfo) {
            this.mConfig.mLegacyExtraInfo = legacyExtraInfo;
            return this;
        }

        @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
        public Builder setBypassableVpn(boolean allowBypass) {
            this.mConfig.allowBypass = allowBypass;
            return this;
        }

        public NetworkAgentConfig build() {
            return this.mConfig;
        }
    }
}

