/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.net.EthernetNetworkSpecifier;
import android.net.MatchAllNetworkSpecifier;
import android.net.NetworkCapabilities;
import android.net.NetworkSpecifier;
import android.net.TelephonyNetworkSpecifier;
import android.net.TestNetworkSpecifier;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.Process;
import android.text.TextUtils;
import android.util.Range;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class NetworkRequest
implements Parcelable {
    public static final int FIRST_REQUEST_ID = 1;
    public static final int REQUEST_ID_NONE = -1;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public final NetworkCapabilities networkCapabilities;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public final int requestId;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public final int legacyType;
    public final Type type;
    public static final Parcelable.Creator<NetworkRequest> CREATOR = new Parcelable.Creator<NetworkRequest>(){

        @Override
        public NetworkRequest createFromParcel(Parcel in) {
            NetworkCapabilities nc = NetworkCapabilities.CREATOR.createFromParcel(in);
            int legacyType = in.readInt();
            int requestId = in.readInt();
            Type type = Type.valueOf(in.readString());
            NetworkRequest result = new NetworkRequest(nc, legacyType, requestId, type);
            return result;
        }

        public NetworkRequest[] newArray(int size) {
            return new NetworkRequest[size];
        }
    };

    public NetworkRequest(NetworkCapabilities nc, int legacyType, int rId, Type type) {
        if (nc == null) {
            throw new NullPointerException();
        }
        this.requestId = rId;
        this.networkCapabilities = nc;
        this.legacyType = legacyType;
        this.type = type;
    }

    public NetworkRequest(NetworkRequest that) {
        this.networkCapabilities = new NetworkCapabilities(that.networkCapabilities);
        this.requestId = that.requestId;
        this.legacyType = that.legacyType;
        this.type = that.type;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        this.networkCapabilities.writeToParcel(dest, flags);
        dest.writeInt(this.legacyType);
        dest.writeInt(this.requestId);
        dest.writeString(this.type.name());
    }

    public boolean isListen() {
        return this.type == Type.LISTEN;
    }

    public boolean isListenForBest() {
        return this.type == Type.LISTEN_FOR_BEST;
    }

    public boolean isRequest() {
        return this.type == Type.REQUEST || this.type == Type.BACKGROUND_REQUEST;
    }

    public boolean isBackgroundRequest() {
        return this.type == Type.BACKGROUND_REQUEST;
    }

    public boolean hasCapability(int capability) {
        return this.networkCapabilities.hasCapability(capability);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public boolean hasForbiddenCapability(int capability) {
        return this.networkCapabilities.hasForbiddenCapability(capability);
    }

    public boolean canBeSatisfiedBy(NetworkCapabilities nc) {
        return this.networkCapabilities.satisfiedByNetworkCapabilities(nc);
    }

    public boolean hasTransport(int transportType) {
        return this.networkCapabilities.hasTransport(transportType);
    }

    public NetworkSpecifier getNetworkSpecifier() {
        return this.networkCapabilities.getNetworkSpecifier();
    }

    @SystemApi
    public int getRequestorUid() {
        return this.networkCapabilities.getRequestorUid();
    }

    @SystemApi
    public String getRequestorPackageName() {
        return this.networkCapabilities.getRequestorPackageName();
    }

    public String toString() {
        return "NetworkRequest [ " + (Object)((Object)this.type) + " id=" + this.requestId + (this.legacyType != -1 ? ", legacyType=" + this.legacyType : "") + ", " + this.networkCapabilities.toString() + " ]";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NetworkRequest)) {
            return false;
        }
        NetworkRequest that = (NetworkRequest)obj;
        return that.legacyType == this.legacyType && that.requestId == this.requestId && that.type == this.type && Objects.equals(that.networkCapabilities, this.networkCapabilities);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.requestId, this.legacyType, this.networkCapabilities, this.type});
    }

    public int[] getCapabilities() {
        return this.networkCapabilities.getCapabilities();
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public int[] getForbiddenCapabilities() {
        return this.networkCapabilities.getForbiddenCapabilities();
    }

    public int[] getTransportTypes() {
        return this.networkCapabilities.getTransportTypes();
    }

    public static class Builder {
        private static final List<Integer> VCN_SUPPORTED_CAPABILITIES = Arrays.asList(17, 2, 19, 12, 20, 11, 13, 18, 21, 15, 24, 25, 14, 16);
        private final NetworkCapabilities mNetworkCapabilities;
        private boolean mShouldDeduceNotVcnManaged = true;

        public Builder() {
            this.mNetworkCapabilities = new NetworkCapabilities();
            this.mNetworkCapabilities.setSingleUid(Process.myUid());
        }

        public Builder(NetworkRequest request) {
            Objects.requireNonNull(request);
            this.mNetworkCapabilities = request.networkCapabilities;
            this.mShouldDeduceNotVcnManaged = false;
        }

        public NetworkRequest build() {
            NetworkCapabilities nc = new NetworkCapabilities(this.mNetworkCapabilities);
            nc.maybeMarkCapabilitiesRestricted();
            this.deduceNotVcnManagedCapability(nc);
            return new NetworkRequest(nc, -1, 0, Type.NONE);
        }

        public Builder addCapability(int capability) {
            this.mNetworkCapabilities.addCapability(capability);
            if (capability == 28) {
                this.mShouldDeduceNotVcnManaged = false;
            }
            return this;
        }

        public Builder removeCapability(int capability) {
            this.mNetworkCapabilities.removeCapability(capability);
            if (capability == 28) {
                this.mShouldDeduceNotVcnManaged = false;
            }
            return this;
        }

        public Builder setCapabilities(NetworkCapabilities nc) {
            this.mNetworkCapabilities.set(nc);
            return this;
        }

        @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setUids(Set<Range<Integer>> uids) {
            this.mNetworkCapabilities.setUids(uids);
            return this;
        }

        @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder addForbiddenCapability(int capability) {
            this.mNetworkCapabilities.addForbiddenCapability(capability);
            return this;
        }

        @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
        @SuppressLint(value={"BuilderSetStyle"})
        public Builder removeForbiddenCapability(int capability) {
            this.mNetworkCapabilities.removeForbiddenCapability(capability);
            return this;
        }

        public Builder clearCapabilities() {
            this.mNetworkCapabilities.clearAll();
            this.mShouldDeduceNotVcnManaged = false;
            return this;
        }

        public Builder addTransportType(int transportType) {
            this.mNetworkCapabilities.addTransportType(transportType);
            return this;
        }

        public Builder removeTransportType(int transportType) {
            this.mNetworkCapabilities.removeTransportType(transportType);
            return this;
        }

        public Builder setLinkUpstreamBandwidthKbps(int upKbps) {
            this.mNetworkCapabilities.setLinkUpstreamBandwidthKbps(upKbps);
            return this;
        }

        public Builder setLinkDownstreamBandwidthKbps(int downKbps) {
            this.mNetworkCapabilities.setLinkDownstreamBandwidthKbps(downKbps);
            return this;
        }

        @Deprecated
        public Builder setNetworkSpecifier(String networkSpecifier) {
            try {
                int subId = Integer.parseInt(networkSpecifier);
                return this.setNetworkSpecifier(new TelephonyNetworkSpecifier.Builder().setSubscriptionId(subId).build());
            }
            catch (NumberFormatException nfe) {
                if (TextUtils.isEmpty(networkSpecifier)) {
                    return this.setNetworkSpecifier((NetworkSpecifier)null);
                }
                if (this.mNetworkCapabilities.hasTransport(7)) {
                    return this.setNetworkSpecifier(new TestNetworkSpecifier(networkSpecifier));
                }
                return this.setNetworkSpecifier(new EthernetNetworkSpecifier(networkSpecifier));
            }
        }

        public Builder setNetworkSpecifier(NetworkSpecifier networkSpecifier) {
            if (networkSpecifier instanceof MatchAllNetworkSpecifier) {
                throw new IllegalArgumentException("A MatchAllNetworkSpecifier is not permitted");
            }
            this.mNetworkCapabilities.setNetworkSpecifier(networkSpecifier);
            this.mShouldDeduceNotVcnManaged = false;
            return this;
        }

        @SystemApi
        @RequiresPermission(value="android.permission.NETWORK_SIGNAL_STRENGTH_WAKEUP")
        public Builder setSignalStrength(int signalStrength) {
            this.mNetworkCapabilities.setSignalStrength(signalStrength);
            return this;
        }

        private void deduceNotVcnManagedCapability(NetworkCapabilities nc) {
            if (!this.mShouldDeduceNotVcnManaged) {
                return;
            }
            for (int cap : nc.getCapabilities()) {
                if (VCN_SUPPORTED_CAPABILITIES.contains(cap)) continue;
                return;
            }
            nc.addCapability(28);
        }

        @SystemApi
        public Builder setSubscriptionIds(Set<Integer> subIds) {
            this.mNetworkCapabilities.setSubscriptionIds(subIds);
            return this;
        }

        public Builder setIncludeOtherUidNetworks(boolean include) {
            if (include) {
                this.mNetworkCapabilities.setUids(null);
            } else {
                this.mNetworkCapabilities.setSingleUid(Process.myUid());
            }
            return this;
        }
    }

    public static enum Type {
        NONE,
        LISTEN,
        TRACK_DEFAULT,
        REQUEST,
        BACKGROUND_REQUEST,
        TRACK_SYSTEM_DEFAULT,
        LISTEN_FOR_BEST;

    }
}

