/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.SystemApi;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.net.module.util.NetworkIdentityUtils;
import java.util.Objects;

@SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
public class NetworkStateSnapshot
implements Parcelable {
    private final Network mNetwork;
    private final NetworkCapabilities mNetworkCapabilities;
    private final LinkProperties mLinkProperties;
    private final String mSubscriberId;
    private final int mLegacyType;
    public static final Parcelable.Creator<NetworkStateSnapshot> CREATOR = new Parcelable.Creator<NetworkStateSnapshot>(){

        @Override
        public NetworkStateSnapshot createFromParcel(Parcel in) {
            return new NetworkStateSnapshot(in);
        }

        public NetworkStateSnapshot[] newArray(int size) {
            return new NetworkStateSnapshot[size];
        }
    };

    public NetworkStateSnapshot(Network network, NetworkCapabilities networkCapabilities, LinkProperties linkProperties, String subscriberId, int legacyType) {
        this.mNetwork = Objects.requireNonNull(network);
        this.mNetworkCapabilities = Objects.requireNonNull(networkCapabilities);
        this.mLinkProperties = Objects.requireNonNull(linkProperties);
        this.mSubscriberId = subscriberId;
        this.mLegacyType = legacyType;
    }

    public NetworkStateSnapshot(Parcel in) {
        this.mNetwork = (Network)in.readParcelable(null);
        this.mNetworkCapabilities = (NetworkCapabilities)in.readParcelable(null);
        this.mLinkProperties = (LinkProperties)in.readParcelable(null);
        this.mSubscriberId = in.readString();
        this.mLegacyType = in.readInt();
    }

    public Network getNetwork() {
        return this.mNetwork;
    }

    public NetworkCapabilities getNetworkCapabilities() {
        return this.mNetworkCapabilities;
    }

    public LinkProperties getLinkProperties() {
        return this.mLinkProperties;
    }

    public String getSubscriberId() {
        return this.mSubscriberId;
    }

    public int getLegacyType() {
        return this.mLegacyType;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeParcelable(this.mNetwork, flags);
        out.writeParcelable(this.mNetworkCapabilities, flags);
        out.writeParcelable(this.mLinkProperties, flags);
        out.writeString(this.mSubscriberId);
        out.writeInt(this.mLegacyType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NetworkStateSnapshot)) {
            return false;
        }
        NetworkStateSnapshot that = (NetworkStateSnapshot)o;
        return this.mLegacyType == that.mLegacyType && Objects.equals(this.mNetwork, that.mNetwork) && Objects.equals(this.mNetworkCapabilities, that.mNetworkCapabilities) && Objects.equals(this.mLinkProperties, that.mLinkProperties) && Objects.equals(this.mSubscriberId, that.mSubscriberId);
    }

    public int hashCode() {
        return Objects.hash(this.mNetwork, this.mNetworkCapabilities, this.mLinkProperties, this.mSubscriberId, this.mLegacyType);
    }

    public String toString() {
        return "NetworkStateSnapshot{network=" + this.mNetwork + ", networkCapabilities=" + this.mNetworkCapabilities + ", linkProperties=" + this.mLinkProperties + ", subscriberId='" + NetworkIdentityUtils.scrubSubscriberId(this.mSubscriberId) + '\'' + ", legacyType=" + this.mLegacyType + '}';
    }
}

