/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.content.Context;
import android.net.IPacProxyInstalledListener;
import android.net.IPacProxyManager;
import android.net.Network;
import android.net.ProxyInfo;
import android.os.Binder;
import android.os.RemoteException;
import com.android.internal.annotations.GuardedBy;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.Executor;

@SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
public class PacProxyManager {
    private final Context mContext;
    private final IPacProxyManager mService;
    @GuardedBy(value={"mListenerMap"})
    private final HashMap<PacProxyInstalledListener, PacProxyInstalledListenerProxy> mListenerMap = new HashMap();

    public PacProxyManager(Context context, IPacProxyManager service) {
        Objects.requireNonNull(service, "missing IPacProxyManager");
        this.mContext = context;
        this.mService = service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(anyOf={"android.permission.NETWORK_STACK", "android.permission.MAINLINE_NETWORK_STACK", "android.permission.NETWORK_SETTINGS"})
    public void addPacProxyInstalledListener(Executor executor, PacProxyInstalledListener listener) {
        try {
            HashMap<PacProxyInstalledListener, PacProxyInstalledListenerProxy> hashMap = this.mListenerMap;
            synchronized (hashMap) {
                PacProxyInstalledListenerProxy listenerProxy = new PacProxyInstalledListenerProxy(executor, listener);
                if (null != this.mListenerMap.putIfAbsent(listener, listenerProxy)) {
                    throw new IllegalStateException("Listener is already added.");
                }
                this.mService.addListener(listenerProxy);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(anyOf={"android.permission.NETWORK_STACK", "android.permission.MAINLINE_NETWORK_STACK", "android.permission.NETWORK_SETTINGS"})
    public void removePacProxyInstalledListener(PacProxyInstalledListener listener) {
        try {
            HashMap<PacProxyInstalledListener, PacProxyInstalledListenerProxy> hashMap = this.mListenerMap;
            synchronized (hashMap) {
                PacProxyInstalledListenerProxy listenerProxy = this.mListenerMap.remove(listener);
                if (listenerProxy == null) {
                    return;
                }
                this.mService.removeListener(listenerProxy);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(anyOf={"android.permission.NETWORK_STACK", "android.permission.MAINLINE_NETWORK_STACK", "android.permission.NETWORK_SETTINGS"})
    public void setCurrentProxyScriptUrl(ProxyInfo proxy) {
        try {
            this.mService.setCurrentProxyScriptUrl(proxy);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public class PacProxyInstalledListenerProxy
    extends IPacProxyInstalledListener.Stub {
        private final Executor mExecutor;
        private final PacProxyInstalledListener mListener;

        PacProxyInstalledListenerProxy(Executor executor, PacProxyInstalledListener listener) {
            this.mExecutor = executor;
            this.mListener = listener;
        }

        @Override
        public void onPacProxyInstalled(Network network, ProxyInfo proxy) {
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> this.mListener.onPacProxyInstalled(network, proxy)));
        }
    }

    public static interface PacProxyInstalledListener {
        public void onPacProxyInstalled(Network var1, ProxyInfo var2);
    }
}

