/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.UserHandle;
import android.util.ArraySet;
import android.util.Range;
import java.util.Collection;
import java.util.Set;

public class UidRange
implements Parcelable {
    public final int start;
    public final int stop;
    public static final Parcelable.Creator<UidRange> CREATOR = new Parcelable.Creator<UidRange>(){

        @Override
        public UidRange createFromParcel(Parcel in) {
            int start = in.readInt();
            int stop = in.readInt();
            return new UidRange(start, stop);
        }

        public UidRange[] newArray(int size) {
            return new UidRange[size];
        }
    };

    public UidRange(int startUid, int stopUid) {
        if (startUid < 0) {
            throw new IllegalArgumentException("Invalid start UID.");
        }
        if (stopUid < 0) {
            throw new IllegalArgumentException("Invalid stop UID.");
        }
        if (startUid > stopUid) {
            throw new IllegalArgumentException("Invalid UID range.");
        }
        this.start = startUid;
        this.stop = stopUid;
    }

    public static UidRange createForUser(UserHandle user) {
        UserHandle nextUser = UserHandle.of(user.getIdentifier() + 1);
        int start = user.getUid(0);
        int end = nextUser.getUid(0) - 1;
        return new UidRange(start, end);
    }

    public int getStartUser() {
        return UserHandle.getUserHandleForUid(this.start).getIdentifier();
    }

    public int getEndUser() {
        return UserHandle.getUserHandleForUid(this.stop).getIdentifier();
    }

    public boolean contains(int uid) {
        return this.start <= uid && uid <= this.stop;
    }

    public int count() {
        return 1 + this.stop - this.start;
    }

    public boolean containsRange(UidRange other) {
        return this.start <= other.start && other.stop <= this.stop;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.start;
        result = 31 * result + this.stop;
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof UidRange) {
            UidRange other = (UidRange)o;
            return this.start == other.start && this.stop == other.stop;
        }
        return false;
    }

    public String toString() {
        return this.start + "-" + this.stop;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.start);
        dest.writeInt(this.stop);
    }

    public static boolean containsUid(Collection<UidRange> ranges, int uid) {
        if (ranges == null) {
            return false;
        }
        for (UidRange range : ranges) {
            if (!range.contains(uid)) continue;
            return true;
        }
        return false;
    }

    public static ArraySet<UidRange> fromIntRanges(Set<Range<Integer>> ranges) {
        if (null == ranges) {
            return null;
        }
        ArraySet<UidRange> uids = new ArraySet<UidRange>();
        for (Range<Integer> range : ranges) {
            uids.add(new UidRange(range.getLower(), range.getUpper()));
        }
        return uids;
    }

    public static ArraySet<Range<Integer>> toIntRanges(Set<UidRange> ranges) {
        if (null == ranges) {
            return null;
        }
        ArraySet<Range<Integer>> uids = new ArraySet<Range<Integer>>();
        for (UidRange range : ranges) {
            uids.add(new Range<Integer>(range.start, range.stop));
        }
        return uids;
    }
}

