/*
 * Decompiled with CFR 0.152.
 */
package android.net.ipsec.ike;

import android.net.ipsec.ike.ChildSaProposal;
import android.net.ipsec.ike.IkeSaProposal;
import android.os.PersistableBundle;
import android.util.Pair;
import android.util.SparseArray;
import com.android.internal.net.ipsec.ike.message.IkePayload;
import com.android.internal.net.ipsec.ike.message.IkeSaPayload;
import com.android.internal.net.utils.build.SdkLevel;
import com.android.internal.net.vcn.util.PersistableBundleUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public abstract class SaProposal {
    public static final int ENCRYPTION_ALGORITHM_3DES = 3;
    public static final int ENCRYPTION_ALGORITHM_AES_CBC = 12;
    public static final int ENCRYPTION_ALGORITHM_AES_CTR = 13;
    public static final int ENCRYPTION_ALGORITHM_AES_GCM_8 = 18;
    public static final int ENCRYPTION_ALGORITHM_AES_GCM_12 = 19;
    public static final int ENCRYPTION_ALGORITHM_AES_GCM_16 = 20;
    public static final int ENCRYPTION_ALGORITHM_CHACHA20_POLY1305 = 28;
    protected static final SparseArray<String> SUPPORTED_ENCRYPTION_ALGO_TO_STR = new SparseArray();
    public static final int KEY_LEN_UNUSED = 0;
    public static final int KEY_LEN_AES_128 = 128;
    public static final int KEY_LEN_AES_192 = 192;
    public static final int KEY_LEN_AES_256 = 256;
    public static final int PSEUDORANDOM_FUNCTION_HMAC_SHA1 = 2;
    public static final int PSEUDORANDOM_FUNCTION_AES128_XCBC = 4;
    public static final int PSEUDORANDOM_FUNCTION_SHA2_256 = 5;
    public static final int PSEUDORANDOM_FUNCTION_SHA2_384 = 6;
    public static final int PSEUDORANDOM_FUNCTION_SHA2_512 = 7;
    public static final int PSEUDORANDOM_FUNCTION_AES128_CMAC = 8;
    protected static final SparseArray<String> SUPPORTED_PRF_TO_STR;
    public static final int INTEGRITY_ALGORITHM_NONE = 0;
    public static final int INTEGRITY_ALGORITHM_HMAC_SHA1_96 = 2;
    public static final int INTEGRITY_ALGORITHM_AES_XCBC_96 = 5;
    public static final int INTEGRITY_ALGORITHM_AES_CMAC_96 = 8;
    public static final int INTEGRITY_ALGORITHM_HMAC_SHA2_256_128 = 12;
    public static final int INTEGRITY_ALGORITHM_HMAC_SHA2_384_192 = 13;
    public static final int INTEGRITY_ALGORITHM_HMAC_SHA2_512_256 = 14;
    protected static final SparseArray<String> SUPPORTED_INTEGRITY_ALGO_TO_STR;
    public static final int DH_GROUP_NONE = 0;
    public static final int DH_GROUP_1024_BIT_MODP = 2;
    public static final int DH_GROUP_1536_BIT_MODP = 5;
    public static final int DH_GROUP_2048_BIT_MODP = 14;
    public static final int DH_GROUP_3072_BIT_MODP = 15;
    public static final int DH_GROUP_4096_BIT_MODP = 16;
    public static final int DH_GROUP_CURVE_25519 = 31;
    private static final SparseArray<String> SUPPORTED_DH_GROUP_TO_STR;
    private static final String PROTOCOL_ID_KEY = "mProtocolId";
    protected static final String ENCRYPT_ALGO_KEY = "mEncryptionAlgorithms";
    protected static final String INTEGRITY_ALGO_KEY = "mIntegrityAlgorithms";
    protected static final String DH_GROUP_KEY = "mDhGroups";
    private final int mProtocolId;
    private final IkeSaPayload.EncryptionTransform[] mEncryptionAlgorithms;
    private final IkeSaPayload.IntegrityTransform[] mIntegrityAlgorithms;
    private final IkeSaPayload.DhGroupTransform[] mDhGroups;

    protected SaProposal(int protocol, IkeSaPayload.EncryptionTransform[] encryptionAlgos, IkeSaPayload.IntegrityTransform[] integrityAlgos, IkeSaPayload.DhGroupTransform[] dhGroups) {
        this.mProtocolId = protocol;
        this.mEncryptionAlgorithms = encryptionAlgos;
        this.mIntegrityAlgorithms = integrityAlgos;
        this.mDhGroups = dhGroups;
    }

    public static SaProposal fromPersistableBundle(PersistableBundle in) {
        Objects.requireNonNull(in, "PersistableBundle is null");
        int protocolId = in.getInt(PROTOCOL_ID_KEY);
        switch (protocolId) {
            case 1: {
                return IkeSaProposal.fromPersistableBundle(in);
            }
            case 3: {
                return ChildSaProposal.fromPersistableBundle(in);
            }
        }
        throw new IllegalArgumentException("Invalid protocol ID " + protocolId);
    }

    public PersistableBundle toPersistableBundle() {
        PersistableBundle result = new PersistableBundle();
        result.putInt(PROTOCOL_ID_KEY, this.mProtocolId);
        PersistableBundle encryptionBundle = PersistableBundleUtils.fromList(Arrays.asList(this.mEncryptionAlgorithms), IkeSaPayload.EncryptionTransform::toPersistableBundle);
        result.putPersistableBundle(ENCRYPT_ALGO_KEY, encryptionBundle);
        int[] integrityAlgoIdArray = this.getIntegrityAlgorithms().stream().mapToInt(i -> i).toArray();
        result.putIntArray(INTEGRITY_ALGO_KEY, integrityAlgoIdArray);
        int[] dhGroupArray = this.getDhGroups().stream().mapToInt(i -> i).toArray();
        result.putIntArray(DH_GROUP_KEY, dhGroupArray);
        return result;
    }

    public boolean isNegotiatedFrom(SaProposal reqProposal) {
        return this.mProtocolId == reqProposal.mProtocolId && SaProposal.isTransformSelectedFrom(this.mEncryptionAlgorithms, reqProposal.mEncryptionAlgorithms) && SaProposal.isIntegrityTransformSelectedFrom(this.mIntegrityAlgorithms, reqProposal.mIntegrityAlgorithms) && SaProposal.isDhGroupTransformSelectedFrom(this.mDhGroups, reqProposal.mDhGroups);
    }

    static boolean isTransformSelectedFrom(IkeSaPayload.Transform[] selected, IkeSaPayload.Transform[] selectFrom) {
        if (selected.length > 1 || selected.length == 0 != (selectFrom.length == 0)) {
            return false;
        }
        if (selected.length == 0) {
            return true;
        }
        return Arrays.asList(selectFrom).contains(selected[0]);
    }

    private static boolean isIntegrityTransformSelectedFrom(IkeSaPayload.IntegrityTransform[] selected, IkeSaPayload.IntegrityTransform[] selectFrom) {
        if (selected.length == 0) {
            selected = new IkeSaPayload.IntegrityTransform[]{new IkeSaPayload.IntegrityTransform(0)};
        }
        if (selectFrom.length == 0) {
            selectFrom = new IkeSaPayload.IntegrityTransform[]{new IkeSaPayload.IntegrityTransform(0)};
        }
        return SaProposal.isTransformSelectedFrom(selected, selectFrom);
    }

    private static boolean isDhGroupTransformSelectedFrom(IkeSaPayload.DhGroupTransform[] selected, IkeSaPayload.DhGroupTransform[] selectFrom) {
        if (selected.length == 0) {
            selected = new IkeSaPayload.DhGroupTransform[]{new IkeSaPayload.DhGroupTransform(0)};
        }
        if (selectFrom.length == 0) {
            selectFrom = new IkeSaPayload.DhGroupTransform[]{new IkeSaPayload.DhGroupTransform(0)};
        }
        return SaProposal.isTransformSelectedFrom(selected, selectFrom);
    }

    public int getProtocolId() {
        return this.mProtocolId;
    }

    public List<Pair<Integer, Integer>> getEncryptionAlgorithms() {
        ArrayList<Pair<Integer, Integer>> result = new ArrayList<Pair<Integer, Integer>>();
        for (IkeSaPayload.EncryptionTransform transform : this.mEncryptionAlgorithms) {
            result.add(new Pair<Integer, Integer>(transform.id, transform.getSpecifiedKeyLength()));
        }
        return result;
    }

    public List<Integer> getIntegrityAlgorithms() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (IkeSaPayload.IntegrityTransform transform : this.mIntegrityAlgorithms) {
            result.add(transform.id);
        }
        return result;
    }

    public List<Integer> getDhGroups() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (IkeSaPayload.DhGroupTransform transform : this.mDhGroups) {
            result.add(transform.id);
        }
        return result;
    }

    public IkeSaPayload.EncryptionTransform[] getEncryptionTransforms() {
        return this.mEncryptionAlgorithms;
    }

    public IkeSaPayload.IntegrityTransform[] getIntegrityTransforms() {
        return this.mIntegrityAlgorithms;
    }

    public IkeSaPayload.DhGroupTransform[] getDhGroupTransforms() {
        return this.mDhGroups;
    }

    protected List<IkeSaPayload.Transform> getAllTransformsAsList() {
        LinkedList<IkeSaPayload.Transform> transformList = new LinkedList<IkeSaPayload.Transform>();
        transformList.addAll(Arrays.asList(this.mEncryptionAlgorithms));
        transformList.addAll(Arrays.asList(this.mIntegrityAlgorithms));
        transformList.addAll(Arrays.asList(this.mDhGroups));
        return transformList;
    }

    public abstract IkeSaPayload.Transform[] getAllTransforms();

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(IkePayload.getProtocolTypeString(this.mProtocolId)).append(": ");
        int len = this.getAllTransforms().length;
        for (int i = 0; i < len; ++i) {
            sb.append(this.getAllTransforms()[i].toString());
            if (i >= len - 1) continue;
            sb.append("|");
        }
        return sb.toString();
    }

    public int hashCode() {
        return Objects.hash(this.mProtocolId, Arrays.hashCode(this.mEncryptionAlgorithms), Arrays.hashCode(this.mIntegrityAlgorithms), Arrays.hashCode(this.mDhGroups));
    }

    public boolean equals(Object o) {
        if (!(o instanceof SaProposal)) {
            return false;
        }
        SaProposal other = (SaProposal)o;
        return this.mProtocolId == other.mProtocolId && Arrays.equals(this.mEncryptionAlgorithms, other.mEncryptionAlgorithms) && Arrays.equals(this.mIntegrityAlgorithms, other.mIntegrityAlgorithms) && Arrays.equals(this.mDhGroups, other.mDhGroups);
    }

    protected static Set<Integer> getKeySet(SparseArray array2) {
        HashSet<Integer> result = new HashSet<Integer>();
        for (int i = 0; i < array2.size(); ++i) {
            result.add(array2.keyAt(i));
        }
        return result;
    }

    public static Set<Integer> getSupportedDhGroups() {
        HashSet<Integer> supportedSet = new HashSet<Integer>();
        for (int dh : SaProposal.getKeySet(SUPPORTED_DH_GROUP_TO_STR)) {
            if (dh == 31 && !SdkLevel.isAtLeastS()) continue;
            supportedSet.add(dh);
        }
        return supportedSet;
    }

    public static String getEncryptionAlgorithmString(int algorithm) {
        if (SUPPORTED_ENCRYPTION_ALGO_TO_STR.contains(algorithm)) {
            return SUPPORTED_ENCRYPTION_ALGO_TO_STR.get(algorithm);
        }
        return "ENC_Unknown_" + algorithm;
    }

    public static String getPseudorandomFunctionString(int algorithm) {
        if (SUPPORTED_PRF_TO_STR.contains(algorithm)) {
            return SUPPORTED_PRF_TO_STR.get(algorithm);
        }
        return "PRF_Unknown_" + algorithm;
    }

    public static String getIntegrityAlgorithmString(int algorithm) {
        if (SUPPORTED_INTEGRITY_ALGO_TO_STR.contains(algorithm)) {
            return SUPPORTED_INTEGRITY_ALGO_TO_STR.get(algorithm);
        }
        return "AUTH_Unknown_" + algorithm;
    }

    public static String getDhGroupString(int dhGroup) {
        if (SUPPORTED_DH_GROUP_TO_STR.contains(dhGroup)) {
            return SUPPORTED_DH_GROUP_TO_STR.get(dhGroup);
        }
        return "DH_Unknown_" + dhGroup;
    }

    static {
        SUPPORTED_ENCRYPTION_ALGO_TO_STR.put(3, "ENCR_3DES");
        SUPPORTED_ENCRYPTION_ALGO_TO_STR.put(12, "ENCR_AES_CBC");
        SUPPORTED_ENCRYPTION_ALGO_TO_STR.put(13, "ENCR_AES_CTR");
        SUPPORTED_ENCRYPTION_ALGO_TO_STR.put(18, "ENCR_AES_GCM_8");
        SUPPORTED_ENCRYPTION_ALGO_TO_STR.put(19, "ENCR_AES_GCM_12");
        SUPPORTED_ENCRYPTION_ALGO_TO_STR.put(20, "ENCR_AES_GCM_16");
        SUPPORTED_ENCRYPTION_ALGO_TO_STR.put(28, "ENCR_CHACHA20_POLY1305");
        SUPPORTED_PRF_TO_STR = new SparseArray();
        SUPPORTED_PRF_TO_STR.put(2, "PRF_HMAC_SHA1");
        SUPPORTED_PRF_TO_STR.put(4, "PRF_AES128_XCBC");
        SUPPORTED_PRF_TO_STR.put(5, "PRF_HMAC2_256");
        SUPPORTED_PRF_TO_STR.put(6, "PRF_HMAC2_384");
        SUPPORTED_PRF_TO_STR.put(7, "PRF_HMAC2_512");
        SUPPORTED_PRF_TO_STR.put(8, "PRF_AES128_CMAC");
        SUPPORTED_INTEGRITY_ALGO_TO_STR = new SparseArray();
        SUPPORTED_INTEGRITY_ALGO_TO_STR.put(0, "AUTH_NONE");
        SUPPORTED_INTEGRITY_ALGO_TO_STR.put(2, "AUTH_HMAC_SHA1_96");
        SUPPORTED_INTEGRITY_ALGO_TO_STR.put(5, "AUTH_AES_XCBC_96");
        SUPPORTED_INTEGRITY_ALGO_TO_STR.put(8, "AUTH_AES_CMAC_96");
        SUPPORTED_INTEGRITY_ALGO_TO_STR.put(12, "AUTH_HMAC_SHA2_256_128");
        SUPPORTED_INTEGRITY_ALGO_TO_STR.put(13, "AUTH_HMAC_SHA2_384_192");
        SUPPORTED_INTEGRITY_ALGO_TO_STR.put(14, "AUTH_HMAC_SHA2_512_256");
        SUPPORTED_DH_GROUP_TO_STR = new SparseArray();
        SUPPORTED_DH_GROUP_TO_STR.put(0, "DH_NONE");
        SUPPORTED_DH_GROUP_TO_STR.put(2, "DH_1024_BIT_MODP");
        SUPPORTED_DH_GROUP_TO_STR.put(5, "DH_1536_BIT_MODP");
        SUPPORTED_DH_GROUP_TO_STR.put(14, "DH_2048_BIT_MODP");
        SUPPORTED_DH_GROUP_TO_STR.put(15, "DH_3072_BIT_MODP");
        SUPPORTED_DH_GROUP_TO_STR.put(16, "DH_4096_BIT_MODP");
        SUPPORTED_DH_GROUP_TO_STR.put(31, "DH_GROUP_CURVE_25519");
    }

    protected static abstract class Builder {
        protected static final String ERROR_TAG = "Invalid SA Proposal: ";
        protected final LinkedHashSet<IkeSaPayload.EncryptionTransform> mProposedEncryptAlgos = new LinkedHashSet();
        protected final LinkedHashSet<IkeSaPayload.PrfTransform> mProposedPrfs = new LinkedHashSet();
        protected final LinkedHashSet<IkeSaPayload.IntegrityTransform> mProposedIntegrityAlgos = new LinkedHashSet();
        protected final LinkedHashSet<IkeSaPayload.DhGroupTransform> mProposedDhGroups = new LinkedHashSet();
        protected boolean mHasAead = false;

        protected Builder() {
        }

        protected static boolean isAead(int algorithm) {
            switch (algorithm) {
                case 3: 
                case 12: 
                case 13: {
                    return false;
                }
                case 18: 
                case 19: 
                case 20: 
                case 28: {
                    return true;
                }
            }
            throw new IllegalArgumentException("Unsupported Encryption Algorithm.");
        }

        protected IkeSaPayload.EncryptionTransform[] buildEncryptAlgosOrThrow() {
            if (this.mProposedEncryptAlgos.isEmpty()) {
                throw new IllegalArgumentException("Invalid SA Proposal: Encryption algorithm must be proposed.");
            }
            return this.mProposedEncryptAlgos.toArray(new IkeSaPayload.EncryptionTransform[this.mProposedEncryptAlgos.size()]);
        }

        protected void validateAndAddEncryptAlgo(int algorithm, int keyLength, boolean isChild) {
            IkeSaPayload.EncryptionTransform encryptionTransform = new IkeSaPayload.EncryptionTransform(algorithm, keyLength);
            if (isChild && !ChildSaProposal.getSupportedEncryptionAlgorithms().contains(algorithm)) {
                throw new IllegalArgumentException("Unsupported encryption algorithm " + algorithm);
            }
            boolean isCurrentAead = Builder.isAead(algorithm);
            if (!this.mProposedEncryptAlgos.isEmpty() && this.mHasAead ^ isCurrentAead) {
                throw new IllegalArgumentException("Invalid SA Proposal: Proposal cannot has both normal ciphers and combined-mode ciphers.");
            }
            if (isCurrentAead) {
                this.mHasAead = true;
            }
            this.mProposedEncryptAlgos.add(encryptionTransform);
        }

        protected void validateAndAddIntegrityAlgo(int algorithm, boolean isChild) {
            if (isChild && !ChildSaProposal.getSupportedIntegrityAlgorithms().contains(algorithm)) {
                throw new IllegalArgumentException("Unsupported integrity algorithm " + algorithm);
            }
            this.mProposedIntegrityAlgos.add(new IkeSaPayload.IntegrityTransform(algorithm));
        }

        protected void addDh(int dhGroup) {
            this.mProposedDhGroups.add(new IkeSaPayload.DhGroupTransform(dhGroup));
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DhGroup {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface IntegrityAlgorithm {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PseudorandomFunction {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EncryptionAlgorithm {
    }
}

