/*
 * Decompiled with CFR 0.152.
 */
package android.net.lowpan;

import android.net.IpPrefix;
import android.net.lowpan.ILowpanEnergyScanCallback;
import android.net.lowpan.ILowpanInterfaceListener;
import android.net.lowpan.ILowpanNetScanCallback;
import android.net.lowpan.LowpanBeaconInfo;
import android.net.lowpan.LowpanChannelInfo;
import android.net.lowpan.LowpanCredential;
import android.net.lowpan.LowpanIdentity;
import android.net.lowpan.LowpanProvision;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import java.util.HashMap;
import java.util.Map;

public interface ILowpanInterface
extends IInterface {
    public static final String DESCRIPTOR = "android.net.lowpan.ILowpanInterface";
    public static final String PERM_ACCESS_LOWPAN_STATE = "android.permission.ACCESS_LOWPAN_STATE";
    public static final String PERM_CHANGE_LOWPAN_STATE = "android.permission.CHANGE_LOWPAN_STATE";
    public static final String PERM_READ_LOWPAN_CREDENTIAL = "android.permission.READ_LOWPAN_CREDENTIAL";
    public static final String KEY_CHANNEL_MASK = "android.net.lowpan.property.CHANNEL_MASK";
    public static final String KEY_MAX_TX_POWER = "android.net.lowpan.property.MAX_TX_POWER";
    public static final String STATE_OFFLINE = "offline";
    public static final String STATE_COMMISSIONING = "commissioning";
    public static final String STATE_ATTACHING = "attaching";
    public static final String STATE_ATTACHED = "attached";
    public static final String STATE_FAULT = "fault";
    public static final String ROLE_END_DEVICE = "end-device";
    public static final String ROLE_ROUTER = "router";
    public static final String ROLE_SLEEPY_END_DEVICE = "sleepy-end-device";
    public static final String ROLE_SLEEPY_ROUTER = "sleepy-router";
    public static final String ROLE_LEADER = "leader";
    public static final String ROLE_COORDINATOR = "coordinator";
    public static final String ROLE_DETACHED = "detached";
    public static final String NETWORK_TYPE_UNKNOWN = "unknown";
    public static final String NETWORK_TYPE_THREAD_V1 = "org.threadgroup.thread.v1";
    public static final int ERROR_UNSPECIFIED = 1;
    public static final int ERROR_INVALID_ARGUMENT = 2;
    public static final int ERROR_DISABLED = 3;
    public static final int ERROR_WRONG_STATE = 4;
    public static final int ERROR_TIMEOUT = 5;
    public static final int ERROR_IO_FAILURE = 6;
    public static final int ERROR_NCP_PROBLEM = 7;
    public static final int ERROR_BUSY = 8;
    public static final int ERROR_ALREADY = 9;
    public static final int ERROR_CANCELED = 10;
    public static final int ERROR_FEATURE_NOT_SUPPORTED = 11;
    public static final int ERROR_JOIN_FAILED_UNKNOWN = 12;
    public static final int ERROR_JOIN_FAILED_AT_SCAN = 13;
    public static final int ERROR_JOIN_FAILED_AT_AUTH = 14;
    public static final int ERROR_FORM_FAILED_AT_SCAN = 15;

    public String getName() throws RemoteException;

    public String getNcpVersion() throws RemoteException;

    public String getDriverVersion() throws RemoteException;

    public LowpanChannelInfo[] getSupportedChannels() throws RemoteException;

    public String[] getSupportedNetworkTypes() throws RemoteException;

    public byte[] getMacAddress() throws RemoteException;

    public boolean isEnabled() throws RemoteException;

    public void setEnabled(boolean var1) throws RemoteException;

    public boolean isUp() throws RemoteException;

    public boolean isCommissioned() throws RemoteException;

    public boolean isConnected() throws RemoteException;

    public String getState() throws RemoteException;

    public String getRole() throws RemoteException;

    public String getPartitionId() throws RemoteException;

    public byte[] getExtendedAddress() throws RemoteException;

    public LowpanIdentity getLowpanIdentity() throws RemoteException;

    public LowpanCredential getLowpanCredential() throws RemoteException;

    public String[] getLinkAddresses() throws RemoteException;

    public IpPrefix[] getLinkNetworks() throws RemoteException;

    public void join(LowpanProvision var1) throws RemoteException;

    public void form(LowpanProvision var1) throws RemoteException;

    public void attach(LowpanProvision var1) throws RemoteException;

    public void leave() throws RemoteException;

    public void reset() throws RemoteException;

    public void startCommissioningSession(LowpanBeaconInfo var1) throws RemoteException;

    public void closeCommissioningSession() throws RemoteException;

    public void sendToCommissioner(byte[] var1) throws RemoteException;

    public void beginLowPower() throws RemoteException;

    public void pollForData() throws RemoteException;

    public void onHostWake() throws RemoteException;

    public void addListener(ILowpanInterfaceListener var1) throws RemoteException;

    public void removeListener(ILowpanInterfaceListener var1) throws RemoteException;

    public void startNetScan(Map var1, ILowpanNetScanCallback var2) throws RemoteException;

    public void stopNetScan() throws RemoteException;

    public void startEnergyScan(Map var1, ILowpanEnergyScanCallback var2) throws RemoteException;

    public void stopEnergyScan() throws RemoteException;

    public void addOnMeshPrefix(IpPrefix var1, int var2) throws RemoteException;

    public void removeOnMeshPrefix(IpPrefix var1) throws RemoteException;

    public void addExternalRoute(IpPrefix var1, int var2) throws RemoteException;

    public void removeExternalRoute(IpPrefix var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ILowpanInterface {
        static final int TRANSACTION_getName = 1;
        static final int TRANSACTION_getNcpVersion = 2;
        static final int TRANSACTION_getDriverVersion = 3;
        static final int TRANSACTION_getSupportedChannels = 4;
        static final int TRANSACTION_getSupportedNetworkTypes = 5;
        static final int TRANSACTION_getMacAddress = 6;
        static final int TRANSACTION_isEnabled = 7;
        static final int TRANSACTION_setEnabled = 8;
        static final int TRANSACTION_isUp = 9;
        static final int TRANSACTION_isCommissioned = 10;
        static final int TRANSACTION_isConnected = 11;
        static final int TRANSACTION_getState = 12;
        static final int TRANSACTION_getRole = 13;
        static final int TRANSACTION_getPartitionId = 14;
        static final int TRANSACTION_getExtendedAddress = 15;
        static final int TRANSACTION_getLowpanIdentity = 16;
        static final int TRANSACTION_getLowpanCredential = 17;
        static final int TRANSACTION_getLinkAddresses = 18;
        static final int TRANSACTION_getLinkNetworks = 19;
        static final int TRANSACTION_join = 20;
        static final int TRANSACTION_form = 21;
        static final int TRANSACTION_attach = 22;
        static final int TRANSACTION_leave = 23;
        static final int TRANSACTION_reset = 24;
        static final int TRANSACTION_startCommissioningSession = 25;
        static final int TRANSACTION_closeCommissioningSession = 26;
        static final int TRANSACTION_sendToCommissioner = 27;
        static final int TRANSACTION_beginLowPower = 28;
        static final int TRANSACTION_pollForData = 29;
        static final int TRANSACTION_onHostWake = 30;
        static final int TRANSACTION_addListener = 31;
        static final int TRANSACTION_removeListener = 32;
        static final int TRANSACTION_startNetScan = 33;
        static final int TRANSACTION_stopNetScan = 34;
        static final int TRANSACTION_startEnergyScan = 35;
        static final int TRANSACTION_stopEnergyScan = 36;
        static final int TRANSACTION_addOnMeshPrefix = 37;
        static final int TRANSACTION_removeOnMeshPrefix = 38;
        static final int TRANSACTION_addExternalRoute = 39;
        static final int TRANSACTION_removeExternalRoute = 40;

        public Stub() {
            this.attachInterface(this, ILowpanInterface.DESCRIPTOR);
        }

        public static ILowpanInterface asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ILowpanInterface.DESCRIPTOR);
            if (iin != null && iin instanceof ILowpanInterface) {
                return (ILowpanInterface)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getName";
                }
                case 2: {
                    return "getNcpVersion";
                }
                case 3: {
                    return "getDriverVersion";
                }
                case 4: {
                    return "getSupportedChannels";
                }
                case 5: {
                    return "getSupportedNetworkTypes";
                }
                case 6: {
                    return "getMacAddress";
                }
                case 7: {
                    return "isEnabled";
                }
                case 8: {
                    return "setEnabled";
                }
                case 9: {
                    return "isUp";
                }
                case 10: {
                    return "isCommissioned";
                }
                case 11: {
                    return "isConnected";
                }
                case 12: {
                    return "getState";
                }
                case 13: {
                    return "getRole";
                }
                case 14: {
                    return "getPartitionId";
                }
                case 15: {
                    return "getExtendedAddress";
                }
                case 16: {
                    return "getLowpanIdentity";
                }
                case 17: {
                    return "getLowpanCredential";
                }
                case 18: {
                    return "getLinkAddresses";
                }
                case 19: {
                    return "getLinkNetworks";
                }
                case 20: {
                    return "join";
                }
                case 21: {
                    return "form";
                }
                case 22: {
                    return "attach";
                }
                case 23: {
                    return "leave";
                }
                case 24: {
                    return "reset";
                }
                case 25: {
                    return "startCommissioningSession";
                }
                case 26: {
                    return "closeCommissioningSession";
                }
                case 27: {
                    return "sendToCommissioner";
                }
                case 28: {
                    return "beginLowPower";
                }
                case 29: {
                    return "pollForData";
                }
                case 30: {
                    return "onHostWake";
                }
                case 31: {
                    return "addListener";
                }
                case 32: {
                    return "removeListener";
                }
                case 33: {
                    return "startNetScan";
                }
                case 34: {
                    return "stopNetScan";
                }
                case 35: {
                    return "startEnergyScan";
                }
                case 36: {
                    return "stopEnergyScan";
                }
                case 37: {
                    return "addOnMeshPrefix";
                }
                case 38: {
                    return "removeOnMeshPrefix";
                }
                case 39: {
                    return "addExternalRoute";
                }
                case 40: {
                    return "removeExternalRoute";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ILowpanInterface.DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    String _result = this.getName();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    String _result = this.getNcpVersion();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    String _result = this.getDriverVersion();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    Parcelable[] _result = this.getSupportedChannels();
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    String[] _result = this.getSupportedNetworkTypes();
                    reply.writeNoException();
                    reply.writeStringArray(_result);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    byte[] _result = this.getMacAddress();
                    reply.writeNoException();
                    reply.writeByteArray(_result);
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.isEnabled();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    this.setEnabled(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.isUp();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.isCommissioned();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 11: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.isConnected();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 12: {
                    data.enforceInterface(descriptor);
                    String _result = this.getState();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 13: {
                    data.enforceInterface(descriptor);
                    String _result = this.getRole();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 14: {
                    data.enforceInterface(descriptor);
                    String _result = this.getPartitionId();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 15: {
                    data.enforceInterface(descriptor);
                    byte[] _result = this.getExtendedAddress();
                    reply.writeNoException();
                    reply.writeByteArray(_result);
                    return true;
                }
                case 16: {
                    data.enforceInterface(descriptor);
                    LowpanIdentity _result = this.getLowpanIdentity();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 17: {
                    data.enforceInterface(descriptor);
                    LowpanCredential _result = this.getLowpanCredential();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 18: {
                    data.enforceInterface(descriptor);
                    String[] _result = this.getLinkAddresses();
                    reply.writeNoException();
                    reply.writeStringArray(_result);
                    return true;
                }
                case 19: {
                    data.enforceInterface(descriptor);
                    Parcelable[] _result = this.getLinkNetworks();
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    return true;
                }
                case 20: {
                    data.enforceInterface(descriptor);
                    LowpanProvision _arg0 = 0 != data.readInt() ? LowpanProvision.CREATOR.createFromParcel(data) : null;
                    this.join(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 21: {
                    data.enforceInterface(descriptor);
                    LowpanProvision _arg0 = 0 != data.readInt() ? LowpanProvision.CREATOR.createFromParcel(data) : null;
                    this.form(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 22: {
                    data.enforceInterface(descriptor);
                    LowpanProvision _arg0 = 0 != data.readInt() ? LowpanProvision.CREATOR.createFromParcel(data) : null;
                    this.attach(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 23: {
                    data.enforceInterface(descriptor);
                    this.leave();
                    reply.writeNoException();
                    return true;
                }
                case 24: {
                    data.enforceInterface(descriptor);
                    this.reset();
                    reply.writeNoException();
                    return true;
                }
                case 25: {
                    data.enforceInterface(descriptor);
                    LowpanBeaconInfo _arg0 = 0 != data.readInt() ? LowpanBeaconInfo.CREATOR.createFromParcel(data) : null;
                    this.startCommissioningSession(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 26: {
                    data.enforceInterface(descriptor);
                    this.closeCommissioningSession();
                    reply.writeNoException();
                    return true;
                }
                case 27: {
                    data.enforceInterface(descriptor);
                    byte[] _arg0 = data.createByteArray();
                    this.sendToCommissioner(_arg0);
                    return true;
                }
                case 28: {
                    data.enforceInterface(descriptor);
                    this.beginLowPower();
                    reply.writeNoException();
                    return true;
                }
                case 29: {
                    data.enforceInterface(descriptor);
                    this.pollForData();
                    return true;
                }
                case 30: {
                    data.enforceInterface(descriptor);
                    this.onHostWake();
                    return true;
                }
                case 31: {
                    data.enforceInterface(descriptor);
                    ILowpanInterfaceListener _arg0 = ILowpanInterfaceListener.Stub.asInterface(data.readStrongBinder());
                    this.addListener(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 32: {
                    data.enforceInterface(descriptor);
                    ILowpanInterfaceListener _arg0 = ILowpanInterfaceListener.Stub.asInterface(data.readStrongBinder());
                    this.removeListener(_arg0);
                    return true;
                }
                case 33: {
                    data.enforceInterface(descriptor);
                    ClassLoader cl = this.getClass().getClassLoader();
                    HashMap _arg0 = data.readHashMap(cl);
                    ILowpanNetScanCallback _arg1 = ILowpanNetScanCallback.Stub.asInterface(data.readStrongBinder());
                    this.startNetScan(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 34: {
                    data.enforceInterface(descriptor);
                    this.stopNetScan();
                    return true;
                }
                case 35: {
                    data.enforceInterface(descriptor);
                    ClassLoader cl = this.getClass().getClassLoader();
                    HashMap _arg0 = data.readHashMap(cl);
                    ILowpanEnergyScanCallback _arg1 = ILowpanEnergyScanCallback.Stub.asInterface(data.readStrongBinder());
                    this.startEnergyScan(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 36: {
                    data.enforceInterface(descriptor);
                    this.stopEnergyScan();
                    return true;
                }
                case 37: {
                    data.enforceInterface(descriptor);
                    IpPrefix _arg0 = 0 != data.readInt() ? IpPrefix.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    this.addOnMeshPrefix(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 38: {
                    data.enforceInterface(descriptor);
                    IpPrefix _arg0 = 0 != data.readInt() ? IpPrefix.CREATOR.createFromParcel(data) : null;
                    this.removeOnMeshPrefix(_arg0);
                    return true;
                }
                case 39: {
                    data.enforceInterface(descriptor);
                    IpPrefix _arg0 = 0 != data.readInt() ? IpPrefix.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    this.addExternalRoute(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 40: {
                    data.enforceInterface(descriptor);
                    IpPrefix _arg0 = 0 != data.readInt() ? IpPrefix.CREATOR.createFromParcel(data) : null;
                    this.removeExternalRoute(_arg0);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(ILowpanInterface impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static ILowpanInterface getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements ILowpanInterface {
            private IBinder mRemote;
            public static ILowpanInterface sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ILowpanInterface.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getName() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILowpanInterface.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String string2 = Stub.getDefaultImpl().getName();
                        return string2;
                    }
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getNcpVersion() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILowpanInterface.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String string2 = Stub.getDefaultImpl().getNcpVersion();
                        return string2;
                    }
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getDriverVersion() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILowpanInterface.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String string2 = Stub.getDefaultImpl().getDriverVersion();
                        return string2;
                    }
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public LowpanChannelInfo[] getSupportedChannels() throws RemoteException {
                LowpanChannelInfo[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILowpanInterface.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        LowpanChannelInfo[] lowpanChannelInfoArray = Stub.getDefaultImpl().getSupportedChannels();
                        return lowpanChannelInfoArray;
                    }
                    _reply.readException();
                    _result = _reply.createTypedArray(LowpanChannelInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] getSupportedNetworkTypes() throws RemoteException {
                String[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILowpanInterface.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String[] stringArray = Stub.getDefaultImpl().getSupportedNetworkTypes();
                        return stringArray;
                    }
                    _reply.readException();
                    _result = _reply.createStringArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] getMacAddress() throws RemoteException {
                byte[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILowpanInterface.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        byte[] byArray = Stub.getDefaultImpl().getMacAddress();
                        return byArray;
                    }
                    _reply.readException();
                    _result = _reply.createByteArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILowpanInterface.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isEnabled();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setEnabled(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILowpanInterface.DESCRIPTOR);
                    _data.writeInt(enabled ? 1 : 0);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setEnabled(enabled);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isUp() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILowpanInterface.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isUp();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isCommissioned() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILowpanInterface.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isCommissioned();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isConnected() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILowpanInterface.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isConnected();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getState() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILowpanInterface.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String string2 = Stub.getDefaultImpl().getState();
                        return string2;
                    }
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getRole() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILowpanInterface.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String string2 = Stub.getDefaultImpl().getRole();
                        return string2;
                    }
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getPartitionId() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILowpanInterface.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String string2 = Stub.getDefaultImpl().getPartitionId();
                        return string2;
                    }
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] getExtendedAddress() throws RemoteException {
                byte[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILowpanInterface.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        byte[] byArray = Stub.getDefaultImpl().getExtendedAddress();
                        return byArray;
                    }
                    _reply.readException();
                    _result = _reply.createByteArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public LowpanIdentity getLowpanIdentity() throws RemoteException {
                LowpanIdentity _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILowpanInterface.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        LowpanIdentity lowpanIdentity = Stub.getDefaultImpl().getLowpanIdentity();
                        return lowpanIdentity;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? LowpanIdentity.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public LowpanCredential getLowpanCredential() throws RemoteException {
                LowpanCredential _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILowpanInterface.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        LowpanCredential lowpanCredential = Stub.getDefaultImpl().getLowpanCredential();
                        return lowpanCredential;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? LowpanCredential.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] getLinkAddresses() throws RemoteException {
                String[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILowpanInterface.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String[] stringArray = Stub.getDefaultImpl().getLinkAddresses();
                        return stringArray;
                    }
                    _reply.readException();
                    _result = _reply.createStringArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IpPrefix[] getLinkNetworks() throws RemoteException {
                IpPrefix[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILowpanInterface.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        IpPrefix[] ipPrefixArray = Stub.getDefaultImpl().getLinkNetworks();
                        return ipPrefixArray;
                    }
                    _reply.readException();
                    _result = _reply.createTypedArray(IpPrefix.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void join(LowpanProvision provision) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILowpanInterface.DESCRIPTOR);
                    if (provision != null) {
                        _data.writeInt(1);
                        provision.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().join(provision);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void form(LowpanProvision provision) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILowpanInterface.DESCRIPTOR);
                    if (provision != null) {
                        _data.writeInt(1);
                        provision.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().form(provision);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void attach(LowpanProvision provision) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILowpanInterface.DESCRIPTOR);
                    if (provision != null) {
                        _data.writeInt(1);
                        provision.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().attach(provision);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void leave() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILowpanInterface.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().leave();
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reset() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILowpanInterface.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().reset();
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startCommissioningSession(LowpanBeaconInfo beaconInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILowpanInterface.DESCRIPTOR);
                    if (beaconInfo != null) {
                        _data.writeInt(1);
                        beaconInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().startCommissioningSession(beaconInfo);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void closeCommissioningSession() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILowpanInterface.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().closeCommissioningSession();
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendToCommissioner(byte[] packet) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILowpanInterface.DESCRIPTOR);
                    _data.writeByteArray(packet);
                    boolean _status = this.mRemote.transact(27, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().sendToCommissioner(packet);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void beginLowPower() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILowpanInterface.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().beginLowPower();
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            @Override
            public void pollForData() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILowpanInterface.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(29, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().pollForData();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onHostWake() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILowpanInterface.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(30, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onHostWake();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addListener(ILowpanInterfaceListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILowpanInterface.DESCRIPTOR);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().addListener(listener);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeListener(ILowpanInterfaceListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILowpanInterface.DESCRIPTOR);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    boolean _status = this.mRemote.transact(32, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().removeListener(listener);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startNetScan(Map properties, ILowpanNetScanCallback listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILowpanInterface.DESCRIPTOR);
                    _data.writeMap(properties);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().startNetScan(properties, listener);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            @Override
            public void stopNetScan() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILowpanInterface.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(34, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().stopNetScan();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startEnergyScan(Map properties, ILowpanEnergyScanCallback listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILowpanInterface.DESCRIPTOR);
                    _data.writeMap(properties);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    boolean _status = this.mRemote.transact(35, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().startEnergyScan(properties, listener);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            @Override
            public void stopEnergyScan() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILowpanInterface.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(36, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().stopEnergyScan();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addOnMeshPrefix(IpPrefix prefix, int flags) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILowpanInterface.DESCRIPTOR);
                    if (prefix != null) {
                        _data.writeInt(1);
                        prefix.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(37, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().addOnMeshPrefix(prefix, flags);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeOnMeshPrefix(IpPrefix prefix) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILowpanInterface.DESCRIPTOR);
                    if (prefix != null) {
                        _data.writeInt(1);
                        prefix.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(38, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().removeOnMeshPrefix(prefix);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addExternalRoute(IpPrefix prefix, int flags) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILowpanInterface.DESCRIPTOR);
                    if (prefix != null) {
                        _data.writeInt(1);
                        prefix.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(39, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().addExternalRoute(prefix, flags);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeExternalRoute(IpPrefix prefix) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILowpanInterface.DESCRIPTOR);
                    if (prefix != null) {
                        _data.writeInt(1);
                        prefix.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(40, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().removeExternalRoute(prefix);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ILowpanInterface {
        @Override
        public String getName() throws RemoteException {
            return null;
        }

        @Override
        public String getNcpVersion() throws RemoteException {
            return null;
        }

        @Override
        public String getDriverVersion() throws RemoteException {
            return null;
        }

        @Override
        public LowpanChannelInfo[] getSupportedChannels() throws RemoteException {
            return null;
        }

        @Override
        public String[] getSupportedNetworkTypes() throws RemoteException {
            return null;
        }

        @Override
        public byte[] getMacAddress() throws RemoteException {
            return null;
        }

        @Override
        public boolean isEnabled() throws RemoteException {
            return false;
        }

        @Override
        public void setEnabled(boolean enabled) throws RemoteException {
        }

        @Override
        public boolean isUp() throws RemoteException {
            return false;
        }

        @Override
        public boolean isCommissioned() throws RemoteException {
            return false;
        }

        @Override
        public boolean isConnected() throws RemoteException {
            return false;
        }

        @Override
        public String getState() throws RemoteException {
            return null;
        }

        @Override
        public String getRole() throws RemoteException {
            return null;
        }

        @Override
        public String getPartitionId() throws RemoteException {
            return null;
        }

        @Override
        public byte[] getExtendedAddress() throws RemoteException {
            return null;
        }

        @Override
        public LowpanIdentity getLowpanIdentity() throws RemoteException {
            return null;
        }

        @Override
        public LowpanCredential getLowpanCredential() throws RemoteException {
            return null;
        }

        @Override
        public String[] getLinkAddresses() throws RemoteException {
            return null;
        }

        @Override
        public IpPrefix[] getLinkNetworks() throws RemoteException {
            return null;
        }

        @Override
        public void join(LowpanProvision provision) throws RemoteException {
        }

        @Override
        public void form(LowpanProvision provision) throws RemoteException {
        }

        @Override
        public void attach(LowpanProvision provision) throws RemoteException {
        }

        @Override
        public void leave() throws RemoteException {
        }

        @Override
        public void reset() throws RemoteException {
        }

        @Override
        public void startCommissioningSession(LowpanBeaconInfo beaconInfo) throws RemoteException {
        }

        @Override
        public void closeCommissioningSession() throws RemoteException {
        }

        @Override
        public void sendToCommissioner(byte[] packet) throws RemoteException {
        }

        @Override
        public void beginLowPower() throws RemoteException {
        }

        @Override
        public void pollForData() throws RemoteException {
        }

        @Override
        public void onHostWake() throws RemoteException {
        }

        @Override
        public void addListener(ILowpanInterfaceListener listener) throws RemoteException {
        }

        @Override
        public void removeListener(ILowpanInterfaceListener listener) throws RemoteException {
        }

        @Override
        public void startNetScan(Map properties, ILowpanNetScanCallback listener) throws RemoteException {
        }

        @Override
        public void stopNetScan() throws RemoteException {
        }

        @Override
        public void startEnergyScan(Map properties, ILowpanEnergyScanCallback listener) throws RemoteException {
        }

        @Override
        public void stopEnergyScan() throws RemoteException {
        }

        @Override
        public void addOnMeshPrefix(IpPrefix prefix, int flags) throws RemoteException {
        }

        @Override
        public void removeOnMeshPrefix(IpPrefix prefix) throws RemoteException {
        }

        @Override
        public void addExternalRoute(IpPrefix prefix, int flags) throws RemoteException {
        }

        @Override
        public void removeExternalRoute(IpPrefix prefix) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

