/*
 * Decompiled with CFR 0.152.
 */
package android.net.lowpan;

import android.content.Context;
import android.net.lowpan.ILowpanInterface;
import android.net.lowpan.ILowpanManager;
import android.net.lowpan.ILowpanManagerListener;
import android.net.lowpan.LowpanException;
import android.net.lowpan.LowpanInterface;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.os.ServiceManager;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.os.BackgroundThread;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public class LowpanManager {
    private static final String TAG = LowpanManager.class.getSimpleName();
    private final Map<Integer, ILowpanManagerListener> mListenerMap = new HashMap<Integer, ILowpanManagerListener>();
    private final Map<String, LowpanInterface> mInterfaceCache = new HashMap<String, LowpanInterface>();
    private final Map<IBinder, WeakReference<LowpanInterface>> mBinderCache = new WeakHashMap<IBinder, WeakReference<LowpanInterface>>();
    private final ILowpanManager mService;
    private final Context mContext;
    private final Looper mLooper;

    public static LowpanManager from(Context context) {
        return (LowpanManager)context.getSystemService("lowpan");
    }

    public static LowpanManager getManager() {
        IBinder binder = ServiceManager.getService("lowpan");
        if (binder != null) {
            ILowpanManager service = ILowpanManager.Stub.asInterface(binder);
            return new LowpanManager(service);
        }
        return null;
    }

    LowpanManager(ILowpanManager service) {
        this.mService = service;
        this.mContext = null;
        this.mLooper = null;
    }

    public LowpanManager(Context context, ILowpanManager service) {
        this(context, service, BackgroundThread.get().getLooper());
    }

    @VisibleForTesting
    public LowpanManager(Context context, ILowpanManager service, Looper looper) {
        this.mContext = context;
        this.mService = service;
        this.mLooper = looper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LowpanInterface getInterfaceNoCreate(ILowpanInterface ifaceService) {
        LowpanInterface iface = null;
        Map<IBinder, WeakReference<LowpanInterface>> map = this.mBinderCache;
        synchronized (map) {
            if (this.mBinderCache.containsKey(ifaceService.asBinder())) {
                iface = (LowpanInterface)this.mBinderCache.get(ifaceService.asBinder()).get();
            }
        }
        return iface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LowpanInterface getInterface(final ILowpanInterface ifaceService) {
        LowpanInterface iface = null;
        try {
            Map<IBinder, WeakReference<LowpanInterface>> map = this.mBinderCache;
            synchronized (map) {
                if (this.mBinderCache.containsKey(ifaceService.asBinder())) {
                    iface = (LowpanInterface)this.mBinderCache.get(ifaceService.asBinder()).get();
                }
                if (iface == null) {
                    final String ifaceName = ifaceService.getName();
                    iface = new LowpanInterface(this.mContext, ifaceService, this.mLooper);
                    Map<String, LowpanInterface> map2 = this.mInterfaceCache;
                    synchronized (map2) {
                        this.mInterfaceCache.put(iface.getName(), iface);
                    }
                    this.mBinderCache.put(ifaceService.asBinder(), new WeakReference<LowpanInterface>(iface));
                    ifaceService.asBinder().linkToDeath(new IBinder.DeathRecipient(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void binderDied() {
                            Map map = LowpanManager.this.mInterfaceCache;
                            synchronized (map) {
                                LowpanInterface iface = (LowpanInterface)LowpanManager.this.mInterfaceCache.get(ifaceName);
                                if (iface != null && iface.getService() == ifaceService) {
                                    LowpanManager.this.mInterfaceCache.remove(ifaceName);
                                }
                            }
                        }
                    }, 0);
                }
            }
        }
        catch (RemoteException x) {
            throw x.rethrowAsRuntimeException();
        }
        return iface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LowpanInterface getInterface(String name) {
        LowpanInterface iface = null;
        try {
            Map<String, LowpanInterface> map = this.mInterfaceCache;
            synchronized (map) {
                if (this.mInterfaceCache.containsKey(name)) {
                    iface = this.mInterfaceCache.get(name);
                } else {
                    ILowpanInterface ifaceService = this.mService.getInterface(name);
                    if (ifaceService != null) {
                        iface = this.getInterface(ifaceService);
                    }
                }
            }
        }
        catch (RemoteException x) {
            throw x.rethrowFromSystemServer();
        }
        return iface;
    }

    public LowpanInterface getInterface() {
        String[] ifaceList = this.getInterfaceList();
        if (ifaceList.length > 0) {
            return this.getInterface(ifaceList[0]);
        }
        return null;
    }

    public String[] getInterfaceList() {
        try {
            return this.mService.getInterfaceList();
        }
        catch (RemoteException x) {
            throw x.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCallback(final Callback cb, final Handler handler) throws LowpanException {
        ILowpanManagerListener.Stub listenerBinder = new ILowpanManagerListener.Stub(){
            private Handler mHandler;
            {
                this.mHandler = handler != null ? handler : (LowpanManager.this.mLooper != null ? new Handler(LowpanManager.this.mLooper) : new Handler());
            }

            @Override
            public void onInterfaceAdded(ILowpanInterface ifaceService) {
                Runnable runnable = () -> {
                    LowpanInterface iface = LowpanManager.this.getInterface(ifaceService);
                    if (iface != null) {
                        cb.onInterfaceAdded(iface);
                    }
                };
                this.mHandler.post(runnable);
            }

            @Override
            public void onInterfaceRemoved(ILowpanInterface ifaceService) {
                Runnable runnable = () -> {
                    LowpanInterface iface = LowpanManager.this.getInterfaceNoCreate(ifaceService);
                    if (iface != null) {
                        cb.onInterfaceRemoved(iface);
                    }
                };
                this.mHandler.post(runnable);
            }
        };
        try {
            this.mService.addListener(listenerBinder);
        }
        catch (RemoteException x) {
            throw x.rethrowFromSystemServer();
        }
        Map<Integer, ILowpanManagerListener> map = this.mListenerMap;
        synchronized (map) {
            this.mListenerMap.put(System.identityHashCode(cb), listenerBinder);
        }
    }

    public void registerCallback(Callback cb) throws LowpanException {
        this.registerCallback(cb, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterCallback(Callback cb) {
        Integer hashCode = System.identityHashCode(cb);
        ILowpanManagerListener listenerBinder = null;
        Map<Integer, ILowpanManagerListener> map = this.mListenerMap;
        synchronized (map) {
            listenerBinder = this.mListenerMap.get(hashCode);
            this.mListenerMap.remove(hashCode);
        }
        if (listenerBinder != null) {
            try {
                this.mService.removeListener(listenerBinder);
            }
            catch (RemoteException x) {
                throw x.rethrowFromSystemServer();
            }
        } else {
            throw new RuntimeException("Attempt to unregister an unknown callback");
        }
    }

    public static abstract class Callback {
        public void onInterfaceAdded(LowpanInterface lowpanInterface) {
        }

        public void onInterfaceRemoved(LowpanInterface lowpanInterface) {
        }
    }
}

