/*
 * Decompiled with CFR 0.152.
 */
package android.net.nsd;

import android.app.compat.CompatChanges;
import android.content.Context;
import android.net.nsd.INsdManager;
import android.net.nsd.NsdServiceInfo;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.AsyncChannel;
import com.android.internal.util.Preconditions;
import java.util.concurrent.CountDownLatch;

public class NsdManager {
    private static final String TAG = NsdManager.class.getSimpleName();
    private static final boolean DBG = false;
    public static final long RUN_NATIVE_NSD_ONLY_IF_LEGACY_APPS = 191844585L;
    public static final String ACTION_NSD_STATE_CHANGED = "android.net.nsd.STATE_CHANGED";
    public static final String EXTRA_NSD_STATE = "nsd_state";
    public static final int NSD_STATE_DISABLED = 1;
    public static final int NSD_STATE_ENABLED = 2;
    private static final int BASE = 393216;
    public static final int DISCOVER_SERVICES = 393217;
    public static final int DISCOVER_SERVICES_STARTED = 393218;
    public static final int DISCOVER_SERVICES_FAILED = 393219;
    public static final int SERVICE_FOUND = 393220;
    public static final int SERVICE_LOST = 393221;
    public static final int STOP_DISCOVERY = 393222;
    public static final int STOP_DISCOVERY_FAILED = 393223;
    public static final int STOP_DISCOVERY_SUCCEEDED = 393224;
    public static final int REGISTER_SERVICE = 393225;
    public static final int REGISTER_SERVICE_FAILED = 393226;
    public static final int REGISTER_SERVICE_SUCCEEDED = 393227;
    public static final int UNREGISTER_SERVICE = 393228;
    public static final int UNREGISTER_SERVICE_FAILED = 393229;
    public static final int UNREGISTER_SERVICE_SUCCEEDED = 393230;
    public static final int RESOLVE_SERVICE = 393234;
    public static final int RESOLVE_SERVICE_FAILED = 393235;
    public static final int RESOLVE_SERVICE_SUCCEEDED = 393236;
    public static final int DAEMON_CLEANUP = 393237;
    public static final int DAEMON_STARTUP = 393238;
    public static final int ENABLE = 393240;
    public static final int DISABLE = 393241;
    public static final int NATIVE_DAEMON_EVENT = 393242;
    public static final int PROTOCOL_DNS_SD = 1;
    private static final SparseArray<String> EVENT_NAMES = new SparseArray();
    private static final int FIRST_LISTENER_KEY = 1;
    private final INsdManager mService;
    private final Context mContext;
    private int mListenerKey = 1;
    private final SparseArray mListenerMap = new SparseArray();
    private final SparseArray<NsdServiceInfo> mServiceMap = new SparseArray();
    private final Object mMapLock = new Object();
    private final AsyncChannel mAsyncChannel = new AsyncChannel();
    private ServiceHandler mHandler;
    private final CountDownLatch mConnected = new CountDownLatch(1);
    public static final int FAILURE_INTERNAL_ERROR = 0;
    public static final int FAILURE_ALREADY_ACTIVE = 3;
    public static final int FAILURE_MAX_LIMIT = 4;

    public static String nameOf(int event) {
        String name = EVENT_NAMES.get(event);
        if (name == null) {
            return Integer.toString(event);
        }
        return name;
    }

    public NsdManager(Context context, INsdManager service) {
        this.mService = service;
        this.mContext = context;
        this.init();
    }

    @VisibleForTesting
    public void disconnect() {
        this.mAsyncChannel.disconnect();
        this.mHandler.getLooper().quitSafely();
    }

    private int nextListenerKey() {
        this.mListenerKey = Math.max(1, this.mListenerKey + 1);
        return this.mListenerKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int putListener(Object listener, NsdServiceInfo s) {
        int key;
        NsdManager.checkListener(listener);
        Object object = this.mMapLock;
        synchronized (object) {
            int valueIndex = this.mListenerMap.indexOfValue(listener);
            Preconditions.checkArgument(valueIndex == -1, "listener already in use");
            key = this.nextListenerKey();
            this.mListenerMap.put(key, listener);
            this.mServiceMap.put(key, s);
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeListener(int key) {
        Object object = this.mMapLock;
        synchronized (object) {
            this.mListenerMap.remove(key);
            this.mServiceMap.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getListenerKey(Object listener) {
        NsdManager.checkListener(listener);
        Object object = this.mMapLock;
        synchronized (object) {
            int valueIndex = this.mListenerMap.indexOfValue(listener);
            Preconditions.checkArgument(valueIndex != -1, "listener not registered");
            return this.mListenerMap.keyAt(valueIndex);
        }
    }

    private static String getNsdServiceInfoType(NsdServiceInfo s) {
        if (s == null) {
            return "?";
        }
        return s.getServiceType();
    }

    private void init() {
        Messenger messenger = this.getMessenger();
        if (messenger == null) {
            NsdManager.fatal("Failed to obtain service Messenger");
        }
        HandlerThread t = new HandlerThread("NsdManager");
        t.start();
        this.mHandler = new ServiceHandler(t.getLooper());
        this.mAsyncChannel.connect(this.mContext, (Handler)this.mHandler, messenger);
        try {
            this.mConnected.await();
        }
        catch (InterruptedException e) {
            NsdManager.fatal("Interrupted wait at init");
        }
        if (CompatChanges.isChangeEnabled(191844585L)) {
            return;
        }
        this.mAsyncChannel.sendMessage(393238);
    }

    private static void fatal(String msg) {
        Log.e(TAG, msg);
        throw new RuntimeException(msg);
    }

    public void registerService(NsdServiceInfo serviceInfo, int protocolType, RegistrationListener listener) {
        Preconditions.checkArgument(serviceInfo.getPort() > 0, "Invalid port number");
        NsdManager.checkServiceInfo(serviceInfo);
        NsdManager.checkProtocol(protocolType);
        int key = this.putListener(listener, serviceInfo);
        this.mAsyncChannel.sendMessage(393225, 0, key, serviceInfo);
    }

    public void unregisterService(RegistrationListener listener) {
        int id2 = this.getListenerKey(listener);
        this.mAsyncChannel.sendMessage(393228, 0, id2);
    }

    public void discoverServices(String serviceType, int protocolType, DiscoveryListener listener) {
        Preconditions.checkStringNotEmpty(serviceType, "Service type cannot be empty");
        NsdManager.checkProtocol(protocolType);
        NsdServiceInfo s = new NsdServiceInfo();
        s.setServiceType(serviceType);
        int key = this.putListener(listener, s);
        this.mAsyncChannel.sendMessage(393217, 0, key, s);
    }

    public void stopServiceDiscovery(DiscoveryListener listener) {
        int id2 = this.getListenerKey(listener);
        this.mAsyncChannel.sendMessage(393222, 0, id2);
    }

    public void resolveService(NsdServiceInfo serviceInfo, ResolveListener listener) {
        NsdManager.checkServiceInfo(serviceInfo);
        int key = this.putListener(listener, serviceInfo);
        this.mAsyncChannel.sendMessage(393234, 0, key, serviceInfo);
    }

    public void setEnabled(boolean enabled) {
        try {
            this.mService.setEnabled(enabled);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private Messenger getMessenger() {
        try {
            return this.mService.getMessenger();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static void checkListener(Object listener) {
        Preconditions.checkNotNull(listener, "listener cannot be null");
    }

    private static void checkProtocol(int protocolType) {
        Preconditions.checkArgument(protocolType == 1, "Unsupported protocol");
    }

    private static void checkServiceInfo(NsdServiceInfo serviceInfo) {
        Preconditions.checkNotNull(serviceInfo, "NsdServiceInfo cannot be null");
        Preconditions.checkStringNotEmpty(serviceInfo.getServiceName(), "Service name cannot be empty");
        Preconditions.checkStringNotEmpty(serviceInfo.getServiceType(), "Service type cannot be empty");
    }

    static {
        EVENT_NAMES.put(393217, "DISCOVER_SERVICES");
        EVENT_NAMES.put(393218, "DISCOVER_SERVICES_STARTED");
        EVENT_NAMES.put(393219, "DISCOVER_SERVICES_FAILED");
        EVENT_NAMES.put(393220, "SERVICE_FOUND");
        EVENT_NAMES.put(393221, "SERVICE_LOST");
        EVENT_NAMES.put(393222, "STOP_DISCOVERY");
        EVENT_NAMES.put(393223, "STOP_DISCOVERY_FAILED");
        EVENT_NAMES.put(393224, "STOP_DISCOVERY_SUCCEEDED");
        EVENT_NAMES.put(393225, "REGISTER_SERVICE");
        EVENT_NAMES.put(393226, "REGISTER_SERVICE_FAILED");
        EVENT_NAMES.put(393227, "REGISTER_SERVICE_SUCCEEDED");
        EVENT_NAMES.put(393228, "UNREGISTER_SERVICE");
        EVENT_NAMES.put(393229, "UNREGISTER_SERVICE_FAILED");
        EVENT_NAMES.put(393230, "UNREGISTER_SERVICE_SUCCEEDED");
        EVENT_NAMES.put(393234, "RESOLVE_SERVICE");
        EVENT_NAMES.put(393235, "RESOLVE_SERVICE_FAILED");
        EVENT_NAMES.put(393236, "RESOLVE_SERVICE_SUCCEEDED");
        EVENT_NAMES.put(393237, "DAEMON_CLEANUP");
        EVENT_NAMES.put(393238, "DAEMON_STARTUP");
        EVENT_NAMES.put(393240, "ENABLE");
        EVENT_NAMES.put(393241, "DISABLE");
        EVENT_NAMES.put(393242, "NATIVE_DAEMON_EVENT");
    }

    @VisibleForTesting
    class ServiceHandler
    extends Handler {
        ServiceHandler(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message message) {
            NsdServiceInfo ns;
            Object listener;
            int what = message.what;
            int key = message.arg2;
            switch (what) {
                case 69632: {
                    NsdManager.this.mAsyncChannel.sendMessage(69633);
                    return;
                }
                case 69634: {
                    NsdManager.this.mConnected.countDown();
                    return;
                }
                case 69636: {
                    Log.e(TAG, "Channel lost");
                    return;
                }
            }
            Object object = NsdManager.this.mMapLock;
            synchronized (object) {
                listener = NsdManager.this.mListenerMap.get(key);
                ns = (NsdServiceInfo)NsdManager.this.mServiceMap.get(key);
            }
            if (listener == null) {
                Log.d(TAG, "Stale key " + message.arg2);
                return;
            }
            switch (what) {
                case 393218: {
                    String s = NsdManager.getNsdServiceInfoType((NsdServiceInfo)message.obj);
                    ((DiscoveryListener)listener).onDiscoveryStarted(s);
                    break;
                }
                case 393219: {
                    NsdManager.this.removeListener(key);
                    ((DiscoveryListener)listener).onStartDiscoveryFailed(NsdManager.getNsdServiceInfoType(ns), message.arg1);
                    break;
                }
                case 393220: {
                    ((DiscoveryListener)listener).onServiceFound((NsdServiceInfo)message.obj);
                    break;
                }
                case 393221: {
                    ((DiscoveryListener)listener).onServiceLost((NsdServiceInfo)message.obj);
                    break;
                }
                case 393223: {
                    NsdManager.this.removeListener(key);
                    ((DiscoveryListener)listener).onStopDiscoveryFailed(NsdManager.getNsdServiceInfoType(ns), message.arg1);
                    break;
                }
                case 393224: {
                    NsdManager.this.removeListener(key);
                    ((DiscoveryListener)listener).onDiscoveryStopped(NsdManager.getNsdServiceInfoType(ns));
                    break;
                }
                case 393226: {
                    NsdManager.this.removeListener(key);
                    ((RegistrationListener)listener).onRegistrationFailed(ns, message.arg1);
                    break;
                }
                case 393227: {
                    ((RegistrationListener)listener).onServiceRegistered((NsdServiceInfo)message.obj);
                    break;
                }
                case 393229: {
                    NsdManager.this.removeListener(key);
                    ((RegistrationListener)listener).onUnregistrationFailed(ns, message.arg1);
                    break;
                }
                case 393230: {
                    NsdManager.this.removeListener(message.arg2);
                    ((RegistrationListener)listener).onServiceUnregistered(ns);
                    break;
                }
                case 393235: {
                    NsdManager.this.removeListener(key);
                    ((ResolveListener)listener).onResolveFailed(ns, message.arg1);
                    break;
                }
                case 393236: {
                    NsdManager.this.removeListener(key);
                    ((ResolveListener)listener).onServiceResolved((NsdServiceInfo)message.obj);
                    break;
                }
                default: {
                    Log.d(TAG, "Ignored " + message);
                }
            }
        }
    }

    public static interface ResolveListener {
        public void onResolveFailed(NsdServiceInfo var1, int var2);

        public void onServiceResolved(NsdServiceInfo var1);
    }

    public static interface RegistrationListener {
        public void onRegistrationFailed(NsdServiceInfo var1, int var2);

        public void onUnregistrationFailed(NsdServiceInfo var1, int var2);

        public void onServiceRegistered(NsdServiceInfo var1);

        public void onServiceUnregistered(NsdServiceInfo var1);
    }

    public static interface DiscoveryListener {
        public void onStartDiscoveryFailed(String var1, int var2);

        public void onStopDiscoveryFailed(String var1, int var2);

        public void onDiscoveryStarted(String var1);

        public void onDiscoveryStopped(String var1);

        public void onServiceFound(NsdServiceInfo var1);

        public void onServiceLost(NsdServiceInfo var1);
    }
}

