/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.net.wifi.SoftApConfiguration;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ILocalOnlyHotspotCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.net.wifi.ILocalOnlyHotspotCallback";

    public void onHotspotStarted(SoftApConfiguration var1) throws RemoteException;

    public void onHotspotStopped() throws RemoteException;

    public void onHotspotFailed(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ILocalOnlyHotspotCallback {
        static final int TRANSACTION_onHotspotStarted = 1;
        static final int TRANSACTION_onHotspotStopped = 2;
        static final int TRANSACTION_onHotspotFailed = 3;

        public Stub() {
            this.attachInterface(this, ILocalOnlyHotspotCallback.DESCRIPTOR);
        }

        public static ILocalOnlyHotspotCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ILocalOnlyHotspotCallback.DESCRIPTOR);
            if (iin != null && iin instanceof ILocalOnlyHotspotCallback) {
                return (ILocalOnlyHotspotCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ILocalOnlyHotspotCallback.DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    SoftApConfiguration _arg0 = 0 != data.readInt() ? SoftApConfiguration.CREATOR.createFromParcel(data) : null;
                    this.onHotspotStarted(_arg0);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    this.onHotspotStopped();
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.onHotspotFailed(_arg0);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(ILocalOnlyHotspotCallback impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static ILocalOnlyHotspotCallback getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements ILocalOnlyHotspotCallback {
            private IBinder mRemote;
            public static ILocalOnlyHotspotCallback sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ILocalOnlyHotspotCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onHotspotStarted(SoftApConfiguration config) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILocalOnlyHotspotCallback.DESCRIPTOR);
                    if (config != null) {
                        _data.writeInt(1);
                        config.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onHotspotStarted(config);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onHotspotStopped() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILocalOnlyHotspotCallback.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onHotspotStopped();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onHotspotFailed(int reason) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILocalOnlyHotspotCallback.DESCRIPTOR);
                    _data.writeInt(reason);
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onHotspotFailed(reason);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ILocalOnlyHotspotCallback {
        @Override
        public void onHotspotStarted(SoftApConfiguration config) throws RemoteException {
        }

        @Override
        public void onHotspotStopped() throws RemoteException {
        }

        @Override
        public void onHotspotFailed(int reason) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

