/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IScoreUpdateObserver
extends IInterface {
    public static final String DESCRIPTOR = "android.net.wifi.IScoreUpdateObserver";

    public void notifyScoreUpdate(int var1, int var2) throws RemoteException;

    public void triggerUpdateOfWifiUsabilityStats(int var1) throws RemoteException;

    public void notifyStatusUpdate(int var1, boolean var2) throws RemoteException;

    public void requestNudOperation(int var1) throws RemoteException;

    public void blocklistCurrentBssid(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IScoreUpdateObserver {
        static final int TRANSACTION_notifyScoreUpdate = 1;
        static final int TRANSACTION_triggerUpdateOfWifiUsabilityStats = 2;
        static final int TRANSACTION_notifyStatusUpdate = 3;
        static final int TRANSACTION_requestNudOperation = 4;
        static final int TRANSACTION_blocklistCurrentBssid = 5;

        public Stub() {
            this.attachInterface(this, IScoreUpdateObserver.DESCRIPTOR);
        }

        public static IScoreUpdateObserver asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IScoreUpdateObserver.DESCRIPTOR);
            if (iin != null && iin instanceof IScoreUpdateObserver) {
                return (IScoreUpdateObserver)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IScoreUpdateObserver.DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.notifyScoreUpdate(_arg0, _arg1);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.triggerUpdateOfWifiUsabilityStats(_arg0);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    boolean _arg1 = 0 != data.readInt();
                    this.notifyStatusUpdate(_arg0, _arg1);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.requestNudOperation(_arg0);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.blocklistCurrentBssid(_arg0);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IScoreUpdateObserver impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IScoreUpdateObserver getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IScoreUpdateObserver {
            private IBinder mRemote;
            public static IScoreUpdateObserver sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IScoreUpdateObserver.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyScoreUpdate(int sessionId, int score) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IScoreUpdateObserver.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    _data.writeInt(score);
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().notifyScoreUpdate(sessionId, score);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void triggerUpdateOfWifiUsabilityStats(int sessionId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IScoreUpdateObserver.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().triggerUpdateOfWifiUsabilityStats(sessionId);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyStatusUpdate(int sessionId, boolean isUsable) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IScoreUpdateObserver.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    _data.writeInt(isUsable ? 1 : 0);
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().notifyStatusUpdate(sessionId, isUsable);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestNudOperation(int sessionId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IScoreUpdateObserver.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    boolean _status = this.mRemote.transact(4, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().requestNudOperation(sessionId);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void blocklistCurrentBssid(int sessionId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IScoreUpdateObserver.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    boolean _status = this.mRemote.transact(5, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().blocklistCurrentBssid(sessionId);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IScoreUpdateObserver {
        @Override
        public void notifyScoreUpdate(int sessionId, int score) throws RemoteException {
        }

        @Override
        public void triggerUpdateOfWifiUsabilityStats(int sessionId) throws RemoteException {
        }

        @Override
        public void notifyStatusUpdate(int sessionId, boolean isUsable) throws RemoteException {
        }

        @Override
        public void requestNudOperation(int sessionId) throws RemoteException {
        }

        @Override
        public void blocklistCurrentBssid(int sessionId) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

