/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.aware;

import android.net.NetworkSpecifier;
import android.net.wifi.aware.WifiAwareNetworkSpecifier;
import android.net.wifi.util.HexEncoding;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.StringJoiner;

public class WifiAwareAgentNetworkSpecifier
extends NetworkSpecifier
implements Parcelable {
    private static final String TAG = "WifiAwareAgentNs";
    private static final boolean VDBG = false;
    private Set<ByteArrayWrapper> mNetworkSpecifiers = new HashSet<ByteArrayWrapper>();
    private MessageDigest mDigester;
    public static final Parcelable.Creator<WifiAwareAgentNetworkSpecifier> CREATOR = new Parcelable.Creator<WifiAwareAgentNetworkSpecifier>(){

        @Override
        public WifiAwareAgentNetworkSpecifier createFromParcel(Parcel in) {
            Object[] objs;
            WifiAwareAgentNetworkSpecifier agentNs = new WifiAwareAgentNetworkSpecifier();
            for (Object obj : objs = in.readArray(null)) {
                agentNs.mNetworkSpecifiers.add((ByteArrayWrapper)obj);
            }
            return agentNs;
        }

        public WifiAwareAgentNetworkSpecifier[] newArray(int size) {
            return new WifiAwareAgentNetworkSpecifier[size];
        }
    };

    public WifiAwareAgentNetworkSpecifier() {
        this.initialize();
    }

    public WifiAwareAgentNetworkSpecifier(WifiAwareNetworkSpecifier ns) {
        this.initialize();
        this.mNetworkSpecifiers.add(this.convert(ns));
    }

    public WifiAwareAgentNetworkSpecifier(WifiAwareNetworkSpecifier[] nss) {
        this.initialize();
        for (WifiAwareNetworkSpecifier ns : nss) {
            this.mNetworkSpecifiers.add(this.convert(ns));
        }
    }

    public boolean isEmpty() {
        return this.mNetworkSpecifiers.isEmpty();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeArray(this.mNetworkSpecifiers.toArray());
    }

    public int hashCode() {
        return this.mNetworkSpecifiers.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof WifiAwareAgentNetworkSpecifier)) {
            return false;
        }
        return this.mNetworkSpecifiers.equals(((WifiAwareAgentNetworkSpecifier)obj).mNetworkSpecifiers);
    }

    public String toString() {
        StringJoiner sj = new StringJoiner(",");
        for (ByteArrayWrapper baw : this.mNetworkSpecifiers) {
            sj.add(baw.toString());
        }
        return sj.toString();
    }

    @Override
    public boolean canBeSatisfiedBy(NetworkSpecifier other) {
        if (!(other instanceof WifiAwareAgentNetworkSpecifier)) {
            return false;
        }
        WifiAwareAgentNetworkSpecifier otherNs = (WifiAwareAgentNetworkSpecifier)other;
        for (ByteArrayWrapper baw : this.mNetworkSpecifiers) {
            if (otherNs.mNetworkSpecifiers.contains(baw)) continue;
            return false;
        }
        return true;
    }

    public boolean satisfiesAwareNetworkSpecifier(WifiAwareNetworkSpecifier ns) {
        ByteArrayWrapper nsBytes = this.convert(ns);
        return this.mNetworkSpecifiers.contains(nsBytes);
    }

    @Override
    public NetworkSpecifier redact() {
        return null;
    }

    private void initialize() {
        try {
            this.mDigester = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            Log.e(TAG, "Can not instantiate a SHA-256 digester!? Will match nothing.");
            return;
        }
    }

    private ByteArrayWrapper convert(WifiAwareNetworkSpecifier ns) {
        if (this.mDigester == null) {
            return null;
        }
        Parcel parcel = Parcel.obtain();
        ns.writeToParcel(parcel, 0);
        byte[] bytes = parcel.marshall();
        this.mDigester.reset();
        this.mDigester.update(bytes);
        return new ByteArrayWrapper(this.mDigester.digest());
    }

    private static class ByteArrayWrapper
    implements Parcelable {
        private byte[] mData;
        public static final Parcelable.Creator<ByteArrayWrapper> CREATOR = new Parcelable.Creator<ByteArrayWrapper>(){

            @Override
            public ByteArrayWrapper createFromParcel(Parcel in) {
                return new ByteArrayWrapper(in.createByteArray());
            }

            public ByteArrayWrapper[] newArray(int size) {
                return new ByteArrayWrapper[size];
            }
        };

        ByteArrayWrapper(byte[] data) {
            this.mData = data;
        }

        public int hashCode() {
            return Arrays.hashCode(this.mData);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ByteArrayWrapper)) {
                return false;
            }
            return Arrays.equals(((ByteArrayWrapper)obj).mData, this.mData);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeByteArray(this.mData);
        }

        public String toString() {
            return new String(HexEncoding.encode(this.mData));
        }
    }
}

