/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.aware;

import android.content.Context;
import android.content.pm.PackageManager;

public class WifiAwareUtils {
    public static void validateServiceName(byte[] serviceNameData) throws IllegalArgumentException {
        if (serviceNameData == null) {
            throw new IllegalArgumentException("Invalid service name - null");
        }
        if (serviceNameData.length < 1 || serviceNameData.length > 255) {
            throw new IllegalArgumentException("Invalid service name length - must be between 1 and 255 bytes (UTF-8 encoding)");
        }
        for (int index = 0; index < serviceNameData.length; ++index) {
            byte b = serviceNameData[index];
            if ((b & 0x80) != 0 || b >= 48 && b <= 57 || b >= 97 && b <= 122 || b >= 65 && b <= 90 || b == 45 || b == 46 || b == 95) continue;
            throw new IllegalArgumentException("Invalid service name - illegal characters, allowed = (0-9, a-z,A-Z, -, _, .)");
        }
    }

    public static boolean validatePassphrase(String passphrase) {
        return passphrase != null && passphrase.length() >= 8 && passphrase.length() <= 63;
    }

    public static boolean validatePmk(byte[] pmk) {
        return pmk != null && pmk.length == 32;
    }

    public static boolean isLegacyVersion(Context context, int minVersion) {
        try {
            if (context.getPackageManager().getApplicationInfo((String)context.getOpPackageName(), (int)0).targetSdkVersion < minVersion) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return false;
    }
}

