/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Parcel;
import android.os.PowerComponents;
import android.util.proto.ProtoOutputStream;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public abstract class BatteryConsumer {
    public static final int POWER_COMPONENT_SCREEN = 0;
    public static final int POWER_COMPONENT_CPU = 1;
    public static final int POWER_COMPONENT_BLUETOOTH = 2;
    public static final int POWER_COMPONENT_CAMERA = 3;
    public static final int POWER_COMPONENT_AUDIO = 4;
    public static final int POWER_COMPONENT_VIDEO = 5;
    public static final int POWER_COMPONENT_FLASHLIGHT = 6;
    public static final int POWER_COMPONENT_SYSTEM_SERVICES = 7;
    public static final int POWER_COMPONENT_MOBILE_RADIO = 8;
    public static final int POWER_COMPONENT_SENSORS = 9;
    public static final int POWER_COMPONENT_GNSS = 10;
    public static final int POWER_COMPONENT_WIFI = 11;
    public static final int POWER_COMPONENT_WAKELOCK = 12;
    public static final int POWER_COMPONENT_MEMORY = 13;
    public static final int POWER_COMPONENT_PHONE = 14;
    public static final int POWER_COMPONENT_AMBIENT_DISPLAY = 15;
    public static final int POWER_COMPONENT_IDLE = 16;
    public static final int POWER_COMPONENT_REATTRIBUTED_TO_OTHER_CONSUMERS = 17;
    public static final int POWER_COMPONENT_COUNT = 18;
    public static final int FIRST_CUSTOM_POWER_COMPONENT_ID = 1000;
    public static final int LAST_CUSTOM_POWER_COMPONENT_ID = 9999;
    private static final String[] sPowerComponentNames = new String[18];
    public static final int POWER_MODEL_UNDEFINED = 0;
    public static final int POWER_MODEL_POWER_PROFILE = 1;
    public static final int POWER_MODEL_MEASURED_ENERGY = 2;
    protected final PowerComponents mPowerComponents;

    protected BatteryConsumer(PowerComponents powerComponents) {
        this.mPowerComponents = powerComponents;
    }

    public double getConsumedPower() {
        return this.mPowerComponents.getConsumedPower();
    }

    public double getConsumedPower(int componentId) {
        return this.mPowerComponents.getConsumedPower(componentId);
    }

    public int getPowerModel(int componentId) {
        return this.mPowerComponents.getPowerModel(componentId);
    }

    public double getConsumedPowerForCustomComponent(int componentId) {
        return this.mPowerComponents.getConsumedPowerForCustomComponent(componentId);
    }

    public int getCustomPowerComponentCount() {
        return this.mPowerComponents.getCustomPowerComponentCount();
    }

    void setCustomPowerComponentNames(String[] customPowerComponentNames) {
        this.mPowerComponents.setCustomPowerComponentNames(customPowerComponentNames);
    }

    public String getCustomPowerComponentName(int componentId) {
        return this.mPowerComponents.getCustomPowerComponentName(componentId);
    }

    public long getUsageDurationMillis(int componentId) {
        return this.mPowerComponents.getUsageDurationMillis(componentId);
    }

    public long getUsageDurationForCustomComponentMillis(int componentId) {
        return this.mPowerComponents.getUsageDurationForCustomComponentMillis(componentId);
    }

    protected void writeToParcel(Parcel dest, int flags) {
        this.mPowerComponents.writeToParcel(dest, flags);
    }

    public static String powerComponentIdToString(int componentId) {
        return sPowerComponentNames[componentId];
    }

    public static String powerModelToString(int powerModel) {
        switch (powerModel) {
            case 2: {
                return "measured energy";
            }
            case 1: {
                return "power profile";
            }
        }
        return "";
    }

    public void dump(PrintWriter pw) {
        this.dump(pw, true);
    }

    public abstract void dump(PrintWriter var1, boolean var2);

    boolean hasStatsProtoData() {
        return this.writeStatsProtoImpl(null, 0L);
    }

    void writeStatsProto(ProtoOutputStream proto, long fieldId) {
        this.writeStatsProtoImpl(proto, fieldId);
    }

    private boolean writeStatsProtoImpl(ProtoOutputStream proto, long fieldId) {
        long totalConsumedPowerDeciCoulombs = BatteryConsumer.convertMahToDeciCoulombs(this.getConsumedPower());
        if (totalConsumedPowerDeciCoulombs == 0L) {
            return false;
        }
        if (proto == null) {
            return true;
        }
        long token = proto.start(fieldId);
        proto.write(0x10300000001L, totalConsumedPowerDeciCoulombs);
        this.mPowerComponents.writeStatsProto(proto);
        proto.end(token);
        return true;
    }

    static long convertMahToDeciCoulombs(double powerMah) {
        return (long)(powerMah * 36.0 + 0.5);
    }

    static {
        BatteryConsumer.sPowerComponentNames[0] = "screen";
        BatteryConsumer.sPowerComponentNames[1] = "cpu";
        BatteryConsumer.sPowerComponentNames[2] = "bluetooth";
        BatteryConsumer.sPowerComponentNames[3] = "camera";
        BatteryConsumer.sPowerComponentNames[4] = "audio";
        BatteryConsumer.sPowerComponentNames[5] = "video";
        BatteryConsumer.sPowerComponentNames[6] = "flashlight";
        BatteryConsumer.sPowerComponentNames[7] = "system_services";
        BatteryConsumer.sPowerComponentNames[8] = "mobile_radio";
        BatteryConsumer.sPowerComponentNames[9] = "sensors";
        BatteryConsumer.sPowerComponentNames[10] = "gnss";
        BatteryConsumer.sPowerComponentNames[11] = "wifi";
        BatteryConsumer.sPowerComponentNames[12] = "wakelock";
        BatteryConsumer.sPowerComponentNames[13] = "memory";
        BatteryConsumer.sPowerComponentNames[14] = "phone";
        BatteryConsumer.sPowerComponentNames[15] = "ambient_display";
        BatteryConsumer.sPowerComponentNames[16] = "idle";
        BatteryConsumer.sPowerComponentNames[17] = "reattributed";
    }

    protected static abstract class BaseBuilder<T extends BaseBuilder<?>> {
        final PowerComponents.Builder mPowerComponentsBuilder;

        public BaseBuilder(String[] customPowerComponentNames, boolean includePowerModels) {
            this.mPowerComponentsBuilder = new PowerComponents.Builder(customPowerComponentNames, includePowerModels);
        }

        public T setConsumedPower(int componentId, double componentPower) {
            return this.setConsumedPower(componentId, componentPower, 1);
        }

        public T setConsumedPower(int componentId, double componentPower, int powerModel) {
            this.mPowerComponentsBuilder.setConsumedPower(componentId, componentPower, powerModel);
            return (T)this;
        }

        public T setConsumedPowerForCustomComponent(int componentId, double componentPower) {
            this.mPowerComponentsBuilder.setConsumedPowerForCustomComponent(componentId, componentPower);
            return (T)this;
        }

        public T setUsageDurationMillis(int componentId, long componentUsageTimeMillis) {
            this.mPowerComponentsBuilder.setUsageDurationMillis(componentId, componentUsageTimeMillis);
            return (T)this;
        }

        public T setUsageDurationForCustomComponentMillis(int componentId, long componentUsageTimeMillis) {
            this.mPowerComponentsBuilder.setUsageDurationForCustomComponentMillis(componentId, componentUsageTimeMillis);
            return (T)this;
        }

        public double getTotalPower() {
            return this.mPowerComponentsBuilder.getTotalPower();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PowerModel {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PowerComponent {
    }
}

