/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.compat.annotation.UnsupportedAppUsage;
import android.os.Handler;
import android.os.Message;

public class Broadcaster {
    private Registration mReg;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public Broadcaster() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void request(int senderWhat, Handler target, int targetWhat) {
        Broadcaster broadcaster = this;
        synchronized (broadcaster) {
            Registration r = null;
            if (this.mReg == null) {
                r = new Registration();
                r.senderWhat = senderWhat;
                r.targets = new Handler[1];
                r.targetWhats = new int[1];
                r.targets[0] = target;
                r.targetWhats[0] = targetWhat;
                this.mReg = r;
                r.next = r;
                r.prev = r;
            } else {
                int n;
                Registration start;
                r = start = this.mReg;
                while (r.senderWhat < senderWhat && (r = r.next) != start) {
                }
                if (r.senderWhat != senderWhat) {
                    Registration reg = new Registration();
                    reg.senderWhat = senderWhat;
                    reg.targets = new Handler[1];
                    reg.targetWhats = new int[1];
                    reg.next = r;
                    reg.prev = r.prev;
                    r.prev.next = reg;
                    r.prev = reg;
                    if (r == this.mReg && r.senderWhat > reg.senderWhat) {
                        this.mReg = reg;
                    }
                    r = reg;
                    n = 0;
                } else {
                    n = r.targets.length;
                    Handler[] oldTargets = r.targets;
                    int[] oldWhats = r.targetWhats;
                    for (int i = 0; i < n; ++i) {
                        if (oldTargets[i] != target || oldWhats[i] != targetWhat) continue;
                        return;
                    }
                    r.targets = new Handler[n + 1];
                    System.arraycopy(oldTargets, 0, r.targets, 0, n);
                    r.targetWhats = new int[n + 1];
                    System.arraycopy(oldWhats, 0, r.targetWhats, 0, n);
                }
                r.targets[n] = target;
                r.targetWhats[n] = targetWhat;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void cancelRequest(int senderWhat, Handler target, int targetWhat) {
        Broadcaster broadcaster = this;
        synchronized (broadcaster) {
            Registration start;
            Registration r = start = this.mReg;
            if (r == null) {
                return;
            }
            while (r.senderWhat < senderWhat && (r = r.next) != start) {
            }
            if (r.senderWhat == senderWhat) {
                Handler[] targets = r.targets;
                int[] whats = r.targetWhats;
                int oldLen = targets.length;
                for (int i = 0; i < oldLen; ++i) {
                    int remainingLen;
                    if (targets[i] != target || whats[i] != targetWhat) continue;
                    r.targets = new Handler[oldLen - 1];
                    r.targetWhats = new int[oldLen - 1];
                    if (i > 0) {
                        System.arraycopy(targets, 0, r.targets, 0, i);
                        System.arraycopy(whats, 0, r.targetWhats, 0, i);
                    }
                    if ((remainingLen = oldLen - i - 1) == 0) break;
                    System.arraycopy(targets, i + 1, r.targets, i, remainingLen);
                    System.arraycopy(whats, i + 1, r.targetWhats, i, remainingLen);
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpRegistrations() {
        Broadcaster broadcaster = this;
        synchronized (broadcaster) {
            Registration start = this.mReg;
            System.out.println("Broadcaster " + this + " {");
            if (start != null) {
                Registration r = start;
                do {
                    System.out.println("    senderWhat=" + r.senderWhat);
                    int n = r.targets.length;
                    for (int i = 0; i < n; ++i) {
                        System.out.println("        [" + r.targetWhats[i] + "] " + r.targets[i]);
                    }
                } while ((r = r.next) != start);
            }
            System.out.println("}");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void broadcast(Message msg) {
        Broadcaster broadcaster = this;
        synchronized (broadcaster) {
            Registration start;
            if (this.mReg == null) {
                return;
            }
            int senderWhat = msg.what;
            Registration r = start = this.mReg;
            while (r.senderWhat < senderWhat && (r = r.next) != start) {
            }
            if (r.senderWhat == senderWhat) {
                Handler[] targets = r.targets;
                int[] whats = r.targetWhats;
                int n = targets.length;
                for (int i = 0; i < n; ++i) {
                    Handler target = targets[i];
                    Message m = Message.obtain();
                    m.copyFrom(msg);
                    m.what = whats[i];
                    target.sendMessage(m);
                }
            }
        }
    }

    private class Registration {
        Registration next;
        Registration prev;
        int senderWhat;
        Handler[] targets;
        int[] targetWhats;

        private Registration() {
        }
    }
}

