/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.bluetooth.BluetoothUuid;
import android.net.MacAddress;
import android.os.ParcelUuid;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.util.HexDump;
import java.util.ArrayList;
import java.util.function.Predicate;

public class BytesMatcher
implements Predicate<byte[]> {
    private static final String TAG = "BytesMatcher";
    private static final char TYPE_EXACT_ACCEPT = '+';
    private static final char TYPE_EXACT_REJECT = '-';
    private static final char TYPE_PREFIX_ACCEPT = '\u2286';
    private static final char TYPE_PREFIX_REJECT = '\u2288';
    private final ArrayList<Rule> mRules = new ArrayList();

    public void addExactAcceptRule(byte[] value, byte[] mask) {
        this.mRules.add(new Rule('+', value, mask));
    }

    public void addExactRejectRule(byte[] value, byte[] mask) {
        this.mRules.add(new Rule('-', value, mask));
    }

    public void addPrefixAcceptRule(byte[] value, byte[] mask) {
        this.mRules.add(new Rule('\u2286', value, mask));
    }

    public void addPrefixRejectRule(byte[] value, byte[] mask) {
        this.mRules.add(new Rule('\u2288', value, mask));
    }

    public boolean testBluetoothUuid(ParcelUuid value) {
        return this.test(BluetoothUuid.uuidToBytes(value));
    }

    public boolean testMacAddress(MacAddress value) {
        return this.test(value.toByteArray());
    }

    @Override
    public boolean test(byte[] value) {
        return this.test(value, false);
    }

    public boolean test(byte[] value, boolean defaultValue) {
        int size = this.mRules.size();
        for (int i = 0; i < size; ++i) {
            Rule rule = this.mRules.get(i);
            if (!rule.test(value)) continue;
            switch (rule.type) {
                case '+': 
                case '\u2286': {
                    return true;
                }
                case '-': 
                case '\u2288': {
                    return false;
                }
            }
        }
        return defaultValue;
    }

    public static String encode(BytesMatcher matcher) {
        StringBuilder builder = new StringBuilder();
        int size = matcher.mRules.size();
        for (int i = 0; i < size; ++i) {
            Rule rule = matcher.mRules.get(i);
            rule.encode(builder);
            builder.append(',');
        }
        if (builder.length() > 0) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    public static BytesMatcher decode(String value) {
        BytesMatcher matcher = new BytesMatcher();
        if (TextUtils.isEmpty(value)) {
            return matcher;
        }
        int length = value.length();
        int i = 0;
        while (i < length) {
            byte[] ruleMask;
            byte[] ruleValue;
            char type = value.charAt(i);
            int nextRule = value.indexOf(44, i);
            int nextMask = value.indexOf(47, i);
            if (nextRule == -1) {
                nextRule = length;
            }
            if (nextMask > nextRule) {
                nextMask = -1;
            }
            if (nextMask >= 0) {
                ruleValue = HexDump.hexStringToByteArray(value.substring(i + 1, nextMask));
                ruleMask = HexDump.hexStringToByteArray(value.substring(nextMask + 1, nextRule));
            } else {
                ruleValue = HexDump.hexStringToByteArray(value.substring(i + 1, nextRule));
                ruleMask = null;
            }
            switch (type) {
                case '+': {
                    matcher.addExactAcceptRule(ruleValue, ruleMask);
                    break;
                }
                case '-': {
                    matcher.addExactRejectRule(ruleValue, ruleMask);
                    break;
                }
                case '\u2286': {
                    matcher.addPrefixAcceptRule(ruleValue, ruleMask);
                    break;
                }
                case '\u2288': {
                    matcher.addPrefixRejectRule(ruleValue, ruleMask);
                    break;
                }
                default: {
                    Log.w(TAG, "Ignoring unknown type " + type);
                }
            }
            i = nextRule + 1;
        }
        return matcher;
    }

    private static class Rule {
        public final char type;
        public final byte[] value;
        public final byte[] mask;

        public Rule(char type, byte[] value, byte[] mask) {
            if (mask != null && value.length != mask.length) {
                throw new IllegalArgumentException("Expected length " + value.length + " but found " + mask.length);
            }
            this.type = type;
            this.value = value;
            this.mask = mask;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            this.encode(builder);
            return builder.toString();
        }

        public void encode(StringBuilder builder) {
            builder.append(this.type);
            builder.append(HexDump.toHexString(this.value));
            if (this.mask != null) {
                builder.append('/');
                builder.append(HexDump.toHexString(this.mask));
            }
        }

        public boolean test(byte[] value) {
            switch (this.type) {
                case '+': 
                case '-': {
                    if (value.length == this.value.length) break;
                    return false;
                }
                case '\u2286': 
                case '\u2288': {
                    if (value.length >= this.value.length) break;
                    return false;
                }
            }
            for (int i = 0; i < this.value.length; ++i) {
                byte local = this.value[i];
                byte remote = value[i];
                if (this.mask != null) {
                    local = (byte)(local & this.mask[i]);
                    remote = (byte)(remote & this.mask[i]);
                }
                if (local == remote) continue;
                return false;
            }
            return true;
        }
    }
}

