/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Binder;
import android.os.CpuUsageInfo;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;

public interface IHardwarePropertiesManager
extends IInterface {
    public float[] getDeviceTemperatures(String var1, int var2, int var3) throws RemoteException;

    public CpuUsageInfo[] getCpuUsages(String var1) throws RemoteException;

    public float[] getFanSpeeds(String var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IHardwarePropertiesManager {
        public static final String DESCRIPTOR = "android.os.IHardwarePropertiesManager";
        static final int TRANSACTION_getDeviceTemperatures = 1;
        static final int TRANSACTION_getCpuUsages = 2;
        static final int TRANSACTION_getFanSpeeds = 3;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IHardwarePropertiesManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IHardwarePropertiesManager) {
                return (IHardwarePropertiesManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getDeviceTemperatures";
                }
                case 2: {
                    return "getCpuUsages";
                }
                case 3: {
                    return "getFanSpeeds";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    float[] _result = this.getDeviceTemperatures(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeFloatArray(_result);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    Parcelable[] _result = this.getCpuUsages(_arg0);
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    float[] _result = this.getFanSpeeds(_arg0);
                    reply.writeNoException();
                    reply.writeFloatArray(_result);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IHardwarePropertiesManager impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IHardwarePropertiesManager getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IHardwarePropertiesManager {
            private IBinder mRemote;
            public static IHardwarePropertiesManager sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public float[] getDeviceTemperatures(String callingPackage, int type, int source) throws RemoteException {
                float[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeInt(type);
                    _data.writeInt(source);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        float[] fArray = Stub.getDefaultImpl().getDeviceTemperatures(callingPackage, type, source);
                        return fArray;
                    }
                    _reply.readException();
                    _result = _reply.createFloatArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CpuUsageInfo[] getCpuUsages(String callingPackage) throws RemoteException {
                CpuUsageInfo[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        CpuUsageInfo[] cpuUsageInfoArray = Stub.getDefaultImpl().getCpuUsages(callingPackage);
                        return cpuUsageInfoArray;
                    }
                    _reply.readException();
                    _result = _reply.createTypedArray(CpuUsageInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public float[] getFanSpeeds(String callingPackage) throws RemoteException {
                float[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        float[] fArray = Stub.getDefaultImpl().getFanSpeeds(callingPackage);
                        return fArray;
                    }
                    _reply.readException();
                    _result = _reply.createFloatArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IHardwarePropertiesManager {
        @Override
        public float[] getDeviceTemperatures(String callingPackage, int type, int source) throws RemoteException {
            return null;
        }

        @Override
        public CpuUsageInfo[] getCpuUsages(String callingPackage) throws RemoteException {
            return null;
        }

        @Override
        public float[] getFanSpeeds(String callingPackage) throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

