/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.SuppressLint;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArrayMap;
import android.util.ArraySet;
import com.android.internal.annotations.Immutable;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@Immutable
public class PackageTagsList
implements Parcelable {
    private final ArrayMap<String, ArraySet<String>> mPackageTags;
    public static final Parcelable.Creator<PackageTagsList> CREATOR = new Parcelable.Creator<PackageTagsList>(){

        @Override
        public PackageTagsList createFromParcel(Parcel in) {
            int count = in.readInt();
            ArrayMap<String, ArraySet<? extends Object>> packageTags = new ArrayMap<String, ArraySet<? extends Object>>(count);
            for (int i = 0; i < count; ++i) {
                String key = in.readString8();
                ArraySet<? extends Object> value = in.readArraySet(null);
                packageTags.append(key, value);
            }
            return new PackageTagsList(packageTags);
        }

        public PackageTagsList[] newArray(int size) {
            return new PackageTagsList[size];
        }
    };

    private PackageTagsList(ArrayMap<String, ArraySet<String>> packageTags) {
        this.mPackageTags = Objects.requireNonNull(packageTags);
    }

    public boolean isEmpty() {
        return this.mPackageTags.isEmpty();
    }

    public boolean includes(String packageName) {
        return this.mPackageTags.containsKey(packageName);
    }

    public boolean includesTag(String attributionTag) {
        int size = this.mPackageTags.size();
        for (int i = 0; i < size; ++i) {
            ArraySet<String> tags = this.mPackageTags.valueAt(i);
            if (!tags.contains(attributionTag)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(String packageName) {
        Set tags = this.mPackageTags.get(packageName);
        return tags != null && tags.isEmpty();
    }

    public boolean contains(String packageName, String attributionTag) {
        Set tags = this.mPackageTags.get(packageName);
        if (tags == null) {
            return false;
        }
        if (tags.isEmpty()) {
            return true;
        }
        return tags.contains(attributionTag);
    }

    public boolean contains(PackageTagsList packageTagsList) {
        int otherSize = packageTagsList.mPackageTags.size();
        if (otherSize > this.mPackageTags.size()) {
            return false;
        }
        for (int i = 0; i < otherSize; ++i) {
            String packageName = packageTagsList.mPackageTags.keyAt(i);
            ArraySet<String> tags = this.mPackageTags.get(packageName);
            if (tags == null) {
                return false;
            }
            if (tags.isEmpty()) continue;
            ArraySet<String> otherTags = packageTagsList.mPackageTags.valueAt(i);
            if (otherTags.isEmpty()) {
                return false;
            }
            if (tags.containsAll(otherTags)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        int count = this.mPackageTags.size();
        parcel.writeInt(count);
        for (int i = 0; i < count; ++i) {
            parcel.writeString8(this.mPackageTags.keyAt(i));
            parcel.writeArraySet(this.mPackageTags.valueAt(i));
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PackageTagsList)) {
            return false;
        }
        PackageTagsList that = (PackageTagsList)o;
        return this.mPackageTags.equals(that.mPackageTags);
    }

    public int hashCode() {
        return Objects.hash(this.mPackageTags);
    }

    public String toString() {
        return this.mPackageTags.toString();
    }

    public void dump(PrintWriter pw) {
        int size = this.mPackageTags.size();
        for (int i = 0; i < size; ++i) {
            String packageName = this.mPackageTags.keyAt(i);
            pw.print(packageName);
            pw.print("[");
            int tagsSize = this.mPackageTags.valueAt(i).size();
            if (tagsSize == 0) {
                pw.print("*");
            } else {
                for (int j = 0; j < tagsSize; ++j) {
                    String attributionTag = this.mPackageTags.valueAt(i).valueAt(j);
                    if (j > 0) {
                        pw.print(", ");
                    }
                    if (attributionTag.startsWith(packageName)) {
                        pw.print(attributionTag.substring(packageName.length()));
                        continue;
                    }
                    pw.print(attributionTag);
                }
            }
            pw.println("]");
        }
    }

    public static class Builder {
        private final ArrayMap<String, ArraySet<String>> mPackageTags;

        public Builder() {
            this.mPackageTags = new ArrayMap();
        }

        public Builder(int capacity) {
            this.mPackageTags = new ArrayMap(capacity);
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder add(String packageName) {
            this.mPackageTags.computeIfAbsent(packageName, p -> new ArraySet()).clear();
            return this;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder add(String packageName, String attributionTag) {
            ArraySet<String> tags = this.mPackageTags.get(packageName);
            if (tags == null) {
                tags = new ArraySet(1);
                tags.add(attributionTag);
                this.mPackageTags.put(packageName, tags);
            } else if (!tags.isEmpty()) {
                tags.add(attributionTag);
            }
            return this;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder add(String packageName, Collection<String> attributionTags) {
            if (attributionTags.isEmpty()) {
                return this;
            }
            ArraySet<String> tags = this.mPackageTags.get(packageName);
            if (tags == null) {
                tags = new ArraySet<String>(attributionTags);
                this.mPackageTags.put(packageName, tags);
            } else if (!tags.isEmpty()) {
                tags.addAll(attributionTags);
            }
            return this;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder add(PackageTagsList packageTagsList) {
            return this.add(packageTagsList.mPackageTags);
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder add(Map<String, ? extends Set<String>> packageTagsMap) {
            this.mPackageTags.ensureCapacity(packageTagsMap.size());
            for (Map.Entry<String, ? extends Set<String>> entry : packageTagsMap.entrySet()) {
                Set<String> newTags = entry.getValue();
                if (newTags.isEmpty()) {
                    this.add(entry.getKey());
                    continue;
                }
                this.add(entry.getKey(), newTags);
            }
            return this;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder remove(String packageName) {
            this.mPackageTags.remove(packageName);
            return this;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder remove(String packageName, String attributionTag) {
            ArraySet<String> tags = this.mPackageTags.get(packageName);
            if (tags != null && tags.remove(attributionTag) && tags.isEmpty()) {
                this.mPackageTags.remove(packageName);
            }
            return this;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder remove(String packageName, Collection<String> attributionTags) {
            if (attributionTags.isEmpty()) {
                return this;
            }
            ArraySet<String> tags = this.mPackageTags.get(packageName);
            if (tags != null && tags.removeAll(attributionTags) && tags.isEmpty()) {
                this.mPackageTags.remove(packageName);
            }
            return this;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder remove(PackageTagsList packageTagsList) {
            return this.remove(packageTagsList.mPackageTags);
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder remove(Map<String, ? extends Set<String>> packageTagsMap) {
            for (Map.Entry<String, ? extends Set<String>> entry : packageTagsMap.entrySet()) {
                Set<String> removedTags = entry.getValue();
                if (removedTags.isEmpty()) {
                    this.remove(entry.getKey());
                    continue;
                }
                this.remove(entry.getKey(), removedTags);
            }
            return this;
        }

        public Builder clear() {
            this.mPackageTags.clear();
            return this;
        }

        public PackageTagsList build() {
            return new PackageTagsList(Builder.copy(this.mPackageTags));
        }

        private static ArrayMap<String, ArraySet<String>> copy(ArrayMap<String, ArraySet<String>> value) {
            int size = value.size();
            ArrayMap<String, ArraySet<String>> copy = new ArrayMap<String, ArraySet<String>>(size);
            for (int i = 0; i < size; ++i) {
                String packageName = value.keyAt(i);
                ArraySet<String> tags = new ArraySet<String>(Objects.requireNonNull(value.valueAt(i)));
                copy.append(packageName, tags);
            }
            return copy;
        }
    }
}

