/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.compat.annotation.UnsupportedAppUsage;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import com.android.layoutlib.bridge.libcore.util.Cleaner;
import com.android.tools.layoutlib.create.OverrideMethod;
import com.android.tools.layoutlib.java.NioUtils_Delegate;
import dalvik.system.VMRuntime;
import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.DirectByteBuffer;

public class SharedMemory
implements Parcelable,
Closeable {
    private final FileDescriptor mFileDescriptor;
    private final int mSize;
    private final MemoryRegistration mMemoryRegistration;
    private Cleaner mCleaner;
    private static final int PROT_MASK = OsConstants.PROT_READ | OsConstants.PROT_WRITE | OsConstants.PROT_EXEC | OsConstants.PROT_NONE;
    public static final Parcelable.Creator<SharedMemory> CREATOR = new Parcelable.Creator<SharedMemory>(){

        @Override
        public SharedMemory createFromParcel(Parcel source) {
            FileDescriptor descriptor = source.readRawFileDescriptor();
            return new SharedMemory(descriptor);
        }

        public SharedMemory[] newArray(int size) {
            return new SharedMemory[size];
        }
    };

    private SharedMemory(FileDescriptor fd) {
        if (fd == null) {
            throw new IllegalArgumentException("Unable to create SharedMemory from a null FileDescriptor");
        }
        if (!fd.valid()) {
            throw new IllegalArgumentException("Unable to create SharedMemory from closed FileDescriptor");
        }
        this.mFileDescriptor = fd;
        this.mSize = SharedMemory.nGetSize(this.mFileDescriptor);
        if (this.mSize <= 0) {
            throw new IllegalArgumentException("FileDescriptor is not a valid ashmem fd");
        }
        this.mMemoryRegistration = new MemoryRegistration(this.mSize);
        this.mCleaner = Cleaner.create(this.mFileDescriptor, new Closer(this.mFileDescriptor, this.mMemoryRegistration));
    }

    public static SharedMemory create(String name, int size) throws ErrnoException {
        if (size <= 0) {
            throw new IllegalArgumentException("Size must be greater than zero");
        }
        return new SharedMemory(SharedMemory.nCreate(name, size));
    }

    private void checkOpen() {
        if (!this.mFileDescriptor.valid()) {
            throw new IllegalStateException("SharedMemory is closed");
        }
    }

    private static void validateProt(int prot) {
        if ((prot & ~PROT_MASK) != 0) {
            throw new IllegalArgumentException("Invalid prot value");
        }
    }

    public boolean setProtect(int prot) {
        this.checkOpen();
        SharedMemory.validateProt(prot);
        int errno = SharedMemory.nSetProt(this.mFileDescriptor, prot);
        return errno == 0;
    }

    public FileDescriptor getFileDescriptor() {
        return this.mFileDescriptor;
    }

    @UnsupportedAppUsage(trackingBug=171971817L)
    public int getFd() {
        return this.mFileDescriptor.getInt$();
    }

    public int getSize() {
        this.checkOpen();
        return this.mSize;
    }

    public ByteBuffer mapReadWrite() throws ErrnoException {
        return this.map(OsConstants.PROT_READ | OsConstants.PROT_WRITE, 0, this.mSize);
    }

    public ByteBuffer mapReadOnly() throws ErrnoException {
        return this.map(OsConstants.PROT_READ, 0, this.mSize);
    }

    public ByteBuffer map(int prot, int offset, int length) throws ErrnoException {
        this.checkOpen();
        SharedMemory.validateProt(prot);
        if (offset < 0) {
            throw new IllegalArgumentException("Offset must be >= 0");
        }
        if (length <= 0) {
            throw new IllegalArgumentException("Length must be > 0");
        }
        if (offset + length > this.mSize) {
            throw new IllegalArgumentException("offset + length must not exceed getSize()");
        }
        long address = Os.mmap(0L, length, prot, OsConstants.MAP_SHARED, this.mFileDescriptor, offset);
        boolean readOnly = (prot & OsConstants.PROT_WRITE) == 0;
        Unmapper unmapper = new Unmapper(address, length, this.mMemoryRegistration.acquire());
        return new DirectByteBuffer(length, address, this.mFileDescriptor, (Runnable)unmapper, readOnly);
    }

    public static void unmap(ByteBuffer buffer) {
        if (!(buffer instanceof DirectByteBuffer)) {
            throw new IllegalArgumentException("ByteBuffer wasn't created by #map(int, int, int); can't unmap");
        }
        NioUtils_Delegate.freeDirectBuffer(buffer);
    }

    @Override
    public void close() {
        if (this.mCleaner != null) {
            this.mCleaner.clean();
            this.mCleaner = null;
        }
    }

    @Override
    public int describeContents() {
        return 1;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        this.checkOpen();
        dest.writeFileDescriptor(this.mFileDescriptor);
    }

    public ParcelFileDescriptor getFdDup() throws IOException {
        return ParcelFileDescriptor.dup(this.mFileDescriptor);
    }

    private static FileDescriptor nCreate(String string2, int n) throws ErrnoException {
        return (FileDescriptor)OverrideMethod.invokeA("android.os.SharedMemory#nCreate(Ljava/lang/String;I)Ljava/io/FileDescriptor;", true, null);
    }

    private static int nGetSize(FileDescriptor fileDescriptor) {
        return OverrideMethod.invokeI("android.os.SharedMemory#nGetSize(Ljava/io/FileDescriptor;)I", true, null);
    }

    private static int nSetProt(FileDescriptor fileDescriptor, int n) {
        return OverrideMethod.invokeI("android.os.SharedMemory#nSetProt(Ljava/io/FileDescriptor;I)I", true, null);
    }

    private static class MemoryRegistration {
        private int mSize;
        private int mReferenceCount;

        private MemoryRegistration(int size) {
            this.mSize = size;
            this.mReferenceCount = 1;
            VMRuntime.getRuntime().registerNativeAllocation(this.mSize);
        }

        public synchronized MemoryRegistration acquire() {
            ++this.mReferenceCount;
            return this;
        }

        public synchronized void release() {
            --this.mReferenceCount;
            if (this.mReferenceCount == 0) {
                VMRuntime.getRuntime().registerNativeFree(this.mSize);
            }
        }
    }

    private static class Unmapper
    implements Runnable {
        private long mAddress;
        private int mSize;
        private MemoryRegistration mMemoryReference;

        private Unmapper(long address, int size, MemoryRegistration memoryReference) {
            this.mAddress = address;
            this.mSize = size;
            this.mMemoryReference = memoryReference;
        }

        @Override
        public void run() {
            try {
                Os.munmap(this.mAddress, this.mSize);
            }
            catch (ErrnoException errnoException) {
                // empty catch block
            }
            this.mMemoryReference.release();
            this.mMemoryReference = null;
        }
    }

    private static class Closer
    implements Runnable {
        private FileDescriptor mFd;
        private MemoryRegistration mMemoryReference;

        private Closer(FileDescriptor fd, MemoryRegistration memoryReference) {
            this.mFd = fd;
            this.mMemoryReference = memoryReference;
        }

        @Override
        public void run() {
            try {
                Os.close(this.mFd);
            }
            catch (ErrnoException errnoException) {
                // empty catch block
            }
            this.mMemoryReference.release();
            this.mMemoryReference = null;
        }
    }
}

