/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.media.AudioAttributes;
import android.os.CombinedVibration;
import android.os.VibrationAttributes;
import android.os.VibrationEffect;
import android.os.Vibrator;
import android.os.VibratorInfo;
import android.os.VibratorManager;
import android.util.ArrayMap;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.Executor;

public class SystemVibrator
extends Vibrator {
    private static final String TAG = "Vibrator";
    private final VibratorManager mVibratorManager;
    private final Context mContext;
    @GuardedBy(value={"mBrokenListeners"})
    private final ArrayList<AllVibratorsStateListener> mBrokenListeners = new ArrayList();
    @GuardedBy(value={"mRegisteredListeners"})
    private final ArrayMap<Vibrator.OnVibratorStateChangedListener, AllVibratorsStateListener> mRegisteredListeners = new ArrayMap();
    private final Object mLock = new Object();
    private AllVibratorsInfo mVibratorInfo;

    @UnsupportedAppUsage
    public SystemVibrator(Context context) {
        super(context);
        this.mContext = context;
        this.mVibratorManager = this.mContext.getSystemService(VibratorManager.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected VibratorInfo getInfo() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mVibratorInfo != null) {
                return this.mVibratorInfo;
            }
            if (this.mVibratorManager == null) {
                Log.w(TAG, "Failed to retrieve vibrator info; no vibrator manager.");
                return VibratorInfo.EMPTY_VIBRATOR_INFO;
            }
            int[] vibratorIds = this.mVibratorManager.getVibratorIds();
            VibratorInfo[] vibratorInfos = new VibratorInfo[vibratorIds.length];
            for (int i = 0; i < vibratorIds.length; ++i) {
                vibratorInfos[i] = this.mVibratorManager.getVibrator(vibratorIds[i]).getInfo();
            }
            this.mVibratorInfo = new AllVibratorsInfo(vibratorInfos);
            return this.mVibratorInfo;
        }
    }

    @Override
    public boolean hasVibrator() {
        if (this.mVibratorManager == null) {
            Log.w(TAG, "Failed to check if vibrator exists; no vibrator manager.");
            return false;
        }
        return this.mVibratorManager.getVibratorIds().length > 0;
    }

    @Override
    public boolean isVibrating() {
        if (this.mVibratorManager == null) {
            Log.w(TAG, "Failed to vibrate; no vibrator manager.");
            return false;
        }
        for (int vibratorId : this.mVibratorManager.getVibratorIds()) {
            if (!this.mVibratorManager.getVibrator(vibratorId).isVibrating()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addVibratorStateListener(Vibrator.OnVibratorStateChangedListener listener) {
        Objects.requireNonNull(listener);
        if (this.mContext == null) {
            Log.w(TAG, "Failed to add vibrate state listener; no vibrator context.");
            return;
        }
        this.addVibratorStateListener(this.mContext.getMainExecutor(), listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addVibratorStateListener(Executor executor, Vibrator.OnVibratorStateChangedListener listener) {
        Objects.requireNonNull(listener);
        Objects.requireNonNull(executor);
        if (this.mVibratorManager == null) {
            Log.w(TAG, "Failed to add vibrate state listener; no vibrator manager.");
            return;
        }
        AllVibratorsStateListener delegate = null;
        try {
            ArrayMap<Vibrator.OnVibratorStateChangedListener, AllVibratorsStateListener> arrayMap = this.mRegisteredListeners;
            synchronized (arrayMap) {
                block19: {
                    if (!this.mRegisteredListeners.containsKey(listener)) break block19;
                    Log.w(TAG, "Listener already registered.");
                    return;
                }
                delegate = new AllVibratorsStateListener(executor, listener);
                delegate.register(this.mVibratorManager);
                this.mRegisteredListeners.put(listener, delegate);
                delegate = null;
            }
        }
        finally {
            if (delegate != null && delegate.hasRegisteredListeners()) {
                ArrayList<AllVibratorsStateListener> arrayList = this.mBrokenListeners;
                synchronized (arrayList) {
                    this.mBrokenListeners.add(delegate);
                }
            }
            this.tryUnregisterBrokenListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeVibratorStateListener(Vibrator.OnVibratorStateChangedListener listener) {
        Objects.requireNonNull(listener);
        if (this.mVibratorManager == null) {
            Log.w(TAG, "Failed to remove vibrate state listener; no vibrator manager.");
            return;
        }
        ArrayMap<Vibrator.OnVibratorStateChangedListener, AllVibratorsStateListener> arrayMap = this.mRegisteredListeners;
        synchronized (arrayMap) {
            if (this.mRegisteredListeners.containsKey(listener)) {
                AllVibratorsStateListener delegate = this.mRegisteredListeners.get(listener);
                delegate.unregister(this.mVibratorManager);
                this.mRegisteredListeners.remove(listener);
            }
        }
        this.tryUnregisterBrokenListeners();
    }

    @Override
    public boolean hasAmplitudeControl() {
        return this.getInfo().hasAmplitudeControl();
    }

    @Override
    public boolean setAlwaysOnEffect(int uid, String opPkg, int alwaysOnId, VibrationEffect effect, AudioAttributes attributes) {
        if (this.mVibratorManager == null) {
            Log.w(TAG, "Failed to set always-on effect; no vibrator manager.");
            return false;
        }
        VibrationAttributes attr2 = new VibrationAttributes.Builder(attributes, effect).build();
        CombinedVibration combinedEffect = CombinedVibration.createParallel(effect);
        return this.mVibratorManager.setAlwaysOnEffect(uid, opPkg, alwaysOnId, combinedEffect, attr2);
    }

    @Override
    public void vibrate(int uid, String opPkg, VibrationEffect effect, String reason, VibrationAttributes attributes) {
        if (this.mVibratorManager == null) {
            Log.w(TAG, "Failed to vibrate; no vibrator manager.");
            return;
        }
        CombinedVibration combinedEffect = CombinedVibration.createParallel(effect);
        this.mVibratorManager.vibrate(uid, opPkg, combinedEffect, reason, attributes);
    }

    @Override
    public void cancel() {
        if (this.mVibratorManager == null) {
            Log.w(TAG, "Failed to cancel vibrate; no vibrator manager.");
            return;
        }
        this.mVibratorManager.cancel();
    }

    @Override
    public void cancel(int usageFilter) {
        if (this.mVibratorManager == null) {
            Log.w(TAG, "Failed to cancel vibrate; no vibrator manager.");
            return;
        }
        this.mVibratorManager.cancel(usageFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryUnregisterBrokenListeners() {
        ArrayList<AllVibratorsStateListener> arrayList = this.mBrokenListeners;
        synchronized (arrayList) {
            try {
                int i = this.mBrokenListeners.size();
                while (--i >= 0) {
                    this.mBrokenListeners.get(i).unregister(this.mVibratorManager);
                    this.mBrokenListeners.remove(i);
                }
            }
            catch (RuntimeException e) {
                Log.w(TAG, "Failed to unregister broken listener", e);
            }
        }
    }

    private static class AllVibratorsStateListener {
        private final Object mLock = new Object();
        private final Executor mExecutor;
        private final Vibrator.OnVibratorStateChangedListener mDelegate;
        @GuardedBy(value={"mLock"})
        private final SparseArray<SingleVibratorStateListener> mVibratorListeners = new SparseArray();
        @GuardedBy(value={"mLock"})
        private int mInitializedMask;
        @GuardedBy(value={"mLock"})
        private int mVibratingMask;

        AllVibratorsStateListener(Executor executor, Vibrator.OnVibratorStateChangedListener listener) {
            this.mExecutor = executor;
            this.mDelegate = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean hasRegisteredListeners() {
            Object object = this.mLock;
            synchronized (object) {
                return this.mVibratorListeners.size() > 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void register(VibratorManager vibratorManager) {
            int[] vibratorIds = vibratorManager.getVibratorIds();
            Object object = this.mLock;
            synchronized (object) {
                for (int i = 0; i < vibratorIds.length; ++i) {
                    int vibratorId = vibratorIds[i];
                    SingleVibratorStateListener listener = new SingleVibratorStateListener(this, i);
                    try {
                        vibratorManager.getVibrator(vibratorId).addVibratorStateListener(this.mExecutor, listener);
                        this.mVibratorListeners.put(vibratorId, listener);
                        continue;
                    }
                    catch (RuntimeException e) {
                        try {
                            this.unregister(vibratorManager);
                        }
                        catch (RuntimeException e1) {
                            Log.w(SystemVibrator.TAG, "Failed to unregister listener while recovering from a failed register call", e1);
                        }
                        throw e;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void unregister(VibratorManager vibratorManager) {
            Object object = this.mLock;
            synchronized (object) {
                int i = this.mVibratorListeners.size();
                while (--i >= 0) {
                    int vibratorId = this.mVibratorListeners.keyAt(i);
                    SingleVibratorStateListener listener = this.mVibratorListeners.valueAt(i);
                    vibratorManager.getVibrator(vibratorId).removeVibratorStateListener(listener);
                    this.mVibratorListeners.removeAt(i);
                }
            }
        }

        void onVibrating(int vibratorIdx, boolean vibrating) {
            this.mExecutor.execute(() -> {
                boolean anyVibrating;
                Object object = this.mLock;
                synchronized (object) {
                    int allInitializedMask = 1 << this.mVibratorListeners.size() - 1;
                    int vibratorMask = 1 << vibratorIdx;
                    if ((this.mInitializedMask & vibratorMask) == 0) {
                        this.mInitializedMask |= vibratorMask;
                        this.mVibratingMask |= vibrating ? vibratorMask : 0;
                    } else {
                        boolean prevVibrating;
                        boolean bl = prevVibrating = (this.mVibratingMask & vibratorMask) != 0;
                        if (prevVibrating != vibrating) {
                            this.mVibratingMask ^= vibratorMask;
                        }
                    }
                    if (this.mInitializedMask != allInitializedMask) {
                        return;
                    }
                    anyVibrating = this.mVibratingMask != 0;
                }
                this.mDelegate.onVibratorStateChanged(anyVibrating);
            });
        }
    }

    @VisibleForTesting
    public static class AllVibratorsInfo
    extends VibratorInfo {
        private final VibratorInfo[] mVibratorInfos;

        public AllVibratorsInfo(VibratorInfo[] vibrators) {
            super(-1, AllVibratorsInfo.capabilitiesIntersection(vibrators), vibrators.length > 0 ? vibrators[0] : VibratorInfo.EMPTY_VIBRATOR_INFO);
            this.mVibratorInfos = vibrators;
        }

        @Override
        public int isEffectSupported(int effectId) {
            if (this.mVibratorInfos.length == 0) {
                return 2;
            }
            int supported = 1;
            for (VibratorInfo info : this.mVibratorInfos) {
                int effectSupported = info.isEffectSupported(effectId);
                if (effectSupported == 2) {
                    return effectSupported;
                }
                if (effectSupported != 0) continue;
                supported = effectSupported;
            }
            return supported;
        }

        @Override
        public boolean isPrimitiveSupported(int primitiveId) {
            if (this.mVibratorInfos.length == 0) {
                return false;
            }
            for (VibratorInfo info : this.mVibratorInfos) {
                if (info.isPrimitiveSupported(primitiveId)) continue;
                return false;
            }
            return true;
        }

        @Override
        public int getPrimitiveDuration(int primitiveId) {
            int maxDuration = 0;
            for (VibratorInfo info : this.mVibratorInfos) {
                int duration = info.getPrimitiveDuration(primitiveId);
                if (duration == 0) {
                    return 0;
                }
                maxDuration = Math.max(maxDuration, duration);
            }
            return maxDuration;
        }

        private static int capabilitiesIntersection(VibratorInfo[] infos) {
            if (infos.length == 0) {
                return 0;
            }
            int intersection = -1;
            for (VibratorInfo info : infos) {
                intersection = (int)((long)intersection & info.getCapabilities());
            }
            return intersection;
        }
    }

    private static class SingleVibratorStateListener
    implements Vibrator.OnVibratorStateChangedListener {
        private final AllVibratorsStateListener mAllVibratorsListener;
        private final int mVibratorIdx;

        SingleVibratorStateListener(AllVibratorsStateListener listener, int vibratorIdx) {
            this.mAllVibratorsListener = listener;
            this.mVibratorIdx = vibratorIdx;
        }

        @Override
        public void onVibratorStateChanged(boolean isVibrating) {
            this.mAllVibratorsListener.onVibrating(this.mVibratorIdx, isVibrating);
        }
    }
}

