/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

public class TimestampedValue<T>
implements Parcelable {
    private final long mReferenceTimeMillis;
    private final T mValue;
    public static final Parcelable.Creator<TimestampedValue<?>> CREATOR = new Parcelable.ClassLoaderCreator<TimestampedValue<?>>(){

        @Override
        public TimestampedValue<?> createFromParcel(Parcel source) {
            return this.createFromParcel(source, null);
        }

        @Override
        public TimestampedValue<?> createFromParcel(Parcel source, ClassLoader classLoader) {
            long referenceTimeMillis = source.readLong();
            Object value = source.readValue(classLoader);
            return new TimestampedValue<Object>(referenceTimeMillis, value);
        }

        public TimestampedValue[] newArray(int size) {
            return new TimestampedValue[size];
        }
    };

    public TimestampedValue(long referenceTimeMillis, T value) {
        this.mReferenceTimeMillis = referenceTimeMillis;
        this.mValue = value;
    }

    public long getReferenceTimeMillis() {
        return this.mReferenceTimeMillis;
    }

    public T getValue() {
        return this.mValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimestampedValue that = (TimestampedValue)o;
        return this.mReferenceTimeMillis == that.mReferenceTimeMillis && Objects.equals(this.mValue, that.mValue);
    }

    public int hashCode() {
        return Objects.hash(this.mReferenceTimeMillis, this.mValue);
    }

    public String toString() {
        return "TimestampedValue{mReferenceTimeMillis=" + this.mReferenceTimeMillis + ", mValue=" + this.mValue + '}';
    }

    public static long referenceTimeDifference(TimestampedValue<?> one, TimestampedValue<?> two) {
        return one.mReferenceTimeMillis - two.mReferenceTimeMillis;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.mReferenceTimeMillis);
        dest.writeValue(this.mValue);
    }
}

