/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.VibrationEffect;
import android.util.Log;
import android.util.MathUtils;
import android.util.Range;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;

public class VibratorInfo
implements Parcelable {
    private static final String TAG = "VibratorInfo";
    public static final VibratorInfo EMPTY_VIBRATOR_INFO = new Builder(-1).build();
    private final int mId;
    private final long mCapabilities;
    private final SparseBooleanArray mSupportedEffects;
    private final SparseBooleanArray mSupportedBraking;
    private final SparseIntArray mSupportedPrimitives;
    private final int mPrimitiveDelayMax;
    private final int mCompositionSizeMax;
    private final int mPwlePrimitiveDurationMax;
    private final int mPwleSizeMax;
    private final float mQFactor;
    private final FrequencyMapping mFrequencyMapping;
    public static final Parcelable.Creator<VibratorInfo> CREATOR = new Parcelable.Creator<VibratorInfo>(){

        @Override
        public VibratorInfo createFromParcel(Parcel in) {
            return new VibratorInfo(in);
        }

        public VibratorInfo[] newArray(int size) {
            return new VibratorInfo[size];
        }
    };

    VibratorInfo(Parcel in) {
        this.mId = in.readInt();
        this.mCapabilities = in.readLong();
        this.mSupportedEffects = in.readSparseBooleanArray();
        this.mSupportedBraking = in.readSparseBooleanArray();
        this.mSupportedPrimitives = in.readSparseIntArray();
        this.mPrimitiveDelayMax = in.readInt();
        this.mCompositionSizeMax = in.readInt();
        this.mPwlePrimitiveDurationMax = in.readInt();
        this.mPwleSizeMax = in.readInt();
        this.mQFactor = in.readFloat();
        this.mFrequencyMapping = (FrequencyMapping)in.readParcelable(VibratorInfo.class.getClassLoader());
    }

    public VibratorInfo(int id2, long capabilities, SparseBooleanArray supportedEffects, SparseBooleanArray supportedBraking, SparseIntArray supportedPrimitives, int primitiveDelayMax, int compositionSizeMax, int pwlePrimitiveDurationMax, int pwleSizeMax, float qFactor, FrequencyMapping frequencyMapping) {
        this.mId = id2;
        this.mCapabilities = capabilities;
        this.mSupportedEffects = supportedEffects == null ? null : supportedEffects.clone();
        this.mSupportedBraking = supportedBraking == null ? null : supportedBraking.clone();
        this.mSupportedPrimitives = supportedPrimitives.clone();
        this.mPrimitiveDelayMax = primitiveDelayMax;
        this.mCompositionSizeMax = compositionSizeMax;
        this.mPwlePrimitiveDurationMax = pwlePrimitiveDurationMax;
        this.mPwleSizeMax = pwleSizeMax;
        this.mQFactor = qFactor;
        this.mFrequencyMapping = frequencyMapping;
    }

    protected VibratorInfo(int id2, int capabilities, VibratorInfo baseVibrator) {
        this(id2, capabilities, baseVibrator.mSupportedEffects, baseVibrator.mSupportedBraking, baseVibrator.mSupportedPrimitives, baseVibrator.mPrimitiveDelayMax, baseVibrator.mCompositionSizeMax, baseVibrator.mPwlePrimitiveDurationMax, baseVibrator.mPwleSizeMax, baseVibrator.mQFactor, baseVibrator.mFrequencyMapping);
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mId);
        dest.writeLong(this.mCapabilities);
        dest.writeSparseBooleanArray(this.mSupportedEffects);
        dest.writeSparseBooleanArray(this.mSupportedBraking);
        dest.writeSparseIntArray(this.mSupportedPrimitives);
        dest.writeInt(this.mPrimitiveDelayMax);
        dest.writeInt(this.mCompositionSizeMax);
        dest.writeInt(this.mPwlePrimitiveDurationMax);
        dest.writeInt(this.mPwleSizeMax);
        dest.writeFloat(this.mQFactor);
        dest.writeParcelable(this.mFrequencyMapping, flags);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VibratorInfo)) {
            return false;
        }
        VibratorInfo that = (VibratorInfo)o;
        int supportedPrimitivesCount = this.mSupportedPrimitives.size();
        if (supportedPrimitivesCount != that.mSupportedPrimitives.size()) {
            return false;
        }
        for (int i = 0; i < supportedPrimitivesCount; ++i) {
            if (this.mSupportedPrimitives.keyAt(i) != that.mSupportedPrimitives.keyAt(i)) {
                return false;
            }
            if (this.mSupportedPrimitives.valueAt(i) == that.mSupportedPrimitives.valueAt(i)) continue;
            return false;
        }
        return this.mId == that.mId && this.mCapabilities == that.mCapabilities && this.mPrimitiveDelayMax == that.mPrimitiveDelayMax && this.mCompositionSizeMax == that.mCompositionSizeMax && this.mPwlePrimitiveDurationMax == that.mPwlePrimitiveDurationMax && this.mPwleSizeMax == that.mPwleSizeMax && Objects.equals(this.mSupportedEffects, that.mSupportedEffects) && Objects.equals(this.mSupportedBraking, that.mSupportedBraking) && Objects.equals(Float.valueOf(this.mQFactor), Float.valueOf(that.mQFactor)) && Objects.equals(this.mFrequencyMapping, that.mFrequencyMapping);
    }

    public int hashCode() {
        int hashCode = Objects.hash(this.mId, this.mCapabilities, this.mSupportedEffects, this.mSupportedBraking, Float.valueOf(this.mQFactor), this.mFrequencyMapping);
        for (int i = 0; i < this.mSupportedPrimitives.size(); ++i) {
            hashCode = 31 * hashCode + this.mSupportedPrimitives.keyAt(i);
            hashCode = 31 * hashCode + this.mSupportedPrimitives.valueAt(i);
        }
        return hashCode;
    }

    public String toString() {
        return "VibratorInfo{mId=" + this.mId + ", mCapabilities=" + Arrays.toString(this.getCapabilitiesNames()) + ", mCapabilities flags=" + Long.toBinaryString(this.mCapabilities) + ", mSupportedEffects=" + Arrays.toString(this.getSupportedEffectsNames()) + ", mSupportedBraking=" + Arrays.toString(this.getSupportedBrakingNames()) + ", mSupportedPrimitives=" + Arrays.toString(this.getSupportedPrimitivesNames()) + ", mPrimitiveDelayMax=" + this.mPrimitiveDelayMax + ", mCompositionSizeMax=" + this.mCompositionSizeMax + ", mPwlePrimitiveDurationMax=" + this.mPwlePrimitiveDurationMax + ", mPwleSizeMax=" + this.mPwleSizeMax + ", mQFactor=" + this.mQFactor + ", mFrequencyMapping=" + this.mFrequencyMapping + '}';
    }

    public int getId() {
        return this.mId;
    }

    public boolean hasAmplitudeControl() {
        return this.hasCapability(4L);
    }

    public int getDefaultBraking() {
        if (this.mSupportedBraking != null) {
            int size = this.mSupportedBraking.size();
            for (int i = 0; i < size; ++i) {
                if (this.mSupportedBraking.keyAt(i) == 0) continue;
                return this.mSupportedBraking.keyAt(i);
            }
        }
        return 0;
    }

    public int isEffectSupported(int effectId) {
        if (this.mSupportedEffects == null) {
            return 0;
        }
        return this.mSupportedEffects.get(effectId) ? 1 : 2;
    }

    public boolean isPrimitiveSupported(int primitiveId) {
        return this.hasCapability(32L) && this.mSupportedPrimitives.indexOfKey(primitiveId) >= 0;
    }

    public int getPrimitiveDuration(int primitiveId) {
        return this.mSupportedPrimitives.get(primitiveId);
    }

    public int getPrimitiveDelayMax() {
        return this.mPrimitiveDelayMax;
    }

    public int getCompositionSizeMax() {
        return this.mCompositionSizeMax;
    }

    public int getPwlePrimitiveDurationMax() {
        return this.mPwlePrimitiveDurationMax;
    }

    public int getPwleSizeMax() {
        return this.mPwleSizeMax;
    }

    public boolean hasCapability(long capability) {
        return (this.mCapabilities & capability) == capability;
    }

    public float getResonantFrequency() {
        return this.mFrequencyMapping.mResonantFrequencyHz;
    }

    public float getQFactor() {
        return this.mQFactor;
    }

    public Range<Float> getFrequencyRange() {
        return this.mFrequencyMapping.mRelativeFrequencyRange;
    }

    public float getMaxAmplitude(float relativeFrequency) {
        if (this.mFrequencyMapping.isEmpty()) {
            return Float.compare(relativeFrequency, 0.0f) == 0 ? 1.0f : 0.0f;
        }
        return this.mFrequencyMapping.getMaxAmplitude(relativeFrequency);
    }

    public float getAbsoluteFrequency(float relativeFrequency) {
        return this.mFrequencyMapping.toHertz(relativeFrequency);
    }

    protected long getCapabilities() {
        return this.mCapabilities;
    }

    private String[] getCapabilitiesNames() {
        ArrayList<String> names = new ArrayList<String>();
        if (this.hasCapability(1L)) {
            names.add("ON_CALLBACK");
        }
        if (this.hasCapability(2L)) {
            names.add("PERFORM_CALLBACK");
        }
        if (this.hasCapability(32L)) {
            names.add("COMPOSE_EFFECTS");
        }
        if (this.hasCapability(1024L)) {
            names.add("COMPOSE_PWLE_EFFECTS");
        }
        if (this.hasCapability(64L)) {
            names.add("ALWAYS_ON_CONTROL");
        }
        if (this.hasCapability(4L)) {
            names.add("AMPLITUDE_CONTROL");
        }
        if (this.hasCapability(512L)) {
            names.add("FREQUENCY_CONTROL");
        }
        if (this.hasCapability(8L)) {
            names.add("EXTERNAL_CONTROL");
        }
        if (this.hasCapability(16L)) {
            names.add("EXTERNAL_AMPLITUDE_CONTROL");
        }
        return names.toArray(new String[names.size()]);
    }

    private String[] getSupportedEffectsNames() {
        if (this.mSupportedEffects == null) {
            return new String[0];
        }
        String[] names = new String[this.mSupportedEffects.size()];
        for (int i = 0; i < this.mSupportedEffects.size(); ++i) {
            names[i] = VibrationEffect.effectIdToString(this.mSupportedEffects.keyAt(i));
        }
        return names;
    }

    private String[] getSupportedBrakingNames() {
        if (this.mSupportedBraking == null) {
            return new String[0];
        }
        String[] names = new String[this.mSupportedBraking.size()];
        block4: for (int i = 0; i < this.mSupportedBraking.size(); ++i) {
            switch (this.mSupportedBraking.keyAt(i)) {
                case 0: {
                    names[i] = "NONE";
                    continue block4;
                }
                case 1: {
                    names[i] = "CLAB";
                    continue block4;
                }
                default: {
                    names[i] = Integer.toString(this.mSupportedBraking.keyAt(i));
                }
            }
        }
        return names;
    }

    private String[] getSupportedPrimitivesNames() {
        int supportedPrimitivesCount = this.mSupportedPrimitives.size();
        String[] names = new String[supportedPrimitivesCount];
        for (int i = 0; i < supportedPrimitivesCount; ++i) {
            names[i] = VibrationEffect.Composition.primitiveToString(this.mSupportedPrimitives.keyAt(i));
        }
        return names;
    }

    public static class Builder {
        private final int mId;
        private long mCapabilities;
        private SparseBooleanArray mSupportedEffects;
        private SparseBooleanArray mSupportedBraking;
        private SparseIntArray mSupportedPrimitives = new SparseIntArray();
        private int mPrimitiveDelayMax;
        private int mCompositionSizeMax;
        private int mPwlePrimitiveDurationMax;
        private int mPwleSizeMax;
        private float mQFactor = Float.NaN;
        private FrequencyMapping mFrequencyMapping = new FrequencyMapping(Float.NaN, Float.NaN, Float.NaN, Float.NaN, null);

        public Builder(int id2) {
            this.mId = id2;
        }

        public Builder setCapabilities(long capabilities) {
            this.mCapabilities = capabilities;
            return this;
        }

        public Builder setSupportedEffects(int ... supportedEffects) {
            this.mSupportedEffects = Builder.toSparseBooleanArray(supportedEffects);
            return this;
        }

        public Builder setSupportedBraking(int ... supportedBraking) {
            this.mSupportedBraking = Builder.toSparseBooleanArray(supportedBraking);
            return this;
        }

        public Builder setPwlePrimitiveDurationMax(int pwlePrimitiveDurationMax) {
            this.mPwlePrimitiveDurationMax = pwlePrimitiveDurationMax;
            return this;
        }

        public Builder setPwleSizeMax(int pwleSizeMax) {
            this.mPwleSizeMax = pwleSizeMax;
            return this;
        }

        public Builder setSupportedPrimitive(int primitiveId, int duration) {
            this.mSupportedPrimitives.put(primitiveId, duration);
            return this;
        }

        public Builder setPrimitiveDelayMax(int primitiveDelayMax) {
            this.mPrimitiveDelayMax = primitiveDelayMax;
            return this;
        }

        public Builder setCompositionSizeMax(int compositionSizeMax) {
            this.mCompositionSizeMax = compositionSizeMax;
            return this;
        }

        public Builder setQFactor(float qFactor) {
            this.mQFactor = qFactor;
            return this;
        }

        public Builder setFrequencyMapping(FrequencyMapping frequencyMapping) {
            this.mFrequencyMapping = frequencyMapping;
            return this;
        }

        public VibratorInfo build() {
            return new VibratorInfo(this.mId, this.mCapabilities, this.mSupportedEffects, this.mSupportedBraking, this.mSupportedPrimitives, this.mPrimitiveDelayMax, this.mCompositionSizeMax, this.mPwlePrimitiveDurationMax, this.mPwleSizeMax, this.mQFactor, this.mFrequencyMapping);
        }

        private static SparseBooleanArray toSparseBooleanArray(int[] supportedKeys) {
            if (supportedKeys == null) {
                return null;
            }
            SparseBooleanArray array2 = new SparseBooleanArray();
            for (int key : supportedKeys) {
                array2.put(key, true);
            }
            return array2;
        }
    }

    public static class FrequencyMapping
    implements Parcelable {
        private final float mMinFrequencyHz;
        private final float mResonantFrequencyHz;
        private final float mFrequencyResolutionHz;
        private final float mSuggestedSafeRangeHz;
        private final float[] mMaxAmplitudes;
        private final Range<Float> mRelativeFrequencyRange;
        public static final Parcelable.Creator<FrequencyMapping> CREATOR = new Parcelable.Creator<FrequencyMapping>(){

            @Override
            public FrequencyMapping createFromParcel(Parcel in) {
                return new FrequencyMapping(in);
            }

            public FrequencyMapping[] newArray(int size) {
                return new FrequencyMapping[size];
            }
        };

        FrequencyMapping(Parcel in) {
            this(in.readFloat(), in.readFloat(), in.readFloat(), in.readFloat(), in.createFloatArray());
        }

        public FrequencyMapping(float minFrequencyHz, float resonantFrequencyHz, float frequencyResolutionHz, float suggestedSafeRangeHz, float[] maxAmplitudes) {
            this.mMinFrequencyHz = minFrequencyHz;
            this.mResonantFrequencyHz = resonantFrequencyHz;
            this.mFrequencyResolutionHz = frequencyResolutionHz;
            this.mSuggestedSafeRangeHz = suggestedSafeRangeHz;
            this.mMaxAmplitudes = new float[maxAmplitudes == null ? 0 : maxAmplitudes.length];
            if (maxAmplitudes != null) {
                System.arraycopy(maxAmplitudes, 0, this.mMaxAmplitudes, 0, maxAmplitudes.length);
            }
            float maxFrequencyHz = minFrequencyHz + frequencyResolutionHz * (float)(this.mMaxAmplitudes.length - 1);
            if (Float.isNaN(resonantFrequencyHz) || Float.isNaN(minFrequencyHz) || Float.isNaN(frequencyResolutionHz) || Float.isNaN(suggestedSafeRangeHz) || resonantFrequencyHz < minFrequencyHz || resonantFrequencyHz > maxFrequencyHz) {
                this.mRelativeFrequencyRange = Range.create(Float.valueOf(0.0f), Float.valueOf(0.0f));
                return;
            }
            float safeDelta = MathUtils.min(suggestedSafeRangeHz / 2.0f, resonantFrequencyHz - minFrequencyHz, maxFrequencyHz - resonantFrequencyHz);
            this.mRelativeFrequencyRange = Range.create(Float.valueOf((minFrequencyHz - resonantFrequencyHz) / safeDelta), Float.valueOf((maxFrequencyHz - resonantFrequencyHz) / safeDelta));
        }

        public boolean isEmpty() {
            return Float.compare(this.mRelativeFrequencyRange.getLower().floatValue(), this.mRelativeFrequencyRange.getUpper().floatValue()) == 0;
        }

        public float toHertz(float relativeFrequency) {
            if (!this.mRelativeFrequencyRange.contains(Float.valueOf(relativeFrequency))) {
                return Float.NaN;
            }
            float relativeMinFrequency = this.mRelativeFrequencyRange.getLower().floatValue();
            if (Float.compare(relativeMinFrequency, 0.0f) == 0) {
                return this.mResonantFrequencyHz;
            }
            float shift = (this.mMinFrequencyHz - this.mResonantFrequencyHz) / relativeMinFrequency;
            return this.mResonantFrequencyHz + relativeFrequency * shift;
        }

        public float getMaxAmplitude(float relativeFrequency) {
            float frequencyHz = this.toHertz(relativeFrequency);
            if (Float.isNaN(frequencyHz)) {
                return 0.0f;
            }
            float position = (frequencyHz - this.mMinFrequencyHz) / this.mFrequencyResolutionHz;
            int floorIndex = (int)Math.floor(position);
            int ceilIndex = (int)Math.ceil(position);
            if (floorIndex < 0 || floorIndex >= this.mMaxAmplitudes.length) {
                if (this.mMaxAmplitudes.length > 0) {
                    Log.w(VibratorInfo.TAG, "Max amplitudes has " + this.mMaxAmplitudes.length + " entries and was expected to cover the frequency " + frequencyHz + " Hz when starting at min frequency of " + this.mMinFrequencyHz + " Hz with resolution of " + this.mFrequencyResolutionHz + " Hz.");
                }
                return 0.0f;
            }
            if (floorIndex != ceilIndex && ceilIndex < this.mMaxAmplitudes.length) {
                return MathUtils.min(this.mMaxAmplitudes[floorIndex], this.mMaxAmplitudes[ceilIndex]);
            }
            return this.mMaxAmplitudes[floorIndex];
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeFloat(this.mMinFrequencyHz);
            dest.writeFloat(this.mResonantFrequencyHz);
            dest.writeFloat(this.mFrequencyResolutionHz);
            dest.writeFloat(this.mSuggestedSafeRangeHz);
            dest.writeFloatArray(this.mMaxAmplitudes);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FrequencyMapping)) {
                return false;
            }
            FrequencyMapping that = (FrequencyMapping)o;
            return Float.compare(this.mMinFrequencyHz, that.mMinFrequencyHz) == 0 && Float.compare(this.mResonantFrequencyHz, that.mResonantFrequencyHz) == 0 && Float.compare(this.mFrequencyResolutionHz, that.mFrequencyResolutionHz) == 0 && Float.compare(this.mSuggestedSafeRangeHz, that.mSuggestedSafeRangeHz) == 0 && Arrays.equals(this.mMaxAmplitudes, that.mMaxAmplitudes);
        }

        public int hashCode() {
            int hashCode = Objects.hash(Float.valueOf(this.mMinFrequencyHz), Float.valueOf(this.mFrequencyResolutionHz), Float.valueOf(this.mFrequencyResolutionHz), Float.valueOf(this.mSuggestedSafeRangeHz));
            hashCode = 31 * hashCode + Arrays.hashCode(this.mMaxAmplitudes);
            return hashCode;
        }

        public String toString() {
            return "FrequencyMapping{mRelativeFrequencyRange=" + this.mRelativeFrequencyRange + ", mMinFrequency=" + this.mMinFrequencyHz + ", mResonantFrequency=" + this.mResonantFrequencyHz + ", mMaxFrequency=" + (this.mMinFrequencyHz + this.mFrequencyResolutionHz * (float)(this.mMaxAmplitudes.length - 1)) + ", mFrequencyResolution=" + this.mFrequencyResolutionHz + ", mSuggestedSafeRange=" + this.mSuggestedSafeRangeHz + ", mMaxAmplitudes count=" + this.mMaxAmplitudes.length + '}';
        }
    }
}

