/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.RequiresPermission;
import android.app.ActivityThread;
import android.content.Context;
import android.os.CombinedVibration;
import android.os.Process;
import android.os.VibrationAttributes;
import android.os.Vibrator;
import android.util.Log;

public abstract class VibratorManager {
    private static final String TAG = "VibratorManager";
    private final String mPackageName;

    public VibratorManager() {
        this.mPackageName = ActivityThread.currentPackageName();
    }

    protected VibratorManager(Context context) {
        this.mPackageName = context.getOpPackageName();
    }

    public abstract int[] getVibratorIds();

    public abstract Vibrator getVibrator(int var1);

    public abstract Vibrator getDefaultVibrator();

    @RequiresPermission(value="android.permission.VIBRATE_ALWAYS_ON")
    public boolean setAlwaysOnEffect(int uid, String opPkg, int alwaysOnId, CombinedVibration effect, VibrationAttributes attributes) {
        Log.w(TAG, "Always-on effects aren't supported");
        return false;
    }

    @RequiresPermission(value="android.permission.VIBRATE")
    public void vibrate(CombinedVibration effect) {
        this.vibrate(effect, null);
    }

    @RequiresPermission(value="android.permission.VIBRATE")
    public void vibrate(CombinedVibration effect, VibrationAttributes attributes) {
        this.vibrate(Process.myUid(), this.mPackageName, effect, null, attributes);
    }

    @RequiresPermission(value="android.permission.VIBRATE")
    public abstract void vibrate(int var1, String var2, CombinedVibration var3, String var4, VibrationAttributes var5);

    @RequiresPermission(value="android.permission.VIBRATE")
    public abstract void cancel();

    @RequiresPermission(value="android.permission.VIBRATE")
    public abstract void cancel(int var1);
}

