/*
 * Decompiled with CFR 0.152.
 */
package android.os.ext;

import android.annotation.SystemApi;
import android.os.SystemProperties;
import android.os.ext.util.SdkLevel;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@SystemApi
public class SdkExtensions {
    private static final int VERSION_CODE_S = 31;
    private static final int R_EXTENSION_INT = SystemProperties.getInt("build.version.extensions.r", 0);
    private static final int S_EXTENSION_INT = SystemProperties.getInt("build.version.extensions.s", 0);
    private static final Map<Integer, Integer> ALL_EXTENSION_INTS;

    private SdkExtensions() {
    }

    public static int getExtensionVersion(int extension) {
        if (extension < 30) {
            throw new IllegalArgumentException("not a valid extension: " + extension);
        }
        if (extension == 30) {
            return R_EXTENSION_INT;
        }
        if (extension == 31) {
            return S_EXTENSION_INT;
        }
        return 0;
    }

    public static Map<Integer, Integer> getAllExtensionVersions() {
        return ALL_EXTENSION_INTS;
    }

    static {
        HashMap<Integer, Integer> extensions = new HashMap<Integer, Integer>();
        extensions.put(30, R_EXTENSION_INT);
        if (SdkLevel.isAtLeastS()) {
            extensions.put(31, S_EXTENSION_INT);
        }
        ALL_EXTENSION_INTS = Collections.unmodifiableMap(extensions);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Extension {
    }
}

