/*
 * Decompiled with CFR 0.152.
 */
package android.os.incremental;

import android.content.pm.DataLoaderParams;
import android.content.pm.IPackageLoadingProgressCallback;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.os.incremental.IIncrementalService;
import android.os.incremental.IStorageLoadingProgressListener;
import android.os.incremental.IncrementalMetrics;
import android.os.incremental.IncrementalStorage;
import android.util.Slog;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Objects;

public class IncrementalManager {
    private static final String TAG = "IncrementalManager";
    private static final String ALLOWED_PROPERTY = "incremental.allowed";
    public static final int MIN_VERSION_TO_SUPPORT_FSVERITY = 2;
    public static final int CREATE_MODE_TEMPORARY_BIND = 1;
    public static final int CREATE_MODE_PERMANENT_BIND = 2;
    public static final int CREATE_MODE_CREATE = 4;
    public static final int CREATE_MODE_OPEN_EXISTING = 8;
    private final IIncrementalService mService;
    private final LoadingProgressCallbacks mLoadingProgressCallbacks = new LoadingProgressCallbacks();

    public IncrementalManager(IIncrementalService service) {
        this.mService = service;
    }

    public IncrementalStorage createStorage(String path, DataLoaderParams params, int createMode) {
        Objects.requireNonNull(path);
        Objects.requireNonNull(params);
        try {
            int id2 = this.mService.createStorage(path, params.getData(), createMode);
            if (id2 < 0) {
                return null;
            }
            return new IncrementalStorage(this.mService, id2);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public IncrementalStorage openStorage(String path) {
        try {
            int id2 = this.mService.openStorage(path);
            if (id2 < 0) {
                return null;
            }
            IncrementalStorage storage = new IncrementalStorage(this.mService, id2);
            return storage;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public IncrementalStorage createStorage(String path, IncrementalStorage linkedStorage, int createMode) {
        try {
            int id2 = this.mService.createLinkedStorage(path, linkedStorage.getId(), createMode);
            if (id2 < 0) {
                return null;
            }
            return new IncrementalStorage(this.mService, id2);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void linkCodePath(File beforeCodeFile, File afterCodeFile) throws IllegalArgumentException, IOException {
        File beforeCodeAbsolute = beforeCodeFile.getAbsoluteFile();
        IncrementalStorage apkStorage = this.openStorage(beforeCodeAbsolute.toString());
        if (apkStorage == null) {
            throw new IllegalArgumentException("Not an Incremental path: " + beforeCodeAbsolute);
        }
        String targetStorageDir = afterCodeFile.getAbsoluteFile().getParent();
        IncrementalStorage linkedApkStorage = this.createStorage(targetStorageDir, apkStorage, 6);
        if (linkedApkStorage == null) {
            throw new IOException("Failed to create linked storage at dir: " + targetStorageDir);
        }
        try {
            String afterCodePathName = afterCodeFile.getName();
            this.linkFiles(apkStorage, beforeCodeAbsolute, "", linkedApkStorage, afterCodePathName);
        }
        catch (Exception e) {
            linkedApkStorage.unBind(targetStorageDir);
            throw e;
        }
    }

    private void linkFiles(final IncrementalStorage sourceStorage, File sourceAbsolutePath, String sourceRelativePath, final IncrementalStorage targetStorage, String targetRelativePath) throws IOException {
        final Path sourceBase = sourceAbsolutePath.toPath().resolve(sourceRelativePath);
        final Path targetRelative = Paths.get(targetRelativePath, new String[0]);
        Files.walkFileTree(sourceAbsolutePath.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Path relativeDir = sourceBase.relativize(dir);
                targetStorage.makeDirectory(targetRelative.resolve(relativeDir).toString());
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Path relativeFile = sourceBase.relativize(file);
                sourceStorage.makeLink(file.toAbsolutePath().toString(), targetStorage, targetRelative.resolve(relativeFile).toString());
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static boolean isFeatureEnabled() {
        return IncrementalManager.nativeIsEnabled();
    }

    public static int getVersion() {
        return IncrementalManager.nativeIsEnabled() ? (IncrementalManager.nativeIsV2Available() ? 2 : 1) : 0;
    }

    public static boolean isAllowed() {
        return IncrementalManager.isFeatureEnabled() && SystemProperties.getBoolean(ALLOWED_PROPERTY, true);
    }

    public static boolean isIncrementalPath(String path) {
        return IncrementalManager.nativeIsIncrementalPath(path);
    }

    public static boolean isIncrementalFileFd(FileDescriptor fd) {
        return IncrementalManager.nativeIsIncrementalFd(fd.getInt$());
    }

    public static byte[] unsafeGetFileSignature(String path) {
        return IncrementalManager.nativeUnsafeGetFileSignature(path);
    }

    public void rmPackageDir(File codeFile) {
        try {
            String codePath = codeFile.getAbsolutePath();
            IncrementalStorage storage = this.openStorage(codePath);
            if (storage == null) {
                return;
            }
            this.mLoadingProgressCallbacks.cleanUpCallbacks(storage);
            storage.unBind(codePath);
        }
        catch (IOException e) {
            Slog.w(TAG, "Failed to remove code path", e);
        }
    }

    public boolean registerLoadingProgressCallback(String codePath, IPackageLoadingProgressCallback callback) {
        IncrementalStorage storage = this.openStorage(codePath);
        if (storage == null) {
            return false;
        }
        return this.mLoadingProgressCallbacks.registerCallback(storage, callback);
    }

    public void unregisterLoadingProgressCallbacks(String codePath) {
        IncrementalStorage storage = this.openStorage(codePath);
        if (storage == null) {
            return;
        }
        this.mLoadingProgressCallbacks.cleanUpCallbacks(storage);
    }

    public IncrementalMetrics getMetrics(String codePath) {
        IncrementalStorage storage = this.openStorage(codePath);
        if (storage == null) {
            return null;
        }
        return new IncrementalMetrics(storage.getMetrics());
    }

    private static boolean nativeIsEnabled() {
        return OverrideMethod.invokeI("android.os.incremental.IncrementalManager#nativeIsEnabled()Z", true, null) != 0;
    }

    private static boolean nativeIsV2Available() {
        return OverrideMethod.invokeI("android.os.incremental.IncrementalManager#nativeIsV2Available()Z", true, null) != 0;
    }

    private static boolean nativeIsIncrementalPath(String string2) {
        return OverrideMethod.invokeI("android.os.incremental.IncrementalManager#nativeIsIncrementalPath(Ljava/lang/String;)Z", true, null) != 0;
    }

    private static boolean nativeIsIncrementalFd(int n) {
        return OverrideMethod.invokeI("android.os.incremental.IncrementalManager#nativeIsIncrementalFd(I)Z", true, null) != 0;
    }

    private static byte[] nativeUnsafeGetFileSignature(String string2) {
        return (byte[])OverrideMethod.invokeA("android.os.incremental.IncrementalManager#nativeUnsafeGetFileSignature(Ljava/lang/String;)[B", true, null);
    }

    private static class LoadingProgressCallbacks
    extends IStorageLoadingProgressListener.Stub {
        @GuardedBy(value={"mCallbacks"})
        private final SparseArray<RemoteCallbackList<IPackageLoadingProgressCallback>> mCallbacks = new SparseArray();

        private LoadingProgressCallbacks() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cleanUpCallbacks(IncrementalStorage storage) {
            RemoteCallbackList<IPackageLoadingProgressCallback> callbacksForStorage;
            int storageId = storage.getId();
            SparseArray<RemoteCallbackList<IPackageLoadingProgressCallback>> sparseArray = this.mCallbacks;
            synchronized (sparseArray) {
                callbacksForStorage = this.mCallbacks.removeReturnOld(storageId);
            }
            if (callbacksForStorage == null) {
                return;
            }
            callbacksForStorage.kill();
            storage.unregisterLoadingProgressListener();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean registerCallback(IncrementalStorage storage, IPackageLoadingProgressCallback callback) {
            int storageId = storage.getId();
            SparseArray<RemoteCallbackList<IPackageLoadingProgressCallback>> sparseArray = this.mCallbacks;
            synchronized (sparseArray) {
                RemoteCallbackList<IPackageLoadingProgressCallback> callbacksForStorage = this.mCallbacks.get(storageId);
                if (callbacksForStorage == null) {
                    callbacksForStorage = new RemoteCallbackList();
                    this.mCallbacks.put(storageId, callbacksForStorage);
                }
                callbacksForStorage.register(callback);
                if (callbacksForStorage.getRegisteredCallbackCount() > 1) {
                    return true;
                }
            }
            return storage.registerLoadingProgressListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onStorageLoadingProgressChanged(int storageId, float progress) {
            RemoteCallbackList<IPackageLoadingProgressCallback> callbacksForStorage;
            SparseArray<RemoteCallbackList<IPackageLoadingProgressCallback>> sparseArray = this.mCallbacks;
            synchronized (sparseArray) {
                callbacksForStorage = this.mCallbacks.get(storageId);
            }
            if (callbacksForStorage == null) {
                return;
            }
            int n = callbacksForStorage.beginBroadcast();
            for (int i = 0; i < n; ++i) {
                IPackageLoadingProgressCallback callback = callbacksForStorage.getBroadcastItem(i);
                try {
                    callback.onPackageLoadingProgressChanged(progress);
                    continue;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            callbacksForStorage.finishBroadcast();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CreateMode {
    }
}

