/*
 * Decompiled with CFR 0.152.
 */
package android.os.vibrator;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.VibrationEffect;
import android.os.vibrator.VibrationEffectSegment;
import java.util.Objects;

public class PrebakedSegment
extends VibrationEffectSegment {
    private final int mEffectId;
    private final boolean mFallback;
    private final int mEffectStrength;
    public static final Parcelable.Creator<PrebakedSegment> CREATOR = new Parcelable.Creator<PrebakedSegment>(){

        @Override
        public PrebakedSegment createFromParcel(Parcel in) {
            in.readInt();
            return new PrebakedSegment(in);
        }

        public PrebakedSegment[] newArray(int size) {
            return new PrebakedSegment[size];
        }
    };

    PrebakedSegment(Parcel in) {
        this.mEffectId = in.readInt();
        this.mFallback = in.readByte() != 0;
        this.mEffectStrength = in.readInt();
    }

    public PrebakedSegment(int effectId, boolean shouldFallback, int effectStrength) {
        this.mEffectId = effectId;
        this.mFallback = shouldFallback;
        this.mEffectStrength = effectStrength;
    }

    public int getEffectId() {
        return this.mEffectId;
    }

    public int getEffectStrength() {
        return this.mEffectStrength;
    }

    public boolean shouldFallback() {
        return this.mFallback;
    }

    @Override
    public long getDuration() {
        return -1L;
    }

    @Override
    public boolean hasNonZeroAmplitude() {
        return true;
    }

    public PrebakedSegment resolve(int defaultAmplitude) {
        return this;
    }

    public PrebakedSegment scale(float scaleFactor) {
        return this;
    }

    public PrebakedSegment applyEffectStrength(int effectStrength) {
        if (effectStrength != this.mEffectStrength && PrebakedSegment.isValidEffectStrength(effectStrength)) {
            return new PrebakedSegment(this.mEffectId, this.mFallback, effectStrength);
        }
        return this;
    }

    private static boolean isValidEffectStrength(int strength) {
        switch (strength) {
            case 0: 
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void validate() {
        switch (this.mEffectId) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 21: {
                break;
            }
            default: {
                int[] ringtones = VibrationEffect.RINGTONES;
                if (this.mEffectId >= ringtones[0] && this.mEffectId <= ringtones[ringtones.length - 1]) break;
                throw new IllegalArgumentException("Unknown prebaked effect type (value=" + this.mEffectId + ")");
            }
        }
        if (!PrebakedSegment.isValidEffectStrength(this.mEffectStrength)) {
            throw new IllegalArgumentException("Unknown prebaked effect strength (value=" + this.mEffectStrength + ")");
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof PrebakedSegment)) {
            return false;
        }
        PrebakedSegment other = (PrebakedSegment)o;
        return this.mEffectId == other.mEffectId && this.mFallback == other.mFallback && this.mEffectStrength == other.mEffectStrength;
    }

    public int hashCode() {
        return Objects.hash(this.mEffectId, this.mFallback, this.mEffectStrength);
    }

    public String toString() {
        return "Prebaked{effect=" + VibrationEffect.effectIdToString(this.mEffectId) + ", strength=" + VibrationEffect.effectStrengthToString(this.mEffectStrength) + ", fallback=" + this.mFallback + "}";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(1);
        out.writeInt(this.mEffectId);
        out.writeByte((byte)(this.mFallback ? 1 : 0));
        out.writeInt(this.mEffectStrength);
    }
}

