/*
 * Decompiled with CFR 0.152.
 */
package android.permission;

import android.annotation.RequiresPermission;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.permission.ILegacyPermissionManager;
import com.android.internal.annotations.VisibleForTesting;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class LegacyPermissionManager {
    private final ILegacyPermissionManager mLegacyPermissionManager;

    public LegacyPermissionManager() throws ServiceManager.ServiceNotFoundException {
        this(ILegacyPermissionManager.Stub.asInterface(ServiceManager.getServiceOrThrow("legacy_permission")));
    }

    @VisibleForTesting
    public LegacyPermissionManager(ILegacyPermissionManager legacyPermissionManager) {
        this.mLegacyPermissionManager = legacyPermissionManager;
    }

    public int checkDeviceIdentifierAccess(String packageName, String message, String callingFeatureId, int pid, int uid) {
        try {
            return this.mLegacyPermissionManager.checkDeviceIdentifierAccess(packageName, message, callingFeatureId, pid, uid);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int checkPhoneNumberAccess(String packageName, String message, String callingFeatureId, int pid, int uid) {
        try {
            return this.mLegacyPermissionManager.checkPhoneNumberAccess(packageName, message, callingFeatureId, pid, uid);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.GRANT_RUNTIME_PERMISSIONS_TO_TELEPHONY_DEFAULTS")
    public void grantDefaultPermissionsToLuiApp(String packageName, UserHandle user, Executor executor, Consumer<Boolean> callback) {
        try {
            this.mLegacyPermissionManager.grantDefaultPermissionsToActiveLuiApp(packageName, user.getIdentifier());
            executor.execute(() -> callback.accept(true));
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.GRANT_RUNTIME_PERMISSIONS_TO_TELEPHONY_DEFAULTS")
    public void revokeDefaultPermissionsFromLuiApps(String[] packageNames, UserHandle user, Executor executor, Consumer<Boolean> callback) {
        try {
            this.mLegacyPermissionManager.revokeDefaultPermissionsFromLuiApps(packageNames, user.getIdentifier());
            executor.execute(() -> callback.accept(true));
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.GRANT_RUNTIME_PERMISSIONS_TO_TELEPHONY_DEFAULTS")
    public void grantDefaultPermissionsToEnabledImsServices(String[] packageNames, UserHandle user, Executor executor, Consumer<Boolean> callback) {
        try {
            this.mLegacyPermissionManager.grantDefaultPermissionsToEnabledImsServices(packageNames, user.getIdentifier());
            executor.execute(() -> callback.accept(true));
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.GRANT_RUNTIME_PERMISSIONS_TO_TELEPHONY_DEFAULTS")
    public void grantDefaultPermissionsToEnabledTelephonyDataServices(String[] packageNames, UserHandle user, Executor executor, Consumer<Boolean> callback) {
        try {
            this.mLegacyPermissionManager.grantDefaultPermissionsToEnabledTelephonyDataServices(packageNames, user.getIdentifier());
            executor.execute(() -> callback.accept(true));
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.GRANT_RUNTIME_PERMISSIONS_TO_TELEPHONY_DEFAULTS")
    public void revokeDefaultPermissionsFromDisabledTelephonyDataServices(String[] packageNames, UserHandle user, Executor executor, Consumer<Boolean> callback) {
        try {
            this.mLegacyPermissionManager.revokeDefaultPermissionsFromDisabledTelephonyDataServices(packageNames, user.getIdentifier());
            executor.execute(() -> callback.accept(true));
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.GRANT_RUNTIME_PERMISSIONS_TO_TELEPHONY_DEFAULTS")
    public void grantDefaultPermissionsToEnabledCarrierApps(String[] packageNames, UserHandle user, Executor executor, Consumer<Boolean> callback) {
        try {
            this.mLegacyPermissionManager.grantDefaultPermissionsToEnabledCarrierApps(packageNames, user.getIdentifier());
            executor.execute(() -> callback.accept(true));
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }
}

