/*
 * Decompiled with CFR 0.152.
 */
package android.permission;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.ActivityManager;
import android.app.ActivityThread;
import android.app.AppGlobals;
import android.app.IActivityManager;
import android.app.PropertyInvalidatedCache;
import android.content.AttributionSource;
import android.content.Context;
import android.content.pm.IPackageManager;
import android.content.pm.PackageManager;
import android.content.pm.ParceledListSlice;
import android.content.pm.PermissionGroupInfo;
import android.content.pm.PermissionInfo;
import android.content.pm.permission.SplitPermissionInfoParcelable;
import android.media.AudioManager;
import android.os.Binder;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.UserHandle;
import android.permission.IOnPermissionsChangeListener;
import android.permission.IPermissionManager;
import android.permission.LegacyPermissionManager;
import android.permission.PermGroupUsage;
import android.permission.PermissionUsageHelper;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Slog;
import com.android.internal.annotations.Immutable;
import com.android.internal.util.CollectionUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@SystemApi
public class PermissionManager {
    private static final String LOG_TAG = PermissionManager.class.getName();
    public static final String LOG_TAG_TRACE_GRANTS = "PermissionGrantTrace";
    public static final String KILL_APP_REASON_PERMISSIONS_REVOKED = "permissions revoked";
    public static final String KILL_APP_REASON_GIDS_CHANGED = "permission grant or revoke changed gids";
    private static final String SYSTEM_PKG = "android";
    public static final long CANNOT_INSTALL_WITH_BAD_PERMISSION_GROUPS = 146211400L;
    private static final long EXEMPTED_INDICATOR_ROLE_UPDATE_FREQUENCY_MS = 15000L;
    private static long sLastIndicatorUpdateTime = -1L;
    private static final int[] EXEMPTED_ROLES = new int[]{17039411, 17039410, 17039412, 17039413, 17039414, 17039415};
    private static final String[] INDICATOR_EXEMPTED_PACKAGES = new String[EXEMPTED_ROLES.length];
    public static final boolean DEBUG_TRACE_GRANTS = false;
    public static final boolean DEBUG_TRACE_PERMISSION_UPDATES = false;
    private final Context mContext;
    private final IPackageManager mPackageManager;
    private final IPermissionManager mPermissionManager;
    private final LegacyPermissionManager mLegacyPermissionManager;
    private final ArrayMap<PackageManager.OnPermissionsChangedListener, IOnPermissionsChangeListener> mPermissionListeners = new ArrayMap();
    private PermissionUsageHelper mUsageHelper;
    private List<SplitPermissionInfo> mSplitPermissionInfos;
    public static final String CACHE_KEY_PACKAGE_INFO = "cache_key.package_info";
    private static final PropertyInvalidatedCache<PermissionQuery, Integer> sPermissionCache = new PropertyInvalidatedCache<PermissionQuery, Integer>(2048, "cache_key.package_info", "checkPermission"){

        @Override
        protected Integer recompute(PermissionQuery query) {
            return PermissionManager.checkPermissionUncached(query.permission, query.pid, query.uid);
        }
    };
    private static PropertyInvalidatedCache<PackageNamePermissionQuery, Integer> sPackageNamePermissionCache = new PropertyInvalidatedCache<PackageNamePermissionQuery, Integer>(16, "cache_key.package_info", "checkPackageNamePermission"){

        @Override
        protected Integer recompute(PackageNamePermissionQuery query) {
            return PermissionManager.checkPackageNamePermissionUncached(query.permName, query.pkgName, query.userId);
        }
    };

    public PermissionManager(Context context) throws ServiceManager.ServiceNotFoundException {
        this.mContext = context;
        this.mPackageManager = AppGlobals.getPackageManager();
        this.mPermissionManager = IPermissionManager.Stub.asInterface(ServiceManager.getServiceOrThrow("permissionmgr"));
        this.mLegacyPermissionManager = context.getSystemService(LegacyPermissionManager.class);
        this.mUsageHelper = new PermissionUsageHelper(context);
    }

    public PermissionInfo getPermissionInfo(String permissionName, int flags) {
        try {
            String packageName = this.mContext.getOpPackageName();
            return this.mPermissionManager.getPermissionInfo(permissionName, packageName, flags);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public List<PermissionInfo> queryPermissionsByGroup(String groupName, int flags) {
        try {
            ParceledListSlice parceledList = this.mPermissionManager.queryPermissionsByGroup(groupName, flags);
            if (parceledList == null) {
                return null;
            }
            return parceledList.getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean addPermission(PermissionInfo permissionInfo, boolean async) {
        try {
            return this.mPermissionManager.addPermission(permissionInfo, async);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void removePermission(String permissionName) {
        try {
            this.mPermissionManager.removePermission(permissionName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public PermissionGroupInfo getPermissionGroupInfo(String groupName, int flags) {
        try {
            return this.mPermissionManager.getPermissionGroupInfo(groupName, flags);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public List<PermissionGroupInfo> getAllPermissionGroups(int flags) {
        try {
            ParceledListSlice parceledList = this.mPermissionManager.getAllPermissionGroups(flags);
            if (parceledList == null) {
                return Collections.emptyList();
            }
            return parceledList.getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isPermissionRevokedByPolicy(String packageName, String permissionName) {
        try {
            return this.mPermissionManager.isPermissionRevokedByPolicy(packageName, permissionName, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static boolean shouldTraceGrant(String packageName, String permissionName, int userId) {
        return false;
    }

    @RequiresPermission(value="android.permission.GRANT_RUNTIME_PERMISSIONS")
    public void grantRuntimePermission(String packageName, String permissionName, UserHandle user) {
        try {
            this.mPermissionManager.grantRuntimePermission(packageName, permissionName, user.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.REVOKE_RUNTIME_PERMISSIONS")
    public void revokeRuntimePermission(String packageName, String permName, UserHandle user, String reason) {
        try {
            this.mPermissionManager.revokeRuntimePermission(packageName, permName, user.getIdentifier(), reason);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(anyOf={"android.permission.GRANT_RUNTIME_PERMISSIONS", "android.permission.REVOKE_RUNTIME_PERMISSIONS", "android.permission.GET_RUNTIME_PERMISSIONS"})
    public int getPermissionFlags(String packageName, String permissionName, UserHandle user) {
        try {
            return this.mPermissionManager.getPermissionFlags(packageName, permissionName, user.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(anyOf={"android.permission.GRANT_RUNTIME_PERMISSIONS", "android.permission.REVOKE_RUNTIME_PERMISSIONS"})
    public void updatePermissionFlags(String packageName, String permissionName, int flagMask, int flagValues, UserHandle user) {
        try {
            boolean checkAdjustPolicyFlagPermission = this.mContext.getApplicationInfo().targetSdkVersion >= 29;
            this.mPermissionManager.updatePermissionFlags(packageName, permissionName, flagMask, flagValues, checkAdjustPolicyFlagPermission, user.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.WHITELIST_RESTRICTED_PERMISSIONS", conditional=true)
    public Set<String> getAllowlistedRestrictedPermissions(String packageName, int allowlistFlag) {
        try {
            List<String> allowlist = this.mPermissionManager.getAllowlistedRestrictedPermissions(packageName, allowlistFlag, this.mContext.getUserId());
            if (allowlist == null) {
                return Collections.emptySet();
            }
            return new ArraySet<String>(allowlist);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.WHITELIST_RESTRICTED_PERMISSIONS", conditional=true)
    public boolean addAllowlistedRestrictedPermission(String packageName, String permissionName, int allowlistFlags) {
        try {
            return this.mPermissionManager.addAllowlistedRestrictedPermission(packageName, permissionName, allowlistFlags, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.WHITELIST_RESTRICTED_PERMISSIONS", conditional=true)
    public boolean removeAllowlistedRestrictedPermission(String packageName, String permissionName, int allowlistFlags) {
        try {
            return this.mPermissionManager.removeAllowlistedRestrictedPermission(packageName, permissionName, allowlistFlags, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.WHITELIST_AUTO_REVOKE_PERMISSIONS", conditional=true)
    public boolean isAutoRevokeExempted(String packageName) {
        try {
            return this.mPermissionManager.isAutoRevokeExempted(packageName, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.WHITELIST_AUTO_REVOKE_PERMISSIONS", conditional=true)
    public boolean setAutoRevokeExempted(String packageName, boolean exempted) {
        try {
            return this.mPermissionManager.setAutoRevokeExempted(packageName, exempted, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean shouldShowRequestPermissionRationale(String permissionName) {
        try {
            String packageName = this.mContext.getPackageName();
            return this.mPermissionManager.shouldShowRequestPermissionRationale(packageName, permissionName, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.OBSERVE_GRANT_REVOKE_PERMISSIONS")
    public void addOnPermissionsChangeListener(PackageManager.OnPermissionsChangedListener listener) {
        ArrayMap<PackageManager.OnPermissionsChangedListener, IOnPermissionsChangeListener> arrayMap = this.mPermissionListeners;
        synchronized (arrayMap) {
            if (this.mPermissionListeners.get(listener) != null) {
                return;
            }
            OnPermissionsChangeListenerDelegate delegate = new OnPermissionsChangeListenerDelegate(listener, Looper.getMainLooper());
            try {
                this.mPermissionManager.addOnPermissionsChangeListener(delegate);
                this.mPermissionListeners.put(listener, delegate);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.OBSERVE_GRANT_REVOKE_PERMISSIONS")
    public void removeOnPermissionsChangeListener(PackageManager.OnPermissionsChangedListener listener) {
        ArrayMap<PackageManager.OnPermissionsChangedListener, IOnPermissionsChangeListener> arrayMap = this.mPermissionListeners;
        synchronized (arrayMap) {
            IOnPermissionsChangeListener delegate = this.mPermissionListeners.get(listener);
            if (delegate != null) {
                try {
                    this.mPermissionManager.removeOnPermissionsChangeListener(delegate);
                    this.mPermissionListeners.remove(listener);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.ADJUST_RUNTIME_PERMISSIONS_POLICY", "android.permission.UPGRADE_RUNTIME_PERMISSIONS"})
    public int getRuntimePermissionsVersion() {
        try {
            return this.mPackageManager.getRuntimePermissionsVersion(this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.ADJUST_RUNTIME_PERMISSIONS_POLICY", "android.permission.UPGRADE_RUNTIME_PERMISSIONS"})
    public void setRuntimePermissionsVersion(int version) {
        try {
            this.mPackageManager.setRuntimePermissionsVersion(version, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public List<SplitPermissionInfo> getSplitPermissions() {
        List<SplitPermissionInfoParcelable> parcelableList;
        if (this.mSplitPermissionInfos != null) {
            return this.mSplitPermissionInfos;
        }
        try {
            parcelableList = ActivityThread.getPermissionManager().getSplitPermissions();
        }
        catch (RemoteException e) {
            Slog.e(LOG_TAG, "Error getting split permissions", e);
            return Collections.emptyList();
        }
        this.mSplitPermissionInfos = this.splitPermissionInfoListToNonParcelableList(parcelableList);
        return this.mSplitPermissionInfos;
    }

    @RequiresPermission(value="android.permission.GET_APP_OPS_STATS")
    public List<PermGroupUsage> getIndicatorAppOpUsageData() {
        return this.mUsageHelper.getOpUsageData(new AudioManager().isMicrophoneMute());
    }

    @RequiresPermission(value="android.permission.GET_APP_OPS_STATS")
    public List<PermGroupUsage> getIndicatorAppOpUsageData(boolean micMuted) {
        if (this.mUsageHelper == null) {
            this.mUsageHelper = new PermissionUsageHelper(this.mContext);
        }
        return this.mUsageHelper.getOpUsageData(micMuted);
    }

    public static boolean shouldShowPackageForIndicatorCached(Context context, String packageName) {
        return !PermissionManager.getIndicatorExemptedPackages(context).contains(packageName);
    }

    public static Set<String> getIndicatorExemptedPackages(Context context) {
        PermissionManager.updateIndicatorExemptedPackages(context);
        ArraySet<String> pkgNames = new ArraySet<String>();
        pkgNames.add(SYSTEM_PKG);
        for (int i = 0; i < INDICATOR_EXEMPTED_PACKAGES.length; ++i) {
            String exemptedPackage = INDICATOR_EXEMPTED_PACKAGES[i];
            if (exemptedPackage == null) continue;
            pkgNames.add(exemptedPackage);
        }
        return pkgNames;
    }

    public static void updateIndicatorExemptedPackages(Context context) {
        long now = SystemClock.elapsedRealtime();
        if (sLastIndicatorUpdateTime == -1L || now - sLastIndicatorUpdateTime > 15000L) {
            sLastIndicatorUpdateTime = now;
            for (int i = 0; i < EXEMPTED_ROLES.length; ++i) {
                PermissionManager.INDICATOR_EXEMPTED_PACKAGES[i] = context.getString(EXEMPTED_ROLES[i]);
            }
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.ADJUST_RUNTIME_PERMISSIONS_POLICY")
    public Set<String> getAutoRevokeExemptionRequestedPackages() {
        try {
            return CollectionUtils.toSet(this.mPermissionManager.getAutoRevokeExemptionRequestedPackages(this.mContext.getUser().getIdentifier()));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.ADJUST_RUNTIME_PERMISSIONS_POLICY")
    public Set<String> getAutoRevokeExemptionGrantedPackages() {
        try {
            return CollectionUtils.toSet(this.mPermissionManager.getAutoRevokeExemptionGrantedPackages(this.mContext.getUser().getIdentifier()));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private List<SplitPermissionInfo> splitPermissionInfoListToNonParcelableList(List<SplitPermissionInfoParcelable> parcelableList) {
        int size = parcelableList.size();
        ArrayList<SplitPermissionInfo> list = new ArrayList<SplitPermissionInfo>(size);
        for (int i = 0; i < size; ++i) {
            list.add(new SplitPermissionInfo(parcelableList.get(i)));
        }
        return list;
    }

    public static List<SplitPermissionInfoParcelable> splitPermissionInfoListToParcelableList(List<SplitPermissionInfo> splitPermissionsList) {
        int size = splitPermissionsList.size();
        ArrayList<SplitPermissionInfoParcelable> outList = new ArrayList<SplitPermissionInfoParcelable>(size);
        for (int i = 0; i < size; ++i) {
            SplitPermissionInfo info = splitPermissionsList.get(i);
            outList.add(new SplitPermissionInfoParcelable(info.getSplitPermission(), info.getNewPermissions(), info.getTargetSdk()));
        }
        return outList;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_ONE_TIME_PERMISSION_SESSIONS")
    public void startOneTimePermissionSession(String packageName, long timeoutMillis, int importanceToResetTimer, int importanceToKeepSessionAlive) {
        try {
            this.mPermissionManager.startOneTimePermissionSession(packageName, this.mContext.getUserId(), timeoutMillis, importanceToResetTimer, importanceToKeepSessionAlive);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_ONE_TIME_PERMISSION_SESSIONS")
    public void stopOneTimePermissionSession(String packageName) {
        try {
            this.mPermissionManager.stopOneTimePermissionSession(packageName, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public int checkDeviceIdentifierAccess(String packageName, String message, String callingFeatureId, int pid, int uid) {
        return this.mLegacyPermissionManager.checkDeviceIdentifierAccess(packageName, message, callingFeatureId, pid, uid);
    }

    public AttributionSource registerAttributionSource(AttributionSource source) {
        AttributionSource registeredSource = source.withToken(new Binder());
        try {
            this.mPermissionManager.registerAttributionSource(registeredSource.asState());
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
        return registeredSource;
    }

    public boolean isRegisteredAttributionSource(AttributionSource source) {
        try {
            return this.mPermissionManager.isRegisteredAttributionSource(source.asState());
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return false;
        }
    }

    private static int checkPermissionUncached(String permission2, int pid, int uid) {
        IActivityManager am = ActivityManager.getService();
        if (am == null) {
            int appId = UserHandle.getAppId(uid);
            if (appId == 0 || appId == 1000) {
                Slog.w(LOG_TAG, "Missing ActivityManager; assuming " + uid + " holds " + permission2);
                return 0;
            }
            Slog.w(LOG_TAG, "Missing ActivityManager; assuming " + uid + " does not hold " + permission2);
            return -1;
        }
        try {
            return am.checkPermission(permission2, pid, uid);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static int checkPermission(String permission2, int pid, int uid) {
        return sPermissionCache.query(new PermissionQuery(permission2, pid, uid));
    }

    public static void disablePermissionCache() {
        sPermissionCache.disableLocal();
    }

    private static int checkPackageNamePermissionUncached(String permName, String pkgName, int userId) {
        try {
            return ActivityThread.getPackageManager().checkPermission(permName, pkgName, userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static int checkPackageNamePermission(String permName, String pkgName, int userId) {
        return sPackageNamePermissionCache.query(new PackageNamePermissionQuery(permName, pkgName, userId));
    }

    public static void disablePackageNamePermissionCache() {
        sPackageNamePermissionCache.disableLocal();
    }

    private class OnPermissionsChangeListenerDelegate
    extends IOnPermissionsChangeListener.Stub
    implements Handler.Callback {
        private static final int MSG_PERMISSIONS_CHANGED = 1;
        private final PackageManager.OnPermissionsChangedListener mListener;
        private final Handler mHandler;

        public OnPermissionsChangeListenerDelegate(PackageManager.OnPermissionsChangedListener listener, Looper looper) {
            this.mListener = listener;
            this.mHandler = new Handler(looper, this);
        }

        @Override
        public void onPermissionsChanged(int uid) {
            this.mHandler.obtainMessage(1, uid, 0).sendToTarget();
        }

        @Override
        public boolean handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    int uid = msg.arg1;
                    this.mListener.onPermissionsChanged(uid);
                    return true;
                }
            }
            return false;
        }
    }

    @Immutable
    private static class PackageNamePermissionQuery {
        final String permName;
        final String pkgName;
        final int userId;

        PackageNamePermissionQuery(String permName, String pkgName, int userId) {
            this.permName = permName;
            this.pkgName = pkgName;
            this.userId = userId;
        }

        public String toString() {
            return String.format("PackageNamePermissionQuery(pkgName=\"%s\", permName=\"%s, userId=%s\")", this.pkgName, this.permName, this.userId);
        }

        public int hashCode() {
            return Objects.hash(this.permName, this.pkgName, this.userId);
        }

        public boolean equals(Object rval) {
            PackageNamePermissionQuery other;
            if (rval == null) {
                return false;
            }
            try {
                other = (PackageNamePermissionQuery)rval;
            }
            catch (ClassCastException ex) {
                return false;
            }
            return Objects.equals(this.permName, other.permName) && Objects.equals(this.pkgName, other.pkgName) && this.userId == other.userId;
        }
    }

    @Immutable
    private static class PermissionQuery {
        final String permission;
        final int pid;
        final int uid;

        PermissionQuery(String permission2, int pid, int uid) {
            this.permission = permission2;
            this.pid = pid;
            this.uid = uid;
        }

        public String toString() {
            return String.format("PermissionQuery(permission=\"%s\", pid=%s, uid=%s)", this.permission, this.pid, this.uid);
        }

        public int hashCode() {
            int hash = Objects.hashCode(this.permission);
            hash = hash * 13 + Objects.hashCode(this.uid);
            return hash;
        }

        public boolean equals(Object rval) {
            PermissionQuery other;
            if (rval == null) {
                return false;
            }
            try {
                other = (PermissionQuery)rval;
            }
            catch (ClassCastException ex) {
                return false;
            }
            return this.uid == other.uid && Objects.equals(this.permission, other.permission);
        }
    }

    @Immutable
    public static class SplitPermissionInfo {
        private final SplitPermissionInfoParcelable mSplitPermissionInfoParcelable;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SplitPermissionInfo that = (SplitPermissionInfo)o;
            return this.mSplitPermissionInfoParcelable.equals(that.mSplitPermissionInfoParcelable);
        }

        public int hashCode() {
            return this.mSplitPermissionInfoParcelable.hashCode();
        }

        public String getSplitPermission() {
            return this.mSplitPermissionInfoParcelable.getSplitPermission();
        }

        public List<String> getNewPermissions() {
            return this.mSplitPermissionInfoParcelable.getNewPermissions();
        }

        public int getTargetSdk() {
            return this.mSplitPermissionInfoParcelable.getTargetSdk();
        }

        public SplitPermissionInfo(String splitPerm, List<String> newPerms, int targetSdk) {
            this(new SplitPermissionInfoParcelable(splitPerm, newPerms, targetSdk));
        }

        private SplitPermissionInfo(SplitPermissionInfoParcelable parcelable) {
            this.mSplitPermissionInfoParcelable = parcelable;
        }
    }
}

