/*
 * Decompiled with CFR 0.152.
 */
package android.security;

import android.hardware.security.keymint.KeyParameter;
import android.os.Binder;
import android.os.RemoteException;
import android.os.ServiceSpecificException;
import android.security.CheckedRemoteRequest;
import android.security.KeyStore2;
import android.security.KeyStoreException;
import android.system.keystore2.IKeystoreOperation;
import android.util.Log;

public class KeyStoreOperation {
    static final String TAG = "KeyStoreOperation";
    private final IKeystoreOperation mOperation;
    private final Long mChallenge;
    private final KeyParameter[] mParameters;

    public KeyStoreOperation(IKeystoreOperation operation, Long challenge, KeyParameter[] parameters) {
        Binder.allowBlocking(operation.asBinder());
        this.mOperation = operation;
        this.mChallenge = challenge;
        this.mParameters = parameters;
    }

    public Long getChallenge() {
        return this.mChallenge;
    }

    public KeyParameter[] getParameters() {
        return this.mParameters;
    }

    private <R> R handleExceptions(CheckedRemoteRequest<R> request) throws KeyStoreException {
        try {
            return request.execute();
        }
        catch (ServiceSpecificException e) {
            switch (e.errorCode) {
                case 19: {
                    throw new IllegalThreadStateException("Cannot update the same operation concurrently.");
                }
            }
            throw KeyStore2.getKeyStoreException(e.errorCode);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Remote exception while advancing a KeyStoreOperation.", e);
            throw new KeyStoreException(-28, "");
        }
    }

    public void updateAad(byte[] input) throws KeyStoreException {
        this.handleExceptions(() -> {
            this.mOperation.updateAad(input);
            return 0;
        });
    }

    public byte[] update(byte[] input) throws KeyStoreException {
        return this.handleExceptions(() -> this.mOperation.update(input));
    }

    public byte[] finish(byte[] input, byte[] signature) throws KeyStoreException {
        return this.handleExceptions(() -> this.mOperation.finish(input, signature));
    }

    public void abort() throws KeyStoreException {
        this.handleExceptions(() -> {
            this.mOperation.abort();
            return 0;
        });
    }
}

