/*
 * Decompiled with CFR 0.152.
 */
package android.security;

import android.app.compat.CompatChanges;
import android.hardware.security.keymint.KeyParameter;
import android.os.Binder;
import android.os.RemoteException;
import android.os.ServiceSpecificException;
import android.security.CheckedRemoteRequest;
import android.security.KeyStore2;
import android.security.KeyStoreException;
import android.security.KeyStoreOperation;
import android.security.keystore.BackendBusyException;
import android.security.keystore.KeyStoreConnectException;
import android.system.keystore2.AuthenticatorSpec;
import android.system.keystore2.CreateOperationResponse;
import android.system.keystore2.IKeystoreSecurityLevel;
import android.system.keystore2.KeyDescriptor;
import android.system.keystore2.KeyMetadata;
import android.util.Log;
import java.util.Calendar;
import java.util.Collection;

public class KeyStoreSecurityLevel {
    private static final String TAG = "KeyStoreSecurityLevel";
    private final IKeystoreSecurityLevel mSecurityLevel;

    public KeyStoreSecurityLevel(IKeystoreSecurityLevel securityLevel) {
        Binder.allowBlocking(securityLevel.asBinder());
        this.mSecurityLevel = securityLevel;
    }

    private <R> R handleExceptions(CheckedRemoteRequest<R> request) throws KeyStoreException {
        try {
            return request.execute();
        }
        catch (ServiceSpecificException e) {
            throw KeyStore2.getKeyStoreException(e.errorCode);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Could not connect to Keystore.", e);
            throw new KeyStoreException(4, "");
        }
    }

    public KeyStoreOperation createOperation(KeyDescriptor keyDescriptor, Collection<KeyParameter> args) throws KeyStoreException {
        block6: while (true) {
            try {
                CreateOperationResponse createOperationResponse = this.mSecurityLevel.createOperation(keyDescriptor, args.toArray(new KeyParameter[args.size()]), false);
                Long challenge = null;
                if (createOperationResponse.operationChallenge != null) {
                    challenge = createOperationResponse.operationChallenge.challenge;
                }
                KeyParameter[] parameters = null;
                if (createOperationResponse.parameters != null) {
                    parameters = createOperationResponse.parameters.keyParameter;
                }
                return new KeyStoreOperation(createOperationResponse.iOperation, challenge, parameters);
            }
            catch (ServiceSpecificException e) {
                switch (e.errorCode) {
                    case 18: {
                        long backOffHint = (long)(Math.random() * 80.0 + 20.0);
                        if (CompatChanges.isChangeEnabled(169897160L)) {
                            throw new BackendBusyException(backOffHint);
                        }
                        KeyStoreSecurityLevel.interruptedPreservingSleep(backOffHint);
                        continue block6;
                    }
                }
                throw KeyStore2.getKeyStoreException(e.errorCode);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Cannot connect to keystore", e);
                throw new KeyStoreConnectException();
            }
            break;
        }
    }

    public KeyMetadata generateKey(KeyDescriptor descriptor, KeyDescriptor attestationKey, Collection<KeyParameter> args, int flags, byte[] entropy) throws KeyStoreException {
        return this.handleExceptions(() -> this.mSecurityLevel.generateKey(descriptor, attestationKey, args.toArray(new KeyParameter[args.size()]), flags, entropy));
    }

    public KeyMetadata importKey(KeyDescriptor descriptor, KeyDescriptor attestationKey, Collection<KeyParameter> args, int flags, byte[] keyData) throws KeyStoreException {
        return this.handleExceptions(() -> this.mSecurityLevel.importKey(descriptor, attestationKey, args.toArray(new KeyParameter[args.size()]), flags, keyData));
    }

    public KeyMetadata importWrappedKey(KeyDescriptor wrappedKeyDescriptor, KeyDescriptor wrappingKeyDescriptor, byte[] wrappedKey, byte[] maskingKey, Collection<KeyParameter> args, AuthenticatorSpec[] authenticatorSpecs) throws KeyStoreException {
        KeyDescriptor keyDescriptor = new KeyDescriptor();
        keyDescriptor.alias = wrappedKeyDescriptor.alias;
        keyDescriptor.nspace = wrappedKeyDescriptor.nspace;
        keyDescriptor.blob = wrappedKey;
        keyDescriptor.domain = wrappedKeyDescriptor.domain;
        return this.handleExceptions(() -> this.mSecurityLevel.importWrappedKey(keyDescriptor, wrappingKeyDescriptor, maskingKey, args.toArray(new KeyParameter[args.size()]), authenticatorSpecs));
    }

    protected static void interruptedPreservingSleep(long millis) {
        boolean wasInterrupted = false;
        Calendar calendar = Calendar.getInstance();
        long target = calendar.getTimeInMillis() + millis;
        while (true) {
            try {
                Thread.sleep(target - calendar.getTimeInMillis());
            }
            catch (InterruptedException e) {
                wasInterrupted = true;
                continue;
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            break;
        }
        if (wasInterrupted) {
            Thread.currentThread().interrupt();
        }
    }
}

