/*
 * Decompiled with CFR 0.152.
 */
package android.security.identity;

import android.security.identity.AccessControlProfileId;
import java.security.cert.X509Certificate;

public class AccessControlProfile {
    private AccessControlProfileId mAccessControlProfileId = new AccessControlProfileId(0);
    private X509Certificate mReaderCertificate = null;
    private boolean mUserAuthenticationRequired = true;
    private long mUserAuthenticationTimeout = 0L;

    private AccessControlProfile() {
    }

    AccessControlProfileId getAccessControlProfileId() {
        return this.mAccessControlProfileId;
    }

    long getUserAuthenticationTimeout() {
        return this.mUserAuthenticationTimeout;
    }

    boolean isUserAuthenticationRequired() {
        return this.mUserAuthenticationRequired;
    }

    X509Certificate getReaderCertificate() {
        return this.mReaderCertificate;
    }

    public static class Builder {
        private AccessControlProfile mProfile = new AccessControlProfile();

        public Builder(AccessControlProfileId accessControlProfileId) {
            this.mProfile.mAccessControlProfileId = accessControlProfileId;
        }

        public Builder setUserAuthenticationRequired(boolean userAuthenticationRequired) {
            this.mProfile.mUserAuthenticationRequired = userAuthenticationRequired;
            return this;
        }

        public Builder setUserAuthenticationTimeout(long userAuthenticationTimeoutMillis) {
            this.mProfile.mUserAuthenticationTimeout = userAuthenticationTimeoutMillis;
            return this;
        }

        public Builder setReaderCertificate(X509Certificate readerCertificate) {
            this.mProfile.mReaderCertificate = readerCertificate;
            return this;
        }

        public AccessControlProfile build() {
            return this.mProfile;
        }
    }
}

