/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore2;

import android.app.AppGlobals;
import android.hardware.biometrics.BiometricManager;
import android.hardware.security.keymint.KeyParameter;
import android.security.GateKeeper;
import android.security.KeyStore2;
import android.security.KeyStoreException;
import android.security.KeyStoreParameter;
import android.security.KeyStoreSecurityLevel;
import android.security.keystore.KeyGenParameterSpec;
import android.security.keystore.KeyPermanentlyInvalidatedException;
import android.security.keystore.KeyProperties;
import android.security.keystore.KeyProtection;
import android.security.keystore.SecureKeyImportUnavailableException;
import android.security.keystore.WrappedKeyEntry;
import android.security.keystore2.AndroidKeyStoreKey;
import android.security.keystore2.AndroidKeyStoreLoadStoreParameter;
import android.security.keystore2.AndroidKeyStorePrivateKey;
import android.security.keystore2.AndroidKeyStoreProvider;
import android.security.keystore2.AndroidKeyStoreSecretKey;
import android.security.keystore2.KeyStore2ParameterUtils;
import android.security.keystore2.KeymasterUtils;
import android.system.keystore2.AuthenticatorSpec;
import android.system.keystore2.Domain;
import android.system.keystore2.KeyDescriptor;
import android.system.keystore2.KeyEntryResponse;
import android.system.keystore2.KeyMetadata;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.crypto.SecretKey;

public class AndroidKeyStoreSpi
extends KeyStoreSpi {
    public static final String TAG = "AndroidKeyStoreSpi";
    public static final String NAME = "AndroidKeyStore";
    private KeyStore2 mKeyStore;
    private int mNamespace = -1;

    @Override
    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        try {
            return AndroidKeyStoreProvider.loadAndroidKeyStoreKeyFromKeystore(this.mKeyStore, alias, this.mNamespace);
        }
        catch (KeyPermanentlyInvalidatedException e) {
            throw new UnrecoverableKeyException(e.getMessage());
        }
        catch (UnrecoverableKeyException e) {
            Throwable cause = e.getCause();
            if (cause instanceof KeyStoreException && ((KeyStoreException)cause).getErrorCode() == 7) {
                return null;
            }
            throw e;
        }
    }

    private KeyDescriptor makeKeyDescriptor(String alias) {
        KeyDescriptor descriptor = new KeyDescriptor();
        descriptor.domain = this.getTargetDomain();
        descriptor.nspace = this.mNamespace;
        descriptor.alias = alias;
        descriptor.blob = null;
        return descriptor;
    }

    @Domain
    private int getTargetDomain() {
        return this.mNamespace == -1 ? 0 : 2;
    }

    private KeyEntryResponse getKeyMetadata(String alias) {
        if (alias == null) {
            throw new NullPointerException("alias == null");
        }
        KeyDescriptor descriptor = this.makeKeyDescriptor(alias);
        try {
            return this.mKeyStore.getKeyEntry(descriptor);
        }
        catch (KeyStoreException e) {
            if (e.getErrorCode() != 7) {
                Log.w(TAG, "Could not get key metadata from Keystore.", e);
            }
            return null;
        }
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        Certificate[] caList;
        KeyEntryResponse response = this.getKeyMetadata(alias);
        if (response == null || response.metadata.certificate == null) {
            return null;
        }
        X509Certificate leaf = AndroidKeyStoreSpi.toCertificate(response.metadata.certificate);
        if (leaf == null) {
            return null;
        }
        byte[] caBytes = response.metadata.certificateChain;
        if (caBytes != null) {
            Collection<X509Certificate> caChain = AndroidKeyStoreSpi.toCertificates(caBytes);
            caList = new Certificate[caChain.size() + 1];
            Iterator<X509Certificate> it = caChain.iterator();
            int i = 1;
            while (it.hasNext()) {
                caList[i++] = it.next();
            }
        } else {
            caList = new Certificate[]{leaf};
        }
        return caList;
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        KeyEntryResponse response = this.getKeyMetadata(alias);
        if (response == null) {
            return null;
        }
        byte[] encodedCert = response.metadata.certificate;
        if (encodedCert != null) {
            return AndroidKeyStoreSpi.toCertificate(encodedCert);
        }
        encodedCert = response.metadata.certificateChain;
        if (encodedCert != null) {
            return AndroidKeyStoreSpi.toCertificate(encodedCert);
        }
        return null;
    }

    static X509Certificate toCertificate(byte[] bytes) {
        try {
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            return (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(bytes));
        }
        catch (CertificateException e) {
            Log.w(NAME, "Couldn't parse certificate in keystore", e);
            return null;
        }
    }

    private static Collection<X509Certificate> toCertificates(byte[] bytes) {
        try {
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            return certFactory.generateCertificates(new ByteArrayInputStream(bytes));
        }
        catch (CertificateException e) {
            Log.w(NAME, "Couldn't parse certificates in keystore", e);
            return new ArrayList<X509Certificate>();
        }
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        KeyEntryResponse response = this.getKeyMetadata(alias);
        if (response == null) {
            return null;
        }
        if (response.metadata.modificationTimeMs == -1L) {
            return null;
        }
        return new Date(response.metadata.modificationTimeMs);
    }

    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws java.security.KeyStoreException {
        if (password != null && password.length > 0) {
            throw new java.security.KeyStoreException("entries cannot be protected with passwords");
        }
        if (key instanceof PrivateKey) {
            this.setPrivateKeyEntry(alias, (PrivateKey)key, chain, null);
        } else if (key instanceof SecretKey) {
            this.setSecretKeyEntry(alias, (SecretKey)key, null);
        } else {
            throw new java.security.KeyStoreException("Only PrivateKey and SecretKey are supported");
        }
    }

    private static KeyProtection getLegacyKeyProtectionParameter(PrivateKey key) throws java.security.KeyStoreException {
        KeyProtection.Builder specBuilder;
        String keyAlgorithm = key.getAlgorithm();
        if ("EC".equalsIgnoreCase(keyAlgorithm)) {
            specBuilder = new KeyProtection.Builder(12);
            specBuilder.setDigests("NONE", "SHA-1", "SHA-224", "SHA-256", "SHA-384", "SHA-512");
        } else if ("RSA".equalsIgnoreCase(keyAlgorithm)) {
            specBuilder = new KeyProtection.Builder(15);
            specBuilder.setDigests("NONE", "MD5", "SHA-1", "SHA-224", "SHA-256", "SHA-384", "SHA-512");
            specBuilder.setEncryptionPaddings("NoPadding", "PKCS1Padding", "OAEPPadding");
            specBuilder.setSignaturePaddings("PKCS1", "PSS");
            specBuilder.setRandomizedEncryptionRequired(false);
        } else {
            throw new java.security.KeyStoreException("Unsupported key algorithm: " + keyAlgorithm);
        }
        specBuilder.setUserAuthenticationRequired(false);
        return specBuilder.build();
    }

    private void setPrivateKeyEntry(String alias, PrivateKey key, Certificate[] chain, KeyStore.ProtectionParameter param) throws java.security.KeyStoreException {
        byte[] chainBytes;
        byte[] userCertBytes;
        KeyProtection spec;
        int securitylevel = 1;
        int flags = 0;
        if (param == null) {
            spec = AndroidKeyStoreSpi.getLegacyKeyProtectionParameter(key);
        } else if (param instanceof KeyStoreParameter) {
            spec = AndroidKeyStoreSpi.getLegacyKeyProtectionParameter(key);
            KeyStoreParameter keyStoreParameter = (KeyStoreParameter)param;
        } else if (param instanceof KeyProtection) {
            spec = (KeyProtection)param;
            if (spec.isCriticalToDeviceEncryption()) {
                flags |= 1;
            }
            if (spec.isStrongBoxBacked()) {
                securitylevel = 2;
            }
        } else {
            throw new java.security.KeyStoreException("Unsupported protection parameter class:" + param.getClass().getName() + ". Supported: " + KeyProtection.class.getName() + ", " + KeyStoreParameter.class.getName());
        }
        if (chain == null || chain.length == 0) {
            throw new java.security.KeyStoreException("Must supply at least one Certificate with PrivateKey");
        }
        X509Certificate[] x509chain = new X509Certificate[chain.length];
        for (int i = 0; i < chain.length; ++i) {
            if (!"X.509".equals(chain[i].getType())) {
                throw new java.security.KeyStoreException("Certificates must be in X.509 format: invalid cert #" + i);
            }
            if (!(chain[i] instanceof X509Certificate)) {
                throw new java.security.KeyStoreException("Certificates must be in X.509 format: invalid cert #" + i);
            }
            x509chain[i] = (X509Certificate)chain[i];
        }
        try {
            userCertBytes = x509chain[0].getEncoded();
        }
        catch (CertificateEncodingException e) {
            throw new java.security.KeyStoreException("Failed to encode certificate #0", e);
        }
        if (chain.length > 1) {
            byte[][] certsBytes = new byte[x509chain.length - 1][];
            int totalCertLength = 0;
            for (int i = 0; i < certsBytes.length; ++i) {
                try {
                    certsBytes[i] = x509chain[i + 1].getEncoded();
                    totalCertLength += certsBytes[i].length;
                    continue;
                }
                catch (CertificateEncodingException e) {
                    throw new java.security.KeyStoreException("Failed to encode certificate #" + i, e);
                }
            }
            chainBytes = new byte[totalCertLength];
            int outputOffset = 0;
            for (int i = 0; i < certsBytes.length; ++i) {
                int certLength = certsBytes[i].length;
                System.arraycopy(certsBytes[i], 0, chainBytes, outputOffset, certLength);
                outputOffset += certLength;
                certsBytes[i] = null;
            }
        } else {
            chainBytes = null;
        }
        int targetDomain = this.getTargetDomain();
        if (key instanceof AndroidKeyStorePrivateKey) {
            AndroidKeyStoreKey ksKey = (AndroidKeyStoreKey)((Object)key);
            KeyDescriptor descriptor = ksKey.getUserKeyDescriptor();
            AndroidKeyStoreSpi.assertCanReplace(alias, targetDomain, this.mNamespace, descriptor);
            try {
                this.mKeyStore.updateSubcomponents(((AndroidKeyStorePrivateKey)key).getKeyIdDescriptor(), userCertBytes, chainBytes);
            }
            catch (KeyStoreException e) {
                throw new java.security.KeyStoreException("Failed to store certificate and certificate chain", e);
            }
            return;
        }
        String keyFormat = key.getFormat();
        if (keyFormat == null || !"PKCS#8".equals(keyFormat)) {
            throw new java.security.KeyStoreException("Unsupported private key export format: " + keyFormat + ". Only private keys which export their key material in PKCS#8 format are supported.");
        }
        byte[] pkcs8EncodedPrivateKeyBytes = key.getEncoded();
        if (pkcs8EncodedPrivateKeyBytes == null) {
            throw new java.security.KeyStoreException("Private key did not export any key material");
        }
        ArrayList<KeyParameter> importArgs = new ArrayList<KeyParameter>();
        try {
            importArgs.add(KeyStore2ParameterUtils.makeEnum(0x10000002, KeyProperties.KeyAlgorithm.toKeymasterAsymmetricKeyAlgorithm(key.getAlgorithm())));
            KeyStore2ParameterUtils.forEachSetFlag(spec.getPurposes(), purpose -> importArgs.add(KeyStore2ParameterUtils.makeEnum(0x20000001, KeyProperties.Purpose.toKeymaster(purpose))));
            if (spec.isDigestsSpecified()) {
                String[] certLength = spec.getDigests();
                int n = certLength.length;
                for (int i = 0; i < n; ++i) {
                    String digest = certLength[i];
                    importArgs.add(KeyStore2ParameterUtils.makeEnum(0x20000005, KeyProperties.Digest.toKeymaster(digest)));
                }
            }
            for (String blockMode : spec.getBlockModes()) {
                importArgs.add(KeyStore2ParameterUtils.makeEnum(0x20000004, KeyProperties.BlockMode.toKeymaster(blockMode)));
            }
            int[] keymasterEncryptionPaddings = KeyProperties.EncryptionPadding.allToKeymaster(spec.getEncryptionPaddings());
            if ((spec.getPurposes() & 1) != 0 && spec.isRandomizedEncryptionRequired()) {
                for (int keymasterPadding : keymasterEncryptionPaddings) {
                    if (KeymasterUtils.isKeymasterPaddingSchemeIndCpaCompatibleWithAsymmetricCrypto(keymasterPadding)) continue;
                    throw new java.security.KeyStoreException("Randomized encryption (IND-CPA) required but is violated by encryption padding mode: " + KeyProperties.EncryptionPadding.fromKeymaster(keymasterPadding) + ". See KeyProtection documentation.");
                }
            }
            for (int padding : keymasterEncryptionPaddings) {
                importArgs.add(KeyStore2ParameterUtils.makeEnum(0x20000006, padding));
            }
            for (String padding : spec.getSignaturePaddings()) {
                importArgs.add(KeyStore2ParameterUtils.makeEnum(0x20000006, KeyProperties.SignaturePadding.toKeymaster(padding)));
            }
            KeyStore2ParameterUtils.addUserAuthArgs(importArgs, spec);
            if (spec.getKeyValidityStart() != null) {
                importArgs.add(KeyStore2ParameterUtils.makeDate(1610613136, spec.getKeyValidityStart()));
            }
            if (spec.getKeyValidityForOriginationEnd() != null) {
                importArgs.add(KeyStore2ParameterUtils.makeDate(1610613137, spec.getKeyValidityForOriginationEnd()));
            }
            if (spec.getKeyValidityForConsumptionEnd() != null) {
                importArgs.add(KeyStore2ParameterUtils.makeDate(1610613138, spec.getKeyValidityForConsumptionEnd()));
            }
            if (spec.getMaxUsageCount() != -1) {
                importArgs.add(KeyStore2ParameterUtils.makeInt(805306773, spec.getMaxUsageCount()));
            }
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            throw new java.security.KeyStoreException(e);
        }
        try {
            KeyStoreSecurityLevel securityLevelInterface = this.mKeyStore.getSecurityLevel(securitylevel);
            KeyDescriptor keyDescriptor = this.makeKeyDescriptor(alias);
            KeyMetadata metadata = securityLevelInterface.importKey(keyDescriptor, null, importArgs, flags, pkcs8EncodedPrivateKeyBytes);
            try {
                this.mKeyStore.updateSubcomponents(metadata.key, userCertBytes, chainBytes);
            }
            catch (KeyStoreException e) {
                this.mKeyStore.deleteKey(metadata.key);
                throw new java.security.KeyStoreException("Failed to store certificate and certificate chain", e);
            }
        }
        catch (KeyStoreException e) {
            throw new java.security.KeyStoreException("Failed to store private key", e);
        }
    }

    private static void assertCanReplace(String alias, @Domain int targetDomain, int targetNamespace, KeyDescriptor descriptor) throws java.security.KeyStoreException {
        if (alias != descriptor.alias || descriptor.domain != targetDomain || descriptor.domain == 2 && descriptor.nspace != (long)targetNamespace) {
            throw new java.security.KeyStoreException("Can only replace keys with same alias: " + alias + " != " + descriptor.alias + " in the same target domain: " + targetDomain + " != " + descriptor.domain + (targetDomain == 2 ? " in the same target namespace: " + targetNamespace + " != " + descriptor.nspace : ""));
        }
    }

    private void setSecretKeyEntry(String alias, SecretKey key, KeyStore.ProtectionParameter param) throws java.security.KeyStoreException {
        if (param != null && !(param instanceof KeyProtection)) {
            throw new java.security.KeyStoreException("Unsupported protection parameter class: " + param.getClass().getName() + ". Supported: " + KeyProtection.class.getName());
        }
        KeyProtection params = (KeyProtection)param;
        int securityLevel = params.isStrongBoxBacked() ? 2 : 1;
        int targetDomain = this.getTargetDomain();
        if (key instanceof AndroidKeyStoreSecretKey) {
            String keyAliasInKeystore = ((AndroidKeyStoreSecretKey)key).getUserKeyDescriptor().alias;
            KeyDescriptor descriptor = ((AndroidKeyStoreSecretKey)key).getUserKeyDescriptor();
            AndroidKeyStoreSpi.assertCanReplace(alias, targetDomain, this.mNamespace, descriptor);
            if (params != null) {
                throw new java.security.KeyStoreException("Modifying KeyStore-backed key using protection parameters not supported");
            }
            return;
        }
        if (params == null) {
            throw new java.security.KeyStoreException("Protection parameters must be specified when importing a symmetric key");
        }
        String keyExportFormat = key.getFormat();
        if (keyExportFormat == null) {
            throw new java.security.KeyStoreException("Only secret keys that export their key material are supported");
        }
        if (!"RAW".equals(keyExportFormat)) {
            throw new java.security.KeyStoreException("Unsupported secret key material export format: " + keyExportFormat);
        }
        byte[] keyMaterial = key.getEncoded();
        if (keyMaterial == null) {
            throw new java.security.KeyStoreException("Key did not export its key material despite supporting RAW format export");
        }
        ArrayList<KeyParameter> importArgs = new ArrayList<KeyParameter>();
        try {
            int keymasterAlgorithm = KeyProperties.KeyAlgorithm.toKeymasterSecretKeyAlgorithm(key.getAlgorithm());
            importArgs.add(KeyStore2ParameterUtils.makeEnum(0x10000002, keymasterAlgorithm));
            if (keymasterAlgorithm == 128) {
                int[] keymasterDigestsFromParams;
                int keymasterImpliedDigest = KeyProperties.KeyAlgorithm.toKeymasterDigest(key.getAlgorithm());
                if (keymasterImpliedDigest == -1) {
                    throw new ProviderException("HMAC key algorithm digest unknown for key algorithm " + key.getAlgorithm());
                }
                if (params.isDigestsSpecified() && ((keymasterDigestsFromParams = KeyProperties.Digest.allToKeymaster(params.getDigests())).length != 1 || keymasterDigestsFromParams[0] != keymasterImpliedDigest)) {
                    throw new java.security.KeyStoreException("Unsupported digests specification: " + Arrays.asList(params.getDigests()) + ". Only " + KeyProperties.Digest.fromKeymaster(keymasterImpliedDigest) + " supported for HMAC key algorithm " + key.getAlgorithm());
                }
                int outputBits = KeymasterUtils.getDigestOutputSizeBits(keymasterImpliedDigest);
                if (outputBits == -1) {
                    throw new ProviderException("HMAC key authorized for unsupported digest: " + KeyProperties.Digest.fromKeymaster(keymasterImpliedDigest));
                }
                importArgs.add(KeyStore2ParameterUtils.makeEnum(0x20000005, keymasterImpliedDigest));
                importArgs.add(KeyStore2ParameterUtils.makeInt(0x30000008, outputBits));
            } else if (params.isDigestsSpecified()) {
                for (String digest : params.getDigests()) {
                    importArgs.add(KeyStore2ParameterUtils.makeEnum(0x20000005, KeyProperties.Digest.toKeymaster(digest)));
                }
            }
            KeyStore2ParameterUtils.forEachSetFlag(params.getPurposes(), purpose -> importArgs.add(KeyStore2ParameterUtils.makeEnum(0x20000001, KeyProperties.Purpose.toKeymaster(purpose))));
            boolean indCpa = false;
            if ((params.getPurposes() & 1) != 0) {
                if (((KeyProtection)param).isRandomizedEncryptionRequired()) {
                    indCpa = true;
                } else {
                    importArgs.add(KeyStore2ParameterUtils.makeBool(0x70000007));
                }
            }
            for (String blockMode : params.getBlockModes()) {
                int keymasterBlockMode = KeyProperties.BlockMode.toKeymaster(blockMode);
                if (indCpa && !KeymasterUtils.isKeymasterBlockModeIndCpaCompatibleWithSymmetricCrypto(keymasterBlockMode)) {
                    throw new java.security.KeyStoreException("Randomized encryption (IND-CPA) required but may be violated by block mode: " + blockMode + ". See KeyProtection documentation.");
                }
                if (keymasterAlgorithm == 32 && keymasterBlockMode == 32) {
                    importArgs.add(KeyStore2ParameterUtils.makeInt(0x30000008, 96));
                }
                importArgs.add(KeyStore2ParameterUtils.makeEnum(0x20000004, keymasterBlockMode));
            }
            if (params.getSignaturePaddings().length > 0) {
                throw new java.security.KeyStoreException("Signature paddings not supported for symmetric keys");
            }
            for (String padding : params.getEncryptionPaddings()) {
                importArgs.add(KeyStore2ParameterUtils.makeEnum(0x20000006, KeyProperties.EncryptionPadding.toKeymaster(padding)));
            }
            KeyStore2ParameterUtils.addUserAuthArgs(importArgs, params);
            if (params.getKeyValidityStart() != null) {
                importArgs.add(KeyStore2ParameterUtils.makeDate(1610613136, params.getKeyValidityStart()));
            }
            if (params.getKeyValidityForOriginationEnd() != null) {
                importArgs.add(KeyStore2ParameterUtils.makeDate(1610613137, params.getKeyValidityForOriginationEnd()));
            }
            if (params.getKeyValidityForConsumptionEnd() != null) {
                importArgs.add(KeyStore2ParameterUtils.makeDate(1610613138, params.getKeyValidityForConsumptionEnd()));
            }
            if (params.getMaxUsageCount() != -1) {
                importArgs.add(KeyStore2ParameterUtils.makeInt(805306773, params.getMaxUsageCount()));
            }
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            throw new java.security.KeyStoreException(e);
        }
        int flags = 0;
        if (params.isCriticalToDeviceEncryption()) {
            flags |= 1;
        }
        try {
            KeyStoreSecurityLevel securityLevelInterface = this.mKeyStore.getSecurityLevel(securityLevel);
            KeyDescriptor descriptor = this.makeKeyDescriptor(alias);
            securityLevelInterface.importKey(descriptor, null, importArgs, flags, keyMaterial);
        }
        catch (KeyStoreException e) {
            throw new java.security.KeyStoreException("Failed to import secret key.", e);
        }
    }

    private void setWrappedKeyEntry(String alias, WrappedKeyEntry entry, KeyStore.ProtectionParameter param) throws java.security.KeyStoreException {
        int digest;
        KeyGenParameterSpec spec;
        int padding;
        if (param != null) {
            throw new java.security.KeyStoreException("Protection parameters are specified inside wrapped keys");
        }
        byte[] maskingKey = new byte[32];
        String[] parts = entry.getTransformation().split("/");
        ArrayList<KeyParameter> args = new ArrayList<KeyParameter>();
        String algorithm = parts[0];
        if (!"RSA".equalsIgnoreCase(algorithm)) {
            throw new java.security.KeyStoreException("Algorithm \"" + algorithm + "\" not supported for wrapping. Only RSA wrapping keys are supported.");
        }
        args.add(KeyStore2ParameterUtils.makeEnum(0x10000002, 1));
        if (parts.length > 1) {
            String mode = parts[1];
            args.add(KeyStore2ParameterUtils.makeEnum(0x20000004, KeyProperties.BlockMode.toKeymaster(mode)));
        }
        if (parts.length > 2 && (padding = KeyProperties.EncryptionPadding.toKeymaster(parts[2])) != 1) {
            args.add(KeyStore2ParameterUtils.makeEnum(0x20000006, padding));
        }
        if ((spec = (KeyGenParameterSpec)entry.getAlgorithmParameterSpec()).isDigestsSpecified() && (digest = KeyProperties.Digest.toKeymaster(spec.getDigests()[0])) != 0) {
            args.add(KeyStore2ParameterUtils.makeEnum(0x20000005, digest));
        }
        KeyDescriptor wrappingkey = this.makeKeyDescriptor(entry.getWrappingKeyAlias());
        KeyEntryResponse response = null;
        try {
            response = this.mKeyStore.getKeyEntry(wrappingkey);
        }
        catch (KeyStoreException e) {
            throw new java.security.KeyStoreException("Failed to import wrapped key. Keystore error code: " + e.getErrorCode(), e);
        }
        KeyDescriptor wrappedKey = this.makeKeyDescriptor(alias);
        KeyStoreSecurityLevel securityLevel = new KeyStoreSecurityLevel(response.iSecurityLevel);
        BiometricManager bm = AppGlobals.getInitialApplication().getSystemService(BiometricManager.class);
        long[] biometricSids = bm.getAuthenticatorIds();
        ArrayList<AuthenticatorSpec> authenticatorSpecs = new ArrayList<AuthenticatorSpec>();
        AuthenticatorSpec authenticatorSpec = new AuthenticatorSpec();
        authenticatorSpec.authenticatorType = 1;
        authenticatorSpec.authenticatorId = GateKeeper.getSecureUserId();
        authenticatorSpecs.add(authenticatorSpec);
        for (long sid : biometricSids) {
            AuthenticatorSpec authSpec = new AuthenticatorSpec();
            authSpec.authenticatorType = 2;
            authSpec.authenticatorId = sid;
            authenticatorSpecs.add(authSpec);
        }
        try {
            securityLevel.importWrappedKey(wrappedKey, wrappingkey, entry.getWrappedKeyBytes(), null, args, authenticatorSpecs.toArray(new AuthenticatorSpec[0]));
        }
        catch (KeyStoreException e) {
            switch (e.getErrorCode()) {
                case -100: {
                    throw new SecureKeyImportUnavailableException("Could not import wrapped key");
                }
            }
            throw new java.security.KeyStoreException("Failed to import wrapped key. Keystore error code: " + e.getErrorCode(), e);
        }
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] userKey, Certificate[] chain) throws java.security.KeyStoreException {
        throw new java.security.KeyStoreException("Operation not supported because key encoding is unknown");
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws java.security.KeyStoreException {
        byte[] encoded;
        if (this.isKeyEntry(alias)) {
            throw new java.security.KeyStoreException("Entry exists and is not a trusted certificate");
        }
        if (cert == null) {
            throw new NullPointerException("cert == null");
        }
        try {
            encoded = cert.getEncoded();
        }
        catch (CertificateEncodingException e) {
            throw new java.security.KeyStoreException(e);
        }
        try {
            this.mKeyStore.updateSubcomponents(this.makeKeyDescriptor(alias), null, encoded);
        }
        catch (KeyStoreException e) {
            throw new java.security.KeyStoreException("Couldn't insert certificate.", e);
        }
    }

    @Override
    public void engineDeleteEntry(String alias) throws java.security.KeyStoreException {
        block2: {
            KeyDescriptor descriptor = this.makeKeyDescriptor(alias);
            try {
                this.mKeyStore.deleteKey(descriptor);
            }
            catch (KeyStoreException e) {
                if (e.getErrorCode() == 7) break block2;
                throw new java.security.KeyStoreException("Failed to delete entry: " + alias, e);
            }
        }
    }

    private Set<String> getUniqueAliases() {
        try {
            KeyDescriptor[] keys = this.mKeyStore.list(this.getTargetDomain(), this.mNamespace);
            HashSet<String> aliases = new HashSet<String>(keys.length);
            for (KeyDescriptor d : keys) {
                aliases.add(d.alias);
            }
            return aliases;
        }
        catch (KeyStoreException e) {
            Log.e(TAG, "Failed to list keystore entries.", e);
            return new HashSet<String>();
        }
    }

    @Override
    public Enumeration<String> engineAliases() {
        return Collections.enumeration(this.getUniqueAliases());
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        if (alias == null) {
            throw new NullPointerException("alias == null");
        }
        return this.getKeyMetadata(alias) != null;
    }

    @Override
    public int engineSize() {
        return this.getUniqueAliases().size();
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        return this.isKeyEntry(alias);
    }

    private boolean isKeyEntry(String alias) {
        if (alias == null) {
            throw new NullPointerException("alias == null");
        }
        KeyEntryResponse response = this.getKeyMetadata(alias);
        return response != null && response.iSecurityLevel != null;
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        if (alias == null) {
            throw new NullPointerException("alias == null");
        }
        KeyEntryResponse response = this.getKeyMetadata(alias);
        return response != null && response.metadata.certificateChain != null && response.iSecurityLevel == null;
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        byte[] targetCertBytes;
        if (cert == null) {
            return null;
        }
        if (!"X.509".equalsIgnoreCase(cert.getType())) {
            Log.e(TAG, "In engineGetCertificateAlias: only X.509 certificates are supported.");
            return null;
        }
        try {
            targetCertBytes = cert.getEncoded();
        }
        catch (CertificateEncodingException e) {
            Log.e(TAG, "While trying to get the alias for a certificate.", e);
            return null;
        }
        if (targetCertBytes == null) {
            return null;
        }
        KeyDescriptor[] keyDescriptors = null;
        try {
            keyDescriptors = this.mKeyStore.list(this.getTargetDomain(), this.mNamespace);
        }
        catch (KeyStoreException e) {
            Log.w(TAG, "Failed to get list of keystore entries.", e);
        }
        String caAlias = null;
        for (KeyDescriptor d : keyDescriptors) {
            KeyEntryResponse response = this.getKeyMetadata(d.alias);
            if (response == null) continue;
            if (response.metadata.certificate != null) {
                if (!Arrays.equals(response.metadata.certificate, targetCertBytes)) continue;
                return d.alias;
            }
            if (response.metadata.certificateChain == null || caAlias != null || !Arrays.equals(response.metadata.certificateChain, targetCertBytes)) continue;
            caAlias = d.alias;
        }
        return caAlias;
    }

    @VisibleForTesting
    public void initForTesting(KeyStore2 keystore) {
        this.mKeyStore = keystore;
        this.mNamespace = -1;
    }

    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        throw new UnsupportedOperationException("Can not serialize AndroidKeyStore to OutputStream");
    }

    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (stream != null) {
            throw new IllegalArgumentException("InputStream not supported");
        }
        if (password != null) {
            throw new IllegalArgumentException("password not supported");
        }
        this.mKeyStore = KeyStore2.getInstance();
        this.mNamespace = -1;
    }

    @Override
    public void engineLoad(KeyStore.LoadStoreParameter param) throws IOException, NoSuchAlgorithmException, CertificateException {
        int namespace = -1;
        if (param != null) {
            if (param instanceof AndroidKeyStoreLoadStoreParameter) {
                namespace = ((AndroidKeyStoreLoadStoreParameter)param).getNamespace();
            } else {
                throw new IllegalArgumentException("Unsupported param type: " + param.getClass());
            }
        }
        this.mKeyStore = KeyStore2.getInstance();
        this.mNamespace = namespace;
    }

    @Override
    public void engineSetEntry(String alias, KeyStore.Entry entry, KeyStore.ProtectionParameter param) throws java.security.KeyStoreException {
        if (entry == null) {
            throw new java.security.KeyStoreException("entry == null");
        }
        if (entry instanceof KeyStore.TrustedCertificateEntry) {
            KeyStore.TrustedCertificateEntry trE = (KeyStore.TrustedCertificateEntry)entry;
            this.engineDeleteEntry(alias);
            this.engineSetCertificateEntry(alias, trE.getTrustedCertificate());
            return;
        }
        if (entry instanceof KeyStore.PrivateKeyEntry) {
            KeyStore.PrivateKeyEntry prE = (KeyStore.PrivateKeyEntry)entry;
            this.setPrivateKeyEntry(alias, prE.getPrivateKey(), prE.getCertificateChain(), param);
        } else if (entry instanceof KeyStore.SecretKeyEntry) {
            KeyStore.SecretKeyEntry secE = (KeyStore.SecretKeyEntry)entry;
            this.setSecretKeyEntry(alias, secE.getSecretKey(), param);
        } else if (entry instanceof WrappedKeyEntry) {
            WrappedKeyEntry wke = (WrappedKeyEntry)entry;
            this.setWrappedKeyEntry(alias, wke, param);
        } else {
            throw new java.security.KeyStoreException("Entry must be a PrivateKeyEntry, SecretKeyEntry, WrappedKeyEntry or TrustedCertificateEntry; was " + entry);
        }
    }
}

