/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore2;

import android.app.AppGlobals;
import android.hardware.biometrics.BiometricManager;
import android.hardware.security.keymint.KeyParameter;
import android.hardware.security.keymint.KeyParameterValue;
import android.hardware.security.keymint.SecurityLevel;
import android.security.GateKeeper;
import android.security.keymaster.KeymasterDefs;
import android.security.keystore.UserAuthArgs;
import android.system.keystore2.Authorization;
import java.math.BigInteger;
import java.security.ProviderException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;

public abstract class KeyStore2ParameterUtils {
    static KeyParameter makeBool(int tag) {
        int type = KeymasterDefs.getTagType(tag);
        if (type != 0x70000000) {
            throw new IllegalArgumentException("Not a boolean tag: " + tag);
        }
        KeyParameter p = new KeyParameter();
        p.tag = tag;
        p.value = KeyParameterValue.boolValue(true);
        return p;
    }

    static KeyParameter makeEnum(int tag, int v) {
        KeyParameter kp = new KeyParameter();
        kp.tag = tag;
        switch (tag) {
            case 0x20000001: {
                kp.value = KeyParameterValue.keyPurpose(v);
                break;
            }
            case 0x10000002: {
                kp.value = KeyParameterValue.algorithm(v);
                break;
            }
            case 0x20000004: {
                kp.value = KeyParameterValue.blockMode(v);
                break;
            }
            case 0x20000005: {
                kp.value = KeyParameterValue.digest(v);
                break;
            }
            case 0x1000000A: {
                kp.value = KeyParameterValue.ecCurve(v);
                break;
            }
            case 268436158: {
                kp.value = KeyParameterValue.origin(v);
                break;
            }
            case 0x20000006: {
                kp.value = KeyParameterValue.paddingMode(v);
                break;
            }
            case 268435960: {
                kp.value = KeyParameterValue.hardwareAuthenticatorType(v);
                break;
            }
            case 0x10000130: {
                kp.value = KeyParameterValue.securityLevel(v);
                break;
            }
            default: {
                throw new IllegalArgumentException("Not an enum or repeatable enum tag: " + tag);
            }
        }
        return kp;
    }

    static KeyParameter makeInt(int tag, int v) {
        int type = KeymasterDefs.getTagType(tag);
        if (type != 0x30000000 && type != 0x40000000) {
            throw new IllegalArgumentException("Not an int or repeatable int tag: " + tag);
        }
        KeyParameter p = new KeyParameter();
        p.tag = tag;
        p.value = KeyParameterValue.integer(v);
        return p;
    }

    static KeyParameter makeLong(int tag, long v) {
        int type = KeymasterDefs.getTagType(tag);
        if (type != 0x50000000 && type != -1610612736) {
            throw new IllegalArgumentException("Not a long or repeatable long tag: " + tag);
        }
        KeyParameter p = new KeyParameter();
        p.tag = tag;
        p.value = KeyParameterValue.longInteger(v);
        return p;
    }

    static KeyParameter makeBytes(int tag, byte[] b) {
        if (KeymasterDefs.getTagType(tag) != -1879048192) {
            throw new IllegalArgumentException("Not a bytes tag: " + tag);
        }
        KeyParameter p = new KeyParameter();
        p.tag = tag;
        p.value = KeyParameterValue.blob(b);
        return p;
    }

    static KeyParameter makeBignum(int tag, BigInteger b) {
        if (KeymasterDefs.getTagType(tag) != Integer.MIN_VALUE) {
            throw new IllegalArgumentException("Not a bignum tag: " + tag);
        }
        KeyParameter p = new KeyParameter();
        p.tag = tag;
        p.value = KeyParameterValue.blob(b.toByteArray());
        return p;
    }

    static KeyParameter makeDate(int tag, Date date) {
        if (KeymasterDefs.getTagType(tag) != 0x60000000) {
            throw new IllegalArgumentException("Not a date tag: " + tag);
        }
        KeyParameter p = new KeyParameter();
        p.tag = tag;
        p.value = KeyParameterValue.dateTime(date.getTime());
        return p;
    }

    static boolean isSecureHardware(@SecurityLevel int securityLevel) {
        return securityLevel == 1 || securityLevel == 2;
    }

    static long getUnsignedInt(Authorization param) {
        if (KeymasterDefs.getTagType(param.keyParameter.tag) != 0x30000000) {
            throw new IllegalArgumentException("Not an int tag: " + param.keyParameter.tag);
        }
        return (long)param.keyParameter.value.getInteger() & 0xFFFFFFFFL;
    }

    static Date getDate(Authorization param) {
        if (KeymasterDefs.getTagType(param.keyParameter.tag) != 0x60000000) {
            throw new IllegalArgumentException("Not a date tag: " + param.keyParameter.tag);
        }
        if (param.keyParameter.value.getDateTime() < 0L) {
            throw new IllegalArgumentException("Date Value too large: " + param.keyParameter.value.getDateTime());
        }
        return new Date(param.keyParameter.value.getDateTime());
    }

    static void forEachSetFlag(int flags, Consumer<Integer> consumer) {
        int offset = 0;
        while (flags != 0) {
            if ((flags & 1) == 1) {
                consumer.accept(1 << offset);
            }
            ++offset;
            flags >>>= 1;
        }
    }

    private static long getRootSid() {
        long rootSid = GateKeeper.getSecureUserId();
        if (rootSid == 0L) {
            throw new IllegalStateException("Secure lock screen must be enabled to create keys requiring user authentication");
        }
        return rootSid;
    }

    private static void addSids(List<KeyParameter> params, UserAuthArgs spec) {
        if (spec.getUserAuthenticationType() == 3) {
            if (spec.getBoundToSpecificSecureUserId() != 0L) {
                params.add(KeyStore2ParameterUtils.makeLong(-1610612234, spec.getBoundToSpecificSecureUserId()));
            } else {
                params.add(KeyStore2ParameterUtils.makeLong(-1610612234, KeyStore2ParameterUtils.getRootSid()));
            }
        } else {
            ArrayList<Long> sids = new ArrayList<Long>();
            if ((spec.getUserAuthenticationType() & 2) != 0) {
                BiometricManager bm = AppGlobals.getInitialApplication().getSystemService(BiometricManager.class);
                long[] biometricSids = bm.getAuthenticatorIds();
                if (biometricSids.length == 0) {
                    throw new IllegalStateException("At least one biometric must be enrolled to create keys requiring user authentication for every use");
                }
                if (spec.getBoundToSpecificSecureUserId() != 0L) {
                    sids.add(spec.getBoundToSpecificSecureUserId());
                } else if (spec.isInvalidatedByBiometricEnrollment()) {
                    for (long sid : biometricSids) {
                        sids.add(sid);
                    }
                } else {
                    sids.add(KeyStore2ParameterUtils.getRootSid());
                }
            } else if ((spec.getUserAuthenticationType() & 1) != 0) {
                sids.add(KeyStore2ParameterUtils.getRootSid());
            } else {
                throw new IllegalStateException("Invalid or no authentication type specified.");
            }
            for (int i = 0; i < sids.size(); ++i) {
                params.add(KeyStore2ParameterUtils.makeLong(-1610612234, (Long)sids.get(i)));
            }
        }
    }

    static void addUserAuthArgs(List<KeyParameter> args, UserAuthArgs spec) {
        if (spec.isUserConfirmationRequired()) {
            args.add(KeyStore2ParameterUtils.makeBool(1879048700));
        }
        if (spec.isUserPresenceRequired()) {
            args.add(KeyStore2ParameterUtils.makeBool(1879048699));
        }
        if (spec.isUnlockedDeviceRequired()) {
            args.add(KeyStore2ParameterUtils.makeBool(1879048701));
        }
        if (!spec.isUserAuthenticationRequired()) {
            args.add(KeyStore2ParameterUtils.makeBool(1879048695));
        } else if (spec.getUserAuthenticationValidityDurationSeconds() == 0) {
            KeyStore2ParameterUtils.addSids(args, spec);
            args.add(KeyStore2ParameterUtils.makeEnum(268435960, spec.getUserAuthenticationType()));
            if (spec.isUserAuthenticationValidWhileOnBody()) {
                throw new ProviderException("Key validity extension while device is on-body is not supported for keys requiring fingerprint authentication");
            }
        } else {
            KeyStore2ParameterUtils.addSids(args, spec);
            args.add(KeyStore2ParameterUtils.makeEnum(268435960, spec.getUserAuthenticationType()));
            args.add(KeyStore2ParameterUtils.makeInt(805306873, spec.getUserAuthenticationValidityDurationSeconds()));
            if (spec.isUserAuthenticationValidWhileOnBody()) {
                args.add(KeyStore2ParameterUtils.makeBool(1879048698));
            }
        }
    }
}

