/*
 * Decompiled with CFR 0.152.
 */
package android.service.notification;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationChannelGroup;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.UserHandle;
import android.service.notification.IStatusBarNotificationHolder;
import android.service.notification.NotificationRankingUpdate;
import android.service.notification.NotificationStats;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.List;

public interface INotificationListener
extends IInterface {
    public void onListenerConnected(NotificationRankingUpdate var1) throws RemoteException;

    public void onNotificationPosted(IStatusBarNotificationHolder var1, NotificationRankingUpdate var2) throws RemoteException;

    public void onStatusBarIconsBehaviorChanged(boolean var1) throws RemoteException;

    public void onNotificationRemoved(IStatusBarNotificationHolder var1, NotificationRankingUpdate var2, NotificationStats var3, int var4) throws RemoteException;

    public void onNotificationRankingUpdate(NotificationRankingUpdate var1) throws RemoteException;

    public void onListenerHintsChanged(int var1) throws RemoteException;

    public void onInterruptionFilterChanged(int var1) throws RemoteException;

    public void onNotificationChannelModification(String var1, UserHandle var2, NotificationChannel var3, int var4) throws RemoteException;

    public void onNotificationChannelGroupModification(String var1, UserHandle var2, NotificationChannelGroup var3, int var4) throws RemoteException;

    public void onNotificationEnqueuedWithChannel(IStatusBarNotificationHolder var1, NotificationChannel var2, NotificationRankingUpdate var3) throws RemoteException;

    public void onNotificationSnoozedUntilContext(IStatusBarNotificationHolder var1, String var2) throws RemoteException;

    public void onNotificationsSeen(List<String> var1) throws RemoteException;

    public void onPanelRevealed(int var1) throws RemoteException;

    public void onPanelHidden() throws RemoteException;

    public void onNotificationVisibilityChanged(String var1, boolean var2) throws RemoteException;

    public void onNotificationExpansionChanged(String var1, boolean var2, boolean var3) throws RemoteException;

    public void onNotificationDirectReply(String var1) throws RemoteException;

    public void onSuggestedReplySent(String var1, CharSequence var2, int var3) throws RemoteException;

    public void onActionClicked(String var1, Notification.Action var2, int var3) throws RemoteException;

    public void onNotificationClicked(String var1) throws RemoteException;

    public void onAllowedAdjustmentsChanged() throws RemoteException;

    public void onNotificationFeedbackReceived(String var1, NotificationRankingUpdate var2, Bundle var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements INotificationListener {
        public static final String DESCRIPTOR = "android.service.notification.INotificationListener";
        static final int TRANSACTION_onListenerConnected = 1;
        static final int TRANSACTION_onNotificationPosted = 2;
        static final int TRANSACTION_onStatusBarIconsBehaviorChanged = 3;
        static final int TRANSACTION_onNotificationRemoved = 4;
        static final int TRANSACTION_onNotificationRankingUpdate = 5;
        static final int TRANSACTION_onListenerHintsChanged = 6;
        static final int TRANSACTION_onInterruptionFilterChanged = 7;
        static final int TRANSACTION_onNotificationChannelModification = 8;
        static final int TRANSACTION_onNotificationChannelGroupModification = 9;
        static final int TRANSACTION_onNotificationEnqueuedWithChannel = 10;
        static final int TRANSACTION_onNotificationSnoozedUntilContext = 11;
        static final int TRANSACTION_onNotificationsSeen = 12;
        static final int TRANSACTION_onPanelRevealed = 13;
        static final int TRANSACTION_onPanelHidden = 14;
        static final int TRANSACTION_onNotificationVisibilityChanged = 15;
        static final int TRANSACTION_onNotificationExpansionChanged = 16;
        static final int TRANSACTION_onNotificationDirectReply = 17;
        static final int TRANSACTION_onSuggestedReplySent = 18;
        static final int TRANSACTION_onActionClicked = 19;
        static final int TRANSACTION_onNotificationClicked = 20;
        static final int TRANSACTION_onAllowedAdjustmentsChanged = 21;
        static final int TRANSACTION_onNotificationFeedbackReceived = 22;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static INotificationListener asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof INotificationListener) {
                return (INotificationListener)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onListenerConnected";
                }
                case 2: {
                    return "onNotificationPosted";
                }
                case 3: {
                    return "onStatusBarIconsBehaviorChanged";
                }
                case 4: {
                    return "onNotificationRemoved";
                }
                case 5: {
                    return "onNotificationRankingUpdate";
                }
                case 6: {
                    return "onListenerHintsChanged";
                }
                case 7: {
                    return "onInterruptionFilterChanged";
                }
                case 8: {
                    return "onNotificationChannelModification";
                }
                case 9: {
                    return "onNotificationChannelGroupModification";
                }
                case 10: {
                    return "onNotificationEnqueuedWithChannel";
                }
                case 11: {
                    return "onNotificationSnoozedUntilContext";
                }
                case 12: {
                    return "onNotificationsSeen";
                }
                case 13: {
                    return "onPanelRevealed";
                }
                case 14: {
                    return "onPanelHidden";
                }
                case 15: {
                    return "onNotificationVisibilityChanged";
                }
                case 16: {
                    return "onNotificationExpansionChanged";
                }
                case 17: {
                    return "onNotificationDirectReply";
                }
                case 18: {
                    return "onSuggestedReplySent";
                }
                case 19: {
                    return "onActionClicked";
                }
                case 20: {
                    return "onNotificationClicked";
                }
                case 21: {
                    return "onAllowedAdjustmentsChanged";
                }
                case 22: {
                    return "onNotificationFeedbackReceived";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    NotificationRankingUpdate _arg0 = 0 != data.readInt() ? NotificationRankingUpdate.CREATOR.createFromParcel(data) : null;
                    this.onListenerConnected(_arg0);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    IStatusBarNotificationHolder _arg0 = IStatusBarNotificationHolder.Stub.asInterface(data.readStrongBinder());
                    NotificationRankingUpdate _arg1 = 0 != data.readInt() ? NotificationRankingUpdate.CREATOR.createFromParcel(data) : null;
                    this.onNotificationPosted(_arg0, _arg1);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    this.onStatusBarIconsBehaviorChanged(_arg0);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    IStatusBarNotificationHolder _arg0 = IStatusBarNotificationHolder.Stub.asInterface(data.readStrongBinder());
                    NotificationRankingUpdate _arg1 = 0 != data.readInt() ? NotificationRankingUpdate.CREATOR.createFromParcel(data) : null;
                    NotificationStats _arg2 = 0 != data.readInt() ? NotificationStats.CREATOR.createFromParcel(data) : null;
                    int _arg3 = data.readInt();
                    this.onNotificationRemoved(_arg0, _arg1, _arg2, _arg3);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    NotificationRankingUpdate _arg0 = 0 != data.readInt() ? NotificationRankingUpdate.CREATOR.createFromParcel(data) : null;
                    this.onNotificationRankingUpdate(_arg0);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.onListenerHintsChanged(_arg0);
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.onInterruptionFilterChanged(_arg0);
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    UserHandle _arg1 = 0 != data.readInt() ? UserHandle.CREATOR.createFromParcel(data) : null;
                    NotificationChannel _arg2 = 0 != data.readInt() ? NotificationChannel.CREATOR.createFromParcel(data) : null;
                    int _arg3 = data.readInt();
                    this.onNotificationChannelModification(_arg0, _arg1, _arg2, _arg3);
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    UserHandle _arg1 = 0 != data.readInt() ? UserHandle.CREATOR.createFromParcel(data) : null;
                    NotificationChannelGroup _arg2 = 0 != data.readInt() ? NotificationChannelGroup.CREATOR.createFromParcel(data) : null;
                    int _arg3 = data.readInt();
                    this.onNotificationChannelGroupModification(_arg0, _arg1, _arg2, _arg3);
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    IStatusBarNotificationHolder _arg0 = IStatusBarNotificationHolder.Stub.asInterface(data.readStrongBinder());
                    NotificationChannel _arg1 = 0 != data.readInt() ? NotificationChannel.CREATOR.createFromParcel(data) : null;
                    NotificationRankingUpdate _arg2 = 0 != data.readInt() ? NotificationRankingUpdate.CREATOR.createFromParcel(data) : null;
                    this.onNotificationEnqueuedWithChannel(_arg0, _arg1, _arg2);
                    return true;
                }
                case 11: {
                    data.enforceInterface(descriptor);
                    IStatusBarNotificationHolder _arg0 = IStatusBarNotificationHolder.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    this.onNotificationSnoozedUntilContext(_arg0, _arg1);
                    return true;
                }
                case 12: {
                    data.enforceInterface(descriptor);
                    ArrayList<String> _arg0 = data.createStringArrayList();
                    this.onNotificationsSeen(_arg0);
                    return true;
                }
                case 13: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.onPanelRevealed(_arg0);
                    return true;
                }
                case 14: {
                    data.enforceInterface(descriptor);
                    this.onPanelHidden();
                    return true;
                }
                case 15: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _arg1 = 0 != data.readInt();
                    this.onNotificationVisibilityChanged(_arg0, _arg1);
                    return true;
                }
                case 16: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _arg1 = 0 != data.readInt();
                    boolean _arg2 = 0 != data.readInt();
                    this.onNotificationExpansionChanged(_arg0, _arg1, _arg2);
                    return true;
                }
                case 17: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.onNotificationDirectReply(_arg0);
                    return true;
                }
                case 18: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    CharSequence _arg1 = 0 != data.readInt() ? TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(data) : null;
                    int _arg2 = data.readInt();
                    this.onSuggestedReplySent(_arg0, _arg1, _arg2);
                    return true;
                }
                case 19: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    Notification.Action _arg1 = 0 != data.readInt() ? Notification.Action.CREATOR.createFromParcel(data) : null;
                    int _arg2 = data.readInt();
                    this.onActionClicked(_arg0, _arg1, _arg2);
                    return true;
                }
                case 20: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.onNotificationClicked(_arg0);
                    return true;
                }
                case 21: {
                    data.enforceInterface(descriptor);
                    this.onAllowedAdjustmentsChanged();
                    return true;
                }
                case 22: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    NotificationRankingUpdate _arg1 = 0 != data.readInt() ? NotificationRankingUpdate.CREATOR.createFromParcel(data) : null;
                    Bundle _arg2 = 0 != data.readInt() ? Bundle.CREATOR.createFromParcel(data) : null;
                    this.onNotificationFeedbackReceived(_arg0, _arg1, _arg2);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(INotificationListener impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static INotificationListener getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements INotificationListener {
            private IBinder mRemote;
            public static INotificationListener sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onListenerConnected(NotificationRankingUpdate update) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (update != null) {
                        _data.writeInt(1);
                        update.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onListenerConnected(update);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNotificationPosted(IStatusBarNotificationHolder notificationHolder, NotificationRankingUpdate update) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(notificationHolder != null ? notificationHolder.asBinder() : null);
                    if (update != null) {
                        _data.writeInt(1);
                        update.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onNotificationPosted(notificationHolder, update);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onStatusBarIconsBehaviorChanged(boolean hideSilentStatusIcons) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(hideSilentStatusIcons ? 1 : 0);
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onStatusBarIconsBehaviorChanged(hideSilentStatusIcons);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNotificationRemoved(IStatusBarNotificationHolder notificationHolder, NotificationRankingUpdate update, NotificationStats stats, int reason) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(notificationHolder != null ? notificationHolder.asBinder() : null);
                    if (update != null) {
                        _data.writeInt(1);
                        update.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (stats != null) {
                        _data.writeInt(1);
                        stats.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(reason);
                    boolean _status = this.mRemote.transact(4, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onNotificationRemoved(notificationHolder, update, stats, reason);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNotificationRankingUpdate(NotificationRankingUpdate update) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (update != null) {
                        _data.writeInt(1);
                        update.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(5, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onNotificationRankingUpdate(update);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onListenerHintsChanged(int hints) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(hints);
                    boolean _status = this.mRemote.transact(6, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onListenerHintsChanged(hints);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onInterruptionFilterChanged(int interruptionFilter) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(interruptionFilter);
                    boolean _status = this.mRemote.transact(7, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onInterruptionFilterChanged(interruptionFilter);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNotificationChannelModification(String pkgName, UserHandle user, NotificationChannel channel, int modificationType) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkgName);
                    if (user != null) {
                        _data.writeInt(1);
                        user.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (channel != null) {
                        _data.writeInt(1);
                        channel.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(modificationType);
                    boolean _status = this.mRemote.transact(8, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onNotificationChannelModification(pkgName, user, channel, modificationType);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNotificationChannelGroupModification(String pkgName, UserHandle user, NotificationChannelGroup group, int modificationType) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkgName);
                    if (user != null) {
                        _data.writeInt(1);
                        user.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (group != null) {
                        _data.writeInt(1);
                        group.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(modificationType);
                    boolean _status = this.mRemote.transact(9, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onNotificationChannelGroupModification(pkgName, user, group, modificationType);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNotificationEnqueuedWithChannel(IStatusBarNotificationHolder notificationHolder, NotificationChannel channel, NotificationRankingUpdate update) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(notificationHolder != null ? notificationHolder.asBinder() : null);
                    if (channel != null) {
                        _data.writeInt(1);
                        channel.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (update != null) {
                        _data.writeInt(1);
                        update.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(10, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onNotificationEnqueuedWithChannel(notificationHolder, channel, update);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNotificationSnoozedUntilContext(IStatusBarNotificationHolder notificationHolder, String snoozeCriterionId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(notificationHolder != null ? notificationHolder.asBinder() : null);
                    _data.writeString(snoozeCriterionId);
                    boolean _status = this.mRemote.transact(11, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onNotificationSnoozedUntilContext(notificationHolder, snoozeCriterionId);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNotificationsSeen(List<String> keys) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStringList(keys);
                    boolean _status = this.mRemote.transact(12, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onNotificationsSeen(keys);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPanelRevealed(int items) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(items);
                    boolean _status = this.mRemote.transact(13, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onPanelRevealed(items);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onPanelHidden() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(14, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onPanelHidden();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNotificationVisibilityChanged(String key, boolean isVisible) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(key);
                    _data.writeInt(isVisible ? 1 : 0);
                    boolean _status = this.mRemote.transact(15, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onNotificationVisibilityChanged(key, isVisible);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNotificationExpansionChanged(String key, boolean userAction, boolean expanded) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(key);
                    _data.writeInt(userAction ? 1 : 0);
                    _data.writeInt(expanded ? 1 : 0);
                    boolean _status = this.mRemote.transact(16, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onNotificationExpansionChanged(key, userAction, expanded);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNotificationDirectReply(String key) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(key);
                    boolean _status = this.mRemote.transact(17, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onNotificationDirectReply(key);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSuggestedReplySent(String key, CharSequence reply, int source) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(key);
                    if (reply != null) {
                        _data.writeInt(1);
                        TextUtils.writeToParcel(reply, _data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(source);
                    boolean _status = this.mRemote.transact(18, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onSuggestedReplySent(key, reply, source);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onActionClicked(String key, Notification.Action action, int source) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(key);
                    if (action != null) {
                        _data.writeInt(1);
                        action.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(source);
                    boolean _status = this.mRemote.transact(19, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onActionClicked(key, action, source);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNotificationClicked(String key) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(key);
                    boolean _status = this.mRemote.transact(20, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onNotificationClicked(key);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onAllowedAdjustmentsChanged() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(21, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onAllowedAdjustmentsChanged();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNotificationFeedbackReceived(String key, NotificationRankingUpdate update, Bundle feedback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(key);
                    if (update != null) {
                        _data.writeInt(1);
                        update.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (feedback != null) {
                        _data.writeInt(1);
                        feedback.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(22, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onNotificationFeedbackReceived(key, update, feedback);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements INotificationListener {
        @Override
        public void onListenerConnected(NotificationRankingUpdate update) throws RemoteException {
        }

        @Override
        public void onNotificationPosted(IStatusBarNotificationHolder notificationHolder, NotificationRankingUpdate update) throws RemoteException {
        }

        @Override
        public void onStatusBarIconsBehaviorChanged(boolean hideSilentStatusIcons) throws RemoteException {
        }

        @Override
        public void onNotificationRemoved(IStatusBarNotificationHolder notificationHolder, NotificationRankingUpdate update, NotificationStats stats, int reason) throws RemoteException {
        }

        @Override
        public void onNotificationRankingUpdate(NotificationRankingUpdate update) throws RemoteException {
        }

        @Override
        public void onListenerHintsChanged(int hints) throws RemoteException {
        }

        @Override
        public void onInterruptionFilterChanged(int interruptionFilter) throws RemoteException {
        }

        @Override
        public void onNotificationChannelModification(String pkgName, UserHandle user, NotificationChannel channel, int modificationType) throws RemoteException {
        }

        @Override
        public void onNotificationChannelGroupModification(String pkgName, UserHandle user, NotificationChannelGroup group, int modificationType) throws RemoteException {
        }

        @Override
        public void onNotificationEnqueuedWithChannel(IStatusBarNotificationHolder notificationHolder, NotificationChannel channel, NotificationRankingUpdate update) throws RemoteException {
        }

        @Override
        public void onNotificationSnoozedUntilContext(IStatusBarNotificationHolder notificationHolder, String snoozeCriterionId) throws RemoteException {
        }

        @Override
        public void onNotificationsSeen(List<String> keys) throws RemoteException {
        }

        @Override
        public void onPanelRevealed(int items) throws RemoteException {
        }

        @Override
        public void onPanelHidden() throws RemoteException {
        }

        @Override
        public void onNotificationVisibilityChanged(String key, boolean isVisible) throws RemoteException {
        }

        @Override
        public void onNotificationExpansionChanged(String key, boolean userAction, boolean expanded) throws RemoteException {
        }

        @Override
        public void onNotificationDirectReply(String key) throws RemoteException {
        }

        @Override
        public void onSuggestedReplySent(String key, CharSequence reply, int source) throws RemoteException {
        }

        @Override
        public void onActionClicked(String key, Notification.Action action, int source) throws RemoteException {
        }

        @Override
        public void onNotificationClicked(String key) throws RemoteException {
        }

        @Override
        public void onAllowedAdjustmentsChanged() throws RemoteException {
        }

        @Override
        public void onNotificationFeedbackReceived(String key, NotificationRankingUpdate update, Bundle feedback) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

