/*
 * Decompiled with CFR 0.152.
 */
package android.service.notification;

import android.app.ActivityManager;
import android.app.AlarmManager;
import android.app.NotificationManager;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.provider.Settings;
import android.service.notification.Condition;
import android.service.notification.ScheduleCalendar;
import android.service.notification.ZenPolicy;
import android.text.TextUtils;
import android.text.format.DateFormat;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Slog;
import android.util.TypedXmlPullParser;
import android.util.TypedXmlSerializer;
import android.util.proto.ProtoOutputStream;
import com.android.internal.lang.System_Delegate;
import com.android.internal.util.XmlUtils;
import com.android.layoutlib.bridge.android.AndroidLocale;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import java.util.UUID;
import org.xmlpull.v1.XmlPullParserException;

public class ZenModeConfig
implements Parcelable {
    private static String TAG = "ZenModeConfig";
    public static final int SOURCE_ANYONE = 0;
    public static final int SOURCE_CONTACT = 1;
    public static final int SOURCE_STAR = 2;
    public static final int MAX_SOURCE = 2;
    private static final int DEFAULT_SOURCE = 1;
    private static final int DEFAULT_CALLS_SOURCE = 2;
    public static final String MANUAL_RULE_ID = "MANUAL_RULE";
    public static final String EVENTS_DEFAULT_RULE_ID = "EVENTS_DEFAULT_RULE";
    public static final String EVERY_NIGHT_DEFAULT_RULE_ID = "EVERY_NIGHT_DEFAULT_RULE";
    public static final List<String> DEFAULT_RULE_IDS = Arrays.asList("EVERY_NIGHT_DEFAULT_RULE", "EVENTS_DEFAULT_RULE");
    public static final int[] ALL_DAYS = new int[]{1, 2, 3, 4, 5, 6, 7};
    public static final int[] MINUTE_BUCKETS = ZenModeConfig.generateMinuteBuckets();
    private static final int SECONDS_MS = 1000;
    private static final int MINUTES_MS = 60000;
    private static final int DAY_MINUTES = 1440;
    private static final int ZERO_VALUE_MS = 10000;
    private static final boolean DEFAULT_ALLOW_ALARMS = true;
    private static final boolean DEFAULT_ALLOW_MEDIA = true;
    private static final boolean DEFAULT_ALLOW_SYSTEM = false;
    private static final boolean DEFAULT_ALLOW_CALLS = true;
    private static final boolean DEFAULT_ALLOW_MESSAGES = false;
    private static final boolean DEFAULT_ALLOW_REMINDERS = false;
    private static final boolean DEFAULT_ALLOW_EVENTS = false;
    private static final boolean DEFAULT_ALLOW_REPEAT_CALLERS = true;
    private static final boolean DEFAULT_ALLOW_CONV = false;
    private static final int DEFAULT_ALLOW_CONV_FROM = 3;
    private static final boolean DEFAULT_CHANNELS_BYPASSING_DND = false;
    private static final int DEFAULT_SUPPRESSED_VISUAL_EFFECTS = 0;
    public static final int XML_VERSION = 8;
    public static final String ZEN_TAG = "zen";
    private static final String ZEN_ATT_VERSION = "version";
    private static final String ZEN_ATT_USER = "user";
    private static final String ALLOW_TAG = "allow";
    private static final String ALLOW_ATT_ALARMS = "alarms";
    private static final String ALLOW_ATT_MEDIA = "media";
    private static final String ALLOW_ATT_SYSTEM = "system";
    private static final String ALLOW_ATT_CALLS = "calls";
    private static final String ALLOW_ATT_REPEAT_CALLERS = "repeatCallers";
    private static final String ALLOW_ATT_MESSAGES = "messages";
    private static final String ALLOW_ATT_FROM = "from";
    private static final String ALLOW_ATT_CALLS_FROM = "callsFrom";
    private static final String ALLOW_ATT_MESSAGES_FROM = "messagesFrom";
    private static final String ALLOW_ATT_REMINDERS = "reminders";
    private static final String ALLOW_ATT_EVENTS = "events";
    private static final String ALLOW_ATT_SCREEN_OFF = "visualScreenOff";
    private static final String ALLOW_ATT_SCREEN_ON = "visualScreenOn";
    private static final String ALLOW_ATT_CONV = "convos";
    private static final String ALLOW_ATT_CONV_FROM = "convosFrom";
    private static final String DISALLOW_TAG = "disallow";
    private static final String DISALLOW_ATT_VISUAL_EFFECTS = "visualEffects";
    private static final String STATE_TAG = "state";
    private static final String STATE_ATT_CHANNELS_BYPASSING_DND = "areChannelsBypassingDnd";
    private static final String SHOW_ATT_FULL_SCREEN_INTENT = "showFullScreenIntent";
    private static final String SHOW_ATT_LIGHTS = "showLights";
    private static final String SHOW_ATT_PEEK = "shoePeek";
    private static final String SHOW_ATT_STATUS_BAR_ICONS = "showStatusBarIcons";
    private static final String SHOW_ATT_BADGES = "showBadges";
    private static final String SHOW_ATT_AMBIENT = "showAmbient";
    private static final String SHOW_ATT_NOTIFICATION_LIST = "showNotificationList";
    private static final String CONDITION_ATT_ID = "id";
    private static final String CONDITION_ATT_SUMMARY = "summary";
    private static final String CONDITION_ATT_LINE1 = "line1";
    private static final String CONDITION_ATT_LINE2 = "line2";
    private static final String CONDITION_ATT_ICON = "icon";
    private static final String CONDITION_ATT_STATE = "state";
    private static final String CONDITION_ATT_FLAGS = "flags";
    private static final String ZEN_POLICY_TAG = "zen_policy";
    private static final String MANUAL_TAG = "manual";
    private static final String AUTOMATIC_TAG = "automatic";
    private static final String RULE_ATT_ID = "ruleId";
    private static final String RULE_ATT_ENABLED = "enabled";
    private static final String RULE_ATT_SNOOZING = "snoozing";
    private static final String RULE_ATT_NAME = "name";
    private static final String RULE_ATT_PKG = "pkg";
    private static final String RULE_ATT_COMPONENT = "component";
    private static final String RULE_ATT_CONFIG_ACTIVITY = "configActivity";
    private static final String RULE_ATT_ZEN = "zen";
    private static final String RULE_ATT_CONDITION_ID = "conditionId";
    private static final String RULE_ATT_CREATION_TIME = "creationTime";
    private static final String RULE_ATT_ENABLER = "enabler";
    private static final String RULE_ATT_MODIFIED = "modified";
    @UnsupportedAppUsage
    public boolean allowAlarms = true;
    public boolean allowMedia = true;
    public boolean allowSystem = false;
    public boolean allowCalls = true;
    public boolean allowRepeatCallers = true;
    public boolean allowMessages = false;
    public boolean allowReminders = false;
    public boolean allowEvents = false;
    public int allowCallsFrom = 2;
    public int allowMessagesFrom = 1;
    public boolean allowConversations = false;
    public int allowConversationsFrom = 3;
    public int user = 0;
    public int suppressedVisualEffects = 0;
    public boolean areChannelsBypassingDnd = false;
    public int version;
    public ZenRule manualRule;
    @UnsupportedAppUsage
    public ArrayMap<String, ZenRule> automaticRules = new ArrayMap();
    public static final Parcelable.Creator<ZenModeConfig> CREATOR = new Parcelable.Creator<ZenModeConfig>(){

        @Override
        public ZenModeConfig createFromParcel(Parcel source) {
            return new ZenModeConfig(source);
        }

        public ZenModeConfig[] newArray(int size) {
            return new ZenModeConfig[size];
        }
    };
    public static final String SYSTEM_AUTHORITY = "android";
    public static final String COUNTDOWN_PATH = "countdown";
    public static final String IS_ALARM_PATH = "alarm";
    public static final String SCHEDULE_PATH = "schedule";
    public static final String EVENT_PATH = "event";

    @UnsupportedAppUsage
    public ZenModeConfig() {
    }

    public ZenModeConfig(Parcel source) {
        this.allowCalls = source.readInt() == 1;
        this.allowRepeatCallers = source.readInt() == 1;
        this.allowMessages = source.readInt() == 1;
        this.allowReminders = source.readInt() == 1;
        this.allowEvents = source.readInt() == 1;
        this.allowCallsFrom = source.readInt();
        this.allowMessagesFrom = source.readInt();
        this.user = source.readInt();
        this.manualRule = (ZenRule)source.readParcelable(null);
        int len = source.readInt();
        if (len > 0) {
            String[] ids = new String[len];
            ZenRule[] rules = new ZenRule[len];
            source.readStringArray(ids);
            source.readTypedArray(rules, ZenRule.CREATOR);
            for (int i = 0; i < len; ++i) {
                this.automaticRules.put(ids[i], rules[i]);
            }
        }
        this.allowAlarms = source.readInt() == 1;
        this.allowMedia = source.readInt() == 1;
        this.allowSystem = source.readInt() == 1;
        this.suppressedVisualEffects = source.readInt();
        this.areChannelsBypassingDnd = source.readInt() == 1;
        this.allowConversations = source.readBoolean();
        this.allowConversationsFrom = source.readInt();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.allowCalls ? 1 : 0);
        dest.writeInt(this.allowRepeatCallers ? 1 : 0);
        dest.writeInt(this.allowMessages ? 1 : 0);
        dest.writeInt(this.allowReminders ? 1 : 0);
        dest.writeInt(this.allowEvents ? 1 : 0);
        dest.writeInt(this.allowCallsFrom);
        dest.writeInt(this.allowMessagesFrom);
        dest.writeInt(this.user);
        dest.writeParcelable(this.manualRule, 0);
        if (!this.automaticRules.isEmpty()) {
            int len = this.automaticRules.size();
            String[] ids = new String[len];
            Parcelable[] rules = new ZenRule[len];
            for (int i = 0; i < len; ++i) {
                ids[i] = this.automaticRules.keyAt(i);
                rules[i] = this.automaticRules.valueAt(i);
            }
            dest.writeInt(len);
            dest.writeStringArray(ids);
            dest.writeTypedArray(rules, 0);
        } else {
            dest.writeInt(0);
        }
        dest.writeInt(this.allowAlarms ? 1 : 0);
        dest.writeInt(this.allowMedia ? 1 : 0);
        dest.writeInt(this.allowSystem ? 1 : 0);
        dest.writeInt(this.suppressedVisualEffects);
        dest.writeInt(this.areChannelsBypassingDnd ? 1 : 0);
        dest.writeBoolean(this.allowConversations);
        dest.writeInt(this.allowConversationsFrom);
    }

    public String toString() {
        return ZenModeConfig.class.getSimpleName() + '[' + "user=" + this.user + ",allowAlarms=" + this.allowAlarms + ",allowMedia=" + this.allowMedia + ",allowSystem=" + this.allowSystem + ",allowReminders=" + this.allowReminders + ",allowEvents=" + this.allowEvents + ",allowCalls=" + this.allowCalls + ",allowRepeatCallers=" + this.allowRepeatCallers + ",allowMessages=" + this.allowMessages + ",allowConversations=" + this.allowConversations + ",allowCallsFrom=" + ZenModeConfig.sourceToString(this.allowCallsFrom) + ",allowMessagesFrom=" + ZenModeConfig.sourceToString(this.allowMessagesFrom) + ",allowConvFrom=" + ZenPolicy.conversationTypeToString(this.allowConversationsFrom) + ",suppressedVisualEffects=" + this.suppressedVisualEffects + ",areChannelsBypassingDnd=" + this.areChannelsBypassingDnd + ",\nautomaticRules=" + this.rulesToString() + ",\nmanualRule=" + this.manualRule + ']';
    }

    private String rulesToString() {
        if (this.automaticRules.isEmpty()) {
            return "{}";
        }
        StringBuilder buffer = new StringBuilder(this.automaticRules.size() * 28);
        buffer.append("{\n");
        for (int i = 0; i < this.automaticRules.size(); ++i) {
            if (i > 0) {
                buffer.append(",\n");
            }
            ZenRule value = this.automaticRules.valueAt(i);
            buffer.append(value);
        }
        buffer.append('}');
        return buffer.toString();
    }

    public Diff diff(ZenModeConfig to) {
        Diff d = new Diff();
        if (to == null) {
            return d.addLine("config", "delete");
        }
        if (this.user != to.user) {
            d.addLine(ZEN_ATT_USER, this.user, to.user);
        }
        if (this.allowAlarms != to.allowAlarms) {
            d.addLine("allowAlarms", this.allowAlarms, to.allowAlarms);
        }
        if (this.allowMedia != to.allowMedia) {
            d.addLine("allowMedia", this.allowMedia, to.allowMedia);
        }
        if (this.allowSystem != to.allowSystem) {
            d.addLine("allowSystem", this.allowSystem, to.allowSystem);
        }
        if (this.allowCalls != to.allowCalls) {
            d.addLine("allowCalls", this.allowCalls, to.allowCalls);
        }
        if (this.allowReminders != to.allowReminders) {
            d.addLine("allowReminders", this.allowReminders, to.allowReminders);
        }
        if (this.allowEvents != to.allowEvents) {
            d.addLine("allowEvents", this.allowEvents, to.allowEvents);
        }
        if (this.allowRepeatCallers != to.allowRepeatCallers) {
            d.addLine("allowRepeatCallers", this.allowRepeatCallers, to.allowRepeatCallers);
        }
        if (this.allowMessages != to.allowMessages) {
            d.addLine("allowMessages", this.allowMessages, to.allowMessages);
        }
        if (this.allowCallsFrom != to.allowCallsFrom) {
            d.addLine("allowCallsFrom", this.allowCallsFrom, to.allowCallsFrom);
        }
        if (this.allowMessagesFrom != to.allowMessagesFrom) {
            d.addLine("allowMessagesFrom", this.allowMessagesFrom, to.allowMessagesFrom);
        }
        if (this.suppressedVisualEffects != to.suppressedVisualEffects) {
            d.addLine("suppressedVisualEffects", this.suppressedVisualEffects, to.suppressedVisualEffects);
        }
        ArraySet allRules = new ArraySet();
        ZenModeConfig.addKeys(allRules, this.automaticRules);
        ZenModeConfig.addKeys(allRules, to.automaticRules);
        int N = allRules.size();
        for (int i = 0; i < N; ++i) {
            String rule = (String)allRules.valueAt(i);
            ZenRule fromRule = this.automaticRules != null ? this.automaticRules.get(rule) : null;
            ZenRule toRule = to.automaticRules != null ? to.automaticRules.get(rule) : null;
            ZenRule.appendDiff(d, "automaticRule[" + rule + "]", fromRule, toRule);
        }
        ZenRule.appendDiff(d, "manualRule", this.manualRule, to.manualRule);
        if (this.areChannelsBypassingDnd != to.areChannelsBypassingDnd) {
            d.addLine(STATE_ATT_CHANNELS_BYPASSING_DND, this.areChannelsBypassingDnd, to.areChannelsBypassingDnd);
        }
        return d;
    }

    public static Diff diff(ZenModeConfig from, ZenModeConfig to) {
        if (from == null) {
            Diff d = new Diff();
            if (to != null) {
                d.addLine("config", "insert");
            }
            return d;
        }
        return from.diff(to);
    }

    private static <T> void addKeys(ArraySet<T> set, ArrayMap<T, ?> map) {
        if (map != null) {
            for (int i = 0; i < map.size(); ++i) {
                set.add(map.keyAt(i));
            }
        }
    }

    public boolean isValid() {
        if (!ZenModeConfig.isValidManualRule(this.manualRule)) {
            return false;
        }
        int N = this.automaticRules.size();
        for (int i = 0; i < N; ++i) {
            if (ZenModeConfig.isValidAutomaticRule(this.automaticRules.valueAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidManualRule(ZenRule rule) {
        return rule == null || Settings.Global.isValidZenMode(rule.zenMode) && ZenModeConfig.sameCondition(rule);
    }

    private static boolean isValidAutomaticRule(ZenRule rule) {
        return rule != null && !TextUtils.isEmpty(rule.name) && Settings.Global.isValidZenMode(rule.zenMode) && rule.conditionId != null && ZenModeConfig.sameCondition(rule);
    }

    private static boolean sameCondition(ZenRule rule) {
        if (rule == null) {
            return false;
        }
        if (rule.conditionId == null) {
            return rule.condition == null;
        }
        return rule.condition == null || rule.conditionId.equals(rule.condition.id);
    }

    private static int[] generateMinuteBuckets() {
        int maxHrs = 12;
        int[] buckets = new int[15];
        buckets[0] = 15;
        buckets[1] = 30;
        buckets[2] = 45;
        for (int i = 1; i <= 12; ++i) {
            buckets[2 + i] = 60 * i;
        }
        return buckets;
    }

    public static String sourceToString(int source) {
        switch (source) {
            case 0: {
                return "anyone";
            }
            case 1: {
                return "contacts";
            }
            case 2: {
                return "stars";
            }
        }
        return "UNKNOWN";
    }

    public boolean equals(Object o) {
        if (!(o instanceof ZenModeConfig)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        ZenModeConfig other = (ZenModeConfig)o;
        return other.allowAlarms == this.allowAlarms && other.allowMedia == this.allowMedia && other.allowSystem == this.allowSystem && other.allowCalls == this.allowCalls && other.allowRepeatCallers == this.allowRepeatCallers && other.allowMessages == this.allowMessages && other.allowCallsFrom == this.allowCallsFrom && other.allowMessagesFrom == this.allowMessagesFrom && other.allowReminders == this.allowReminders && other.allowEvents == this.allowEvents && other.user == this.user && Objects.equals(other.automaticRules, this.automaticRules) && Objects.equals(other.manualRule, this.manualRule) && other.suppressedVisualEffects == this.suppressedVisualEffects && other.areChannelsBypassingDnd == this.areChannelsBypassingDnd && other.allowConversations == this.allowConversations && other.allowConversationsFrom == this.allowConversationsFrom;
    }

    public int hashCode() {
        return Objects.hash(this.allowAlarms, this.allowMedia, this.allowSystem, this.allowCalls, this.allowRepeatCallers, this.allowMessages, this.allowCallsFrom, this.allowMessagesFrom, this.allowReminders, this.allowEvents, this.user, this.automaticRules, this.manualRule, this.suppressedVisualEffects, this.areChannelsBypassingDnd, this.allowConversations, this.allowConversationsFrom);
    }

    private static String toDayList(int[] days) {
        if (days == null || days.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < days.length; ++i) {
            if (i > 0) {
                sb.append('.');
            }
            sb.append(days[i]);
        }
        return sb.toString();
    }

    private static int[] tryParseDayList(String dayList, String sep) {
        if (dayList == null) {
            return null;
        }
        String[] tokens = dayList.split(sep);
        if (tokens.length == 0) {
            return null;
        }
        int[] rt = new int[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            int day = ZenModeConfig.tryParseInt(tokens[i], -1);
            if (day == -1) {
                return null;
            }
            rt[i] = day;
        }
        return rt;
    }

    private static int tryParseInt(String value, int defValue) {
        if (TextUtils.isEmpty(value)) {
            return defValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defValue;
        }
    }

    private static long tryParseLong(String value, long defValue) {
        if (TextUtils.isEmpty(value)) {
            return defValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return defValue;
        }
    }

    private static Long tryParseLong(String value, Long defValue) {
        if (TextUtils.isEmpty(value)) {
            return defValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return defValue;
        }
    }

    public static ZenModeConfig readXml(TypedXmlPullParser parser) throws XmlPullParserException, IOException {
        int type = parser.getEventType();
        if (type != 2) {
            return null;
        }
        String tag = parser.getName();
        if (!"zen".equals(tag)) {
            return null;
        }
        ZenModeConfig rt = new ZenModeConfig();
        rt.version = ZenModeConfig.safeInt(parser, ZEN_ATT_VERSION, 8);
        rt.user = ZenModeConfig.safeInt(parser, ZEN_ATT_USER, rt.user);
        boolean readSuppressedEffects = false;
        while ((type = parser.next()) != 1) {
            tag = parser.getName();
            if (type == 3 && "zen".equals(tag)) {
                return rt;
            }
            if (type != 2) continue;
            if (ALLOW_TAG.equals(tag)) {
                Boolean allowWhenScreenOn;
                rt.allowCalls = ZenModeConfig.safeBoolean(parser, ALLOW_ATT_CALLS, true);
                rt.allowRepeatCallers = ZenModeConfig.safeBoolean(parser, ALLOW_ATT_REPEAT_CALLERS, true);
                rt.allowMessages = ZenModeConfig.safeBoolean(parser, ALLOW_ATT_MESSAGES, false);
                rt.allowReminders = ZenModeConfig.safeBoolean(parser, ALLOW_ATT_REMINDERS, false);
                rt.allowConversations = ZenModeConfig.safeBoolean(parser, ALLOW_ATT_CONV, false);
                rt.allowEvents = ZenModeConfig.safeBoolean(parser, ALLOW_ATT_EVENTS, false);
                int from = ZenModeConfig.safeInt(parser, ALLOW_ATT_FROM, -1);
                int callsFrom = ZenModeConfig.safeInt(parser, ALLOW_ATT_CALLS_FROM, -1);
                int messagesFrom = ZenModeConfig.safeInt(parser, ALLOW_ATT_MESSAGES_FROM, -1);
                rt.allowConversationsFrom = ZenModeConfig.safeInt(parser, ALLOW_ATT_CONV_FROM, 3);
                if (ZenModeConfig.isValidSource(callsFrom) && ZenModeConfig.isValidSource(messagesFrom)) {
                    rt.allowCallsFrom = callsFrom;
                    rt.allowMessagesFrom = messagesFrom;
                } else if (ZenModeConfig.isValidSource(from)) {
                    Slog.i(TAG, "Migrating existing shared 'from': " + ZenModeConfig.sourceToString(from));
                    rt.allowCallsFrom = from;
                    rt.allowMessagesFrom = from;
                } else {
                    rt.allowCallsFrom = 2;
                    rt.allowMessagesFrom = 1;
                }
                rt.allowAlarms = ZenModeConfig.safeBoolean(parser, ALLOW_ATT_ALARMS, true);
                rt.allowMedia = ZenModeConfig.safeBoolean(parser, ALLOW_ATT_MEDIA, true);
                rt.allowSystem = ZenModeConfig.safeBoolean(parser, ALLOW_ATT_SYSTEM, false);
                Boolean allowWhenScreenOff = ZenModeConfig.unsafeBoolean(parser, ALLOW_ATT_SCREEN_OFF);
                if (allowWhenScreenOff != null) {
                    readSuppressedEffects = true;
                    if (!allowWhenScreenOff.booleanValue()) {
                        rt.suppressedVisualEffects |= 0xC;
                    }
                }
                if ((allowWhenScreenOn = ZenModeConfig.unsafeBoolean(parser, ALLOW_ATT_SCREEN_ON)) != null) {
                    readSuppressedEffects = true;
                    if (!allowWhenScreenOn.booleanValue()) {
                        rt.suppressedVisualEffects |= 0x10;
                    }
                }
                if (!readSuppressedEffects) continue;
                Slog.d(TAG, "Migrated visual effects to " + rt.suppressedVisualEffects);
                continue;
            }
            if (DISALLOW_TAG.equals(tag) && !readSuppressedEffects) {
                rt.suppressedVisualEffects = ZenModeConfig.safeInt(parser, DISALLOW_ATT_VISUAL_EFFECTS, 0);
                continue;
            }
            if (MANUAL_TAG.equals(tag)) {
                rt.manualRule = ZenModeConfig.readRuleXml(parser);
                continue;
            }
            if (AUTOMATIC_TAG.equals(tag)) {
                String id2 = parser.getAttributeValue(null, RULE_ATT_ID);
                ZenRule automaticRule = ZenModeConfig.readRuleXml(parser);
                if (id2 == null || automaticRule == null) continue;
                automaticRule.id = id2;
                rt.automaticRules.put(id2, automaticRule);
                continue;
            }
            if (!"state".equals(tag)) continue;
            rt.areChannelsBypassingDnd = ZenModeConfig.safeBoolean(parser, STATE_ATT_CHANNELS_BYPASSING_DND, false);
        }
        throw new IllegalStateException("Failed to reach END_DOCUMENT");
    }

    public void writeXml(TypedXmlSerializer out, Integer version) throws IOException {
        out.startTag(null, "zen");
        out.attribute(null, ZEN_ATT_VERSION, version == null ? Integer.toString(8) : Integer.toString(version));
        out.attributeInt(null, ZEN_ATT_USER, this.user);
        out.startTag(null, ALLOW_TAG);
        out.attributeBoolean(null, ALLOW_ATT_CALLS, this.allowCalls);
        out.attributeBoolean(null, ALLOW_ATT_REPEAT_CALLERS, this.allowRepeatCallers);
        out.attributeBoolean(null, ALLOW_ATT_MESSAGES, this.allowMessages);
        out.attributeBoolean(null, ALLOW_ATT_REMINDERS, this.allowReminders);
        out.attributeBoolean(null, ALLOW_ATT_EVENTS, this.allowEvents);
        out.attributeInt(null, ALLOW_ATT_CALLS_FROM, this.allowCallsFrom);
        out.attributeInt(null, ALLOW_ATT_MESSAGES_FROM, this.allowMessagesFrom);
        out.attributeBoolean(null, ALLOW_ATT_ALARMS, this.allowAlarms);
        out.attributeBoolean(null, ALLOW_ATT_MEDIA, this.allowMedia);
        out.attributeBoolean(null, ALLOW_ATT_SYSTEM, this.allowSystem);
        out.attributeBoolean(null, ALLOW_ATT_CONV, this.allowConversations);
        out.attributeInt(null, ALLOW_ATT_CONV_FROM, this.allowConversationsFrom);
        out.endTag(null, ALLOW_TAG);
        out.startTag(null, DISALLOW_TAG);
        out.attributeInt(null, DISALLOW_ATT_VISUAL_EFFECTS, this.suppressedVisualEffects);
        out.endTag(null, DISALLOW_TAG);
        if (this.manualRule != null) {
            out.startTag(null, MANUAL_TAG);
            ZenModeConfig.writeRuleXml(this.manualRule, out);
            out.endTag(null, MANUAL_TAG);
        }
        int N = this.automaticRules.size();
        for (int i = 0; i < N; ++i) {
            String id2 = this.automaticRules.keyAt(i);
            ZenRule automaticRule = this.automaticRules.valueAt(i);
            out.startTag(null, AUTOMATIC_TAG);
            out.attribute(null, RULE_ATT_ID, id2);
            ZenModeConfig.writeRuleXml(automaticRule, out);
            out.endTag(null, AUTOMATIC_TAG);
        }
        out.startTag(null, "state");
        out.attributeBoolean(null, STATE_ATT_CHANNELS_BYPASSING_DND, this.areChannelsBypassingDnd);
        out.endTag(null, "state");
        out.endTag(null, "zen");
    }

    public static ZenRule readRuleXml(TypedXmlPullParser parser) {
        ZenRule rt = new ZenRule();
        rt.enabled = ZenModeConfig.safeBoolean(parser, RULE_ATT_ENABLED, true);
        rt.name = parser.getAttributeValue(null, RULE_ATT_NAME);
        String zen = parser.getAttributeValue(null, "zen");
        rt.zenMode = ZenModeConfig.tryParseZenMode(zen, -1);
        if (rt.zenMode == -1) {
            Slog.w(TAG, "Bad zen mode in rule xml:" + zen);
            return null;
        }
        rt.conditionId = ZenModeConfig.safeUri(parser, RULE_ATT_CONDITION_ID);
        rt.component = ZenModeConfig.safeComponentName(parser, RULE_ATT_COMPONENT);
        rt.configurationActivity = ZenModeConfig.safeComponentName(parser, RULE_ATT_CONFIG_ACTIVITY);
        rt.pkg = XmlUtils.readStringAttribute(parser, RULE_ATT_PKG);
        if (rt.pkg == null) {
            rt.pkg = rt.component != null ? rt.component.getPackageName() : null;
        }
        rt.creationTime = ZenModeConfig.safeLong(parser, RULE_ATT_CREATION_TIME, 0L);
        rt.enabler = parser.getAttributeValue(null, RULE_ATT_ENABLER);
        rt.condition = ZenModeConfig.readConditionXml(parser);
        if (rt.zenMode != 1 && Condition.isValidId(rt.conditionId, SYSTEM_AUTHORITY)) {
            Slog.i(TAG, "Updating zenMode of automatic rule " + rt.name);
            rt.zenMode = 1;
        }
        rt.modified = ZenModeConfig.safeBoolean(parser, RULE_ATT_MODIFIED, false);
        rt.zenPolicy = ZenModeConfig.readZenPolicyXml(parser);
        return rt;
    }

    public static void writeRuleXml(ZenRule rule, TypedXmlSerializer out) throws IOException {
        out.attributeBoolean(null, RULE_ATT_ENABLED, rule.enabled);
        if (rule.name != null) {
            out.attribute(null, RULE_ATT_NAME, rule.name);
        }
        out.attributeInt(null, "zen", rule.zenMode);
        if (rule.pkg != null) {
            out.attribute(null, RULE_ATT_PKG, rule.pkg);
        }
        if (rule.component != null) {
            out.attribute(null, RULE_ATT_COMPONENT, rule.component.flattenToString());
        }
        if (rule.configurationActivity != null) {
            out.attribute(null, RULE_ATT_CONFIG_ACTIVITY, rule.configurationActivity.flattenToString());
        }
        if (rule.conditionId != null) {
            out.attribute(null, RULE_ATT_CONDITION_ID, rule.conditionId.toString());
        }
        out.attributeLong(null, RULE_ATT_CREATION_TIME, rule.creationTime);
        if (rule.enabler != null) {
            out.attribute(null, RULE_ATT_ENABLER, rule.enabler);
        }
        if (rule.condition != null) {
            ZenModeConfig.writeConditionXml(rule.condition, out);
        }
        if (rule.zenPolicy != null) {
            ZenModeConfig.writeZenPolicyXml(rule.zenPolicy, out);
        }
        out.attributeBoolean(null, RULE_ATT_MODIFIED, rule.modified);
    }

    public static Condition readConditionXml(TypedXmlPullParser parser) {
        Uri id2 = ZenModeConfig.safeUri(parser, CONDITION_ATT_ID);
        if (id2 == null) {
            return null;
        }
        String summary = parser.getAttributeValue(null, CONDITION_ATT_SUMMARY);
        String line1 = parser.getAttributeValue(null, CONDITION_ATT_LINE1);
        String line2 = parser.getAttributeValue(null, CONDITION_ATT_LINE2);
        int icon = ZenModeConfig.safeInt(parser, CONDITION_ATT_ICON, -1);
        int state = ZenModeConfig.safeInt(parser, "state", -1);
        int flags = ZenModeConfig.safeInt(parser, CONDITION_ATT_FLAGS, -1);
        try {
            return new Condition(id2, summary, line1, line2, icon, state, flags);
        }
        catch (IllegalArgumentException e) {
            Slog.w(TAG, "Unable to read condition xml", e);
            return null;
        }
    }

    public static void writeConditionXml(Condition c, TypedXmlSerializer out) throws IOException {
        out.attribute(null, CONDITION_ATT_ID, c.id.toString());
        out.attribute(null, CONDITION_ATT_SUMMARY, c.summary);
        out.attribute(null, CONDITION_ATT_LINE1, c.line1);
        out.attribute(null, CONDITION_ATT_LINE2, c.line2);
        out.attributeInt(null, CONDITION_ATT_ICON, c.icon);
        out.attributeInt(null, "state", c.state);
        out.attributeInt(null, CONDITION_ATT_FLAGS, c.flags);
    }

    public static ZenPolicy readZenPolicyXml(TypedXmlPullParser parser) {
        boolean policySet = false;
        ZenPolicy.Builder builder = new ZenPolicy.Builder();
        int calls = ZenModeConfig.safeInt(parser, ALLOW_ATT_CALLS_FROM, 0);
        int messages = ZenModeConfig.safeInt(parser, ALLOW_ATT_MESSAGES_FROM, 0);
        int repeatCallers = ZenModeConfig.safeInt(parser, ALLOW_ATT_REPEAT_CALLERS, 0);
        int alarms = ZenModeConfig.safeInt(parser, ALLOW_ATT_ALARMS, 0);
        int media = ZenModeConfig.safeInt(parser, ALLOW_ATT_MEDIA, 0);
        int system = ZenModeConfig.safeInt(parser, ALLOW_ATT_SYSTEM, 0);
        int events = ZenModeConfig.safeInt(parser, ALLOW_ATT_EVENTS, 0);
        int reminders = ZenModeConfig.safeInt(parser, ALLOW_ATT_REMINDERS, 0);
        if (calls != 0) {
            builder.allowCalls(calls);
            policySet = true;
        }
        if (messages != 0) {
            builder.allowMessages(messages);
            policySet = true;
        }
        if (repeatCallers != 0) {
            builder.allowRepeatCallers(repeatCallers == 1);
            policySet = true;
        }
        if (alarms != 0) {
            builder.allowAlarms(alarms == 1);
            policySet = true;
        }
        if (media != 0) {
            builder.allowMedia(media == 1);
            policySet = true;
        }
        if (system != 0) {
            builder.allowSystem(system == 1);
            policySet = true;
        }
        if (events != 0) {
            builder.allowEvents(events == 1);
            policySet = true;
        }
        if (reminders != 0) {
            builder.allowReminders(reminders == 1);
            policySet = true;
        }
        int fullScreenIntent = ZenModeConfig.safeInt(parser, SHOW_ATT_FULL_SCREEN_INTENT, 0);
        int lights = ZenModeConfig.safeInt(parser, SHOW_ATT_LIGHTS, 0);
        int peek = ZenModeConfig.safeInt(parser, SHOW_ATT_PEEK, 0);
        int statusBar = ZenModeConfig.safeInt(parser, SHOW_ATT_STATUS_BAR_ICONS, 0);
        int badges = ZenModeConfig.safeInt(parser, SHOW_ATT_BADGES, 0);
        int ambient = ZenModeConfig.safeInt(parser, SHOW_ATT_AMBIENT, 0);
        int notificationList = ZenModeConfig.safeInt(parser, SHOW_ATT_NOTIFICATION_LIST, 0);
        if (fullScreenIntent != 0) {
            builder.showFullScreenIntent(fullScreenIntent == 1);
            policySet = true;
        }
        if (lights != 0) {
            builder.showLights(lights == 1);
            policySet = true;
        }
        if (peek != 0) {
            builder.showPeeking(peek == 1);
            policySet = true;
        }
        if (statusBar != 0) {
            builder.showStatusBarIcons(statusBar == 1);
            policySet = true;
        }
        if (badges != 0) {
            builder.showBadges(badges == 1);
            policySet = true;
        }
        if (ambient != 0) {
            builder.showInAmbientDisplay(ambient == 1);
            policySet = true;
        }
        if (notificationList != 0) {
            builder.showInNotificationList(notificationList == 1);
            policySet = true;
        }
        if (policySet) {
            return builder.build();
        }
        return null;
    }

    public static void writeZenPolicyXml(ZenPolicy policy, TypedXmlSerializer out) throws IOException {
        ZenModeConfig.writeZenPolicyState(ALLOW_ATT_CALLS_FROM, policy.getPriorityCallSenders(), out);
        ZenModeConfig.writeZenPolicyState(ALLOW_ATT_MESSAGES_FROM, policy.getPriorityMessageSenders(), out);
        ZenModeConfig.writeZenPolicyState(ALLOW_ATT_REPEAT_CALLERS, policy.getPriorityCategoryRepeatCallers(), out);
        ZenModeConfig.writeZenPolicyState(ALLOW_ATT_ALARMS, policy.getPriorityCategoryAlarms(), out);
        ZenModeConfig.writeZenPolicyState(ALLOW_ATT_MEDIA, policy.getPriorityCategoryMedia(), out);
        ZenModeConfig.writeZenPolicyState(ALLOW_ATT_SYSTEM, policy.getPriorityCategorySystem(), out);
        ZenModeConfig.writeZenPolicyState(ALLOW_ATT_REMINDERS, policy.getPriorityCategoryReminders(), out);
        ZenModeConfig.writeZenPolicyState(ALLOW_ATT_EVENTS, policy.getPriorityCategoryEvents(), out);
        ZenModeConfig.writeZenPolicyState(SHOW_ATT_FULL_SCREEN_INTENT, policy.getVisualEffectFullScreenIntent(), out);
        ZenModeConfig.writeZenPolicyState(SHOW_ATT_LIGHTS, policy.getVisualEffectLights(), out);
        ZenModeConfig.writeZenPolicyState(SHOW_ATT_PEEK, policy.getVisualEffectPeek(), out);
        ZenModeConfig.writeZenPolicyState(SHOW_ATT_STATUS_BAR_ICONS, policy.getVisualEffectStatusBar(), out);
        ZenModeConfig.writeZenPolicyState(SHOW_ATT_BADGES, policy.getVisualEffectBadge(), out);
        ZenModeConfig.writeZenPolicyState(SHOW_ATT_AMBIENT, policy.getVisualEffectAmbient(), out);
        ZenModeConfig.writeZenPolicyState(SHOW_ATT_NOTIFICATION_LIST, policy.getVisualEffectNotificationList(), out);
    }

    private static void writeZenPolicyState(String attr2, int val, TypedXmlSerializer out) throws IOException {
        if (Objects.equals(attr2, ALLOW_ATT_CALLS_FROM) || Objects.equals(attr2, ALLOW_ATT_MESSAGES_FROM)) {
            if (val != 0) {
                out.attributeInt(null, attr2, val);
            }
        } else if (val != 0) {
            out.attributeInt(null, attr2, val);
        }
    }

    public static boolean isValidHour(int val) {
        return val >= 0 && val < 24;
    }

    public static boolean isValidMinute(int val) {
        return val >= 0 && val < 60;
    }

    private static boolean isValidSource(int source) {
        return source >= 0 && source <= 2;
    }

    private static Boolean unsafeBoolean(TypedXmlPullParser parser, String att) {
        try {
            return parser.getAttributeBoolean(null, att);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static boolean safeBoolean(TypedXmlPullParser parser, String att, boolean defValue) {
        return parser.getAttributeBoolean(null, att, defValue);
    }

    private static boolean safeBoolean(String val, boolean defValue) {
        if (TextUtils.isEmpty(val)) {
            return defValue;
        }
        return Boolean.parseBoolean(val);
    }

    private static int safeInt(TypedXmlPullParser parser, String att, int defValue) {
        return parser.getAttributeInt(null, att, defValue);
    }

    private static ComponentName safeComponentName(TypedXmlPullParser parser, String att) {
        String val = parser.getAttributeValue(null, att);
        if (TextUtils.isEmpty(val)) {
            return null;
        }
        return ComponentName.unflattenFromString(val);
    }

    private static Uri safeUri(TypedXmlPullParser parser, String att) {
        String val = parser.getAttributeValue(null, att);
        if (TextUtils.isEmpty(val)) {
            return null;
        }
        return Uri.parse(val);
    }

    private static long safeLong(TypedXmlPullParser parser, String att, long defValue) {
        String val = parser.getAttributeValue(null, att);
        return ZenModeConfig.tryParseLong(val, defValue);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public ZenModeConfig copy() {
        Parcel parcel = Parcel.obtain();
        try {
            this.writeToParcel(parcel, 0);
            parcel.setDataPosition(0);
            ZenModeConfig zenModeConfig = new ZenModeConfig(parcel);
            return zenModeConfig;
        }
        finally {
            parcel.recycle();
        }
    }

    public ZenPolicy toZenPolicy() {
        ZenPolicy.Builder builder = new ZenPolicy.Builder().allowCalls(this.allowCalls ? ZenModeConfig.getZenPolicySenders(this.allowCallsFrom) : 4).allowRepeatCallers(this.allowRepeatCallers).allowMessages(this.allowMessages ? ZenModeConfig.getZenPolicySenders(this.allowMessagesFrom) : 4).allowReminders(this.allowReminders).allowEvents(this.allowEvents).allowAlarms(this.allowAlarms).allowMedia(this.allowMedia).allowSystem(this.allowSystem).allowConversations(this.allowConversations ? ZenModeConfig.getZenPolicySenders(this.allowConversationsFrom) : 4);
        if (this.suppressedVisualEffects == 0) {
            builder.showAllVisualEffects();
        } else {
            builder.showFullScreenIntent((this.suppressedVisualEffects & 4) == 0);
            builder.showLights((this.suppressedVisualEffects & 8) == 0);
            builder.showPeeking((this.suppressedVisualEffects & 0x10) == 0);
            builder.showStatusBarIcons((this.suppressedVisualEffects & 0x20) == 0);
            builder.showBadges((this.suppressedVisualEffects & 0x40) == 0);
            builder.showInAmbientDisplay((this.suppressedVisualEffects & 0x80) == 0);
            builder.showInNotificationList((this.suppressedVisualEffects & 0x100) == 0);
        }
        return builder.build();
    }

    public NotificationManager.Policy toNotificationPolicy(ZenPolicy zenPolicy) {
        boolean suppressAmbient;
        NotificationManager.Policy defaultPolicy = this.toNotificationPolicy();
        int priorityCategories = 0;
        int suppressedVisualEffects = 0;
        int callSenders = defaultPolicy.priorityCallSenders;
        int messageSenders = defaultPolicy.priorityMessageSenders;
        int conversationSenders = defaultPolicy.priorityConversationSenders;
        if (zenPolicy.isCategoryAllowed(0, this.isPriorityCategoryEnabled(1, defaultPolicy))) {
            priorityCategories |= 1;
        }
        if (zenPolicy.isCategoryAllowed(1, this.isPriorityCategoryEnabled(2, defaultPolicy))) {
            priorityCategories |= 2;
        }
        if (zenPolicy.isCategoryAllowed(2, this.isPriorityCategoryEnabled(4, defaultPolicy))) {
            priorityCategories |= 4;
            messageSenders = this.getNotificationPolicySenders(zenPolicy.getPriorityMessageSenders(), messageSenders);
        }
        if (zenPolicy.isCategoryAllowed(8, this.isPriorityCategoryEnabled(256, defaultPolicy))) {
            priorityCategories |= 0x100;
            conversationSenders = this.getNotificationPolicySenders(zenPolicy.getPriorityConversationSenders(), conversationSenders);
        }
        if (zenPolicy.isCategoryAllowed(3, this.isPriorityCategoryEnabled(8, defaultPolicy))) {
            priorityCategories |= 8;
            callSenders = this.getNotificationPolicySenders(zenPolicy.getPriorityCallSenders(), callSenders);
        }
        if (zenPolicy.isCategoryAllowed(4, this.isPriorityCategoryEnabled(16, defaultPolicy))) {
            priorityCategories |= 0x10;
        }
        if (zenPolicy.isCategoryAllowed(5, this.isPriorityCategoryEnabled(32, defaultPolicy))) {
            priorityCategories |= 0x20;
        }
        if (zenPolicy.isCategoryAllowed(6, this.isPriorityCategoryEnabled(64, defaultPolicy))) {
            priorityCategories |= 0x40;
        }
        if (zenPolicy.isCategoryAllowed(7, this.isPriorityCategoryEnabled(128, defaultPolicy))) {
            priorityCategories |= 0x80;
        }
        boolean suppressFullScreenIntent = !zenPolicy.isVisualEffectAllowed(0, this.isVisualEffectAllowed(4, defaultPolicy));
        boolean suppressLights = !zenPolicy.isVisualEffectAllowed(1, this.isVisualEffectAllowed(8, defaultPolicy));
        boolean bl = suppressAmbient = !zenPolicy.isVisualEffectAllowed(5, this.isVisualEffectAllowed(128, defaultPolicy));
        if (suppressFullScreenIntent && suppressLights && suppressAmbient) {
            suppressedVisualEffects |= 1;
        }
        if (suppressFullScreenIntent) {
            suppressedVisualEffects |= 4;
        }
        if (suppressLights) {
            suppressedVisualEffects |= 8;
        }
        if (!zenPolicy.isVisualEffectAllowed(2, this.isVisualEffectAllowed(16, defaultPolicy))) {
            suppressedVisualEffects |= 0x10;
            suppressedVisualEffects |= 2;
        }
        if (!zenPolicy.isVisualEffectAllowed(3, this.isVisualEffectAllowed(32, defaultPolicy))) {
            suppressedVisualEffects |= 0x20;
        }
        if (!zenPolicy.isVisualEffectAllowed(4, this.isVisualEffectAllowed(64, defaultPolicy))) {
            suppressedVisualEffects |= 0x40;
        }
        if (suppressAmbient) {
            suppressedVisualEffects |= 0x80;
        }
        if (!zenPolicy.isVisualEffectAllowed(6, this.isVisualEffectAllowed(256, defaultPolicy))) {
            suppressedVisualEffects |= 0x100;
        }
        return new NotificationManager.Policy(priorityCategories, callSenders, messageSenders, suppressedVisualEffects, defaultPolicy.state, conversationSenders);
    }

    private boolean isPriorityCategoryEnabled(int categoryType, NotificationManager.Policy policy) {
        return (policy.priorityCategories & categoryType) != 0;
    }

    private boolean isVisualEffectAllowed(int visualEffect, NotificationManager.Policy policy) {
        return (policy.suppressedVisualEffects & visualEffect) == 0;
    }

    private int getNotificationPolicySenders(int senders, int defaultPolicySender) {
        switch (senders) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
        }
        return defaultPolicySender;
    }

    public static int getZenPolicySenders(int senders) {
        switch (senders) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
        }
        return 3;
    }

    public NotificationManager.Policy toNotificationPolicy() {
        int priorityCategories = 0;
        int priorityCallSenders = 1;
        int priorityMessageSenders = 1;
        int priorityConversationSenders = 2;
        if (this.allowConversations) {
            priorityCategories |= 0x100;
        }
        if (this.allowCalls) {
            priorityCategories |= 8;
        }
        if (this.allowMessages) {
            priorityCategories |= 4;
        }
        if (this.allowEvents) {
            priorityCategories |= 2;
        }
        if (this.allowReminders) {
            priorityCategories |= 1;
        }
        if (this.allowRepeatCallers) {
            priorityCategories |= 0x10;
        }
        if (this.allowAlarms) {
            priorityCategories |= 0x20;
        }
        if (this.allowMedia) {
            priorityCategories |= 0x40;
        }
        if (this.allowSystem) {
            priorityCategories |= 0x80;
        }
        priorityCallSenders = ZenModeConfig.sourceToPrioritySenders(this.allowCallsFrom, priorityCallSenders);
        priorityMessageSenders = ZenModeConfig.sourceToPrioritySenders(this.allowMessagesFrom, priorityMessageSenders);
        priorityConversationSenders = this.allowConversationsFrom;
        return new NotificationManager.Policy(priorityCategories, priorityCallSenders, priorityMessageSenders, this.suppressedVisualEffects, this.areChannelsBypassingDnd ? 1 : 0, priorityConversationSenders);
    }

    public static ScheduleCalendar toScheduleCalendar(Uri conditionId) {
        ScheduleInfo schedule = ZenModeConfig.tryParseScheduleConditionId(conditionId);
        if (schedule == null || schedule.days == null || schedule.days.length == 0) {
            return null;
        }
        ScheduleCalendar sc = new ScheduleCalendar();
        sc.setSchedule(schedule);
        sc.setTimeZone(TimeZone.getDefault());
        return sc;
    }

    private static int sourceToPrioritySenders(int source, int def) {
        switch (source) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        return def;
    }

    private static int prioritySendersToSource(int prioritySenders, int def) {
        switch (prioritySenders) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 0: {
                return 0;
            }
        }
        return def;
    }

    private static int normalizePrioritySenders(int prioritySenders, int def) {
        if (prioritySenders != 1 && prioritySenders != 2 && prioritySenders != 0) {
            return def;
        }
        return prioritySenders;
    }

    private static int normalizeConversationSenders(boolean allowed, int senders, int def) {
        if (!allowed) {
            return 3;
        }
        if (senders != 1 && senders != 2 && senders != 3) {
            return def;
        }
        return senders;
    }

    public void applyNotificationPolicy(NotificationManager.Policy policy) {
        if (policy == null) {
            return;
        }
        this.allowAlarms = (policy.priorityCategories & 0x20) != 0;
        this.allowMedia = (policy.priorityCategories & 0x40) != 0;
        this.allowSystem = (policy.priorityCategories & 0x80) != 0;
        this.allowEvents = (policy.priorityCategories & 2) != 0;
        this.allowReminders = (policy.priorityCategories & 1) != 0;
        this.allowCalls = (policy.priorityCategories & 8) != 0;
        this.allowMessages = (policy.priorityCategories & 4) != 0;
        this.allowRepeatCallers = (policy.priorityCategories & 0x10) != 0;
        this.allowCallsFrom = ZenModeConfig.normalizePrioritySenders(policy.priorityCallSenders, this.allowCallsFrom);
        this.allowMessagesFrom = ZenModeConfig.normalizePrioritySenders(policy.priorityMessageSenders, this.allowMessagesFrom);
        if (policy.suppressedVisualEffects != -1) {
            this.suppressedVisualEffects = policy.suppressedVisualEffects;
        }
        this.allowConversations = (policy.priorityCategories & 0x100) != 0;
        this.allowConversationsFrom = ZenModeConfig.normalizeConversationSenders(this.allowConversations, policy.priorityConversationSenders, this.allowConversationsFrom);
        if (policy.state != -1) {
            this.areChannelsBypassingDnd = (policy.state & 1) != 0;
        }
    }

    public static Condition toTimeCondition(Context context, int minutesFromNow, int userHandle) {
        return ZenModeConfig.toTimeCondition(context, minutesFromNow, userHandle, false);
    }

    public static Condition toTimeCondition(Context context, int minutesFromNow, int userHandle, boolean shortVersion) {
        long now = System_Delegate.currentTimeMillis();
        long millis = minutesFromNow == 0 ? 10000L : (long)(minutesFromNow * 60000);
        return ZenModeConfig.toTimeCondition(context, now + millis, minutesFromNow, userHandle, shortVersion);
    }

    public static Condition toTimeCondition(Context context, long time, int minutes, int userHandle, boolean shortVersion) {
        String line2;
        String line1;
        String summary;
        int summaryResId;
        CharSequence formattedTime = ZenModeConfig.getFormattedTime(context, time, ZenModeConfig.isToday(time), userHandle);
        Resources res = context.getResources();
        if (minutes < 60) {
            int num = minutes;
            summaryResId = shortVersion ? 18153505 : 18153504;
            summary = res.getQuantityString(summaryResId, num, num, formattedTime);
            int line1ResId = shortVersion ? 18153503 : 18153502;
            line1 = res.getQuantityString(line1ResId, num, num, formattedTime);
            line2 = res.getString(17041680, formattedTime);
        } else if (minutes < 1440) {
            int num = Math.round((float)minutes / 60.0f);
            summaryResId = shortVersion ? 18153501 : 18153500;
            summary = res.getQuantityString(summaryResId, num, num, formattedTime);
            int line1ResId = shortVersion ? 18153499 : 18153498;
            line1 = res.getQuantityString(line1ResId, num, num, formattedTime);
            line2 = res.getString(17041680, formattedTime);
        } else {
            line1 = line2 = res.getString(17041681, formattedTime);
            summary = line2;
        }
        Uri id2 = ZenModeConfig.toCountdownConditionId(time, false);
        return new Condition(id2, summary, line1, line2, 0, 1, 1);
    }

    public static Condition toNextAlarmCondition(Context context, long alarm, int userHandle) {
        boolean isSameDay = ZenModeConfig.isToday(alarm);
        CharSequence formattedTime = ZenModeConfig.getFormattedTime(context, alarm, isSameDay, userHandle);
        Resources res = context.getResources();
        String line1 = res.getString(17041680, formattedTime);
        Uri id2 = ZenModeConfig.toCountdownConditionId(alarm, true);
        return new Condition(id2, "", line1, "", 0, 1, 1);
    }

    public static CharSequence getFormattedTime(Context context, long time, boolean isSameDay, int userHandle) {
        String skeleton = (!isSameDay ? "EEE " : "") + (DateFormat.is24HourFormat(context, userHandle) ? "Hm" : "hma");
        String pattern = DateFormat.getBestDateTimePattern(AndroidLocale.getDefault(), skeleton);
        return DateFormat.format((CharSequence)pattern, time);
    }

    public static boolean isToday(long time) {
        GregorianCalendar now = new GregorianCalendar();
        GregorianCalendar endTime = new GregorianCalendar();
        endTime.setTimeInMillis(time);
        return now.get(1) == endTime.get(1) && now.get(2) == endTime.get(2) && now.get(5) == endTime.get(5);
    }

    public static Uri toCountdownConditionId(long time, boolean alarm) {
        return new Uri.Builder().scheme("condition").authority(SYSTEM_AUTHORITY).appendPath(COUNTDOWN_PATH).appendPath(Long.toString(time)).appendPath(IS_ALARM_PATH).appendPath(Boolean.toString(alarm)).build();
    }

    public static long tryParseCountdownConditionId(Uri conditionId) {
        if (!Condition.isValidId(conditionId, SYSTEM_AUTHORITY)) {
            return 0L;
        }
        if (conditionId.getPathSegments().size() < 2 || !COUNTDOWN_PATH.equals(conditionId.getPathSegments().get(0))) {
            return 0L;
        }
        try {
            return Long.parseLong(conditionId.getPathSegments().get(1));
        }
        catch (RuntimeException e) {
            Slog.w(TAG, "Error parsing countdown condition: " + conditionId, e);
            return 0L;
        }
    }

    public static boolean isValidCountdownConditionId(Uri conditionId) {
        return ZenModeConfig.tryParseCountdownConditionId(conditionId) != 0L;
    }

    public static boolean isValidCountdownToAlarmConditionId(Uri conditionId) {
        if (ZenModeConfig.tryParseCountdownConditionId(conditionId) != 0L) {
            if (conditionId.getPathSegments().size() < 4 || !IS_ALARM_PATH.equals(conditionId.getPathSegments().get(2))) {
                return false;
            }
            try {
                return Boolean.parseBoolean(conditionId.getPathSegments().get(3));
            }
            catch (RuntimeException e) {
                Slog.w(TAG, "Error parsing countdown alarm condition: " + conditionId, e);
                return false;
            }
        }
        return false;
    }

    public static Uri toScheduleConditionId(ScheduleInfo schedule) {
        return new Uri.Builder().scheme("condition").authority(SYSTEM_AUTHORITY).appendPath(SCHEDULE_PATH).appendQueryParameter("days", ZenModeConfig.toDayList(schedule.days)).appendQueryParameter("start", schedule.startHour + "." + schedule.startMinute).appendQueryParameter("end", schedule.endHour + "." + schedule.endMinute).appendQueryParameter("exitAtAlarm", String.valueOf(schedule.exitAtAlarm)).build();
    }

    public static boolean isValidScheduleConditionId(Uri conditionId) {
        ScheduleInfo info;
        try {
            info = ZenModeConfig.tryParseScheduleConditionId(conditionId);
        }
        catch (ArrayIndexOutOfBoundsException | NullPointerException e) {
            return false;
        }
        return info != null && info.days != null && info.days.length != 0;
    }

    public static boolean isValidScheduleConditionId(Uri conditionId, boolean allowNever) {
        ScheduleInfo info;
        try {
            info = ZenModeConfig.tryParseScheduleConditionId(conditionId);
        }
        catch (ArrayIndexOutOfBoundsException | NullPointerException e) {
            return false;
        }
        return info != null && (allowNever || info.days != null && info.days.length != 0);
    }

    @UnsupportedAppUsage
    public static ScheduleInfo tryParseScheduleConditionId(Uri conditionId) {
        boolean isSchedule;
        boolean bl = isSchedule = conditionId != null && "condition".equals(conditionId.getScheme()) && SYSTEM_AUTHORITY.equals(conditionId.getAuthority()) && conditionId.getPathSegments().size() == 1 && SCHEDULE_PATH.equals(conditionId.getPathSegments().get(0));
        if (!isSchedule) {
            return null;
        }
        int[] start = ZenModeConfig.tryParseHourAndMinute(conditionId.getQueryParameter("start"));
        int[] end = ZenModeConfig.tryParseHourAndMinute(conditionId.getQueryParameter("end"));
        if (start == null || end == null) {
            return null;
        }
        ScheduleInfo rt = new ScheduleInfo();
        rt.days = ZenModeConfig.tryParseDayList(conditionId.getQueryParameter("days"), "\\.");
        rt.startHour = start[0];
        rt.startMinute = start[1];
        rt.endHour = end[0];
        rt.endMinute = end[1];
        rt.exitAtAlarm = ZenModeConfig.safeBoolean(conditionId.getQueryParameter("exitAtAlarm"), false);
        return rt;
    }

    public static ComponentName getScheduleConditionProvider() {
        return new ComponentName(SYSTEM_AUTHORITY, "ScheduleConditionProvider");
    }

    public static Uri toEventConditionId(EventInfo event) {
        return new Uri.Builder().scheme("condition").authority(SYSTEM_AUTHORITY).appendPath(EVENT_PATH).appendQueryParameter("userId", Long.toString(event.userId)).appendQueryParameter("calendar", event.calName != null ? event.calName : "").appendQueryParameter("calendarId", event.calendarId != null ? event.calendarId.toString() : "").appendQueryParameter("reply", Integer.toString(event.reply)).build();
    }

    public static boolean isValidEventConditionId(Uri conditionId) {
        return ZenModeConfig.tryParseEventConditionId(conditionId) != null;
    }

    public static EventInfo tryParseEventConditionId(Uri conditionId) {
        boolean isEvent;
        boolean bl = isEvent = conditionId != null && "condition".equals(conditionId.getScheme()) && SYSTEM_AUTHORITY.equals(conditionId.getAuthority()) && conditionId.getPathSegments().size() == 1 && EVENT_PATH.equals(conditionId.getPathSegments().get(0));
        if (!isEvent) {
            return null;
        }
        EventInfo rt = new EventInfo();
        rt.userId = ZenModeConfig.tryParseInt(conditionId.getQueryParameter("userId"), -10000);
        rt.calName = conditionId.getQueryParameter("calendar");
        if (TextUtils.isEmpty(rt.calName)) {
            rt.calName = null;
        }
        rt.calendarId = ZenModeConfig.tryParseLong(conditionId.getQueryParameter("calendarId"), null);
        rt.reply = ZenModeConfig.tryParseInt(conditionId.getQueryParameter("reply"), 0);
        return rt;
    }

    public static ComponentName getEventConditionProvider() {
        return new ComponentName(SYSTEM_AUTHORITY, "EventConditionProvider");
    }

    private static int[] tryParseHourAndMinute(String value) {
        int[] nArray;
        if (TextUtils.isEmpty(value)) {
            return null;
        }
        int i = value.indexOf(46);
        if (i < 1 || i >= value.length() - 1) {
            return null;
        }
        int hour = ZenModeConfig.tryParseInt(value.substring(0, i), -1);
        int minute = ZenModeConfig.tryParseInt(value.substring(i + 1), -1);
        if (ZenModeConfig.isValidHour(hour) && ZenModeConfig.isValidMinute(minute)) {
            int[] nArray2 = new int[2];
            nArray2[0] = hour;
            nArray = nArray2;
            nArray2[1] = minute;
        } else {
            nArray = null;
        }
        return nArray;
    }

    private static int tryParseZenMode(String value, int defValue) {
        int rt = ZenModeConfig.tryParseInt(value, defValue);
        return Settings.Global.isValidZenMode(rt) ? rt : defValue;
    }

    public static String newRuleId() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static String getOwnerCaption(Context context, String owner) {
        PackageManager pm = context.getPackageManager();
        try {
            String str;
            CharSequence seq;
            ApplicationInfo info = pm.getApplicationInfo(owner, 0);
            if (info != null && (seq = info.loadLabel(pm)) != null && (str = seq.toString().trim()).length() > 0) {
                return str;
            }
        }
        catch (Throwable e) {
            Slog.w(TAG, "Error loading owner caption", e);
        }
        return "";
    }

    public static String getConditionSummary(Context context, ZenModeConfig config, int userHandle, boolean shortVersion) {
        return ZenModeConfig.getConditionLine(context, config, userHandle, false, shortVersion);
    }

    private static String getConditionLine(Context context, ZenModeConfig config, int userHandle, boolean useLine1, boolean shortVersion) {
        if (config == null) {
            return "";
        }
        String summary = "";
        if (config.manualRule != null) {
            Uri id2 = config.manualRule.conditionId;
            if (config.manualRule.enabler != null) {
                summary = ZenModeConfig.getOwnerCaption(context, config.manualRule.enabler);
            } else if (id2 == null) {
                summary = context.getString(17041677);
            } else {
                long time = ZenModeConfig.tryParseCountdownConditionId(id2);
                Condition c = config.manualRule.condition;
                if (time > 0L) {
                    long now = System_Delegate.currentTimeMillis();
                    long span = time - now;
                    c = ZenModeConfig.toTimeCondition(context, time, Math.round((float)span / 60000.0f), userHandle, shortVersion);
                }
                String rt = c == null ? "" : (useLine1 ? c.line1 : c.summary);
                summary = TextUtils.isEmpty(rt) ? "" : rt;
            }
        }
        for (ZenRule automaticRule : config.automaticRules.values()) {
            if (!automaticRule.isAutomaticActive()) continue;
            if (summary.isEmpty()) {
                summary = automaticRule.name;
                continue;
            }
            summary = context.getResources().getString(17041679, summary, automaticRule.name);
        }
        return summary;
    }

    public static boolean areAllPriorityOnlyRingerSoundsMuted(NotificationManager.Policy policy) {
        boolean allowReminders = (policy.priorityCategories & 1) != 0;
        boolean allowCalls = (policy.priorityCategories & 8) != 0;
        boolean allowMessages = (policy.priorityCategories & 4) != 0;
        boolean allowEvents = (policy.priorityCategories & 2) != 0;
        boolean allowRepeatCallers = (policy.priorityCategories & 0x10) != 0;
        boolean allowConversations = (policy.priorityConversationSenders & 0x100) != 0;
        boolean areChannelsBypassingDnd = (policy.state & 1) != 0;
        boolean allowSystem = (policy.priorityCategories & 0x80) != 0;
        return !allowReminders && !allowCalls && !allowMessages && !allowEvents && !allowRepeatCallers && !areChannelsBypassingDnd && !allowSystem && !allowConversations;
    }

    public static boolean areAllZenBehaviorSoundsMuted(NotificationManager.Policy policy) {
        boolean allowAlarms = (policy.priorityCategories & 0x20) != 0;
        boolean allowMedia = (policy.priorityCategories & 0x40) != 0;
        return !allowAlarms && !allowMedia && ZenModeConfig.areAllPriorityOnlyRingerSoundsMuted(policy);
    }

    public static boolean isZenOverridingRinger(int zen, NotificationManager.Policy consolidatedPolicy) {
        return zen == 2 || zen == 3 || zen == 1 && ZenModeConfig.areAllPriorityOnlyRingerSoundsMuted(consolidatedPolicy);
    }

    public static boolean areAllPriorityOnlyRingerSoundsMuted(ZenModeConfig config) {
        return !config.allowReminders && !config.allowCalls && !config.allowMessages && !config.allowEvents && !config.allowRepeatCallers && !config.areChannelsBypassingDnd && !config.allowSystem;
    }

    public static boolean areAllZenBehaviorSoundsMuted(ZenModeConfig config) {
        return !config.allowAlarms && !config.allowMedia && ZenModeConfig.areAllPriorityOnlyRingerSoundsMuted(config);
    }

    public static String getDescription(Context context, boolean zenOn, ZenModeConfig config, boolean describeForeverCondition) {
        if (!zenOn || config == null) {
            return null;
        }
        String secondaryText = "";
        long latestEndTime = -1L;
        if (config.manualRule != null) {
            Uri id2 = config.manualRule.conditionId;
            if (config.manualRule.enabler != null) {
                String appName = ZenModeConfig.getOwnerCaption(context, config.manualRule.enabler);
                if (!appName.isEmpty()) {
                    secondaryText = appName;
                }
            } else {
                if (id2 == null) {
                    if (describeForeverCondition) {
                        return context.getString(17041677);
                    }
                    return null;
                }
                latestEndTime = ZenModeConfig.tryParseCountdownConditionId(id2);
                if (latestEndTime > 0L) {
                    CharSequence formattedTime = ZenModeConfig.getFormattedTime(context, latestEndTime, ZenModeConfig.isToday(latestEndTime), context.getUserId());
                    secondaryText = context.getString(17041680, formattedTime);
                }
            }
        }
        for (ZenRule automaticRule : config.automaticRules.values()) {
            if (!automaticRule.isAutomaticActive()) continue;
            if (ZenModeConfig.isValidEventConditionId(automaticRule.conditionId) || ZenModeConfig.isValidScheduleConditionId(automaticRule.conditionId)) {
                long endTime = ZenModeConfig.parseAutomaticRuleEndTime(context, automaticRule.conditionId);
                if (endTime <= latestEndTime) continue;
                latestEndTime = endTime;
                secondaryText = automaticRule.name;
                continue;
            }
            return automaticRule.name;
        }
        return !secondaryText.equals("") ? secondaryText : null;
    }

    private static long parseAutomaticRuleEndTime(Context context, Uri id2) {
        if (ZenModeConfig.isValidEventConditionId(id2)) {
            return Long.MAX_VALUE;
        }
        if (ZenModeConfig.isValidScheduleConditionId(id2)) {
            ScheduleCalendar schedule = ZenModeConfig.toScheduleCalendar(id2);
            long endTimeMs = schedule.getNextChangeTime(System_Delegate.currentTimeMillis());
            if (schedule.exitAtAlarm()) {
                long nextAlarm = ZenModeConfig.getNextAlarm(context);
                schedule.maybeSetNextAlarm(System_Delegate.currentTimeMillis(), nextAlarm);
                if (schedule.shouldExitForAlarm(endTimeMs)) {
                    return nextAlarm;
                }
            }
            return endTimeMs;
        }
        return -1L;
    }

    private static long getNextAlarm(Context context) {
        AlarmManager alarms = (AlarmManager)context.getSystemService(IS_ALARM_PATH);
        AlarmManager.AlarmClockInfo info = alarms.getNextAlarmClock(context.getUserId());
        return info != null ? info.getTriggerTime() : 0L;
    }

    public static class Diff {
        private final ArrayList<String> lines = new ArrayList();

        public String toString() {
            StringBuilder sb = new StringBuilder("Diff[");
            int N = this.lines.size();
            for (int i = 0; i < N; ++i) {
                if (i > 0) {
                    sb.append(",\n");
                }
                sb.append(this.lines.get(i));
            }
            return sb.append(']').toString();
        }

        private Diff addLine(String item, String action) {
            this.lines.add(item + ":" + action);
            return this;
        }

        public Diff addLine(String item, String subitem, Object from, Object to) {
            return this.addLine(item + "." + subitem, from, to);
        }

        public Diff addLine(String item, Object from, Object to) {
            return this.addLine(item, from + "->" + to);
        }

        public boolean isEmpty() {
            return this.lines.isEmpty();
        }
    }

    public static class ZenRule
    implements Parcelable {
        @UnsupportedAppUsage
        public boolean enabled;
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public boolean snoozing;
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public String name;
        @UnsupportedAppUsage
        public int zenMode;
        @UnsupportedAppUsage
        public Uri conditionId;
        public Condition condition;
        public ComponentName component;
        public ComponentName configurationActivity;
        public String id;
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public long creationTime;
        public String enabler;
        public ZenPolicy zenPolicy;
        public boolean modified;
        public String pkg;
        public static final Parcelable.Creator<ZenRule> CREATOR = new Parcelable.Creator<ZenRule>(){

            @Override
            public ZenRule createFromParcel(Parcel source) {
                return new ZenRule(source);
            }

            public ZenRule[] newArray(int size) {
                return new ZenRule[size];
            }
        };

        public ZenRule() {
        }

        public ZenRule(Parcel source) {
            this.enabled = source.readInt() == 1;
            boolean bl = this.snoozing = source.readInt() == 1;
            if (source.readInt() == 1) {
                this.name = source.readString();
            }
            this.zenMode = source.readInt();
            this.conditionId = (Uri)source.readParcelable(null);
            this.condition = (Condition)source.readParcelable(null);
            this.component = (ComponentName)source.readParcelable(null);
            this.configurationActivity = (ComponentName)source.readParcelable(null);
            if (source.readInt() == 1) {
                this.id = source.readString();
            }
            this.creationTime = source.readLong();
            if (source.readInt() == 1) {
                this.enabler = source.readString();
            }
            this.zenPolicy = (ZenPolicy)source.readParcelable(null);
            this.modified = source.readInt() == 1;
            this.pkg = source.readString();
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.enabled ? 1 : 0);
            dest.writeInt(this.snoozing ? 1 : 0);
            if (this.name != null) {
                dest.writeInt(1);
                dest.writeString(this.name);
            } else {
                dest.writeInt(0);
            }
            dest.writeInt(this.zenMode);
            dest.writeParcelable(this.conditionId, 0);
            dest.writeParcelable(this.condition, 0);
            dest.writeParcelable(this.component, 0);
            dest.writeParcelable(this.configurationActivity, 0);
            if (this.id != null) {
                dest.writeInt(1);
                dest.writeString(this.id);
            } else {
                dest.writeInt(0);
            }
            dest.writeLong(this.creationTime);
            if (this.enabler != null) {
                dest.writeInt(1);
                dest.writeString(this.enabler);
            } else {
                dest.writeInt(0);
            }
            dest.writeParcelable(this.zenPolicy, 0);
            dest.writeInt(this.modified ? 1 : 0);
            dest.writeString(this.pkg);
        }

        public String toString() {
            return ZenRule.class.getSimpleName() + '[' + "id=" + this.id + ",state=" + (this.condition == null ? "STATE_FALSE" : Condition.stateToString(this.condition.state)) + ",enabled=" + String.valueOf(this.enabled).toUpperCase() + ",snoozing=" + this.snoozing + ",name=" + this.name + ",zenMode=" + Settings.Global.zenModeToString(this.zenMode) + ",conditionId=" + this.conditionId + ",pkg=" + this.pkg + ",component=" + this.component + ",configActivity=" + this.configurationActivity + ",creationTime=" + this.creationTime + ",enabler=" + this.enabler + ",zenPolicy=" + this.zenPolicy + ",modified=" + this.modified + ",condition=" + this.condition + ']';
        }

        public void dumpDebug(ProtoOutputStream proto, long fieldId) {
            long token = proto.start(fieldId);
            proto.write(0x10900000001L, this.id);
            proto.write(1138166333442L, this.name);
            proto.write(0x10300000003L, this.creationTime);
            proto.write(1133871366148L, this.enabled);
            proto.write(1138166333445L, this.enabler);
            proto.write(1133871366150L, this.snoozing);
            proto.write(1159641169927L, this.zenMode);
            if (this.conditionId != null) {
                proto.write(1138166333448L, this.conditionId.toString());
            }
            if (this.condition != null) {
                this.condition.dumpDebug(proto, 1146756268041L);
            }
            if (this.component != null) {
                this.component.dumpDebug(proto, 1146756268042L);
            }
            if (this.zenPolicy != null) {
                this.zenPolicy.dumpDebug(proto, 0x10B0000000BL);
            }
            proto.write(1133871366156L, this.modified);
            proto.end(token);
        }

        private static void appendDiff(Diff d, String item, ZenRule from, ZenRule to) {
            if (d == null) {
                return;
            }
            if (from == null) {
                if (to != null) {
                    d.addLine(item, "insert");
                }
                return;
            }
            from.appendDiff(d, item, to);
        }

        private void appendDiff(Diff d, String item, ZenRule to) {
            if (to == null) {
                d.addLine(item, "delete");
                return;
            }
            if (this.enabled != to.enabled) {
                d.addLine(item, ZenModeConfig.RULE_ATT_ENABLED, this.enabled, to.enabled);
            }
            if (this.snoozing != to.snoozing) {
                d.addLine(item, ZenModeConfig.RULE_ATT_SNOOZING, this.snoozing, to.snoozing);
            }
            if (!Objects.equals(this.name, to.name)) {
                d.addLine(item, ZenModeConfig.RULE_ATT_NAME, this.name, to.name);
            }
            if (this.zenMode != to.zenMode) {
                d.addLine(item, "zenMode", this.zenMode, to.zenMode);
            }
            if (!Objects.equals(this.conditionId, to.conditionId)) {
                d.addLine(item, ZenModeConfig.RULE_ATT_CONDITION_ID, this.conditionId, to.conditionId);
            }
            if (!Objects.equals(this.condition, to.condition)) {
                d.addLine(item, "condition", this.condition, to.condition);
            }
            if (!Objects.equals(this.component, to.component)) {
                d.addLine(item, ZenModeConfig.RULE_ATT_COMPONENT, this.component, to.component);
            }
            if (!Objects.equals(this.configurationActivity, to.configurationActivity)) {
                d.addLine(item, ZenModeConfig.RULE_ATT_CONFIG_ACTIVITY, this.configurationActivity, to.configurationActivity);
            }
            if (!Objects.equals(this.id, to.id)) {
                d.addLine(item, ZenModeConfig.CONDITION_ATT_ID, this.id, to.id);
            }
            if (this.creationTime != to.creationTime) {
                d.addLine(item, ZenModeConfig.RULE_ATT_CREATION_TIME, this.creationTime, to.creationTime);
            }
            if (!Objects.equals(this.enabler, to.enabler)) {
                d.addLine(item, ZenModeConfig.RULE_ATT_ENABLER, this.enabler, to.enabler);
            }
            if (!Objects.equals(this.zenPolicy, to.zenPolicy)) {
                d.addLine(item, "zenPolicy", this.zenPolicy, to.zenPolicy);
            }
            if (this.modified != to.modified) {
                d.addLine(item, ZenModeConfig.RULE_ATT_MODIFIED, this.modified, to.modified);
            }
            if (!Objects.equals(this.pkg, to.pkg)) {
                d.addLine(item, ZenModeConfig.RULE_ATT_PKG, this.pkg, to.pkg);
            }
        }

        public boolean equals(Object o) {
            if (!(o instanceof ZenRule)) {
                return false;
            }
            if (o == this) {
                return true;
            }
            ZenRule other = (ZenRule)o;
            return other.enabled == this.enabled && other.snoozing == this.snoozing && Objects.equals(other.name, this.name) && other.zenMode == this.zenMode && Objects.equals(other.conditionId, this.conditionId) && Objects.equals(other.condition, this.condition) && Objects.equals(other.component, this.component) && Objects.equals(other.configurationActivity, this.configurationActivity) && Objects.equals(other.id, this.id) && Objects.equals(other.enabler, this.enabler) && Objects.equals(other.zenPolicy, this.zenPolicy) && Objects.equals(other.pkg, this.pkg) && other.modified == this.modified;
        }

        public int hashCode() {
            return Objects.hash(this.enabled, this.snoozing, this.name, this.zenMode, this.conditionId, this.condition, this.component, this.configurationActivity, this.pkg, this.id, this.enabler, this.zenPolicy, this.modified);
        }

        public boolean isAutomaticActive() {
            return this.enabled && !this.snoozing && this.getPkg() != null && this.isTrueOrUnknown();
        }

        public String getPkg() {
            return !TextUtils.isEmpty(this.pkg) ? this.pkg : (this.component != null ? this.component.getPackageName() : (this.configurationActivity != null ? this.configurationActivity.getPackageName() : null));
        }

        public boolean isTrueOrUnknown() {
            return this.condition != null && (this.condition.state == 1 || this.condition.state == 2);
        }
    }

    public static class EventInfo {
        public static final int REPLY_ANY_EXCEPT_NO = 0;
        public static final int REPLY_YES_OR_MAYBE = 1;
        public static final int REPLY_YES = 2;
        public int userId = -10000;
        public String calName;
        public Long calendarId;
        public int reply;

        public int hashCode() {
            return Objects.hash(this.userId, this.calName, this.calendarId, this.reply);
        }

        public boolean equals(Object o) {
            if (!(o instanceof EventInfo)) {
                return false;
            }
            EventInfo other = (EventInfo)o;
            return this.userId == other.userId && Objects.equals(this.calName, other.calName) && this.reply == other.reply && Objects.equals(this.calendarId, other.calendarId);
        }

        public EventInfo copy() {
            EventInfo rt = new EventInfo();
            rt.userId = this.userId;
            rt.calName = this.calName;
            rt.reply = this.reply;
            rt.calendarId = this.calendarId;
            return rt;
        }

        public static int resolveUserId(int userId) {
            return userId == -10000 ? ActivityManager.getCurrentUser() : userId;
        }
    }

    public static class ScheduleInfo {
        @UnsupportedAppUsage
        public int[] days;
        @UnsupportedAppUsage
        public int startHour;
        @UnsupportedAppUsage
        public int startMinute;
        @UnsupportedAppUsage
        public int endHour;
        @UnsupportedAppUsage
        public int endMinute;
        public boolean exitAtAlarm;
        public long nextAlarm;

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ScheduleInfo)) {
                return false;
            }
            ScheduleInfo other = (ScheduleInfo)o;
            return ZenModeConfig.toDayList(this.days).equals(ZenModeConfig.toDayList(other.days)) && this.startHour == other.startHour && this.startMinute == other.startMinute && this.endHour == other.endHour && this.endMinute == other.endMinute && this.exitAtAlarm == other.exitAtAlarm;
        }

        public ScheduleInfo copy() {
            ScheduleInfo rt = new ScheduleInfo();
            if (this.days != null) {
                rt.days = new int[this.days.length];
                System.arraycopy(this.days, 0, rt.days, 0, this.days.length);
            }
            rt.startHour = this.startHour;
            rt.startMinute = this.startMinute;
            rt.endHour = this.endHour;
            rt.endMinute = this.endMinute;
            rt.exitAtAlarm = this.exitAtAlarm;
            rt.nextAlarm = this.nextAlarm;
            return rt;
        }

        public String toString() {
            return "ScheduleInfo{days=" + Arrays.toString(this.days) + ", startHour=" + this.startHour + ", startMinute=" + this.startMinute + ", endHour=" + this.endHour + ", endMinute=" + this.endMinute + ", exitAtAlarm=" + this.exitAtAlarm + ", nextAlarm=" + ScheduleInfo.ts(this.nextAlarm) + '}';
        }

        protected static String ts(long time) {
            return new Date(time) + " (" + time + ")";
        }
    }
}

