/*
 * Decompiled with CFR 0.152.
 */
package android.system;

import libcore.util.Objects;

public class StructTimeval {
    public final long tv_sec;
    public final long tv_usec;

    private StructTimeval(long tv_sec, long tv_usec) {
        this.tv_sec = tv_sec;
        this.tv_usec = tv_usec;
        if (tv_usec < 0L || tv_usec > 999999L) {
            throw new IllegalArgumentException("tv_usec value " + tv_usec + " is not in [0, 999999]");
        }
    }

    public static StructTimeval fromMillis(long millis) {
        long tv_sec = millis / 1000L;
        if (tv_sec * 1000L > millis) {
            --tv_sec;
        }
        long tv_usec = (millis - tv_sec * 1000L) * 1000L;
        return new StructTimeval(tv_sec, tv_usec);
    }

    public long toMillis() {
        return this.tv_sec * 1000L + this.tv_usec / 1000L;
    }

    public String toString() {
        return Objects.toString(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StructTimeval that = (StructTimeval)o;
        return this.tv_sec == that.tv_sec && this.tv_usec == that.tv_usec;
    }

    public int hashCode() {
        return java.util.Objects.hash(this.tv_sec, this.tv_usec);
    }
}

