/*
 * Decompiled with CFR 0.152.
 */
package android.system.keystore2;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.system.keystore2.IKeystoreSecurityLevel;
import android.system.keystore2.KeyDescriptor;
import android.system.keystore2.KeyEntryResponse;

public interface IKeystoreService
extends IInterface {
    public static final int VERSION = 1;
    public static final String HASH = "19e8b65277839bad0ab335c781e3c652324920ce";
    public static final String DESCRIPTOR = "android$system$keystore2$IKeystoreService".replace('$', '.');

    public IKeystoreSecurityLevel getSecurityLevel(int var1) throws RemoteException;

    public KeyEntryResponse getKeyEntry(KeyDescriptor var1) throws RemoteException;

    public void updateSubcomponent(KeyDescriptor var1, byte[] var2, byte[] var3) throws RemoteException;

    public KeyDescriptor[] listEntries(int var1, long var2) throws RemoteException;

    public void deleteKey(KeyDescriptor var1) throws RemoteException;

    public KeyDescriptor grant(KeyDescriptor var1, int var2, int var3) throws RemoteException;

    public void ungrant(KeyDescriptor var1, int var2) throws RemoteException;

    public int getInterfaceVersion() throws RemoteException;

    public String getInterfaceHash() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IKeystoreService {
        static final int TRANSACTION_getSecurityLevel = 1;
        static final int TRANSACTION_getKeyEntry = 2;
        static final int TRANSACTION_updateSubcomponent = 3;
        static final int TRANSACTION_listEntries = 4;
        static final int TRANSACTION_deleteKey = 5;
        static final int TRANSACTION_grant = 6;
        static final int TRANSACTION_ungrant = 7;
        static final int TRANSACTION_getInterfaceVersion = 0xFFFFFF;
        static final int TRANSACTION_getInterfaceHash = 0xFFFFFE;

        public Stub() {
            this.markVintfStability();
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IKeystoreService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IKeystoreService) {
                return (IKeystoreService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 0xFFFFFF: {
                    data.enforceInterface(descriptor);
                    reply.writeNoException();
                    reply.writeInt(this.getInterfaceVersion());
                    return true;
                }
                case 0xFFFFFE: {
                    data.enforceInterface(descriptor);
                    reply.writeNoException();
                    reply.writeString(this.getInterfaceHash());
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    IKeystoreSecurityLevel _result = this.getSecurityLevel(_arg0);
                    reply.writeNoException();
                    reply.writeStrongBinder(_result != null ? _result.asBinder() : null);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    KeyDescriptor _arg0 = 0 != data.readInt() ? KeyDescriptor.CREATOR.createFromParcel(data) : null;
                    KeyEntryResponse _result = this.getKeyEntry(_arg0);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    KeyDescriptor _arg0 = 0 != data.readInt() ? KeyDescriptor.CREATOR.createFromParcel(data) : null;
                    byte[] _arg1 = data.createByteArray();
                    byte[] _arg2 = data.createByteArray();
                    this.updateSubcomponent(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    long _arg1 = data.readLong();
                    Parcelable[] _result = this.listEntries(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    KeyDescriptor _arg0 = 0 != data.readInt() ? KeyDescriptor.CREATOR.createFromParcel(data) : null;
                    this.deleteKey(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    KeyDescriptor _arg0 = 0 != data.readInt() ? KeyDescriptor.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    KeyDescriptor _result = this.grant(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    KeyDescriptor _arg0 = 0 != data.readInt() ? KeyDescriptor.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    this.ungrant(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IKeystoreService impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IKeystoreService getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IKeystoreService {
            private IBinder mRemote;
            private int mCachedVersion = -1;
            private String mCachedHash = "-1";
            public static IKeystoreService sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IKeystoreSecurityLevel getSecurityLevel(int securityLevel) throws RemoteException {
                IKeystoreSecurityLevel _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeInt(securityLevel);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status) {
                        if (Stub.getDefaultImpl() != null) {
                            IKeystoreSecurityLevel iKeystoreSecurityLevel = Stub.getDefaultImpl().getSecurityLevel(securityLevel);
                            return iKeystoreSecurityLevel;
                        }
                        throw new RemoteException("Method getSecurityLevel is unimplemented.");
                    }
                    _reply.readException();
                    _result = IKeystoreSecurityLevel.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public KeyEntryResponse getKeyEntry(KeyDescriptor key) throws RemoteException {
                KeyEntryResponse _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    if (key != null) {
                        _data.writeInt(1);
                        key.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status) {
                        if (Stub.getDefaultImpl() != null) {
                            KeyEntryResponse keyEntryResponse = Stub.getDefaultImpl().getKeyEntry(key);
                            return keyEntryResponse;
                        }
                        throw new RemoteException("Method getKeyEntry is unimplemented.");
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? KeyEntryResponse.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateSubcomponent(KeyDescriptor key, byte[] publicCert, byte[] certificateChain) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    if (key != null) {
                        _data.writeInt(1);
                        key.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeByteArray(publicCert);
                    _data.writeByteArray(certificateChain);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status) {
                        if (Stub.getDefaultImpl() != null) {
                            Stub.getDefaultImpl().updateSubcomponent(key, publicCert, certificateChain);
                            return;
                        }
                        throw new RemoteException("Method updateSubcomponent is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public KeyDescriptor[] listEntries(int domain, long nspace) throws RemoteException {
                KeyDescriptor[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeInt(domain);
                    _data.writeLong(nspace);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status) {
                        if (Stub.getDefaultImpl() != null) {
                            KeyDescriptor[] keyDescriptorArray = Stub.getDefaultImpl().listEntries(domain, nspace);
                            return keyDescriptorArray;
                        }
                        throw new RemoteException("Method listEntries is unimplemented.");
                    }
                    _reply.readException();
                    _result = _reply.createTypedArray(KeyDescriptor.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void deleteKey(KeyDescriptor key) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    if (key != null) {
                        _data.writeInt(1);
                        key.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status) {
                        if (Stub.getDefaultImpl() != null) {
                            Stub.getDefaultImpl().deleteKey(key);
                            return;
                        }
                        throw new RemoteException("Method deleteKey is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public KeyDescriptor grant(KeyDescriptor key, int granteeUid, int accessVector) throws RemoteException {
                KeyDescriptor _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    if (key != null) {
                        _data.writeInt(1);
                        key.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(granteeUid);
                    _data.writeInt(accessVector);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    if (!_status) {
                        if (Stub.getDefaultImpl() != null) {
                            KeyDescriptor keyDescriptor = Stub.getDefaultImpl().grant(key, granteeUid, accessVector);
                            return keyDescriptor;
                        }
                        throw new RemoteException("Method grant is unimplemented.");
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? KeyDescriptor.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void ungrant(KeyDescriptor key, int granteeUid) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    if (key != null) {
                        _data.writeInt(1);
                        key.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(granteeUid);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    if (!_status) {
                        if (Stub.getDefaultImpl() != null) {
                            Stub.getDefaultImpl().ungrant(key, granteeUid);
                            return;
                        }
                        throw new RemoteException("Method ungrant is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getInterfaceVersion() throws RemoteException {
                if (this.mCachedVersion == -1) {
                    Parcel data = Parcel.obtain();
                    Parcel reply = Parcel.obtain();
                    try {
                        data.writeInterfaceToken(DESCRIPTOR);
                        boolean _status = this.mRemote.transact(0xFFFFFF, data, reply, 0);
                        if (!_status && Stub.getDefaultImpl() != null) {
                            int n = Stub.getDefaultImpl().getInterfaceVersion();
                            return n;
                        }
                        reply.readException();
                        this.mCachedVersion = reply.readInt();
                    }
                    finally {
                        reply.recycle();
                        data.recycle();
                    }
                }
                return this.mCachedVersion;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized String getInterfaceHash() throws RemoteException {
                if ("-1".equals(this.mCachedHash)) {
                    Parcel data = Parcel.obtain();
                    Parcel reply = Parcel.obtain();
                    try {
                        data.writeInterfaceToken(DESCRIPTOR);
                        boolean _status = this.mRemote.transact(0xFFFFFE, data, reply, 0);
                        if (!_status && Stub.getDefaultImpl() != null) {
                            String string2 = Stub.getDefaultImpl().getInterfaceHash();
                            return string2;
                        }
                        reply.readException();
                        this.mCachedHash = reply.readString();
                    }
                    finally {
                        reply.recycle();
                        data.recycle();
                    }
                }
                return this.mCachedHash;
            }
        }
    }

    public static class Default
    implements IKeystoreService {
        @Override
        public IKeystoreSecurityLevel getSecurityLevel(int securityLevel) throws RemoteException {
            return null;
        }

        @Override
        public KeyEntryResponse getKeyEntry(KeyDescriptor key) throws RemoteException {
            return null;
        }

        @Override
        public void updateSubcomponent(KeyDescriptor key, byte[] publicCert, byte[] certificateChain) throws RemoteException {
        }

        @Override
        public KeyDescriptor[] listEntries(int domain, long nspace) throws RemoteException {
            return null;
        }

        @Override
        public void deleteKey(KeyDescriptor key) throws RemoteException {
        }

        @Override
        public KeyDescriptor grant(KeyDescriptor key, int granteeUid, int accessVector) throws RemoteException {
            return null;
        }

        @Override
        public void ungrant(KeyDescriptor key, int granteeUid) throws RemoteException {
        }

        @Override
        public int getInterfaceVersion() {
            return 0;
        }

        @Override
        public String getInterfaceHash() {
            return "";
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

