/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.data;

import android.annotation.SystemApi;
import android.content.ContentValues;
import android.database.Cursor;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.ServiceState;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.Log;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ApnSetting
implements Parcelable {
    private static final String LOG_TAG = "ApnSetting";
    private static final boolean VDBG = false;
    private static final String V2_FORMAT_REGEX = "^\\[ApnSettingV2\\]\\s*";
    private static final String V3_FORMAT_REGEX = "^\\[ApnSettingV3\\]\\s*";
    private static final String V4_FORMAT_REGEX = "^\\[ApnSettingV4\\]\\s*";
    private static final String V5_FORMAT_REGEX = "^\\[ApnSettingV5\\]\\s*";
    private static final String V6_FORMAT_REGEX = "^\\[ApnSettingV6\\]\\s*";
    private static final String V7_FORMAT_REGEX = "^\\[ApnSettingV7\\]\\s*";
    public static final int UNSET_MTU = 0;
    private static final int UNSPECIFIED_INT = -1;
    private static final String UNSPECIFIED_STRING = "";
    public static final int TYPE_NONE = 0;
    public static final int TYPE_ALL = 255;
    public static final int TYPE_DEFAULT = 17;
    public static final int TYPE_MMS = 2;
    public static final int TYPE_SUPL = 4;
    public static final int TYPE_DUN = 8;
    public static final int TYPE_HIPRI = 16;
    public static final int TYPE_FOTA = 32;
    public static final int TYPE_IMS = 64;
    public static final int TYPE_CBS = 128;
    public static final int TYPE_IA = 256;
    public static final int TYPE_EMERGENCY = 512;
    public static final int TYPE_MCX = 1024;
    public static final int TYPE_XCAP = 2048;
    public static final int TYPE_VSIM = 4096;
    public static final int TYPE_BIP = 8192;
    public static final int TYPE_ENTERPRISE = 16384;
    public static final int AUTH_TYPE_NONE = 0;
    public static final int AUTH_TYPE_PAP = 1;
    public static final int AUTH_TYPE_CHAP = 2;
    public static final int AUTH_TYPE_PAP_OR_CHAP = 3;
    @SystemApi
    public static final String TYPE_ALL_STRING = "*";
    @SystemApi
    public static final String TYPE_DEFAULT_STRING = "default";
    @SystemApi
    public static final String TYPE_MMS_STRING = "mms";
    @SystemApi
    public static final String TYPE_SUPL_STRING = "supl";
    @SystemApi
    public static final String TYPE_DUN_STRING = "dun";
    @SystemApi
    public static final String TYPE_HIPRI_STRING = "hipri";
    @SystemApi
    public static final String TYPE_FOTA_STRING = "fota";
    @SystemApi
    public static final String TYPE_IMS_STRING = "ims";
    @SystemApi
    public static final String TYPE_CBS_STRING = "cbs";
    @SystemApi
    public static final String TYPE_IA_STRING = "ia";
    @SystemApi
    public static final String TYPE_EMERGENCY_STRING = "emergency";
    @SystemApi
    public static final String TYPE_MCX_STRING = "mcx";
    @SystemApi
    public static final String TYPE_XCAP_STRING = "xcap";
    @SystemApi
    public static final String TYPE_VSIM_STRING = "vsim";
    @SystemApi
    public static final String TYPE_BIP_STRING = "bip";
    public static final String TYPE_ENTERPRISE_STRING = "enterprise";
    public static final int PROTOCOL_IP = 0;
    public static final int PROTOCOL_IPV6 = 1;
    public static final int PROTOCOL_IPV4V6 = 2;
    public static final int PROTOCOL_PPP = 3;
    public static final int PROTOCOL_NON_IP = 4;
    public static final int PROTOCOL_UNSTRUCTURED = 5;
    public static final int MVNO_TYPE_SPN = 0;
    public static final int MVNO_TYPE_IMSI = 1;
    public static final int MVNO_TYPE_GID = 2;
    public static final int MVNO_TYPE_ICCID = 3;
    private static final Map<String, Integer> APN_TYPE_STRING_MAP = new ArrayMap<String, Integer>();
    private static final Map<Integer, String> APN_TYPE_INT_MAP;
    private static final Map<String, Integer> PROTOCOL_STRING_MAP;
    private static final Map<Integer, String> PROTOCOL_INT_MAP;
    private static final Map<String, Integer> MVNO_TYPE_STRING_MAP;
    private static final Map<Integer, String> MVNO_TYPE_INT_MAP;
    private final String mEntryName;
    private final String mApnName;
    private final String mProxyAddress;
    private final int mProxyPort;
    private final Uri mMmsc;
    private final String mMmsProxyAddress;
    private final int mMmsProxyPort;
    private final String mUser;
    private final String mPassword;
    private final int mAuthType;
    private final int mApnTypeBitmask;
    private final int mId;
    private final String mOperatorNumeric;
    private final int mProtocol;
    private final int mRoamingProtocol;
    private final int mMtu;
    private final boolean mCarrierEnabled;
    private final int mNetworkTypeBitmask;
    private final int mProfileId;
    private final boolean mPersistent;
    private final int mMaxConns;
    private final int mWaitTime;
    private final int mMaxConnsTime;
    private final int mMvnoType;
    private final String mMvnoMatchData;
    private final int mApnSetId;
    private boolean mPermanentFailed = false;
    private final int mCarrierId;
    private final int mSkip464Xlat;
    public static final Parcelable.Creator<ApnSetting> CREATOR;

    public int getMtu() {
        return this.mMtu;
    }

    public int getProfileId() {
        return this.mProfileId;
    }

    public boolean isPersistent() {
        return this.mPersistent;
    }

    public int getMaxConns() {
        return this.mMaxConns;
    }

    public int getWaitTime() {
        return this.mWaitTime;
    }

    public int getMaxConnsTime() {
        return this.mMaxConnsTime;
    }

    public String getMvnoMatchData() {
        return this.mMvnoMatchData;
    }

    public int getApnSetId() {
        return this.mApnSetId;
    }

    public boolean getPermanentFailed() {
        return this.mPermanentFailed;
    }

    public void setPermanentFailed(boolean permanentFailed) {
        this.mPermanentFailed = permanentFailed;
    }

    public String getEntryName() {
        return this.mEntryName;
    }

    public String getApnName() {
        return this.mApnName;
    }

    @Deprecated
    public InetAddress getProxyAddress() {
        return ApnSetting.inetAddressFromString(this.mProxyAddress);
    }

    public String getProxyAddressAsString() {
        return this.mProxyAddress;
    }

    public int getProxyPort() {
        return this.mProxyPort;
    }

    public Uri getMmsc() {
        return this.mMmsc;
    }

    @Deprecated
    public InetAddress getMmsProxyAddress() {
        return ApnSetting.inetAddressFromString(this.mMmsProxyAddress);
    }

    public String getMmsProxyAddressAsString() {
        return this.mMmsProxyAddress;
    }

    public int getMmsProxyPort() {
        return this.mMmsProxyPort;
    }

    public String getUser() {
        return this.mUser;
    }

    public String getPassword() {
        return this.mPassword;
    }

    public int getAuthType() {
        return this.mAuthType;
    }

    public int getApnTypeBitmask() {
        return this.mApnTypeBitmask;
    }

    public int getId() {
        return this.mId;
    }

    public String getOperatorNumeric() {
        return this.mOperatorNumeric;
    }

    public int getProtocol() {
        return this.mProtocol;
    }

    public int getRoamingProtocol() {
        return this.mRoamingProtocol;
    }

    public boolean isEnabled() {
        return this.mCarrierEnabled;
    }

    public int getNetworkTypeBitmask() {
        return this.mNetworkTypeBitmask;
    }

    public int getMvnoType() {
        return this.mMvnoType;
    }

    public int getCarrierId() {
        return this.mCarrierId;
    }

    public int getSkip464Xlat() {
        return this.mSkip464Xlat;
    }

    private ApnSetting(Builder builder) {
        this.mEntryName = builder.mEntryName;
        this.mApnName = builder.mApnName;
        this.mProxyAddress = builder.mProxyAddress;
        this.mProxyPort = builder.mProxyPort;
        this.mMmsc = builder.mMmsc;
        this.mMmsProxyAddress = builder.mMmsProxyAddress;
        this.mMmsProxyPort = builder.mMmsProxyPort;
        this.mUser = builder.mUser;
        this.mPassword = builder.mPassword;
        this.mAuthType = builder.mAuthType;
        this.mApnTypeBitmask = builder.mApnTypeBitmask;
        this.mId = builder.mId;
        this.mOperatorNumeric = builder.mOperatorNumeric;
        this.mProtocol = builder.mProtocol;
        this.mRoamingProtocol = builder.mRoamingProtocol;
        this.mMtu = builder.mMtu;
        this.mCarrierEnabled = builder.mCarrierEnabled;
        this.mNetworkTypeBitmask = builder.mNetworkTypeBitmask;
        this.mProfileId = builder.mProfileId;
        this.mPersistent = builder.mModemCognitive;
        this.mMaxConns = builder.mMaxConns;
        this.mWaitTime = builder.mWaitTime;
        this.mMaxConnsTime = builder.mMaxConnsTime;
        this.mMvnoType = builder.mMvnoType;
        this.mMvnoMatchData = builder.mMvnoMatchData;
        this.mApnSetId = builder.mApnSetId;
        this.mCarrierId = builder.mCarrierId;
        this.mSkip464Xlat = builder.mSkip464Xlat;
    }

    public static ApnSetting makeApnSetting(int id2, String operatorNumeric, String entryName, String apnName, String proxyAddress, int proxyPort, Uri mmsc, String mmsProxyAddress, int mmsProxyPort, String user, String password, int authType, int mApnTypeBitmask, int protocol, int roamingProtocol, boolean carrierEnabled, int networkTypeBitmask, int profileId, boolean modemCognitive, int maxConns, int waitTime, int maxConnsTime, int mtu, int mvnoType, String mvnoMatchData, int apnSetId, int carrierId, int skip464xlat) {
        return new Builder().setId(id2).setOperatorNumeric(operatorNumeric).setEntryName(entryName).setApnName(apnName).setProxyAddress(proxyAddress).setProxyPort(proxyPort).setMmsc(mmsc).setMmsProxyAddress(mmsProxyAddress).setMmsProxyPort(mmsProxyPort).setUser(user).setPassword(password).setAuthType(authType).setApnTypeBitmask(mApnTypeBitmask).setProtocol(protocol).setRoamingProtocol(roamingProtocol).setCarrierEnabled(carrierEnabled).setNetworkTypeBitmask(networkTypeBitmask).setProfileId(profileId).setModemCognitive(modemCognitive).setMaxConns(maxConns).setWaitTime(waitTime).setMaxConnsTime(maxConnsTime).setMtu(mtu).setMvnoType(mvnoType).setMvnoMatchData(mvnoMatchData).setApnSetId(apnSetId).setCarrierId(carrierId).setSkip464Xlat(skip464xlat).buildWithoutCheck();
    }

    public static ApnSetting makeApnSetting(int id2, String operatorNumeric, String entryName, String apnName, String proxyAddress, int proxyPort, Uri mmsc, String mmsProxyAddress, int mmsProxyPort, String user, String password, int authType, int mApnTypeBitmask, int protocol, int roamingProtocol, boolean carrierEnabled, int networkTypeBitmask, int profileId, boolean modemCognitive, int maxConns, int waitTime, int maxConnsTime, int mtu, int mvnoType, String mvnoMatchData) {
        return ApnSetting.makeApnSetting(id2, operatorNumeric, entryName, apnName, proxyAddress, proxyPort, mmsc, mmsProxyAddress, mmsProxyPort, user, password, authType, mApnTypeBitmask, protocol, roamingProtocol, carrierEnabled, networkTypeBitmask, profileId, modemCognitive, maxConns, waitTime, maxConnsTime, mtu, mvnoType, mvnoMatchData, 0, -1, -1);
    }

    public static ApnSetting makeApnSetting(Cursor cursor) {
        int apnTypesBitmask = ApnSetting.getApnTypesBitmaskFromString(cursor.getString(cursor.getColumnIndexOrThrow("type")));
        int networkTypeBitmask = cursor.getInt(cursor.getColumnIndexOrThrow("network_type_bitmask"));
        if (networkTypeBitmask == 0) {
            int bearerBitmask = cursor.getInt(cursor.getColumnIndexOrThrow("bearer_bitmask"));
            networkTypeBitmask = ServiceState.convertBearerBitmaskToNetworkTypeBitmask(bearerBitmask);
        }
        return ApnSetting.makeApnSetting(cursor.getInt(cursor.getColumnIndexOrThrow("_id")), cursor.getString(cursor.getColumnIndexOrThrow("numeric")), cursor.getString(cursor.getColumnIndexOrThrow("name")), cursor.getString(cursor.getColumnIndexOrThrow("apn")), cursor.getString(cursor.getColumnIndexOrThrow("proxy")), ApnSetting.portFromString(cursor.getString(cursor.getColumnIndexOrThrow("port"))), ApnSetting.UriFromString(cursor.getString(cursor.getColumnIndexOrThrow("mmsc"))), cursor.getString(cursor.getColumnIndexOrThrow("mmsproxy")), ApnSetting.portFromString(cursor.getString(cursor.getColumnIndexOrThrow("mmsport"))), cursor.getString(cursor.getColumnIndexOrThrow("user")), cursor.getString(cursor.getColumnIndexOrThrow("password")), cursor.getInt(cursor.getColumnIndexOrThrow("authtype")), apnTypesBitmask, ApnSetting.getProtocolIntFromString(cursor.getString(cursor.getColumnIndexOrThrow("protocol"))), ApnSetting.getProtocolIntFromString(cursor.getString(cursor.getColumnIndexOrThrow("roaming_protocol"))), cursor.getInt(cursor.getColumnIndexOrThrow("carrier_enabled")) == 1, networkTypeBitmask, cursor.getInt(cursor.getColumnIndexOrThrow("profile_id")), cursor.getInt(cursor.getColumnIndexOrThrow("modem_cognitive")) == 1, cursor.getInt(cursor.getColumnIndexOrThrow("max_conns")), cursor.getInt(cursor.getColumnIndexOrThrow("wait_time")), cursor.getInt(cursor.getColumnIndexOrThrow("max_conns_time")), cursor.getInt(cursor.getColumnIndexOrThrow("mtu")), ApnSetting.getMvnoTypeIntFromString(cursor.getString(cursor.getColumnIndexOrThrow("mvno_type"))), cursor.getString(cursor.getColumnIndexOrThrow("mvno_match_data")), cursor.getInt(cursor.getColumnIndexOrThrow("apn_set_id")), cursor.getInt(cursor.getColumnIndexOrThrow("carrier_id")), cursor.getInt(cursor.getColumnIndexOrThrow("skip_464xlat")));
    }

    public static ApnSetting makeApnSetting(ApnSetting apn) {
        return ApnSetting.makeApnSetting(apn.mId, apn.mOperatorNumeric, apn.mEntryName, apn.mApnName, apn.mProxyAddress, apn.mProxyPort, apn.mMmsc, apn.mMmsProxyAddress, apn.mMmsProxyPort, apn.mUser, apn.mPassword, apn.mAuthType, apn.mApnTypeBitmask, apn.mProtocol, apn.mRoamingProtocol, apn.mCarrierEnabled, apn.mNetworkTypeBitmask, apn.mProfileId, apn.mPersistent, apn.mMaxConns, apn.mWaitTime, apn.mMaxConnsTime, apn.mMtu, apn.mMvnoType, apn.mMvnoMatchData, apn.mApnSetId, apn.mCarrierId, apn.mSkip464Xlat);
    }

    public static ApnSetting fromString(String data) {
        boolean carrierEnabled;
        String roamingProtocol;
        String protocol;
        Object[] typeArray;
        int authType;
        int version;
        if (data == null) {
            return null;
        }
        if (data.matches("^\\[ApnSettingV7\\]\\s*.*")) {
            version = 7;
            data = data.replaceFirst(V7_FORMAT_REGEX, UNSPECIFIED_STRING);
        } else if (data.matches("^\\[ApnSettingV6\\]\\s*.*")) {
            version = 6;
            data = data.replaceFirst(V6_FORMAT_REGEX, UNSPECIFIED_STRING);
        } else if (data.matches("^\\[ApnSettingV5\\]\\s*.*")) {
            version = 5;
            data = data.replaceFirst(V5_FORMAT_REGEX, UNSPECIFIED_STRING);
        } else if (data.matches("^\\[ApnSettingV4\\]\\s*.*")) {
            version = 4;
            data = data.replaceFirst(V4_FORMAT_REGEX, UNSPECIFIED_STRING);
        } else if (data.matches("^\\[ApnSettingV3\\]\\s*.*")) {
            version = 3;
            data = data.replaceFirst(V3_FORMAT_REGEX, UNSPECIFIED_STRING);
        } else if (data.matches("^\\[ApnSettingV2\\]\\s*.*")) {
            version = 2;
            data = data.replaceFirst(V2_FORMAT_REGEX, UNSPECIFIED_STRING);
        } else {
            version = 1;
        }
        String[] a = data.split("\\s*,\\s*", -1);
        if (a.length < 14) {
            return null;
        }
        try {
            authType = Integer.parseInt(a[12]);
        }
        catch (NumberFormatException e) {
            authType = 0;
        }
        int bearerBitmask = 0;
        int networkTypeBitmask = 0;
        int profileId = 0;
        boolean modemCognitive = false;
        int maxConns = 0;
        int waitTime = 0;
        int maxConnsTime = 0;
        int mtu = 0;
        String mvnoType = UNSPECIFIED_STRING;
        String mvnoMatchData = UNSPECIFIED_STRING;
        int apnSetId = 0;
        int carrierId = -1;
        int skip464xlat = -1;
        if (version == 1) {
            typeArray = new String[a.length - 13];
            System.arraycopy(a, 13, typeArray, 0, a.length - 13);
            protocol = PROTOCOL_INT_MAP.get(0);
            roamingProtocol = PROTOCOL_INT_MAP.get(0);
            carrierEnabled = true;
        } else {
            if (a.length < 18) {
                return null;
            }
            typeArray = a[13].split("\\s*\\|\\s*");
            protocol = a[14];
            roamingProtocol = a[15];
            carrierEnabled = Boolean.parseBoolean(a[16]);
            bearerBitmask = ServiceState.getBitmaskFromString(a[17]);
            if (a.length > 22) {
                modemCognitive = Boolean.parseBoolean(a[19]);
                try {
                    profileId = Integer.parseInt(a[18]);
                    maxConns = Integer.parseInt(a[20]);
                    waitTime = Integer.parseInt(a[21]);
                    maxConnsTime = Integer.parseInt(a[22]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (a.length > 23) {
                try {
                    mtu = Integer.parseInt(a[23]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (a.length > 25) {
                mvnoType = a[24];
                mvnoMatchData = a[25];
            }
            if (a.length > 26) {
                networkTypeBitmask = ServiceState.getBitmaskFromString(a[26]);
            }
            if (a.length > 27) {
                apnSetId = Integer.parseInt(a[27]);
            }
            if (a.length > 28) {
                carrierId = Integer.parseInt(a[28]);
            }
            if (a.length > 29) {
                try {
                    skip464xlat = Integer.parseInt(a[29]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if (networkTypeBitmask == 0) {
            networkTypeBitmask = ServiceState.convertBearerBitmaskToNetworkTypeBitmask(bearerBitmask);
        }
        return ApnSetting.makeApnSetting(-1, a[10] + a[11], a[0], a[1], a[2], ApnSetting.portFromString(a[3]), ApnSetting.UriFromString(a[7]), a[8], ApnSetting.portFromString(a[9]), a[4], a[5], authType, ApnSetting.getApnTypesBitmaskFromString(TextUtils.join((CharSequence)",", typeArray)), ApnSetting.getProtocolIntFromString(protocol), ApnSetting.getProtocolIntFromString(roamingProtocol), carrierEnabled, networkTypeBitmask, profileId, modemCognitive, maxConns, waitTime, maxConnsTime, mtu, ApnSetting.getMvnoTypeIntFromString(mvnoType), mvnoMatchData, apnSetId, carrierId, skip464xlat);
    }

    public static List<ApnSetting> arrayFromString(String data) {
        String[] apnStrings;
        ArrayList<ApnSetting> retVal = new ArrayList<ApnSetting>();
        if (TextUtils.isEmpty(data)) {
            return retVal;
        }
        for (String apnString : apnStrings = data.split("\\s*;\\s*")) {
            ApnSetting apn = ApnSetting.fromString(apnString);
            if (apn == null) continue;
            retVal.add(apn);
        }
        return retVal;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[ApnSettingV7] ").append(this.mEntryName).append(", ").append(this.mId).append(", ").append(this.mOperatorNumeric).append(", ").append(this.mApnName).append(", ").append(this.mProxyAddress).append(", ").append(ApnSetting.UriToString(this.mMmsc)).append(", ").append(this.mMmsProxyAddress).append(", ").append(ApnSetting.portToString(this.mMmsProxyPort)).append(", ").append(ApnSetting.portToString(this.mProxyPort)).append(", ").append(this.mAuthType).append(", ");
        Object[] types = ApnSetting.getApnTypesStringFromBitmask(this.mApnTypeBitmask).split(",");
        sb.append(TextUtils.join((CharSequence)" | ", types));
        sb.append(", ").append(PROTOCOL_INT_MAP.get(this.mProtocol));
        sb.append(", ").append(PROTOCOL_INT_MAP.get(this.mRoamingProtocol));
        sb.append(", ").append(this.mCarrierEnabled);
        sb.append(", ").append(this.mProfileId);
        sb.append(", ").append(this.mPersistent);
        sb.append(", ").append(this.mMaxConns);
        sb.append(", ").append(this.mWaitTime);
        sb.append(", ").append(this.mMaxConnsTime);
        sb.append(", ").append(this.mMtu);
        sb.append(", ").append(MVNO_TYPE_INT_MAP.get(this.mMvnoType));
        sb.append(", ").append(this.mMvnoMatchData);
        sb.append(", ").append(this.mPermanentFailed);
        sb.append(", ").append(this.mNetworkTypeBitmask);
        sb.append(", ").append(this.mApnSetId);
        sb.append(", ").append(this.mCarrierId);
        sb.append(", ").append(this.mSkip464Xlat);
        return sb.toString();
    }

    public boolean hasMvnoParams() {
        return !TextUtils.isEmpty(ApnSetting.getMvnoTypeStringFromInt(this.mMvnoType)) && !TextUtils.isEmpty(this.mMvnoMatchData);
    }

    private boolean hasApnType(int type) {
        return (this.mApnTypeBitmask & type) == type;
    }

    public boolean isEmergencyApn() {
        return this.hasApnType(512);
    }

    public boolean canHandleType(int type) {
        if (!this.mCarrierEnabled) {
            return false;
        }
        return this.hasApnType(type);
    }

    private boolean typeSameAny(ApnSetting first, ApnSetting second) {
        return (first.mApnTypeBitmask & second.mApnTypeBitmask) != 0;
    }

    public int hashCode() {
        return Objects.hash(this.mApnName, this.mProxyAddress, this.mProxyPort, this.mMmsc, this.mMmsProxyAddress, this.mMmsProxyPort, this.mUser, this.mPassword, this.mAuthType, this.mApnTypeBitmask, this.mId, this.mOperatorNumeric, this.mProtocol, this.mRoamingProtocol, this.mMtu, this.mCarrierEnabled, this.mNetworkTypeBitmask, this.mProfileId, this.mPersistent, this.mMaxConns, this.mWaitTime, this.mMaxConnsTime, this.mMvnoType, this.mMvnoMatchData, this.mApnSetId, this.mCarrierId, this.mSkip464Xlat);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ApnSetting)) {
            return false;
        }
        ApnSetting other = (ApnSetting)o;
        return this.mEntryName.equals(other.mEntryName) && Objects.equals(this.mId, other.mId) && Objects.equals(this.mOperatorNumeric, other.mOperatorNumeric) && Objects.equals(this.mApnName, other.mApnName) && Objects.equals(this.mProxyAddress, other.mProxyAddress) && Objects.equals(this.mMmsc, other.mMmsc) && Objects.equals(this.mMmsProxyAddress, other.mMmsProxyAddress) && Objects.equals(this.mMmsProxyPort, other.mMmsProxyPort) && Objects.equals(this.mProxyPort, other.mProxyPort) && Objects.equals(this.mUser, other.mUser) && Objects.equals(this.mPassword, other.mPassword) && Objects.equals(this.mAuthType, other.mAuthType) && Objects.equals(this.mApnTypeBitmask, other.mApnTypeBitmask) && Objects.equals(this.mProtocol, other.mProtocol) && Objects.equals(this.mRoamingProtocol, other.mRoamingProtocol) && Objects.equals(this.mCarrierEnabled, other.mCarrierEnabled) && Objects.equals(this.mProfileId, other.mProfileId) && Objects.equals(this.mPersistent, other.mPersistent) && Objects.equals(this.mMaxConns, other.mMaxConns) && Objects.equals(this.mWaitTime, other.mWaitTime) && Objects.equals(this.mMaxConnsTime, other.mMaxConnsTime) && Objects.equals(this.mMtu, other.mMtu) && Objects.equals(this.mMvnoType, other.mMvnoType) && Objects.equals(this.mMvnoMatchData, other.mMvnoMatchData) && Objects.equals(this.mNetworkTypeBitmask, other.mNetworkTypeBitmask) && Objects.equals(this.mApnSetId, other.mApnSetId) && Objects.equals(this.mCarrierId, other.mCarrierId) && Objects.equals(this.mSkip464Xlat, other.mSkip464Xlat);
    }

    public boolean equals(Object o, boolean isDataRoaming) {
        if (!(o instanceof ApnSetting)) {
            return false;
        }
        ApnSetting other = (ApnSetting)o;
        return !(!this.mEntryName.equals(other.mEntryName) || !Objects.equals(this.mOperatorNumeric, other.mOperatorNumeric) || !Objects.equals(this.mApnName, other.mApnName) || !Objects.equals(this.mProxyAddress, other.mProxyAddress) || !Objects.equals(this.mMmsc, other.mMmsc) || !Objects.equals(this.mMmsProxyAddress, other.mMmsProxyAddress) || !Objects.equals(this.mMmsProxyPort, other.mMmsProxyPort) || !Objects.equals(this.mProxyPort, other.mProxyPort) || !Objects.equals(this.mUser, other.mUser) || !Objects.equals(this.mPassword, other.mPassword) || !Objects.equals(this.mAuthType, other.mAuthType) || !Objects.equals(this.mApnTypeBitmask, other.mApnTypeBitmask) || !isDataRoaming && !Objects.equals(this.mProtocol, other.mProtocol) || isDataRoaming && !Objects.equals(this.mRoamingProtocol, other.mRoamingProtocol) || !Objects.equals(this.mCarrierEnabled, other.mCarrierEnabled) || !Objects.equals(this.mProfileId, other.mProfileId) || !Objects.equals(this.mPersistent, other.mPersistent) || !Objects.equals(this.mMaxConns, other.mMaxConns) || !Objects.equals(this.mWaitTime, other.mWaitTime) || !Objects.equals(this.mMaxConnsTime, other.mMaxConnsTime) || !Objects.equals(this.mMtu, other.mMtu) || !Objects.equals(this.mMvnoType, other.mMvnoType) || !Objects.equals(this.mMvnoMatchData, other.mMvnoMatchData) || !Objects.equals(this.mApnSetId, other.mApnSetId) || !Objects.equals(this.mCarrierId, other.mCarrierId) || !Objects.equals(this.mSkip464Xlat, other.mSkip464Xlat));
    }

    public boolean similar(ApnSetting other) {
        return !this.canHandleType(8) && !other.canHandleType(8) && Objects.equals(this.mApnName, other.mApnName) && !this.typeSameAny(this, other) && this.xorEqualsString(this.mProxyAddress, other.mProxyAddress) && this.xorEqualsInt(this.mProxyPort, other.mProxyPort) && this.xorEquals(this.mProtocol, other.mProtocol) && this.xorEquals(this.mRoamingProtocol, other.mRoamingProtocol) && Objects.equals(this.mCarrierEnabled, other.mCarrierEnabled) && Objects.equals(this.mProfileId, other.mProfileId) && Objects.equals(this.mMvnoType, other.mMvnoType) && Objects.equals(this.mMvnoMatchData, other.mMvnoMatchData) && this.xorEquals(this.mMmsc, other.mMmsc) && this.xorEqualsString(this.mMmsProxyAddress, other.mMmsProxyAddress) && this.xorEqualsInt(this.mMmsProxyPort, other.mMmsProxyPort) && Objects.equals(this.mNetworkTypeBitmask, other.mNetworkTypeBitmask) && Objects.equals(this.mApnSetId, other.mApnSetId) && Objects.equals(this.mCarrierId, other.mCarrierId) && Objects.equals(this.mSkip464Xlat, other.mSkip464Xlat);
    }

    private boolean xorEquals(Object first, Object second) {
        return first == null || second == null || first.equals(second);
    }

    private boolean xorEqualsString(String first, String second) {
        return TextUtils.isEmpty(first) || TextUtils.isEmpty(second) || first.equals(second);
    }

    private boolean xorEqualsInt(int first, int second) {
        return first == -1 || second == -1 || Objects.equals(first, second);
    }

    private String nullToEmpty(String stringValue) {
        return stringValue == null ? UNSPECIFIED_STRING : stringValue;
    }

    public ContentValues toContentValues() {
        ContentValues apnValue = new ContentValues();
        apnValue.put("numeric", this.nullToEmpty(this.mOperatorNumeric));
        apnValue.put("name", this.nullToEmpty(this.mEntryName));
        apnValue.put("apn", this.nullToEmpty(this.mApnName));
        apnValue.put("proxy", this.nullToEmpty(this.mProxyAddress));
        apnValue.put("port", this.nullToEmpty(ApnSetting.portToString(this.mProxyPort)));
        apnValue.put("mmsc", this.nullToEmpty(ApnSetting.UriToString(this.mMmsc)));
        apnValue.put("mmsport", this.nullToEmpty(ApnSetting.portToString(this.mMmsProxyPort)));
        apnValue.put("mmsproxy", this.nullToEmpty(this.mMmsProxyAddress));
        apnValue.put("user", this.nullToEmpty(this.mUser));
        apnValue.put("password", this.nullToEmpty(this.mPassword));
        apnValue.put("authtype", this.mAuthType);
        String apnType = ApnSetting.getApnTypesStringFromBitmask(this.mApnTypeBitmask);
        apnValue.put("type", this.nullToEmpty(apnType));
        apnValue.put("protocol", ApnSetting.getProtocolStringFromInt(this.mProtocol));
        apnValue.put("roaming_protocol", ApnSetting.getProtocolStringFromInt(this.mRoamingProtocol));
        apnValue.put("carrier_enabled", this.mCarrierEnabled);
        apnValue.put("mvno_type", ApnSetting.getMvnoTypeStringFromInt(this.mMvnoType));
        apnValue.put("network_type_bitmask", this.mNetworkTypeBitmask);
        apnValue.put("carrier_id", this.mCarrierId);
        apnValue.put("skip_464xlat", this.mSkip464Xlat);
        return apnValue;
    }

    public List<Integer> getApnTypes() {
        ArrayList<Integer> types = new ArrayList<Integer>();
        for (Integer type : APN_TYPE_INT_MAP.keySet()) {
            if ((this.mApnTypeBitmask & type) != type) continue;
            types.add(type);
        }
        return types;
    }

    public static String getApnTypesStringFromBitmask(int apnTypeBitmask) {
        ArrayList<String> types = new ArrayList<String>();
        for (Integer type : APN_TYPE_INT_MAP.keySet()) {
            if ((apnTypeBitmask & type) != type) continue;
            types.add(APN_TYPE_INT_MAP.get(type));
        }
        return TextUtils.join((CharSequence)",", types);
    }

    public static int[] getApnTypesFromBitmask(int apnTypeBitmask) {
        return APN_TYPE_INT_MAP.keySet().stream().filter(type -> (apnTypeBitmask & type) == type).mapToInt(Integer::intValue).toArray();
    }

    @SystemApi
    public static String getApnTypeString(int apnType) {
        if (apnType == 255) {
            return TYPE_ALL_STRING;
        }
        String apnTypeString = APN_TYPE_INT_MAP.get(apnType);
        return apnTypeString == null ? UNSPECIFIED_STRING : apnTypeString;
    }

    @SystemApi
    public static int getApnTypeInt(String apnType) {
        return APN_TYPE_STRING_MAP.getOrDefault(apnType.toLowerCase(), 0);
    }

    public static int getApnTypesBitmaskFromString(String types) {
        if (TextUtils.isEmpty(types)) {
            return 255;
        }
        int result = 0;
        for (String str : types.split(",")) {
            Integer type = APN_TYPE_STRING_MAP.get(str.toLowerCase());
            if (type == null) continue;
            result |= type.intValue();
        }
        return result;
    }

    public static int getMvnoTypeIntFromString(String mvnoType) {
        String mvnoTypeString = TextUtils.isEmpty(mvnoType) ? mvnoType : mvnoType.toLowerCase();
        Integer mvnoTypeInt = MVNO_TYPE_STRING_MAP.get(mvnoTypeString);
        return mvnoTypeInt == null ? -1 : mvnoTypeInt;
    }

    public static String getMvnoTypeStringFromInt(int mvnoType) {
        String mvnoTypeString = MVNO_TYPE_INT_MAP.get(mvnoType);
        return mvnoTypeString == null ? UNSPECIFIED_STRING : mvnoTypeString;
    }

    public static int getProtocolIntFromString(String protocol) {
        Integer protocolInt = PROTOCOL_STRING_MAP.get(protocol);
        return protocolInt == null ? -1 : protocolInt;
    }

    public static String getProtocolStringFromInt(int protocol) {
        String protocolString = PROTOCOL_INT_MAP.get(protocol);
        return protocolString == null ? UNSPECIFIED_STRING : protocolString;
    }

    private static Uri UriFromString(String uri) {
        return TextUtils.isEmpty(uri) ? null : Uri.parse(uri);
    }

    private static String UriToString(Uri uri) {
        return uri == null ? null : uri.toString();
    }

    public static InetAddress inetAddressFromString(String inetAddress) {
        if (TextUtils.isEmpty(inetAddress)) {
            return null;
        }
        try {
            return InetAddress.getByName(inetAddress);
        }
        catch (UnknownHostException e) {
            Log.e(LOG_TAG, "Can't parse InetAddress from string: unknown host.");
            return null;
        }
    }

    public static String inetAddressToString(InetAddress inetAddress) {
        if (inetAddress == null) {
            return null;
        }
        String inetAddressString = inetAddress.toString();
        if (TextUtils.isEmpty(inetAddressString)) {
            return null;
        }
        String hostName = inetAddressString.substring(0, inetAddressString.indexOf("/"));
        String address = inetAddressString.substring(inetAddressString.indexOf("/") + 1);
        if (TextUtils.isEmpty(hostName) && TextUtils.isEmpty(address)) {
            return null;
        }
        return TextUtils.isEmpty(hostName) ? address : hostName;
    }

    private static int portFromString(String strPort) {
        int port = -1;
        if (!TextUtils.isEmpty(strPort)) {
            try {
                port = Integer.parseInt(strPort);
            }
            catch (NumberFormatException e) {
                Log.e(LOG_TAG, "Can't parse port from String");
            }
        }
        return port;
    }

    private static String portToString(int port) {
        return port == -1 ? null : Integer.toString(port);
    }

    public boolean canSupportNetworkType(int networkType) {
        if (networkType == 16 && ((long)this.mNetworkTypeBitmask & 3L) != 0L) {
            return true;
        }
        return ServiceState.bitmaskHasTech(this.mNetworkTypeBitmask, networkType);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mId);
        dest.writeString(this.mOperatorNumeric);
        dest.writeString(this.mEntryName);
        dest.writeString(this.mApnName);
        dest.writeString(this.mProxyAddress);
        dest.writeInt(this.mProxyPort);
        dest.writeValue(this.mMmsc);
        dest.writeString(this.mMmsProxyAddress);
        dest.writeInt(this.mMmsProxyPort);
        dest.writeString(this.mUser);
        dest.writeString(this.mPassword);
        dest.writeInt(this.mAuthType);
        dest.writeInt(this.mApnTypeBitmask);
        dest.writeInt(this.mProtocol);
        dest.writeInt(this.mRoamingProtocol);
        dest.writeBoolean(this.mCarrierEnabled);
        dest.writeInt(this.mMvnoType);
        dest.writeInt(this.mNetworkTypeBitmask);
        dest.writeInt(this.mApnSetId);
        dest.writeInt(this.mCarrierId);
        dest.writeInt(this.mSkip464Xlat);
    }

    private static ApnSetting readFromParcel(Parcel in) {
        int id2 = in.readInt();
        String operatorNumeric = in.readString();
        String entryName = in.readString();
        String apnName = in.readString();
        String proxy = in.readString();
        int port = in.readInt();
        Uri mmsc = (Uri)in.readValue(Uri.class.getClassLoader());
        String mmsProxy = in.readString();
        int mmsPort = in.readInt();
        String user = in.readString();
        String password = in.readString();
        int authType = in.readInt();
        int apnTypesBitmask = in.readInt();
        int protocol = in.readInt();
        int roamingProtocol = in.readInt();
        boolean carrierEnabled = in.readBoolean();
        int mvnoType = in.readInt();
        int networkTypeBitmask = in.readInt();
        int apnSetId = in.readInt();
        int carrierId = in.readInt();
        int skip464xlat = in.readInt();
        return ApnSetting.makeApnSetting(id2, operatorNumeric, entryName, apnName, proxy, port, mmsc, mmsProxy, mmsPort, user, password, authType, apnTypesBitmask, protocol, roamingProtocol, carrierEnabled, networkTypeBitmask, 0, false, 0, 0, 0, 0, mvnoType, null, apnSetId, carrierId, skip464xlat);
    }

    static {
        APN_TYPE_STRING_MAP.put(TYPE_ALL_STRING, 255);
        APN_TYPE_STRING_MAP.put(TYPE_DEFAULT_STRING, 17);
        APN_TYPE_STRING_MAP.put(TYPE_MMS_STRING, 2);
        APN_TYPE_STRING_MAP.put(TYPE_SUPL_STRING, 4);
        APN_TYPE_STRING_MAP.put(TYPE_DUN_STRING, 8);
        APN_TYPE_STRING_MAP.put(TYPE_HIPRI_STRING, 16);
        APN_TYPE_STRING_MAP.put(TYPE_FOTA_STRING, 32);
        APN_TYPE_STRING_MAP.put(TYPE_IMS_STRING, 64);
        APN_TYPE_STRING_MAP.put(TYPE_CBS_STRING, 128);
        APN_TYPE_STRING_MAP.put(TYPE_IA_STRING, 256);
        APN_TYPE_STRING_MAP.put(TYPE_EMERGENCY_STRING, 512);
        APN_TYPE_STRING_MAP.put(TYPE_MCX_STRING, 1024);
        APN_TYPE_STRING_MAP.put(TYPE_XCAP_STRING, 2048);
        APN_TYPE_STRING_MAP.put(TYPE_ENTERPRISE_STRING, 16384);
        APN_TYPE_STRING_MAP.put(TYPE_VSIM_STRING, 4096);
        APN_TYPE_STRING_MAP.put(TYPE_BIP_STRING, 8192);
        APN_TYPE_INT_MAP = new ArrayMap<Integer, String>();
        APN_TYPE_INT_MAP.put(17, TYPE_DEFAULT_STRING);
        APN_TYPE_INT_MAP.put(2, TYPE_MMS_STRING);
        APN_TYPE_INT_MAP.put(4, TYPE_SUPL_STRING);
        APN_TYPE_INT_MAP.put(8, TYPE_DUN_STRING);
        APN_TYPE_INT_MAP.put(16, TYPE_HIPRI_STRING);
        APN_TYPE_INT_MAP.put(32, TYPE_FOTA_STRING);
        APN_TYPE_INT_MAP.put(64, TYPE_IMS_STRING);
        APN_TYPE_INT_MAP.put(128, TYPE_CBS_STRING);
        APN_TYPE_INT_MAP.put(256, TYPE_IA_STRING);
        APN_TYPE_INT_MAP.put(512, TYPE_EMERGENCY_STRING);
        APN_TYPE_INT_MAP.put(1024, TYPE_MCX_STRING);
        APN_TYPE_INT_MAP.put(2048, TYPE_XCAP_STRING);
        APN_TYPE_INT_MAP.put(16384, TYPE_ENTERPRISE_STRING);
        APN_TYPE_INT_MAP.put(4096, TYPE_VSIM_STRING);
        APN_TYPE_INT_MAP.put(8192, TYPE_BIP_STRING);
        PROTOCOL_STRING_MAP = new ArrayMap<String, Integer>();
        PROTOCOL_STRING_MAP.put("IP", 0);
        PROTOCOL_STRING_MAP.put("IPV6", 1);
        PROTOCOL_STRING_MAP.put("IPV4V6", 2);
        PROTOCOL_STRING_MAP.put("PPP", 3);
        PROTOCOL_STRING_MAP.put("NON-IP", 4);
        PROTOCOL_STRING_MAP.put("UNSTRUCTURED", 5);
        PROTOCOL_INT_MAP = new ArrayMap<Integer, String>();
        PROTOCOL_INT_MAP.put(0, "IP");
        PROTOCOL_INT_MAP.put(1, "IPV6");
        PROTOCOL_INT_MAP.put(2, "IPV4V6");
        PROTOCOL_INT_MAP.put(3, "PPP");
        PROTOCOL_INT_MAP.put(4, "NON-IP");
        PROTOCOL_INT_MAP.put(5, "UNSTRUCTURED");
        MVNO_TYPE_STRING_MAP = new ArrayMap<String, Integer>();
        MVNO_TYPE_STRING_MAP.put("spn", 0);
        MVNO_TYPE_STRING_MAP.put("imsi", 1);
        MVNO_TYPE_STRING_MAP.put("gid", 2);
        MVNO_TYPE_STRING_MAP.put("iccid", 3);
        MVNO_TYPE_INT_MAP = new ArrayMap<Integer, String>();
        MVNO_TYPE_INT_MAP.put(0, "spn");
        MVNO_TYPE_INT_MAP.put(1, "imsi");
        MVNO_TYPE_INT_MAP.put(2, "gid");
        MVNO_TYPE_INT_MAP.put(3, "iccid");
        CREATOR = new Parcelable.Creator<ApnSetting>(){

            @Override
            public ApnSetting createFromParcel(Parcel in) {
                return ApnSetting.readFromParcel(in);
            }

            public ApnSetting[] newArray(int size) {
                return new ApnSetting[size];
            }
        };
    }

    public static class Builder {
        private String mEntryName;
        private String mApnName;
        private String mProxyAddress;
        private int mProxyPort = -1;
        private Uri mMmsc;
        private String mMmsProxyAddress;
        private int mMmsProxyPort = -1;
        private String mUser;
        private String mPassword;
        private int mAuthType;
        private int mApnTypeBitmask;
        private int mId;
        private String mOperatorNumeric;
        private int mProtocol = -1;
        private int mRoamingProtocol = -1;
        private int mMtu;
        private int mNetworkTypeBitmask;
        private boolean mCarrierEnabled;
        private int mProfileId;
        private boolean mModemCognitive;
        private int mMaxConns;
        private int mWaitTime;
        private int mMaxConnsTime;
        private int mMvnoType = -1;
        private String mMvnoMatchData;
        private int mApnSetId;
        private int mCarrierId = -1;
        private int mSkip464Xlat = -1;

        private Builder setId(int id2) {
            this.mId = id2;
            return this;
        }

        public Builder setMtu(int mtu) {
            this.mMtu = mtu;
            return this;
        }

        public Builder setProfileId(int profileId) {
            this.mProfileId = profileId;
            return this;
        }

        public Builder setModemCognitive(boolean modemCognitive) {
            this.mModemCognitive = modemCognitive;
            return this;
        }

        public Builder setMaxConns(int maxConns) {
            this.mMaxConns = maxConns;
            return this;
        }

        public Builder setWaitTime(int waitTime) {
            this.mWaitTime = waitTime;
            return this;
        }

        public Builder setMaxConnsTime(int maxConnsTime) {
            this.mMaxConnsTime = maxConnsTime;
            return this;
        }

        public Builder setMvnoMatchData(String mvnoMatchData) {
            this.mMvnoMatchData = mvnoMatchData;
            return this;
        }

        public Builder setApnSetId(int apnSetId) {
            this.mApnSetId = apnSetId;
            return this;
        }

        public Builder setEntryName(String entryName) {
            this.mEntryName = entryName;
            return this;
        }

        public Builder setApnName(String apnName) {
            this.mApnName = apnName;
            return this;
        }

        @Deprecated
        public Builder setProxyAddress(InetAddress proxy) {
            this.mProxyAddress = ApnSetting.inetAddressToString(proxy);
            return this;
        }

        public Builder setProxyAddress(String proxy) {
            this.mProxyAddress = proxy;
            return this;
        }

        public Builder setProxyPort(int port) {
            this.mProxyPort = port;
            return this;
        }

        public Builder setMmsc(Uri mmsc) {
            this.mMmsc = mmsc;
            return this;
        }

        @Deprecated
        public Builder setMmsProxyAddress(InetAddress mmsProxy) {
            this.mMmsProxyAddress = ApnSetting.inetAddressToString(mmsProxy);
            return this;
        }

        public Builder setMmsProxyAddress(String mmsProxy) {
            this.mMmsProxyAddress = mmsProxy;
            return this;
        }

        public Builder setMmsProxyPort(int mmsPort) {
            this.mMmsProxyPort = mmsPort;
            return this;
        }

        public Builder setUser(String user) {
            this.mUser = user;
            return this;
        }

        public Builder setPassword(String password) {
            this.mPassword = password;
            return this;
        }

        public Builder setAuthType(int authType) {
            this.mAuthType = authType;
            return this;
        }

        public Builder setApnTypeBitmask(int apnTypeBitmask) {
            this.mApnTypeBitmask = apnTypeBitmask;
            return this;
        }

        public Builder setOperatorNumeric(String operatorNumeric) {
            this.mOperatorNumeric = operatorNumeric;
            return this;
        }

        public Builder setProtocol(int protocol) {
            this.mProtocol = protocol;
            return this;
        }

        public Builder setRoamingProtocol(int roamingProtocol) {
            this.mRoamingProtocol = roamingProtocol;
            return this;
        }

        public Builder setCarrierEnabled(boolean carrierEnabled) {
            this.mCarrierEnabled = carrierEnabled;
            return this;
        }

        public Builder setNetworkTypeBitmask(int networkTypeBitmask) {
            this.mNetworkTypeBitmask = networkTypeBitmask;
            return this;
        }

        public Builder setMvnoType(int mvnoType) {
            this.mMvnoType = mvnoType;
            return this;
        }

        public Builder setCarrierId(int carrierId) {
            this.mCarrierId = carrierId;
            return this;
        }

        public Builder setSkip464Xlat(int skip464xlat) {
            this.mSkip464Xlat = skip464xlat;
            return this;
        }

        public ApnSetting build() {
            if ((this.mApnTypeBitmask & Short.MAX_VALUE) == 0 || TextUtils.isEmpty(this.mApnName) || TextUtils.isEmpty(this.mEntryName)) {
                return null;
            }
            return new ApnSetting(this);
        }

        public ApnSetting buildWithoutCheck() {
            return new ApnSetting(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MvnoType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ProtocolType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AuthType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ApnTypeString {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Skip464XlatStatus {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ApnType {
    }
}

