/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.data;

import android.hardware.radio.V1_6.SliceInfo;
import android.hardware.radio.V1_6.SlicingConfig;
import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.data.NetworkSliceInfo;
import android.telephony.data.UrspRule;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class NetworkSlicingConfig
implements Parcelable {
    private final List<UrspRule> mUrspRules;
    private final List<NetworkSliceInfo> mSliceInfo;
    public static final Parcelable.Creator<NetworkSlicingConfig> CREATOR = new Parcelable.Creator<NetworkSlicingConfig>(){

        @Override
        public NetworkSlicingConfig createFromParcel(Parcel source) {
            return new NetworkSlicingConfig(source);
        }

        public NetworkSlicingConfig[] newArray(int size) {
            return new NetworkSlicingConfig[size];
        }
    };

    public NetworkSlicingConfig() {
        this.mUrspRules = new ArrayList<UrspRule>();
        this.mSliceInfo = new ArrayList<NetworkSliceInfo>();
    }

    public NetworkSlicingConfig(SlicingConfig sc) {
        this(sc.urspRules, sc.sliceInfo);
    }

    public NetworkSlicingConfig(List<android.hardware.radio.V1_6.UrspRule> urspRules, List<SliceInfo> sliceInfo) {
        this.mUrspRules = new ArrayList<UrspRule>();
        for (android.hardware.radio.V1_6.UrspRule ur : urspRules) {
            this.mUrspRules.add(new UrspRule(ur.precedence, ur.trafficDescriptors, ur.routeSelectionDescriptor));
        }
        this.mSliceInfo = new ArrayList<NetworkSliceInfo>();
        for (SliceInfo si : sliceInfo) {
            this.mSliceInfo.add(this.sliceInfoBuilder(si));
        }
    }

    private NetworkSliceInfo sliceInfoBuilder(SliceInfo si) {
        NetworkSliceInfo.Builder builder = new NetworkSliceInfo.Builder().setSliceServiceType(si.sst).setMappedHplmnSliceServiceType(si.mappedHplmnSst);
        if (si.sliceDifferentiator != -1) {
            builder.setSliceDifferentiator(si.sliceDifferentiator).setMappedHplmnSliceDifferentiator(si.mappedHplmnSD);
        }
        return builder.build();
    }

    public NetworkSlicingConfig(Parcel p) {
        this.mUrspRules = p.createTypedArrayList(UrspRule.CREATOR);
        this.mSliceInfo = p.createTypedArrayList(NetworkSliceInfo.CREATOR);
    }

    public List<UrspRule> getUrspRules() {
        return this.mUrspRules;
    }

    public List<NetworkSliceInfo> getSliceInfo() {
        return this.mSliceInfo;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeTypedList(this.mUrspRules, flags);
        dest.writeTypedList(this.mSliceInfo, flags);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetworkSlicingConfig that = (NetworkSlicingConfig)o;
        return this.mUrspRules.size() == that.mUrspRules.size() && this.mUrspRules.containsAll(that.mUrspRules) && this.mSliceInfo.size() == that.mSliceInfo.size() && this.mSliceInfo.containsAll(that.mSliceInfo);
    }

    public int hashCode() {
        return Objects.hash(this.mUrspRules, this.mSliceInfo);
    }

    public String toString() {
        return "{.urspRules = " + this.mUrspRules + ", .sliceInfo = " + this.mSliceInfo + "}";
    }
}

