/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.data;

import android.annotation.SystemApi;
import android.net.QosSessionAttributes;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@SystemApi
public class NrQosSessionAttributes
implements Parcelable,
QosSessionAttributes {
    private static final String TAG = NrQosSessionAttributes.class.getSimpleName();
    private final int m5Qi;
    private final int mQfi;
    private final long mMaxUplinkBitRate;
    private final long mMaxDownlinkBitRate;
    private final long mGuaranteedUplinkBitRate;
    private final long mGuaranteedDownlinkBitRate;
    private final long mAveragingWindow;
    private final List<InetSocketAddress> mRemoteAddresses;
    public static final Parcelable.Creator<NrQosSessionAttributes> CREATOR = new Parcelable.Creator<NrQosSessionAttributes>(){

        @Override
        public NrQosSessionAttributes createFromParcel(Parcel in) {
            return new NrQosSessionAttributes(in);
        }

        public NrQosSessionAttributes[] newArray(int size) {
            return new NrQosSessionAttributes[size];
        }
    };

    public int getQosIdentifier() {
        return this.m5Qi;
    }

    public int getQosFlowIdentifier() {
        return this.mQfi;
    }

    public long getGuaranteedUplinkBitRateKbps() {
        return this.mGuaranteedUplinkBitRate;
    }

    public long getGuaranteedDownlinkBitRateKbps() {
        return this.mGuaranteedDownlinkBitRate;
    }

    public long getMaxUplinkBitRateKbps() {
        return this.mMaxUplinkBitRate;
    }

    public long getMaxDownlinkBitRateKbps() {
        return this.mMaxDownlinkBitRate;
    }

    public Duration getBitRateWindowDuration() {
        return Duration.ofMillis(this.mAveragingWindow);
    }

    public List<InetSocketAddress> getRemoteAddresses() {
        return this.mRemoteAddresses;
    }

    public NrQosSessionAttributes(int fiveQi, int qfi, long maxDownlinkBitRate, long maxUplinkBitRate, long guaranteedDownlinkBitRate, long guaranteedUplinkBitRate, long averagingWindow, List<InetSocketAddress> remoteAddresses) {
        Objects.requireNonNull(remoteAddresses, "remoteAddress must be non-null");
        this.m5Qi = fiveQi;
        this.mQfi = qfi;
        this.mMaxDownlinkBitRate = maxDownlinkBitRate;
        this.mMaxUplinkBitRate = maxUplinkBitRate;
        this.mGuaranteedDownlinkBitRate = guaranteedDownlinkBitRate;
        this.mGuaranteedUplinkBitRate = guaranteedUplinkBitRate;
        this.mAveragingWindow = averagingWindow;
        List<InetSocketAddress> remoteAddressesTemp = NrQosSessionAttributes.copySocketAddresses(remoteAddresses);
        this.mRemoteAddresses = Collections.unmodifiableList(remoteAddressesTemp);
    }

    private static List<InetSocketAddress> copySocketAddresses(List<InetSocketAddress> remoteAddresses) {
        ArrayList<InetSocketAddress> remoteAddressesTemp = new ArrayList<InetSocketAddress>();
        for (InetSocketAddress socketAddress : remoteAddresses) {
            if (socketAddress == null || socketAddress.getAddress() == null) continue;
            remoteAddressesTemp.add(socketAddress);
        }
        return remoteAddressesTemp;
    }

    private NrQosSessionAttributes(Parcel in) {
        this.m5Qi = in.readInt();
        this.mQfi = in.readInt();
        this.mMaxDownlinkBitRate = in.readLong();
        this.mMaxUplinkBitRate = in.readLong();
        this.mGuaranteedDownlinkBitRate = in.readLong();
        this.mGuaranteedUplinkBitRate = in.readLong();
        this.mAveragingWindow = in.readLong();
        int size = in.readInt();
        ArrayList<InetSocketAddress> remoteAddresses = new ArrayList<InetSocketAddress>(size);
        for (int i = 0; i < size; ++i) {
            byte[] addressBytes = in.createByteArray();
            int port = in.readInt();
            try {
                remoteAddresses.add(new InetSocketAddress(InetAddress.getByAddress(addressBytes), port));
                continue;
            }
            catch (UnknownHostException e) {
                Log.e(TAG, "unable to unparcel remote address at index: " + i, e);
            }
        }
        this.mRemoteAddresses = Collections.unmodifiableList(remoteAddresses);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.m5Qi);
        dest.writeInt(this.mQfi);
        dest.writeLong(this.mMaxDownlinkBitRate);
        dest.writeLong(this.mMaxUplinkBitRate);
        dest.writeLong(this.mGuaranteedDownlinkBitRate);
        dest.writeLong(this.mGuaranteedUplinkBitRate);
        dest.writeLong(this.mAveragingWindow);
        int size = this.mRemoteAddresses.size();
        dest.writeInt(size);
        for (int i = 0; i < size; ++i) {
            InetSocketAddress address = this.mRemoteAddresses.get(i);
            dest.writeByteArray(address.getAddress().getAddress());
            dest.writeInt(address.getPort());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NrQosSessionAttributes nrQosAttr = (NrQosSessionAttributes)o;
        return this.m5Qi == nrQosAttr.m5Qi && this.mQfi == nrQosAttr.mQfi && this.mMaxUplinkBitRate == nrQosAttr.mMaxUplinkBitRate && this.mMaxDownlinkBitRate == nrQosAttr.mMaxDownlinkBitRate && this.mGuaranteedUplinkBitRate == nrQosAttr.mGuaranteedUplinkBitRate && this.mGuaranteedDownlinkBitRate == nrQosAttr.mGuaranteedDownlinkBitRate && this.mAveragingWindow == nrQosAttr.mAveragingWindow && this.mRemoteAddresses.size() == nrQosAttr.mRemoteAddresses.size() && this.mRemoteAddresses.containsAll(nrQosAttr.mRemoteAddresses);
    }

    public int hashCode() {
        return Objects.hash(this.m5Qi, this.mQfi, this.mMaxUplinkBitRate, this.mMaxDownlinkBitRate, this.mGuaranteedUplinkBitRate, this.mGuaranteedDownlinkBitRate, this.mAveragingWindow, this.mRemoteAddresses);
    }
}

