/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.data;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.Arrays;
import java.util.Objects;

public class TrafficDescriptor
implements Parcelable {
    private final String mDnn;
    private final byte[] mOsAppId;
    public static final Parcelable.Creator<TrafficDescriptor> CREATOR = new Parcelable.Creator<TrafficDescriptor>(){

        @Override
        public TrafficDescriptor createFromParcel(Parcel source) {
            return new TrafficDescriptor(source);
        }

        public TrafficDescriptor[] newArray(int size) {
            return new TrafficDescriptor[size];
        }
    };

    private TrafficDescriptor(Parcel in) {
        this.mDnn = in.readString();
        this.mOsAppId = in.createByteArray();
    }

    public TrafficDescriptor(String dnn, byte[] osAppId) {
        this.mDnn = dnn;
        this.mOsAppId = osAppId;
    }

    public String getDataNetworkName() {
        return this.mDnn;
    }

    public byte[] getOsAppId() {
        return this.mOsAppId;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        return "TrafficDescriptor={mDnn=" + this.mDnn + ", mOsAppId=" + this.mOsAppId + "}";
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mDnn);
        dest.writeByteArray(this.mOsAppId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrafficDescriptor that = (TrafficDescriptor)o;
        return Objects.equals(this.mDnn, that.mDnn) && Arrays.equals(this.mOsAppId, that.mOsAppId);
    }

    public int hashCode() {
        return Objects.hash(this.mDnn, this.mOsAppId);
    }

    public static class Builder {
        private String mDnn = null;
        private byte[] mOsAppId = null;

        public Builder setDataNetworkName(String dnn) {
            this.mDnn = dnn;
            return this;
        }

        public Builder setOsAppId(byte[] osAppId) {
            this.mOsAppId = osAppId;
            return this;
        }

        public TrafficDescriptor build() {
            if (this.mDnn == null && this.mOsAppId == null) {
                throw new IllegalArgumentException("DNN and OS App ID are null");
            }
            return new TrafficDescriptor(this.mDnn, this.mOsAppId);
        }
    }
}

