/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims.aidl;

import android.net.Uri;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.telephony.ims.aidl.IOptionsRequestCallback;
import java.util.ArrayList;
import java.util.List;

public interface ICapabilityExchangeEventListener
extends IInterface {
    public static final String DESCRIPTOR = "android.telephony.ims.aidl.ICapabilityExchangeEventListener";

    public void onRequestPublishCapabilities(int var1) throws RemoteException;

    public void onUnpublish() throws RemoteException;

    public void onRemoteCapabilityRequest(Uri var1, List<String> var2, IOptionsRequestCallback var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ICapabilityExchangeEventListener {
        static final int TRANSACTION_onRequestPublishCapabilities = 1;
        static final int TRANSACTION_onUnpublish = 2;
        static final int TRANSACTION_onRemoteCapabilityRequest = 3;

        public Stub() {
            this.attachInterface(this, ICapabilityExchangeEventListener.DESCRIPTOR);
        }

        public static ICapabilityExchangeEventListener asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ICapabilityExchangeEventListener.DESCRIPTOR);
            if (iin != null && iin instanceof ICapabilityExchangeEventListener) {
                return (ICapabilityExchangeEventListener)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onRequestPublishCapabilities";
                }
                case 2: {
                    return "onUnpublish";
                }
                case 3: {
                    return "onRemoteCapabilityRequest";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ICapabilityExchangeEventListener.DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.onRequestPublishCapabilities(_arg0);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    this.onUnpublish();
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    Uri _arg0 = 0 != data.readInt() ? Uri.CREATOR.createFromParcel(data) : null;
                    ArrayList<String> _arg1 = data.createStringArrayList();
                    IOptionsRequestCallback _arg2 = IOptionsRequestCallback.Stub.asInterface(data.readStrongBinder());
                    this.onRemoteCapabilityRequest(_arg0, _arg1, _arg2);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(ICapabilityExchangeEventListener impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static ICapabilityExchangeEventListener getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements ICapabilityExchangeEventListener {
            private IBinder mRemote;
            public static ICapabilityExchangeEventListener sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ICapabilityExchangeEventListener.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRequestPublishCapabilities(int publishTriggerType) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ICapabilityExchangeEventListener.DESCRIPTOR);
                    _data.writeInt(publishTriggerType);
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onRequestPublishCapabilities(publishTriggerType);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onUnpublish() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ICapabilityExchangeEventListener.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onUnpublish();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRemoteCapabilityRequest(Uri contactUri, List<String> remoteCapabilities, IOptionsRequestCallback cb) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ICapabilityExchangeEventListener.DESCRIPTOR);
                    if (contactUri != null) {
                        _data.writeInt(1);
                        contactUri.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStringList(remoteCapabilities);
                    _data.writeStrongBinder(cb != null ? cb.asBinder() : null);
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onRemoteCapabilityRequest(contactUri, remoteCapabilities, cb);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ICapabilityExchangeEventListener {
        @Override
        public void onRequestPublishCapabilities(int publishTriggerType) throws RemoteException {
        }

        @Override
        public void onUnpublish() throws RemoteException {
        }

        @Override
        public void onRemoteCapabilityRequest(Uri contactUri, List<String> remoteCapabilities, IOptionsRequestCallback cb) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

